      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       IDENTIFICATION DIVISION. 
       CLASS-ID. CustomLock AS "CustomLock" INHERITS DYNAMICISAM.

       CONFIGURATION SECTION.
       REPOSITORY.
           CLASS JINT            AS "int"
           CLASS JLONG           AS "long"
           CLASS JSTRING         AS "java.lang.String" 
           CLASS JBOOL           AS "boolean"
           CLASS JBYTEARRAY      AS "byte[]"
           CLASS KEYDESCRIPTION  AS "com.iscobol.rts.KeyDescription"
           >> IF ISAM_CTREE IS DEFINED
              CLASS DYNAMICISAM  AS "com.iscobol.io.DynamicCtreeJ"
           >> ELSE 
              CLASS DYNAMICISAM  AS "com.iscobol.io.DynamicJIsam"
           >> END-IF
           .

       IDENTIFICATION DIVISION.
       OBJECT.

       WORKING-STORAGE SECTION.
       78  E_IO_LOCKED   VALUE 107.
       77  OBJ-THERECORD OBJECT REFERENCE JBYTEARRAY.
       77  OBJ-OFFS      OBJECT REFERENCE JINT. 
       77  OBJ-KEYNUM    OBJECT REFERENCE JINT.
       77  OBJ-FLAGLOCK  OBJECT REFERENCE JINT.
       77  OBJ-KEYS      OBJECT REFERENCE KEYDESCRIPTION.
       77  W-TYPE-READ   PIC 9.
       77  W-LOCK-RETRY  PIC 9.
       77  W-fileName    PIC X ANY LENGTH.
       77  W-filePath    PIC X ANY LENGTH.

       PROCEDURE DIVISION.
************************************************************************
       IDENTIFICATION DIVISION.
       METHOD-ID. NEW AS "new" OVERRIDE.
       PROCEDURE DIVISION.
       MAIN.
           ACCEPT W-LOCK-RETRY FROM ENVIRONMENT "customlock.lock_retry"
             ON EXCEPTION
                MOVE 0 TO W-LOCK-RETRY
           END-ACCEPT
           .
       END METHOD.
************************************************************************
       IDENTIFICATION DIVISION.
       METHOD-ID. getCobErrno AS "getCobErrno" OVERRIDE.
       WORKING-STORAGE SECTION.
       copy "isgui.def".
       77  MB-RETURN     PIC 9.
       77  RESULT OBJECT REFERENCE JINT.
       77  RESULT2 OBJECT REFERENCE JLONG.
       PROCEDURE DIVISION RETURNING RESULT.
       MAIN.
           SET RESULT TO SUPER:>getCobErrno().
           IF RESULT = E_IO_LOCKED
              EVALUATE W-LOCK-RETRY 
              WHEN 0
                   CONTINUE
              WHEN 1
                   CALL "C$SLEEP" USING 1
                   IF W-TYPE-READ = 1
                      SET RESULT2 TO SELF:>read(OBJ-THERECORD,
                                                OBJ-OFFS,
                                                OBJ-KEYNUM,
                                                OBJ-FLAGLOCK)
                   ELSE
                      SET RESULT2 TO SELF:>read(OBJ-THERECORD,
                                                OBJ-OFFS,
                                                OBJ-KEYS,
                                                OBJ-FLAGLOCK)
                   END-IF
                   SET RESULT TO SELF:>getCobErrno()
              WHEN 2
                   initialize W-fileName W-filePath
                   CALL "C$GETLASTFILENAME" USING W-fileName 
                                                  W-filePath
                   display message 
                           "The record is locked. "
                           "How would you like to continue?"
                           x"0A"
                           "file name=" W-fileName X"0A"
                           "file path=" W-filePath
                           title "Lock Detected"
                           default mb-retry
                           type mb-abort-retry-ignore
                           giving mb-return
                   evaluate mb-return
                   when mb-abort
                        stop run
                   when mb-retry
                        CALL "C$SLEEP" USING 1
                        IF W-TYPE-READ = 1
                           SET RESULT2 TO SELF:>read(OBJ-THERECORD,
                                                     OBJ-OFFS,
                                                     OBJ-KEYNUM,
                                                     OBJ-FLAGLOCK)
                        ELSE
                           SET RESULT2 TO SELF:>read(OBJ-THERECORD,
                                                     OBJ-OFFS,
                                                     OBJ-KEYS,
                                                     OBJ-FLAGLOCK)
                        END-IF
                        SET RESULT TO SELF:>getCobErrno()
                 when mb-ignore
                      continue
                 end-evaluate
              END-EVALUATE
           END-IF
           GOBACK.
       END METHOD.    
************************************************************************
       IDENTIFICATION DIVISION.
       METHOD-ID. CustomRead AS "read" OVERRIDE.
       WORKING-STORAGE SECTION.
       77  RESULT OBJECT REFERENCE JLONG.
       LINKAGE SECTION.
       77  THERECORD OBJECT REFERENCE JBYTEARRAY.
       77  OFFS      OBJECT REFERENCE JINT. 
       77  KEYNUM    OBJECT REFERENCE JINT.
       77  FLAGLOCK  OBJECT REFERENCE JINT.
       PROCEDURE DIVISION USING THERECORD,
                                OFFS,
                                KEYNUM,
                                FLAGLOCK
                      RETURNING RESULT.
       MAIN.
           SET RESULT TO SUPER:>read(THERECORD,
                                     OFFS,
                                     KEYNUM,
                                     FLAGLOCK).
           IF W-LOCK-RETRY > 0 AND FLAGLOCK = 1
              MOVE 1 TO W-TYPE-READ
              SET OBJ-THERECORD TO THERECORD
              SET OBJ-OFFS      TO OFFS
              SET OBJ-KEYNUM    TO KEYNUM
              SET OBJ-FLAGLOCK  TO FLAGLOCK
           END-IF
           GOBACK.
       END METHOD.
************************************************************************
       IDENTIFICATION DIVISION.
       METHOD-ID. CustomRead AS "read" OVERRIDE.
       WORKING-STORAGE SECTION.
       77  RESULT OBJECT REFERENCE JLONG.
       LINKAGE SECTION.
       77  THERECORD OBJECT REFERENCE JBYTEARRAY.
       77  OFFS      OBJECT REFERENCE JINT. 
       77  KEYS      OBJECT REFERENCE KEYDESCRIPTION.
       77  FLAGLOCK  OBJECT REFERENCE JINT.
       PROCEDURE DIVISION USING THERECORD,
                                OFFS,
                                KEYS,
                                FLAGLOCK
                      RETURNING RESULT.
       MAIN.
           SET RESULT TO SUPER:>read(THERECORD,
                                     OFFS,
                                     KEYS,
                                     FLAGLOCK).
           IF W-LOCK-RETRY > 0 AND FLAGLOCK = 1
              MOVE 2 TO W-TYPE-READ
              SET OBJ-THERECORD TO THERECORD
              SET OBJ-OFFS      TO OFFS
              SET OBJ-KEYS      TO KEYS
              SET OBJ-FLAGLOCK  TO FLAGLOCK
           END-IF
           GOBACK.
       END METHOD.  
************************************************************************
       END OBJECT.
************************************************************************
