      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. runcobol.
       CONFIGURATION SECTION.
       SPECIAL-NAMES.
           switch-1 on status is is-on-1 
           switch-2 on status is is-on-2
           switch-3 on status is is-on-3
           switch-4 on status is is-on-4
           switch-5 on status is is-on-5
           switch-6 on status is is-on-6
           switch-7 on status is is-on-7
           switch-8 on status is is-on-8
           .

       WORKING-STORAGE SECTION.
       78  78-max-params        value 20.
       78  78-num-options       value  3.

       01  w-tab-check          occurs 78-num-options.
           03 opt-1             pic x.
           03 opt-2a            pic x(2).
           03 opt-2b            pic x(2).
           03 opt-3             pic x(3).

       01  w-tab-options.
      *    "A" Option to pass an argument to the program
           03 option-A          pic x value "A". 
      *    "S" Option to set (or reset) the initial state of switches in the COBOL run unit
           03 option-S          pic x value "S".
      *    "T" Option to specify the amount of memory (n bytes) to be used for a sort operation
           03 option-T          pic x value "T".
       01  w-tab-options-red    redefines w-tab-options.
           03 w-opt             pic x occurs 78-num-options.

       77  num-params           pic 9(3) comp-1.
       77  par                  pic x any length occurs 78-max-params.
       77  prg-name             pic x any length.
       77  ind                  pic 9(3).
       77  par-size             pic 9(3).
       77  par-value-upper      pic x any length.
       77  flag-next            pic 9 value 0.
       77  prg-args             pic x any length.
       77  switches             pic x(8).
       77  sortmem-size         pic 9(10).
       77  w-start-offset       pic 9.
       77  idx-opt              pic 9.

       01  main-parameter.
           02 parameter-length  pic s9(4) binary (2).
           02 parameter-text.
              03 parameter-char pic x occurs 0 to 2048 times 
                                         depending on parameter-length.

       PROCEDURE DIVISION CHAINING par(01), par(02), par(03), par(04), 
                                   par(05), par(06), par(07), par(08), 
                                   par(09), par(10), par(11), par(12), 
                                   par(13), par(14), par(15), par(16), 
                                   par(17), par(18), par(19), par(20).

       MAIN.
           call "c$narg" using num-params
           if num-params = 0
              stop run
           end-if.

           perform varying idx-opt from 1 by 1 
                                      until idx-opt > 78-num-options
              move w-opt(idx-opt)  to opt-1(idx-opt)
              string "-" 
                     w-opt(idx-opt) 
                     into opt-2a(idx-opt)
              string w-opt(idx-opt) 
                     "=" 
                     into opt-2b(idx-opt)
              string "-" 
                     w-opt(idx-opt) 
                     "=" 
                     into opt-3(idx-opt)
           end-perform

           move par(1) to prg-name

           perform varying ind from 2 by 1 until ind > 78-max-params
              if ind > num-params
                 exit perform
              end-if
              initialize par-size 
                         par-value-upper
              move function length(par(ind))      to par-size
              move function upper-case(par(ind))  to par-value-upper
              perform ANALYZE-PAR
           end-perform
           
           initialize main-parameter
           set parameter-length to size of prg-args 
           if parameter-length > 0
              move prg-args to parameter-text(1:parameter-length)
           end-if
           call prg-name using main-parameter
           goback
           .

       ANALYZE-PAR.
           if flag-next = 0
              perform varying idx-opt from 1 by 1 
                                         until idx-opt > 78-num-options
                 evaluate par-size
                 when 1
                      if par-value-upper = opt-1(idx-opt)
                         move idx-opt to flag-next
                      end-if
                 when 2
                      if par-value-upper = opt-2a(idx-opt) or 
                                           opt-2b(idx-opt)
                         move idx-opt to flag-next
                      end-if
                 when 3
                      if par-value-upper = opt-3(idx-opt)
                         move idx-opt to flag-next
                      end-if
                 when > 3
                      if flag-next = 0
                         initialize w-start-offset
                         if par-value-upper(1:2) = opt-2b(idx-opt)
                           move 3 to w-start-offset 
                         else
                            if par-value-upper(1:3) = opt-3(idx-opt)
                              move 4 to w-start-offset
                            end-if
                         end-if
                         if w-start-offset > 0
                            evaluate idx-opt
                            when 1
                                 perform SET-PRG-ARGS
                            when 2
                                 perform SET-SWITCH
                            when 3
                                 perform SET-SORT-MEM
                            end-evaluate
                         end-if 
                      end-if 
                 end-evaluate
              end-perform
           else
              perform varying idx-opt from 1 by 1 
                                      until idx-opt > 78-num-options
                 if flag-next > 0
                    if par-size = 1 and par-value-upper = "="
                       continue
                    else
                       evaluate flag-next
                       when 1
                            perform SET-PRG-ARGS
                       when 2
                            perform SET-SWITCH
                       when 3
                            perform SET-SORT-MEM
                       end-evaluate
                       move 0 to flag-next
                    end-if
                 end-if
              end-perform
           end-if
           .

       SET-PRG-ARGS.
           initialize prg-args
           if w-start-offset > 0
              move par(ind)(w-start-offset:) to prg-args
              move 0 to w-start-offset
           else
              move par(ind) to prg-args
           end-if
           .

       SET-SWITCH.
           if w-start-offset > 0
              move par(ind)(w-start-offset:) to switches
              move 0 to w-start-offset
           else
              move par(ind) to switches
           end-if
           
           if switches(1:1) = "1"
              set is-on-1 to on
           else
              set is-on-1 to off
           end-if
           if switches(2:1) = "1"
              set is-on-2 to on
           else
              set is-on-2 to off
           end-if
           if switches(3:1) = "1"
              set is-on-3 to on
           else
              set is-on-3 to off
           end-if
           if switches(4:1) = "1"
              set is-on-4 to on
           else
              set is-on-4 to off
           end-if
           if switches(5:1) = "1"
              set is-on-5 to on
           else
              set is-on-5 to off
           end-if
           if switches(6:1) = "1"
              set is-on-6 to on
           else
              set is-on-6 to off
           end-if
           if switches(7:1) = "1"
              set is-on-7 to on
           else
              set is-on-7 to off
           end-if
           if switches(8:1) = "1"
              set is-on-8 to on
           else
              set is-on-8 to off
           end-if
           .

       SET-SORT-MEM.
           if w-start-offset > 0
              move par(ind)(w-start-offset:) 
                                         to sortmem-size with convert
              move 0 to w-start-offset
           else
              move par(ind) to sortmem-size with convert
           end-if
           set environment "sort.memsize" to sortmem-size 
           .
           