import com.iscobol.java.IsCobol;

public class MainEnvIsolated {
    public static void main (String[] args) {
        
        Runnable javaThread1 = new Runnable(){
            public void run(){                
                System.out.println();
                System.out.println("Java Thread 1");
                IsCobol.setEnvironment("file.prefix", "data-thread-1");
                IsCobol.setEnvironment("myenv", "environment value from Java Thread 1");
                IsCobol.call("COBPROG1", new Object[]{});
            }
        };

        Runnable javaThread2 = new Runnable(){
            public void run(){
                System.out.println();
                System.out.println("Java Thread 2");
                IsCobol.setEnvironment("file.prefix", "data-thread-2");
                IsCobol.setEnvironment("myenv", "environment value from Java Thread 2");
                IsCobol.call("COBPROG2", new Object[]{});
            }
        };
        Thread t1 = new Thread(javaThread1);
        Thread t2 = new Thread(javaThread2);

        t1.start();
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            System.err.println(e);
        }   
        t2.start();

        try {
            t1.join();
            t2.join();
        } catch (InterruptedException e) {
            System.err.println(e);
        }
        System.exit(0);
    }
}