      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
      
       PROGRAM-ID. ZPRODUCT.
       configuration section.
       special-names.   
      
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           copy "product.sl".
       DATA DIVISION.
       FILE SECTION.
           COPY "product.fd".
      
       WORKING-STORAGE SECTION.
      
           copy "common.wrk".
           copy "color.wrk".
      
       77  STATUS-Product   PIC XX.
      
       01  rec-grid.
           05 rg-filler            pic x.
           05 rg-prod-id           pic  x(10).
           05 rg-prod-name         pic  x(20).
           05 rg-prod-description  pic  x(150).
           05 rg-prod-price        pic  zzz,zz9.99.
      
       01                          pic 9.
           88 no-record            value 1 false zero.
      
       01                          pic 9.
           88 record-selected      value 1 false zero.
         
       77  key-used                pic x.
       77  wrk-y                   pic 9(3).
       
       LINKAGE SECTION.
       77  lnk-prod-id     pic x(10).
 
       screen section.

       01  mask-main.
           05  h-grid, grid
               reordering-columns
               sortable-columns
               adjustable-rows
               line 2 col 2
               lines 28 size 78
               width-in-cells
               height-in-cells
               data-columns (1, 2, 12, 32, 182)
               alignment ( "C", "L", "L", "L", "R")
               data-types ( "I", "I", "I", "I", "I",)
               display-columns (3, 16, 30, 65) 
               color 513  
               vscroll
               tiled-headings
               centered-headings 
               column-headings
               row-headings
               heading-color 257
               adjustable-columns
               use-tab
               cursor-frame-width 1
               Row-Cursor-Background-Color rgb 
                                            78-lbl-menu-background-color
               Row-Cursor-foreground-Color rgb 
                                            78-lbl-menu-foreground-color
               Cursor-Foreground-Color rgb 78-cursor-foreground-color 
               Cursor-Background-Color rgb 78-cursor-background-color
               event H-GRID-EVENT
               .

           copy "standard-lookup-tool.scr".

       PROCEDURE DIVISION using lnk-prod-id.
       DECLARATIVES.
       PRODUCT-ERR section.
           use after standard error procedure on product.
           perform ERROR-FILE
           .
       END DECLARATIVES.
       MAIN.
       
           set record-selected  to false.
           initialize lnk-prod-id.
           
           perform OPEN-FILES.
           
           display floating graphical window      
                   title R"isCOBOL_Application_List_of_Product"
                   lines 30
                   size 80
                   control font h-font
                   background-low
                   handle h-sta
                   visible 0
                   system menu
                   gradient-color-1 rgb 78-gradient-color-1
                   gradient-color-2 rgb 78-gradient-color-2 
                   .
           
           display tool-bar 
                   lines 2.5 
                   control font h-font 
                   handle h-tool 
                   upon h-sta
           
           display mask-main upon h-sta
           display mask-tool upon h-tool
           
           perform LOAD-GRID
           
           if no-record
              display message box R"No_record_in_File"
           else
              perform ACCEPT-SCREEN
           end-if
           perform EXIT-PRG.
           goback
           .

       ACCEPT-SCREEN.
           modify h-sta visible 1
           
           perform until key-status = 27
              accept mask-main
                 on exception continue
              end-accept
              perform AFTER-ACCEPT
              move 4 to accept-control
           end-perform       
           .

       AFTER-ACCEPT.
           evaluate key-status
           when 78-exe-selected
                set record-selected   to true
           when w-event
                evaluate event-type
                when cmd-close
                     move 27 to key-status
                end-evaluate
           end-evaluate.
           
           if record-selected
              inquire h-grid cursor-y = wrk-y
              inquire h-grid(wrk-y ) record-data = rec-grid
              move rg-prod-id   to lnk-prod-id
              move 27  to key-status
           end-if.

       LOAD-GRID.
           set no-record  to true.
           
           modify h-grid(1, 2) cell-data R"Product_Id"
           modify h-grid(1, 3) cell-data R"Name"
           modify h-grid(1, 4) cell-data R"Description"
           modify h-grid(1, 5) cell-data R"Price"
           
           move low-value  to prod-id
           start Product key not < Prod-key
              invalid
                 continue
              not invalid
                 perform until 1 = 2
                    read Product next no lock
                       at end
                          exit perform
                       not at end 
                          set no-record   to false
                          initialize rec-grid
                          move prod-id            to rg-prod-id
                          move prod-name          to rg-prod-name
                          move prod-description   to rg-prod-description
                          move prod-price         to rg-prod-price
                          modify h-grid record-to-add rec-grid
                    end-read
                 end-perform
           end-start.

       OPEN-FILES.
           open input Product.

       EXIT-PRG.
           perform DESTROY-RESOURCE
           perform CLOSE-FILE
           .

       CLOSE-FILE.
           close Product.

       DESTROY-RESOURCE.
           modify h-sta visible 0
           destroy mask-main mask-tool h-tool 
                   h-sta 
           .

       H-GRID-EVENT.
           evaluate event-type
           when MSG-BEGIN-ENTRY
                inquire h-grid entry-reason = key-used
                if key-used = x"0D" or
                   key-used = x"00"
                   set record-selected   to true
                   set event-action   to EVENT-ACTION-FAIL-TERMINATE
                else
                    set event-action   to EVENT-ACTION-FAIL
                end-if
           end-evaluate.

           copy "dec-file.prd".