
##### isCOBOL release 2025 R2 build#1158.10-20251128-41083 ######
##### Copyright (c) 2005 - 2025 Veryant. ######

----------
**This sample shows an example for each control, function, routine and object**

**This document assumes the $ISCOBOL environment variable exists and points**
**to the isCOBOL SDK installation folder.**

**When talking about a "command prompt window" it means an isCOBOL Shell**
**on the Windows OS and a standard shell on Linux/Unix**

----------
### To test this program from the Command Prompt follow these instructions:

 - 1 Using a command prompt window go to the "$ISCOBOL/sample/issamples" folder.

 - 2 Compile the programs

        iscc -od=prg -incr=build *.cbl
        iscc -od=prg -incr=build s-functions/*.cbl
        iscc -od=prg -incr=build s-gui/*.cbl
        iscc -od=prg -incr=build s-news/*.cbl
        iscc -od=prg -incr=build s-objects/*.cbl
        iscc -od=prg -incr=build s-routines/*.cbl

 **NOTE:**

        Instead of executing the steps of the point 2 you can run compile.sh file

 **NOTE:**

        The -sp option passes the copybook directories needed to compile the programs
        The -od option specifies the output directory for the generated java classes
        The -incr=build option activate the incremental compiler option. 
            The Incremental Compiler is a compilation strategy in which only modified 
            programs and programs that include modified COPY files get recompiled. 

 - 3 Run the test program

        iscrun SAMPLES 

 **NOTE:**

    To run these samples in debug add the option "-d" or "-dx" during compilation
    and add the "-d" option during the execution

----------
### To test this program from the Command Prompt using ANT follow these instructions:

 **NOTE:**

    Before use this section download the apache ant and put it into the path.
    Also check to have in path the JDK

 - 1 Using a command prompt window go to the "$ISCOBOL/sample/issamples" folder.

 - 2 Compile the programs

        ant build

 **NOTE:**

    the provided build.xml have 4 targets
    - clean: clean up the ANT project
    - compile: compile the ANT project 
    - run: execute the program SAMPLES
    - build: execute the previous 3 target. This is the default target of the ANT process.

 - 3 Run the test program

   - 3a using the ANT syntax:

            ant run

   - 3b using the isCOBOL syntax:

            iscrun SAMPLES

----------
### To test this program from the Command Prompt with application server follow these instructions:

 **On the server**

 - 1 Compile in the same way of previous section

 - 2 Start the Application Server:

        iscserver -hostname <hostname | IP address> -port <port-number> 

 **NOTE:**

    If you have already started an instance of the Application Server,
    you can start a new instance of it on a different port


 **On the client**

 - 1 Start the SAMPLES program

        iscclient -hostname <host-name> -port <port-number> -c iscobol.properties SAMPLES 

----------
### To test this program in the WebClient environment follow the following steps:
  (This option is available only if you have the WebClient option installed)

 **On the isCOBOL application server machine**

 - 1 Repeat steps 1 and 2 of the Stand Alone section

 - 2 Start the Application Server

        iscserver -hostname <hostname | IP address> -port <port-number> 

 **NOTE:**

    If you have already started an instance of the Application Server,
    you can start a new instance on a different port

 **On the WebClient server machine**

 - 1 Using a Webclient's command prompt window go to the "$ISCOBOL/webclient" folder.

 - 2 If the WebClient server is not already running, start it with the following command

        webcclient 

 - 3 Open another Webclient's command prompt

 - 4 If the WebClient Adminstrator service is not already running, start it with the following command

        webcclient-admin

 **NOTE:**

     For development environments you can start the WebClient server and WebClient Admin Console as a single process.
     In order to make this you need to edit the webclient.config file and replace:
     "adminConsoleUrl" : "http://localhost:8090"
     with:
     "adminConsoleUrl" : "http://localhost:8080/admin"

     After this change, you can run
     webcclient-and-admin
     to execute both the webcclient and webclient-admin commands as one."

     The admin link is http://127.0.0.1:8080/admin

 **On the WebClient machine**

 - 1 From your browser open the following url to access the WebClient Administrator panel, changing the address and port to reflect your deployment configuration:

        http://localhost:8090/

 - 2 use the default login credentials

        User: admin 
        Password: admin 

 - 3 Click on **"Applications"**

 - 4 Click on **"+"** and select **"Create new"**

 - 5 Type **"samples"** into the field and confirm the creation of the app

 - 6 Click on the **samples** application on the left side of the window.

 - 7 Fill the configuration fields as follows
     - In the **Web Config** area
       - In the **"General"** section       
         - Web Folder: Type the folder that contains the html start page. The folder is located under your iscobol SDK folder, sample/issamples/files/webclient subfolder
     - In the **App Config** area
       - isCOBOL Server address: Type the hostname of your application server
       - isCOBOL Server port: Type the port used by your application server
       - Program name and arguments: SAMPLES

 - 8 Click on  **"Apply"** in the bottom right side of the screen.

 - 9 Click on  **"Enable"** in the upper right side of the screen.

 - 10 Use the following link in a different browser window to test the sample

        http://localhost:8080/samples/ 
        changing the address and port to reflect your deployment configuration.

### To debug the programs in this environment follow these instructions:

 - Repeat step 1 of the Stand Alone section

 - Compile the programs

        iscc -sp=copylib -d *.cbl

 **NOTE:**

        The -sp option passes the copybook directories needed to compile 
        the programs

 - Modify the iscobol.properties adding the following property

        iscobol.rundebug=1 

 - Start the application server:

        iscserver -hostname <hostname | IP address> -port <port-number> 

 - Using an additional command prompt window and run the remote debugger

        iscrun -d -r <hostname | IP address> <port-number> 

 **NOTE:**

     The remote debugger is started with this command. The debugger is still not 
     activated until the remote program starts

 - Start a new instance of the sample from the browser, navigating to the following URL: 

        http://localhost:8080/samples/ 
        changing the address and port to reflect your deployment configuration.

