      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. yyyy.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5). 
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       01  dateyy.
           03 dateyy-yy            pic 99.
           03 dateyy-mm            pic 99.
           03 dateyy-dd            pic 99.
       77  dateyy9                 pic 9(6) redefines dateyy.

       01  dayyy.
           03 dayyy-yy             pic 99.
           03 dayyy-ddd            pic 9(3).
       77  dayyy9                  pic 9(5) redefines dayyy.

       77  yy                      pic 99.

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              col                  2
              size                 3 cells
              title                "YY"
              .     
           03 label
              line                 2
              col                  6
              size                 3 cells
              title                "MM"
              .
           03 label
              line                 2
              col                  10
              size                 3 cells
              title                "DD"
              .
           03 entry-field
              numeric 
              auto
              line                 4
              col                  2
              size                 3 cells
              max-text             2
              value                dateyy-yy
              .  
           03 entry-field
              numeric 
              auto
              line                 4
              col                  6
              size                 3 cells
              max-text             2
              min-val              1
              max-val              12
              value                dateyy-mm
              .
           03 entry-field
              numeric 
              auto
              line                 4
              col                  10
              size                 3 cells
              max-text             2 
              min-val              1
              max-val              31
              value                dateyy-dd
              .
           03 push-button
              line                 4
              col                  14
              size                 20 cells
              title                "DATE-TO-YYYYMMDD"
              exception-value      101
              self-act
              .
           03 e1 entry-field
              read-only
              line                 4
              col                  35
              size                 20 cells
              .            
           03 label
              line                 6
              col                  2
              size                 3 cells
              title                "YY"
              .     
           03 label
              line                 6
              col                  6
              size                 6 cells
              title                "DDD"
              .
           03 entry-field
              numeric 
              auto
              line                 8 
              col                  2
              size                 3 cells
              max-text             2
              value                dayyy-yy
              .  
           03 entry-field
              numeric auto
              line                 8
              col                  6
              size                 6 cells
              max-text             3
              min-val              1
              max-val              365
              value                dayyy-ddd
              .
           03 push-button
              line                 8
              col                  14
              size                 20 cells
              title                "DAY-TO-YYYYDDD"
              exception-value      102
              self-act
              .
           03 e2 entry-field
              read-only
              line                 8
              col                  35
              size                 20 cells
              . 
           03 label
              line                 10
              col                  2
              size                 3 cells
              title                "YY"
              .
           03 entry-field
              numeric 
              auto
              line                 12
              col                  2
              size                 3 cells
              max-text             2
              value                yy
              .             
           03 push-button
              line                 12
              col                  14
              size                 20 cells
              title                "YEAR-TO-YYYY"
              exception-value      103
              self-act
              .
           03 e3 entry-field
              read-only
              line                 12
              col                  35
              size                 20 cells
              . 
           03 Pb-exit  
              push-button
              line                 20
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.       
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "Date conversion functions"
                   lines 21 
                   min-lines 21
                   size 70
                   min-size 70
                   control font control-font
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    evaluate crt-status 
                    when 101
                         perform DATE-TO-YYYYMMDD 
                    when 102
                         perform DAY-TO-YYYYDDD
                    when 103
                         perform YEAR-TO-YYYY
                    end-evaluate
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .
     
       DATE-TO-YYYYMMDD.
           modify e1 value function date-to-yyyymmdd (dateyy9 , 50)
           .  

       DAY-TO-YYYYDDD. 
           modify e2 value function day-to-yyyyddd (dayyy9 , 50)
           .  

       YEAR-TO-YYYY. 
           modify e3 value function year-to-yyyy (yy , 50)
           .  

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move EVENT-ACTION-FAIL-TERMINATE to EVENT-ACTION 
                move 1 to close-win
           end-evaluate
           .
