      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. date-entry.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.       
       77  close-win               pic 9 value 0. 
       77  control-font            handle of font.

       77  chosen-date1            pic 9(8).
       77  chosen-date1-ed         pic 9999/99/99.
       77  chosen-date2            pic 9(8).
       77  chosen-date2-ed         pic 9999/99/99.
       77  chosen-date3            pic 9(8).
       77  chosen-date3-ed         pic 9999/99/99.
       77  chosen-date4            pic 9(8).
       77  chosen-date4-ed         pic 9999/99/99.
       77  chosen-date5            pic 9(8).
       77  chosen-date5-ed         pic 9999/99/99.
       77  chosen-time             pic 9(4).
       77  chosen-time-ed          pic x(5).

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2 
              col                  2 
              size                 20 cells
              title                "choose a date:"
              .
           03 label
              line                 2 
              col                  40 
              size                 20 cells
              title                "Chosen date:"
              .
           03 label
              line                 4 
              col                  2 
              size                 10 cells
              title                "Normal:"
              .
           03 De1 
              date-entry
              line                 4 
              col                  14 
              size                 20 cells
              value-format         davf-yyyymmdd
              value                chosen-date1
              Notify-Change
              ID                   1
              event                EVENT-DATE
              .
           03 LB1
              label
              line                 4 
              col                  40 
              size                 20 cells
              title                chosen-date1-ed
              .
           03 label
              line                 6
              col                  2 
              size                 11 cells
              title                "Today:"
              .
           03 De2
              date-entry
              line                 6 
              col                  14 
              size                 20 cells
              value-format         davf-yyyymmdd
              value                chosen-date2
              Notify-Change
              today-button-visible
              ID                   2
              event                EVENT-DATE
              .
           03 LB2
              label
              line                 6
              col                  40 
              size                 20 cells
              title                chosen-date2-ed
              .
           03 label
              line                 8 
              col                  2 
              size                 11 cells
              title                "Allow-Empty:"
              .
           03 De3
              date-entry
              Allow-Empty
              line                 8 
              col                  14 
              size                 20 cells
              value-format         davf-yyyymmdd
              value                chosen-date3
              Notify-Change
              ID                   3
              event                EVENT-DATE
              .
           03 LB3
              label
              line                 8 
              col                  40 
              size                 20 cells
              title                chosen-date3-ed
              .
           03 label
              line                 10 
              col                  2 
              size                 10 cells
              title                "Numeric:"
              .
           03 De4
              date-entry
              Numeric
              line                 10
              col                  14 
              size                 20 cells
              value-format         davf-yyyymmdd
              value                chosen-date4
              Notify-Change
              ID                   4
              event                EVENT-DATE
              .
           03 LB4
              label
              line                 10
              col                  40 
              size                 20 cells
              title                chosen-date4-ed
              .
           03 label
              line                 12
              col                  2 
              size                 10 cells
              title                "Show-None:"
              .
           03 De5
              date-entry
              Show-None
              line                 12 
              col                  14 
              size                 20 cells
              value-format         davf-yyyymmdd
              value                chosen-date5-ed
              Notify-Change
              ID                   5
              event                EVENT-DATE
              .
           03 LB5
              label
              line                 12 
              col                  40 
              size                 20 cells
              title                chosen-date5-ed
              .
           03 label
              line                 14 
              col                  2 
              size                 10 cells
              title                "Time:"
              .
           03 De6
              date-entry
              Time
              line                 14 
              col                  14 
              size                 17 cells
              value-format         davf-hhmm
              value                chosen-time
              Notify-Change
              ID                   6
              event                EVENT-DATE
              .
           03 LB6
              label
              line                 14 
              col                  40 
              size                 20 cells
              title                chosen-time-ed
              .
           03 Pb1 
              push-button
              line                 17
              col                  2
              size                 12
              title                "&Chosen date"
              exception-value      100
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "DATE-ENTRY Control"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask

           inquire DE1 value chosen-date1
           move chosen-date1 to chosen-date1-ed
           modify LB1 title chosen-date1-ed

           inquire DE2 value chosen-date2
           move chosen-date2 to chosen-date2-ed
           modify LB2 title chosen-date2-ed

           inquire DE3 value chosen-date3
           move chosen-date3 to chosen-date3-ed
           modify LB3 title chosen-date3-ed

           inquire DE4 value chosen-date4
           move chosen-date4 to chosen-date4-ed
           modify LB4 title chosen-date4-ed

           inquire DE5 value chosen-date5
           move chosen-date5 to chosen-date5-ed
           modify LB5 title chosen-date5-ed

           inquire DE6 value chosen-time
           string chosen-time(1:2) delimited by size
                  ":"              delimited by size
                  chosen-time(3:2) delimited by size
                  into chosen-time-ed
           modify LB6 title chosen-time-ed

           perform until crt-status = 27 or close-win = 1
              accept  Mask 
                   on exception
                      if crt-status = 100
                         perform CHOSEN-DATE
                      end-if
              end-accept
              move 4   to accept-control
           end-perform 

           destroy Mask
           destroy hWin
           goback
           .

       CHOSEN-DATE.
           display message x"0A"
                           "Chosen date: " 
                           x"0A0A"
                           "Normal: "       chosen-date1
                           x"0A0A"
                           "Today button: " chosen-date2
                           x"0A0A"
                           "Allow-Empty: "  chosen-date3
                           x"0A0A"
                           "Numeric: "      chosen-date4
                           x"0A0A"
                           "Show-None: "    chosen-date5
                           x"0A0A"
                           "Time: "         chosen-time
           .

       EVENT-DATE.
           if event-type = NTF-CHANGED
              evaluate event-control-id
                       when 1
                            inquire DE1 value chosen-date1
                            move chosen-date1 to chosen-date1-ed
                            modify LB1 title chosen-date1-ed
                       when 2
                            inquire DE2 value chosen-date2
                            move chosen-date2 to chosen-date2-ed
                            modify LB2 title chosen-date2-ed
                       when 3
                            inquire DE3 value chosen-date3
                            move chosen-date3 to chosen-date3-ed
                            modify LB3 title chosen-date3-ed
                       when 4
                            inquire DE4 value chosen-date4
                            move chosen-date4 to chosen-date4-ed
                            modify LB4 title chosen-date4-ed
                       when 5
                            inquire DE5 value chosen-date5
                            move chosen-date5 to chosen-date5-ed
                            modify LB5 title chosen-date5-ed
                       when 6
                            inquire DE6 value chosen-time
                            string chosen-time(1:2) delimited by size
                                   ":"              delimited by size
                                   chosen-time(3:2) delimited by size
                                   into chosen-time-ed
                            modify LB6 title chosen-time-ed
              end-evaluate
           end-if
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
