      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. notification.

       WORKING-STORAGE SECTION. 
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  close-win               pic 9 value 0.
       77  control-font            handle of font.
       77  h-main                  handle of window.
       77  h-notif                 handle of window.
       
       77  base-sorg-path          pic x(20). 
       77  command                 pic x(100).

       77  lb1-title               pic 9.
       77  lb1                     handle of label.

       SCREEN SECTION.
       01  mask.
           03 frame
              engraved
              line                 4
              col                  15
              size                 40
              lines                14
              title                "Types of notification"
              .
           03 push-button 
              line                 7 
              col                  29 
              size                 11 
              title                "Top-Right"
              exception-value      11
              .
           03 push-button 
              line                 9 
              col                  29 
              size                 11 
              title                "Top-Left"
              exception-value      12
              .
           03 push-button 
              line                 11
              col                  29 
              size                 11 
              title                "Bottom-Right"
              exception-value      13
              .
           03 push-button 
              line                 13
              col                  29 
              size                 11 
              title                "Bottom-Left"
              exception-value      14
              .
           03 push-button 
              line                 15
              col                  29 
              size                 11 
              title                "Before Time"
              exception-value      15
              .
           03 push-button
              line                 20
              col                  2
              size                 20 cells
              title                "View &Source [F2]"
              exception-value      2
              .
           03 push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           accept base-sorg-path from environment "home_source".
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call

           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   size      70 
                   lines     21
                   min-size  70 
                   min-lines 21
                   resizable
                   title     "Notification Window"
                   control font control-font
                   handle h-main
                   event  WIN-EVT

           display mask

           perform until crt-status = 27 or close-win = 1
              accept mask 
                 on exception
                    continue
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform

           destroy mask
           destroy h-main
           destroy control-font
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status 
           when 2
                perform VIEW-SORG
           when 11
                display notification window
                        top right 
                        lines 5 
                        size 28
                        control font control-font
                        visible 0
                        handle h-notif
                perform DISPLAY-SCREEN-NOTIF
           when 12
                display NOTIFICATION window
                        top left 
                        lines 5 
                        size 28
                        control font control-font
                        visible 0
                        handle h-notif
                perform DISPLAY-SCREEN-NOTIF
           when 13
                display notification window
                        bottom right 
                        lines 5 
                        size 28
                        control font control-font
                        visible 0
                        handle h-notif
                perform DISPLAY-SCREEN-NOTIF
           when 14
                display notification window
                        bottom left
                        lines 5 
                        size 28
                        control font control-font
                        visible 0
                        handle h-notif
                perform DISPLAY-SCREEN-NOTIF
           when 15
                display notification window
                        top right 
                        lines 3 
                        size 31
                        control font control-font
                        before time 550
                        visible 0
                        handle h-notif
                perform DISPLAY-SCREEN-NOTIF-BEFORE
           when 201
                display message box "Pressed 'Pb 1' Button"
           when 202
                display message box "Pressed 'Pb 2' Button"
           end-evaluate
           .
       DISPLAY-SCREEN-NOTIF.
           display label 
                   line 2 
                   col 3
                   title "Choose one of available options..."
                   upon h-notif.

           display push-button 
                   line                 4
                   col                  3
                   size                 10 
                   title                "Pb 1" 
                   self-act
                   exception-value      201
                   upon h-notif.

           display push-button 
                   line                 4 
                   col                  17
                   size                 10 
                   title                "Pb 2" 
                   self-act
                   exception-value      202
                   upon h-notif.
           modify h-notif visible 1.

       DISPLAY-SCREEN-NOTIF-BEFORE.
           move 5 to lb1-title.

           display label 
                   line 2 
                   col 2
                   title "The notification will close in "
                   upon h-notif.
           display label 
                   line 2 
                   col 22
                   title lb1-title
                   handle in lb1 
                   .
           display label 
                   line 2
                   col 24
                   title "seconds".
           modify h-notif visible 1.

           perform thread until lb1-title = 0
              call "c$sleep" using 1
              subtract 1 from lb1-title
              modify lb1 title lb1-title
           end-perform
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       VIEW-SORG.
           initialize command
           string base-sorg-path      delimited by trailing space
                  "s-gui"             delimited by space
                  "/NOTIFICATION.cbl" delimited by size
                  into command.

           call run "TEXTVIEWER"  using command.
           