      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. tab-close-buttons.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  close-win               pic 9 value 0.
       77  control-font            handle of font.

       SCREEN SECTION.

       01  Mask.
           03 Tb1-container
              tab-control
              line                          2 
              col                           2
              lines                         5 cells
              size                          68 cells
              allow-container
              tab-flat
              active-tab-border-width       (0 0 2 0)
              tab-border-width              (0 0 1 0)
              tab-foreground-color          rgb x#ACACAC
              tab-border-color              rgb x#ACACAC
              active-tab-border-color       rgb x#395a9d
              active-tab-background-color   rgb x#FFFFD0 
              active-tab-foreground-color   rgb x#354c5c
              close-buttons
              Relative-Offset
              .
           03 tb1-container-page1 
              tab-group Tb1-container       tab-group-value 1.
              05 label 
                 line                       2
                 col                        2
                 transparent
                 title                      "This is the first page"
                 .
              05 ef1-container
                 entry-field
                 line                       2
                 col                        20
                 .
           03 tb1-container-page2 
              tab-group Tb1-container       tab-group-value 2.
              05 label
                 line                       2
                 col                        2 
                 title                      "This is the second page"
                 .
              05 cb1-container
                 combo-box
                 line                       2
                 col                        22
                 .
           03 tb1-container-page3  
              tab-group Tb1-container       tab-group-value 3.
              05 label
                 line                       2
                 col                        2
                 title                      "This is the third page"
                 .
           03 Tb1-accordion
              tab-control
              line                          8
              col                           2
              lines                         11 cells
              size                          68 cells
              accordion
              tab-flat
              background-color              rgb X#DAE1E5 
              foreground-color              rgb x#354C5C
              tab-background-color          rgb x#FFFFD0
              tab-foreground-color          rgb x#354c5c
              tab-rollover-color            rgb x#6A98C6
              tab-flat
              tab-delay                     700
              close-buttons
              Relative-Offset
              .
           03 Tb1-accordion-page1 
              tab-group Tb1-accordion       tab-group-value 1.
              05 label 
                 transparent
                 line                       2
                 col                        2
                 title                      "This is the first page"
                 .
              05 ef1-accordion
                 entry-field
                 line                       4
                 col                        2
                 .
           03 Tb1-accordion-page2 
              tab-group Tb1-accordion       tab-group-value 2.
              05 label
                 transparent
                 line                       2
                 col                        2 
                 title                      "This is the second page"
                 .
              05 cb1-accordion
                 combo-box
                 line                       4
                 col                        2
                 .
           03 Tb1-accordion-page3  
              tab-group Tb1-accordion       tab-group-value 3.
              05 label
                 transparent
                 line                       2
                 col                        2
                 title                      "This is the third page"
                 .
           03 push-button
              line                          20
              col                           62
              size                          8 cells
              title                         "Exit" 
              exception-value               27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "TAB Control close-buttons and tab-hint"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask

           modify Tb1-container tab-to-add ("Page1", "Page2", "Page 3")
           modify Tb1-container tab-index 1 
                                tab-hint "This is the hint of page 1"
           modify Tb1-container tab-index 2
                                tab-hint "This is the hint of page 2"
           modify Tb1-container tab-index 3
                                tab-hint "This is the hint of page 3"


           modify Tb1-accordion tab-to-add ("Page1", "Page2", "Page3")
           modify Tb1-accordion tab-index 1 tab-hint "Hint Page1"
                                tab-hint "This is the hint of page 1"
           modify Tb1-accordion tab-index 2
                                tab-hint "This is the hint of page 2"
           modify Tb1-accordion tab-index 3
                                tab-hint "This is the hint of page 3"

           modify Cb1-container item-to-add ("item1", "item2")
           modify Cb1-accordion item-to-add ("item1", "item2")

           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception
                    continue 
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin 
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
