      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. esqlruntime.
       ENVIRONMENT DIVISION.

       CONFIGURATION SECTION.

       REPOSITORY.
           class iscobolrtsEsqlRuntime as "com.iscobol.rts.EsqlRuntime"
           class sqlConnection  as "java.sql.Connection"
           .

       INPUT-OUTPUT SECTION.

       DATA DIVISION.

       FILE SECTION.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".
       copy "isresize.def".
       copy "SQLCA".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.       
       77  control-font            handle of font.
       77  close-win               pic 9      value 0. 

       77  sql-conn                object reference sqlConnection.

       77  url                     pic x(256) value 
                                "jdbc:derby:memory:testdb;create=true".
       77  driver                  pic x(256) value 
                                 "org.apache.derby.jdbc.EmbeddedDriver".

       77  err-message             pic x any length.
       77  ed-sqlcode              PIC -z(8)9.
       
       77                          pic 9.
           88 no-first-connection  value 1 false zero.

       SCREEN SECTION.
       01  Mask.   
           03 label
              line                 2 
              lines                2
              size                 68
              col                  2 
              title                "This sample needs to make a SQL conn
      -                            "ection. Ensure you have your databas
      -                            "e JDBC driver jar library in your CL
      -                            "ASSPATH."
              .
           03 label
              line                 4 
              lines                2
              size                 68
              col                  2 
              title                "Change the name of the Driver and th
      -                            "e URL to set correct value for your 
      -                            "RDBMS."
              . 
              
           03 frame 
              line                 6 
              col                  2 
              engraved 
              title                "JDBC Settings"
              lines                10 
              size                 68
              height-in-cells 
              width-in-cells
              .
           03 label
              line                 7 
              col                  3
              title                "Driver:"
              .
           03 entry-field
              line                 9
              col                  3
              size                 65 cells
              max-text             256
              value                driver
              .  
           03 label
              line                 11
              col                  3 
              title                "Url:"
              .
           03 entry-field
              line                 13
              col                  3
              size                 65 cells
              max-text             256
              value                url
              .
           03 push-button 
              line                 17
              col                  2
              size                 17 cells
              title                "&Check Connection"
              exception-value      101
              .
           03 push-button 
              line                 17
              col                  27
              size                 17 cells
              title                "&Connect"
              exception-value      102
              .
           03 push-button 
              line                 17
              col                  53
              size                 17 cells
              title                "&Disconnect"
              exception-value      103
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN. 

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "EsqlRuntime Objects"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask
           
           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform  

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status
           when 101
                perform GET-CURRENT-CONNECTION
           when 102
                perform CONNECT-DB
           when 103
                perform DISCONNECT-DB
           end-evaluate
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       GET-CURRENT-CONNECTION.
           set no-first-connection to false
           try
              set sql-conn   to iscobolrtsEsqlRuntime:>getCurrConnection
           catch exception
              set no-first-connection to true
           end-try
           if no-first-connection
              display message "No SQL connection done so far."
                              x"0D0A"
                              "Press 'Connect' button"
           else
              if sql-conn = NULL
                 display message "No SQL connection available" 
              else
                 display message "Current DB connection is " 
                               sql-conn
              end-if
           end-if
           .

       CONNECT-DB.
           set environment "jdbc.driver" to driver
           set environment "jdbc.url"  to url

           exec sql 
              connect 
           end-exec.

           if SQLCODE not = 0
              initialize err-message
              move sqlcode to ed-sqlcode
              string "Error:"       delimited by size
                     x"0D0A"        delimited by size
                     "SQLCODE is "  delimited by size
                     ed-sqlcode     delimited by size
                     x"0D0A"        delimited by size
                     "Message is <" delimited by size
                     sqlerrmc       delimited by trailing space
                     ">"            delimited by size
                     into err-message
              display message err-message
           end-if
           .

       DISCONNECT-DB.
           exec sql
              disconnect current
           end-exec
           .
