       PROGRAM-ID. SEARCHPANELSETTINGS.
       CONFIGURATION SECTION.

       REPOSITORY.
           class sp-settings
                       as "com.iscobol.gui.server.SearchPanelSettings"
           class j-boolean as "java.lang.Boolean"
           .
       INPUT-OUTPUT SECTION.

       DATA DIVISION.

       FILE SECTION.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5). 
       77  hWin                    handle of window.
       77  close-win               pic 9 value 0.
       77  control-font            handle of font.

       77  gd-songs-settings       object reference sp-settings.
       77  ls-songs-settings       object reference sp-settings.
       77  tv-songs-settings       object reference sp-settings.
       77  tt-songs-settings       object reference sp-settings.
       77  bool                    object reference j-boolean.

       01  tab-album.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Let It Be".
           03 filler               pic x(5)  value "4:03".
           03 filler               pic x(20) value "Beatles".
           03 filler               pic x(30) value "Let It Be".
           03 filler               pic x(15) value "Pop".
           03 filler               pic x(30) value "Apple Records".
           03 filler               pic 9(4)  value 1970.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Yellow Submarine".
           03 filler               pic x(5)  value "2:40".
           03 filler               pic x(20) value "Beatles".
           03 filler               pic x(30) value "Revolver".
           03 filler               pic x(15) value "Pop".
           03 filler               pic x(30) value "Apple Records".
           03 filler               pic 9(4)  value 1966.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Help!".
           03 filler               pic x(5)  value "2:21".
           03 filler               pic x(20) value "Beatles".
           03 filler               pic x(30) value "Help!".
           03 filler               pic x(15) value "Pop".
           03 filler               pic x(30) value "Parlophone".
           03 filler               pic 9(4)  value 1965.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Yesterday".
           03 filler               pic x(5)  value "2:07".
           03 filler               pic x(20) value "Beatles".
           03 filler               pic x(30) value "Help!".
           03 filler               pic x(15) value "Pop".
           03 filler               pic x(30) value "Parlophone".
           03 filler               pic 9(4)  value 1965.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Angie".
           03 filler               pic x(5)  value "4:30".
           03 filler               pic x(20) value "The Rolling Stones".
           03 filler               pic x(30) value "Goats Head Soup".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "R.S.Records".
           03 filler               pic 9(4)  value 1973.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Start Me Up".
           03 filler               pic x(5)  value "3:32".
           03 filler               pic x(20) value "The Rolling Stones".
           03 filler               pic x(30) value "Tattoo You".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value 
                                               "Rolling Stones records".
           03 filler               pic 9(4)  value 1981.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Satisfaction".
           03 filler               pic x(5)  value "3:45".
           03 filler               pic x(20) value "The Rolling Stones".
           03 filler               pic x(30) value "Out of Our Heads".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Decca/ABKCO".
           03 filler               pic 9(4)  value 1965.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Rain Fall Down".
           03 filler               pic x(5)  value "4:55".
           03 filler               pic x(20) value "The Rolling Stones".
           03 filler               pic x(30) value "A Bigger Bang".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Polydor Records".
           03 filler               pic 9(4)  value 2005.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Maria Maria".
           03 filler               pic x(5)  value "4:19".
           03 filler               pic x(20) value "Santana".
           03 filler               pic x(30) value "Supernatural".
           03 filler               pic x(15) value "Latin Rock".
           03 filler               pic x(30) value "BMG Arista/Ariola".
           03 filler               pic 9(4)  value 1999.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Oye como va".
           03 filler               pic x(5)  value "4:36".
           03 filler               pic x(20) value "Santana".
           03 filler               pic x(30) value "Abraxas".
           03 filler               pic x(15) value "Latin Rock".
           03 filler               pic x(30) value "Columbia Records".
           03 filler               pic 9(4)  value 1970.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value 
                                               "Lightning in the sky".
           03 filler               pic x(5)  value "3:50".
           03 filler               pic x(20) value "Santana".
           03 filler               pic x(30) value "Marathon".
           03 filler               pic x(15) value "Latin Rock".
           03 filler               pic x(30) value "Columbia Records".
           03 filler               pic 9(4)  value 1979.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Foo Foo".
           03 filler               pic x(5)  value "6:29".
           03 filler               pic x(20) value "Santana".
           03 filler               pic x(30) value "Shaman".
           03 filler               pic x(15) value "Latin Rock".
           03 filler               pic x(30) value "Arista".
           03 filler               pic 9(4)  value 2002.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Money for Nothing".
           03 filler               pic x(5)  value "6:19".
           03 filler               pic x(20) value "Eric Clapton".
           03 filler               pic x(30) value 
                                                  "After Midnight Live". 
           03 filler               pic x(15) value "Rock/Pop".
           03 filler               pic x(30) value "Immortal".
           03 filler               pic 9(4)  value 2006.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "After Midnight".
           03 filler               pic x(5)  value "2:51".
           03 filler               pic x(20) value "Eric Clapton".
           03 filler               pic x(30) value "Eric Clapton".
           03 filler               pic x(15) value "Rock/Pop".
           03 filler               pic x(30) value 
                                               "Atco, Polydor Records".
           03 filler               pic 9(4)  value 1970.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Bad Love".
           03 filler               pic x(5)  value "6:25".
           03 filler               pic x(20) value "Eric Clapton".
           03 filler               pic x(30) value "24 Nights".
           03 filler               pic x(15) value "Blues rock".
           03 filler               pic x(30) value "Duck Records".
           03 filler               pic 9(4)  value 1991.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value 
                                               "Next Time You See Her".
           03 filler               pic x(5)  value "4:02".
           03 filler               pic x(20) value "Eric Clapton".
           03 filler               pic x(30) value "Slowhand".
           03 filler               pic x(15) value "Blues".
           03 filler               pic x(30) value "Polydor".
           03 filler               pic 9(4)  value 1977.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Albachiara".
           03 filler               pic x(5)  value "4:05".
           03 filler               pic x(20) value "Vasco Rossi".
           03 filler               pic x(30) value 
                                         "Non siamo mica gli americani".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Lotus LOP".
           03 filler               pic 9(4)  value 1979.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Tango".
           03 filler               pic x(5)  value "3:07".
           03 filler               pic x(20) value "Vasco Rossi".
           03 filler               pic x(30) value "Liberi Liberi".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Emi".
           03 filler               pic 9(4)  value 1988.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "C'e' chi dice no". 
           03 filler               pic x(5)  value "4:38".
           03 filler               pic x(20) value "Vasco Rossi".
           03 filler               pic x(30) value "C'e' chi dice no". 
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Carosello".
           03 filler               pic 9(4)  value 1987.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Bollicine".
           03 filler               pic x(5)  value "5:40".
           03 filler               pic x(20) value "Vasco Rossi".
           03 filler               pic x(30) value "Bollicine".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Carosello".
           03 filler               pic 9(4)  value 1983.

       01  tab-album-red           redefines tab-album.
           03 ta-item              occurs 20.
              05 ta-prog           pic z(3).
              05 ta-title          pic x(30).
              05 ta-length         pic x(5).
              05 ta-Artist         pic x(20).
              05 ta-album          pic x(30).
              05 ta-genre          pic x(15).
              05 ta-label          pic x(30).
              05 ta-year           pic 9(4).

       01  gd-songs-data.
           05 gsd-prog             pic z(3).
           05 gsd-title            pic x(30).
           05 gsd-length           pic x(5).
           05 gsd-Artist           pic x(20).
           05 gsd-album            pic x(30).
           05 gsd-genre            pic x(15).
           05 gsd-label            pic x(30).
           05 gsd-year             pic 9(4).

       01  tt-songs-data.
           03 tsd-multi            pic x(30).
           03 tsd-length           pic x(5).
           03 tsd-album            pic x(30).
           03 tsd-year             pic z(4).

       77  old-ta-Artist           pic x(20).
       77  old-ta-genre            pic x(15).
       77  item-name               pic x(50).
       77  idx                     pic 99.
       77  tv-songs-item           unsigned-int.
       77  tv-songs-item-parent    unsigned-int.
       77  tv-songs-item-child     unsigned-int.
       77  tt-songs-item           unsigned-int.
       77  tt-songs-item-parent    unsigned-int.
       77  tt-songs-item-child     unsigned-int.

       77  h-gd-songs              usage handle.
       77  h-ls-songs              usage handle.
       77  h-tv-songs              usage handle.
       77  h-tt-songs              usage handle.
       
       77  wrk-sp-setings          pic x any length.

       77  p-filter-button         pic 9.
       77  p-filter                pic 9.
       77  p-navigation            pic 9.
       77  p-erase                 pic 9.
       77  p-case-button           pic 9.
       77  p-case                  pic 9.

       SCREEN SECTION.
       01  Mask.
           03 cb-filter-button
              check-box
              title                         "Filter button"
              line                          2
              col                           2
              size                          15 cells
              left-text
              left-text-alignment           1
              value                         p-filter-button
              exception-value               101
              .
           03 cb-filter
              check-box
              title                         "Filter Active"
              line                          2
              col                           25
              size                          15 cells
              left-text
              left-text-alignment           1
              value                         p-filter
              exception-value               102
              .
           03 cb-navigation
              check-box
              title                         "Navigation buttons"
              line                          2
              col                           48
              size                          20 cells
              left-text
              left-text-alignment           1
              value                         p-navigation
              exception-value               103
              .
           03 cb-erase
              check-box
              title                         "Erase button"
              line                          4
              col                           2
              size                          15 cells
              left-text
              left-text-alignment           1
              value                         p-erase
              exception-value               104
              .
           03 cb-case-button
              check-box
              title                         "Case button"
              line                          4
              col                           25
              size                          15 cells
              left-text
              left-text-alignment           1
              value                         p-case-button
              exception-value               105
              .
           03 cb-case
              check-box
              title                         "Case Sensitive"
              line                          4
              col                           48
              size                          20 cells
              left-text
              left-text-alignment           1
              value                         p-case
              exception-value               106
              .
           03 tab-container
              tab-control
              line                          6
              col                           2
              lines                         14 cells
              size                          68 cells
              allow-container
              tab-flat
              relative-offset
              active-tab-border-width       (0 0 2 0)
              tab-border-width              (0 0 1 0)
              tab-foreground-color          rgb x#ACACAC
              tab-border-color              rgb x#ACACAC
              active-tab-border-color       rgb x#395a9d
              active-tab-background-color   rgb x#dae1e5 
              active-tab-foreground-color   rgb x#354c5c
              .
           03 tab-container-page1 
              tab-group tab-container       tab-group-value 1.
              05 gd-songs
                 grid 
                 line                       1.5
                 col                        2
                 lines                      6
                 size                       65 cells
                 display-columns           (1, 5, 25, 35, 55, 80, 100, 
                                            120)
                 data-columns              (record-position of gsd-prog
                                            record-position of gsd-title
                                         record-position of gsd-length
                                         record-position of gsd-Artist
                                            record-position of gsd-album
                                            record-position of gsd-genre
                                            record-position of gsd-label
                                            record-position of gsd-year)

                 alignment                 ("C" "L" "C" "L" "L" "L" "L" 
                                            "R")
                 data-types                ("Z(3)", "X(30)", "X(5)", 
                                            "X(20)", "X(30)", "X(15)", 
                                            "X(30)", "9(4)") 
                 virtual-width              130
                 boxed
                 column-headings 
                 row-headings 
                 centered-headings
                 tiled-headings
                 Adjustable-Columns
                 reordering-columns
                 sortable-columns
                 vscroll
                 row-background-color-pattern = (-16777215, -14675438)
                 end-color                  -16774581
                 heading-color              257
                 border-color               rgb x#ACACAC
                 search-panel               1
                 .
           03 tab-container-page2 
              tab-group tab-container       tab-group-value 2.
              05 ls-songs
                 list-box
                 line                       1.5
                 col                        2
                 lines                      11 cells
                 size                       65 cells
                 unsorted
                 search-panel               1
                 .

           03 tab-container-page3 
              tab-group tab-container       tab-group-value 3.
              05 Tv-songs
                 tree-view
                 buttons 
                 lines-at-root
                 line                       1.5
                 col                        2
                 lines                      11 cells
                 size                       65 cells
                 show-sel-always
                 selection-background-color rgb x#6883AE
                 selection-foreground-color rgb x#FFFFFF
                 search-panel               1
                 .
           03 tab-container-page4 
              tab-group tab-container       tab-group-value 4.
              05 tt-songs
                 tree-view
                 table-view
                 flat
                 buttons
                 lines-at-root
                 adjustable-columns
                 line                       1.5
                 col                        2
                 lines                      11
                 size                       65 cells  
                 display-columns           (1, 30, 37, 60)
                 virtual-width              63
                 data-columns              (record-position of tsd-multi
                                           record-position of tsd-length
                                            record-position of tsd-album
                                            record-position of tsd-year)
                 column-headings
                 tiled-headings
                 centered-headings
                 heading-color              257
                 adjustable-columns
                 reordering-columns
                 end-color                  -16774581
                 selection-background-color rgb x#6883AE
                 selection-foreground-color rgb x#FFFFFF
                 sortable-columns
                 sort-types                ("X", "X", "X", "X")
                 heading-menu-popup         3
                 alignment                 ("U", "C", "L", "R")
                 vpadding                   50
                 search-panel               1
                 .
           03 push-button
              line                          20 
              col                           62 
              size                          8 cells
              title                         "Exit" 
              exception-value               27
              .

       PROCEDURE DIVISION.
       MAIN.
           perform INITIAL-VALUES

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "SearchPanelSettings Obejct"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask

           perform INITIAL-SETTINGS

           modify tab-container tab-to-add ("Grid"
                                            "List-box"
                                            "Tree-view"
                                            "Tree-view table-view")

           perform LOAD-DATA

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    evaluate crt-status
                    when 101 
                         perform CHANGE-FILTER-BUTTON
                    when 102 
                         perform CHANGE-FILTER
                    when 103 
                         perform CHANGE-NAVIGATION
                    when 104
                         perform CHANGE-ERASE
                    when 105
                         perform CHANGE-CASE-BUTTON
                    when 106
                         perform CHANGE-CASE
                    end-evaluate
              end-accept
              move 4 to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       INITIAL-SETTINGS.
           set h-gd-songs          to handle of gd-songs
           set h-ls-songs          to handle of ls-songs
           set h-tv-songs          to handle of tv-songs
           set h-tt-songs          to handle of tt-songs

           set gd-songs-settings   to sp-settings:>new(h-gd-songs)
           set ls-songs-settings   to sp-settings:>new(h-ls-songs)
           set tv-songs-settings   to sp-settings:>new(h-tv-songs)
           set tt-songs-settings   to sp-settings:>new(h-tt-songs)
           .

       INITIAL-VALUES.
           accept wrk-sp-setings 
                          from environment "gui.search_panel_settings"
              on exception
                 move "1012" to wrk-sp-setings
           end-accept

           evaluate wrk-sp-setings(1:1)
           when "0"
                move 0 to p-filter-button
                move 0 to p-filter
           when "1"
                move 0 to p-filter-button
                move 1 to p-filter
           when "2"
                move 1 to p-filter-button
                move 0 to p-filter
           when "3"
                move 1 to p-filter-button
                move 1 to p-filter
           end-evaluate

           evaluate wrk-sp-setings(2:1)
           when "0"
                move 0 to p-navigation
           when "1"
                move 1 to p-navigation
           end-evaluate

           evaluate wrk-sp-setings(3:1)
           when "0"
                move 0 to p-erase
           when "1"
                move 1 to p-erase
           end-evaluate

           evaluate wrk-sp-setings(4:1)
           when "0"
                move 0 to p-case-button
                move 0 to p-case
           when "1"
                move 0 to p-case-button
                move 1 to p-case
           when "2"
                move 1 to p-case-button
                move 0 to p-case
           when "3"
                move 1 to p-case-button
                move 1 to p-case
           end-evaluate
           .

       CHANGE-FILTER-BUTTON.
           inquire CB-filter-BUTTON value p-filter-button
           if p-filter-button = 1
              set bool to j-boolean:>TRUE
           else
              set bool to j-boolean:>FALSE
           end-if

           gd-songs-settings:>setShowFilterButton(bool)
           ls-songs-settings:>setShowFilterButton(bool)
           tv-songs-settings:>setShowFilterButton(bool)
           tt-songs-settings:>setShowFilterButton(bool)
           .

       CHANGE-FILTER.
           inquire CB-filter value p-filter
           if p-filter = 1
              set bool to j-boolean:>TRUE
           else
              set bool to j-boolean:>FALSE
           end-if

           gd-songs-settings:>setFilterEnabled(bool)
           ls-songs-settings:>setFilterEnabled(bool)
           tv-songs-settings:>setFilterEnabled(bool)
           tt-songs-settings:>setFilterEnabled(bool)
           .

       CHANGE-NAVIGATION.
           inquire CB-navigation   value p-navigation
           if p-navigation = 1
              set bool to j-boolean:>TRUE
           else
              set bool to j-boolean:>FALSE
           end-if

           gd-songs-settings:>setShowNavigationButtons(bool)
           ls-songs-settings:>setShowNavigationButtons(bool)
           tv-songs-settings:>setShowNavigationButtons(bool)
           tt-songs-settings:>setShowNavigationButtons(bool)
           .

       CHANGE-ERASE.
           inquire cb-erase   value p-erase
           if p-erase = 1
              set bool to j-boolean:>TRUE
           else
              set bool to j-boolean:>FALSE
           end-if

           gd-songs-settings:>setShowCleanButton(bool)
           ls-songs-settings:>setShowCleanButton(bool)
           tv-songs-settings:>setShowCleanButton(bool)
           tt-songs-settings:>setShowCleanButton(bool)
           .

       CHANGE-CASE-BUTTON.
           inquire cb-case-button   value p-case-button
           if p-case-button = 1
              set bool to j-boolean:>TRUE
           else
              set bool to j-boolean:>FALSE
           end-if

           gd-songs-settings:>setShowCaseSensitiveButton(bool)
           ls-songs-settings:>setShowCaseSensitiveButton(bool)
           tv-songs-settings:>setShowCaseSensitiveButton(bool)
           tt-songs-settings:>setShowCaseSensitiveButton(bool)
           .

       CHANGE-CASE.
           inquire cb-case   value p-case
           if p-case = 1
              set bool to j-boolean:>TRUE
           else
              set bool to j-boolean:>FALSE
           end-if

           gd-songs-settings:>setCaseSensitiveEnabled(bool)
           ls-songs-settings:>setCaseSensitiveEnabled(bool)
           tv-songs-settings:>setCaseSensitiveEnabled(bool)
           tt-songs-settings:>setCaseSensitiveEnabled(bool)
           .

       LOAD-DATA.
           modify gd-songs   mass-update 1
           modify ls-songs   mass-update 1
           modify tv-songs   mass-update 1
           modify tt-songs   mass-update 1

      *    Grid settings
           modify gd-songs x 2, y 1, cell-data "Title"
           modify gd-songs x 2, y 1, column-protection 1
           modify gd-songs x 3, y 1, cell-data "Length"
           modify gd-songs x 4, y 1, cell-data "Artist"
           modify gd-songs x 5, y 1, cell-data "Album"
           modify gd-songs x 6, y 1, cell-data "Genre"
           modify gd-songs x 7, y 1, cell-data "Label"
           modify gd-songs x 8, y 1, cell-data "Year"
           modify gd-songs insertion-index 2

           move low-value to old-ta-genre
           move low-value to old-ta-Artist

           modify tt-songs(-1, 1) item-text ("Title")
           modify tt-songs(-1, 2) item-text ("Length")
           modify tt-songs(-1, 3) item-text ("Album")
           modify tt-songs(-1, 4) item-text ("Year")


           perform varying idx from 1 by 1 until idx > 20
              move idx to ta-prog(idx)
              move ta-item(idx)  to gd-songs-data
              modify gd-songs record-to-add gd-songs-data
              modify ls-songs item-to-add ta-title(idx)
              if ta-genre(idx) not = old-ta-genre
                 perform ADD-TREE-PARENT
              else
                 if ta-Artist(idx) not = old-ta-Artist
                    perform ADD-TREE-CHILD
                 else
                    perform ADD-TREE-CHILD-CHILD
                 end-if
              end-if
           end-perform

           modify gd-songs   mass-update 0
           modify ls-songs   mass-update 0
           modify tv-songs   mass-update 0
           modify tt-songs   mass-update 0
           .

       ADD-TREE-PARENT.
           move ta-genre(idx)  to old-ta-genre
           modify tv-songs parent null 
                           item-to-add ta-genre(idx) 
                           giving tv-songs-item-parent
                           has-children 1 
                           item-foreground-color rgb x#6883AE

           initialize tt-songs-data.
           move ta-genre(idx)   to tsd-multi

           modify tt-songs parent null 
                           item-to-add tt-songs-data 
                           giving tt-songs-item-parent
                           has-children 1 
                           item-foreground-color rgb x#6883AE

           perform ADD-TREE-CHILD
           .

       ADD-TREE-CHILD.
           move ta-Artist(idx) to old-ta-Artist
           modify tv-songs parent tv-songs-item-parent
                           item-to-add ta-Artist(idx) 
                           giving tv-songs-item-child
                           has-children 1
                           item-foreground-color rgb x#6A98C6

           initialize tt-songs-data.
           move ta-Artist(idx) to tsd-multi

           modify tt-songs parent tt-songs-item-parent
                           item-to-add tt-songs-data 
                           giving tt-songs-item-child
                           has-children 1
                           item-foreground-color rgb x#6A98C6
           perform ADD-TREE-CHILD-CHILD
           .

       ADD-TREE-CHILD-CHILD.
           modify tv-songs parent tv-songs-item-child  
                           item-to-add ta-title(idx) 
                           giving tv-songs-item
                           has-children 0
                           item-foreground-color rgb x#354C5C 

           initialize tt-songs-data
           move ta-title(idx)   to tsd-multi
           move ta-length(idx)  to tsd-length
           move ta-album(idx)   to tsd-album
           move ta-year(idx)    to tsd-year

           modify tt-songs parent tt-songs-item-child  
                           item-to-add tt-songs-data 
                           giving tt-songs-item
                           has-children 0
                           item-foreground-color rgb x#354C5C 
                           item-background-color rgb x#D1DFED

           if idx < 7
              modify tv-songs ensure-visible = tv-songs-item
              modify tt-songs ensure-visible = tt-songs-item
           end-if.
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
