      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CBLMEM.

       WORKING-STORAGE SECTION.
           copy "isgui.def".
           copy "isfonts.def".
           copy "iscrt.def".
           copy "iscobol.def".
           copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  cbl-mem-status          pic s9.

       77  mem-pointer             usage pointer.
       77  mem-size                pic x(4) comp-5.
       77  mem-flags               pic x(4) comp-5.

       77  h-float                 handle of window.
       77  PBOK                    handle of push-button.

       LINKAGE SECTION.
       77  lk-area                 pic X(8).

       SCREEN SECTION.
       01  Mask.
           03 push-button
              line                 02 
              col                  02
              size                 40
              title                "CBL_ALLOC_MEM and CBL_FREE_MEM"
              exception-value      102
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.                            
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "CBL_ALLOC_MEM and CBL_FREE_MEM Routines"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue
              end-accept
              evaluate crt-status
              when 102
                   perform MTEST
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       MTEST.

      *shows a window for the output
           display independent window
                   lines 11, size 55
                   title  "CBL_ALLOC_MEM and CBL_FREE_MEM Routines"
                   handle h-float

      * MTEST.
           display label line 2, col 2, size 75 cells, 
                   title "Allocate 8 bytes of memory"
           move 8 to mem-size
           call "cbl_alloc_mem" using mem-pointer
                             by value mem-size  
                                      mem-flags
                               giving cbl-mem-status
           
           if cbl-mem-status = 1
              perform MERROR
           end-if

           display label line 4, col 2, size 75 cells, 
                   title "Put Hello in the allocated memory"
           set address of lk-area to mem-pointer
           move "Hello" to lk-area
           
           display label line 6, col 2, size 75 cells, 
                   title "Free memory area, end of test"
           CALL "CBL_FREE_MEM" using by value mem-pointer 
                              giving cbl-mem-status.

           if cbl-mem-status = 1
              perform MERROR
           end-if

           display push-button line 10 col 2 title "OK" handle PBOK
           accept PBOK
           destroy h-float
           .

       MERROR.
           display message "An error occurred!"
                   icon    mb-warning-icon
           .

       WIN-EVT.  
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .