      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CCOVPROF-ELABORATION.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "isopensave.def".
       copy "isfilesys.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
       77  base-sorg-path          pic x(20). 
       77  command                 pic x(100).

       77  f                       handle .
       77  locks                   pic 9(3). 
       77  file-io                 pic x(128).
       77  key-io                  pic x(10).
       77  rec-buffer              pic x(22).

       78  keysize                 value 2.
       01                          pic 0.
           88 operation-failed     value 1 false zero.

       77  e-profile               pic 9 value 0.
       77  e-coverage              pic 9 value 0.
       77  profiler-file-name      pic x any length.
       77  profiler-path           pic x any length.
       77  coverage-file-name      pic x any length.
       77  coverage-path           pic x any length.
       77  user-home-path          pic x any length.

       77  number-iterations       pic 9(3) value 1.
       77  profile-type            pic 9 value 1.
           88 prof-html-type       value 1.
           88 prof-xml-type        value 2.
           88 prof-txt-type        value 3.

       77  coverage-type           pic 9 value 1.
           88 cov-html-type        value 1.
           88 cov-xml-type         value 2.

       77  kind-of-execution       pic 9 value 3.
           88 profile              value 1.
           88 coverage             value 2.

       SCREEN SECTION.
       01  Mask.
           03 label
              title                "Profile output format"
              line                 3
              col                  2
              .
           03 radio-button 
              line                 3 
              col                  22
              title                "HTML"
              group                1
              group-value          1 
              value                profile-type
              exception-value      105
              enabled              e-profile
              . 
           03 radio-button 
              line                 3
              col                  32
              title                "XML"
              group                1
              group-value          2 
              value                profile-type
              exception-value      105
              enabled              e-profile
              . 
           03 radio-button 
              line                 3 
              col                  42
              title                "TXT"
              group                1
              group-value          3
              value                profile-type
              exception-value      105
              enabled              e-profile
              . 
           03 label
              title                "Coverage output format"
              line                 5
              col                  2
              .
           03 radio-button 
              line                 5 
              col                  22
              title                "HTML"
              group                2
              group-value          1 
              value                coverage-type
              exception-value      106
              enabled              e-coverage
              . 
           03 radio-button 
              line                 5
              col                  32
              title                "XML"
              group                2
              group-value          2 
              value                coverage-type
              exception-value      106
              enabled              e-coverage
              . 
           03 label
              title                "Number of iterations"
              line                 8
              col                  2
              .
           03 entry-field
              line                 8
              col                  20
              numeric
              right
              value                number-iterations
              .
           03 push-button
              line                 11 
              col                  02
              size                 20
              title                "&Start processing"
              exception-value      102
              .
           03 push-button
              line                 13
              col                  02
              size                 20
              title                "Show profiler report"
              exception-value      103
              enabled              e-profile
              .
           03 push-button
              line                 15
              col                  02
              size                 20
              title                "Show coverage report"
              exception-value      104
              enabled              e-coverage
              .
           03 push-button
              line                 20 
              col                  2 
              size                 20 cells
              title                "View &Source [F2]"
              exception-value      2
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION CHAINING kind-of-execution.
       MAIN.
           evaluate true
           when profile
                move 1 to e-profile
           when coverage
                move 1 to e-coverage
           end-evaluate. 

           call "C$GETENV" USING "user.home"
                                 user-home-path

           call "C$PROFILER" USING cprof-disable

           accept base-sorg-path from environment "home_source".
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call

           set prof-html-type   to true
           perform SET-PROFILER-NAME

           set cov-html-type   to true
           perform SET-COVERAGE-NAME

           display standard graphical window
                   background-low
                   resizable
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$COVERAGE and C$PROFILER Routines"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue 
              end-accept
              evaluate crt-status
              when 2
                   perform VIEW-SORG
              when 102
                   call "C$PROFILER" USING cprof-enable
                   perform number-iterations times
                      perform PROCESSING
                   end-perform
                   call "C$PROFILER" using cprof-disable
                   call "C$PROFILER" using cprof-flush
                   call "C$COVERAGE" using ccov-flush
                   display message "Processing done"
              when 103
                   call "C$EASYOPEN" using profiler-file-name 
              when 104
                   call "C$EASYOPEN" using coverage-file-name 
              when 105
                   perform SET-PROFILER-NAME
              when 106
                   perform SET-COVERAGE-NAME
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       SET-PROFILER-NAME.
           initialize profiler-file-name
           initialize profiler-path
           string user-home-path   delimited by trailing spaces
                  "/profiler"      delimited by size
                  into profiler-path

           evaluate true
           when prof-html-type
                string profiler-path  delimited by size
                       "/index.html"    delimited by size
                       into profiler-file-name
                call "C$PROFILER" using cprof-set 
                                        "html" 
                                        profiler-path
           when prof-xml-type
                string profiler-path  delimited by size
                       "/profile.xml" delimited by size
                       into profiler-file-name
                call "C$PROFILER" using cprof-set 
                                        "xml" 
                                        profiler-file-name

           when prof-txt-type
                string profiler-path  delimited by size
                       "/profile.txt" delimited by size
                       into profiler-file-name
                call "C$PROFILER" using cprof-set 
                                        "txt" 
                                        profiler-file-name

           end-evaluate.
           inspect profiler-file-name replacing all "\" by "/".


       SET-COVERAGE-NAME.
           initialize coverage-file-name
           initialize coverage-path
           string user-home-path   delimited by trailing spaces
                  "/coverage"      delimited by size
                  into coverage-path

           evaluate true
           when cov-html-type
                string coverage-path  delimited by size
                       "/index.html"    delimited by size
                       into coverage-file-name
                call "C$COVERAGE" using ccov-set 
                                        "html" 
                                        coverage-path
           when cov-xml-type
                string coverage-path     delimited by size
                       "/coverage.xml"   delimited by size
                       into coverage-file-name
                call "C$COVERAGE" using ccov-set 
                                        "xml" 
                                        coverage-file-name
           end-evaluate.
           inspect profiler-file-name replacing all "\" by "/".

       PROCESSING.
           set operation-failed to false.

           call "C$GETENV" USING "user.home"
                                 file-io
           string file-io        delimited by trailing space
                  "/iss-file-io" delimited by size
                  into file-io
           move zero to BLOCK-MULTIPLE PRE-ALLOCATION-AMOUNT 
                      EXTENSION-AMOUNT COMPRESSION-FACTOR ENCRYPTED-FLAG
           move 22 to max-rec-size
           move 22 to min-rec-size
           move 1 to num-keys
           move "1,0,2,0" to key-io
           inspect file-io replacing trailing spaces by low-value
           inspect key-io  replacing trailing spaces by low-value
           inspect logical-info  replacing trailing spaces by low-value
           set make-function to true

           call "i$io" using io-function, file-io, 0, physical-info, 
                                          logical-info, key-io
           if return-code = 0
              perform DISPLAY-ERROR
           else
              perform DISPLAY-OK
           end-if
      *opening 
           if not operation-failed
              perform OPEN-IO
           end-if

      *record writing
           if not operation-failed
              move "02aaa" to rec-buffer
              set write-function to true
              call "I$IO" using io-function, f, rec-buffer, 0
              if return-code = 0
                 perform DISPLAY-ERROR
              else
                 perform DISPLAY-OK
              end-if
           end-if
      *record writing
           if not operation-failed
              move "03aaa" to rec-buffer
              set write-function to true
              call "I$IO" using io-function, f, rec-buffer, 0
              if return-code = 0
                 perform DISPLAY-ERROR
              else
                 perform DISPLAY-OK
              end-if
           end-if
      *start
           if not operation-failed
              move low-values    to rec-buffer
              set start-function to true
              set f-not-less     to true
              move 0             to key-num
              call "I$IO" using io-function, f, rec-buffer, key-num, 
                             keysize, start-mode
              if return-code = 0
                 perform DISPLAY-ERROR
              else
                 perform DISPLAY-OK
              end-if
           end-if
      *read next
           if not operation-failed
              set next-function to true
              move 0 to key-num
              call "I$IO" using io-function, f, rec-buffer, key-num
              if return-code = 0
                 perform DISPLAY-ERROR
              else
                 perform DISPLAY-OK
              end-if
           end-if
      *record rewriting
           if not operation-failed
              move "02bbb" to rec-buffer
              set rewrite-function to true
              call "I$IO" using io-function, f, rec-buffer, 0
              if return-code = 0
                 perform DISPLAY-ERROR
              else
                 perform DISPLAY-OK
              end-if
           end-if
      *record deleting
           if not operation-failed
              move "03" to rec-buffer
              set delete-function to true
              call "I$IO" using io-function, f, rec-buffer
              if return-code = 0
                 perform DISPLAY-ERROR
              else
                 perform DISPLAY-OK
              end-if
           end-if
      *close
           if not operation-failed
              perform IIO-CLOSE
              if return-code = 0
                 perform DISPLAY-ERROR
              else
                 perform DISPLAY-OK
              end-if
           end-if.

      *info file
           if not operation-failed
              perform OPEN-IO
              if return-code not = 0
                 perform IIO-QUERY
                 perform IIO-CLOSE
              else
                 perform DISPLAY-ERROR
              end-if
           end-if.
           .

       IIO-QUERY.
           set info-function to true
      *    number of records
           set get-record-count to true
           call "I$IO" using io-function, f, info-mode, 
                                             record-count-info 
      *    locked records
           set get-lock-count to true
           call "I$IO" using io-function, f, info-mode, locks 
      *    logical pharams    
           set get-logical-params to true
           call "I$IO" using io-function, f, info-mode, logical-info
           .

       IIO-CLOSE.
           set close-function to true
           call "I$IO" using io-function, f
           .
           
       OPEN-IO.
           set open-function to true
           move fio to open-mode    
           call "i$io" using io-function, file-io, 
                             open-mode, logical-info

           if return-code = 0
              perform DISPLAY-ERROR
           else
              perform DISPLAY-OK
              move return-code to f
           end-if
           .

       DISPLAY-ERROR.
           set operation-failed to true.

       DISPLAY-OK.
           set open-function to true.

       WIN-EVT.  
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .

       VIEW-SORG.
           initialize command
           string base-sorg-path            delimited by trailing space
                  "s-routines"                 delimited by space
                  "/CCOVPROF-ELABORATION.cbl"  delimited by size
                  into command.

           call run "TEXTVIEWER"  using command.
           