      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. get-host-info.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(4).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  rb-value                pic 9.
       01  execution-type          pic X.
           88 standalone-execution value "A".
           88 client-execution     value "C".
           88 server-execution     value "S".
       77  e-remote                pic 9.
       77  e-standalone            pic 9.

       77  w-name                  pic x(32).
       77  w-address               pic x(32).
       77  msg-text                pic x(128).
       
       SCREEN SECTION.
       01  Mask.
           03 radio-button 
              line                 2 
              col                  2
              title                "Stand alone"
              group                1
              group-value          1 
              value                rb-value
              exception-value      103
              enabled              e-standalone
              .
           03 radio-button 
              line                 2 
              col                  17
              title                "Run on Client"
              group                1
              group-value          2
              value                rb-value
              exception-value      103
              enabled              e-remote
              .
           03 radio-button 
              line                 2 
              col                  34
              title                "Run on Server"  
              group                1
              group-value          3
              value                rb-value
              exception-value      103
              enabled              e-remote
              .
           03 push-button 
              title                "WHO AM I ?"
              size                 12 cells 
              line                 4 cells
              col                  2 
              exception-value      101
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.       
           accept terminal-abilities from terminal-info.
           if is-remote
              move 1                     to e-remote
              move zero                  to e-standalone
              move 2                     to rb-value
              set client-execution       to true
           else
              move zero                  to e-remote
              move 1                     to e-standalone
              move 1                     to rb-value
              set standalone-execution   to true
           end-if

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "J$NETADDRESS Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    continue
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status 
           when 101
                perform NET-ADDRESS
           when 103
                if rb-value = 2
                   set client-execution   to true
                else
                   set server-execution   to true
                end-if
           end-evaluate
           .

       NET-ADDRESS.
           initialize msg-text
           evaluate true
           when client-execution
                call client "J$NETADDRESS" using w-name, 
                                                 w-address
                string "Hello client " delimited by size
                       w-name     delimited by trailing spaces
                       ", your IP address is:" 
                       x"0d0a"    delimited by size
                       w-address  delimited by trailing spaces 
                       into msg-text

           when standalone-execution
           when server-execution
                call "J$NETADDRESS" using w-name, 
                                          w-address
                string "Hello "   delimited by size
                       w-name     delimited by trailing spaces
                       ", your IP address is:" 
                       x"0d0a"    delimited by size
                       w-address  delimited by trailing spaces 
                       into msg-text
           end-evaluate.

           display message box msg-text
                     title "J$NETADDRESS Routine"
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
