      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. WBITMAP-BARCODE.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "iscobol.def".   
       copy "isresize.def".
       copy "isfonts.def".

       77  crt-status                 special-names crt status pic 9(4).
       77  hWin                       handle of window.
       77  control-font               handle of font.
       77  close-win                  pic 9 value 0.

       77  h-bmp-barcode              pic s9(9) comp-4.
       77  h-logo-icon                pic s9(9) comp-4.

       77  p-text                     pic x any length.
       77  p-size-w                   pic 9(5).
       77  p-size-h                   pic 9(5).
       77  p-position                 pic x(20).
           88 p-none                  value "None".
           88 p-bottom                value "Bottom".
           88 p-top                   value "Top".
       77  p-type                     pic x(30).
           88 p-codabar               value "Codabar".
           88 p-code128               value "Code 128".
           88 p-code39                value "Code 39".
           88 p-datamatrix            value "Datamatrix".
           88 p-royalmailcbc          value "Royal Mail Cbc".
           88 p-uspsintelligentmail   value "Usps Intelligent Mail".
           88 p-postnet               value "Postnet            ".
           88 p-interleaved2of5       value "Interleaved 2 of 5".
           88 p-itf14                 value "Itf 14".
           88 p-pdf417                value "Pdf 417".
           88 p-ean128                value "Ean 128".
           88 p-ean13                 value "Ean 13".
           88 p-ean8                  value "Ean 8".
           88 p-upca                  value "Upca".
           88 p-upce                  value "Upce".
           88 p-qrcode                value "QR code".
       77  p-dpi                      pic 9(4) comp-4.
       77  p-orientation              pic 9.
           88 p-horizontal            value 1.
           88 p-vertical              value 2.
       77  p-aliasing                 pic 9.
       77  p-custom-color             pic 9.
       77  p-logo                     pic 9.
       77  wrk-error-description      pic x any length.
       77  e-logo                     pic 9.
       77  e-custom-color             pic 9.

       77  color-fore-hex             pic x(6).
       77  color-back-hex             pic x(6).

       01  wrk-color-hex.
           03  wrk-hex-r           pic xx.
           03  wrk-hex-g           pic xx.
           03  wrk-hex-b           pic xx.
       77  wrk-color               pic s9(9).

       01  wrk-buffer-rgb.
           03  wrk-r               pic 999.
           03  wrk-g               pic 999.
           03  wrk-b               pic 999.


       77  base-sorg-path             pic x(20). 
       77  command                    pic x(100).

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              col                  2
              title                "Text:"
              .
           03 ef-title
              entry-field
              line                 2
              col                  15
              size                 53 cells
              value                p-text
              .
           03 label
              line                 4
              col                  2
              title                "Text position:"
              transparent
              .
           03 cb-position
              combo-box 
              unsorted
              drop-list 
              color                513
              line                 4
              col                  15
              size                 11 cells
              value                p-position
              .
           03 label
              line                 4
              col                  28
              title                "Type:"
              transparent
              .
           03 cb-type 
              combo-box 
              unsorted
              drop-list 
              color                513
              line                 4
              col                  34
              size                 21 cells
              lines                17 cells
              value                p-type
              Notify-Selchange
              event procedure      evt-type
              .
           03 cb-logo
              check-box
              title                "Logo:"
              line                 4.1
              col                  57
              size                 11 cells
              left-text
              left-text-alignment  1
              value                p-logo
              enabled              e-logo
              .
           03 label
              line                 6
              col                  2
              size                 10 cells
              title                "width:"
              .
           03 ef-size-width 
              entry-field
              numeric
              line                 6
              col                  15
              size                 8 cells
              value                p-size-w
              max-text             5
              right
              .
           03 label
              line                 6
              col                  31
              size                 10 cells
              title                "Height:"
              .
           03 ef-size-height 
              entry-field
              numeric
              line                 6
              col                  38
              size                 8 cells
              value                p-size-h
              max-text             5
              right
              .
           03 label
              line                 6
              col                  55
              size                 10 cells
              title                "Dpi:"
              .
           03 ef-size-height 
              entry-field
              numeric
              line                 6
              col                  60
              size                 8 cells
              value                p-dpi
              max-text             3
              right
              .
           03 label
              line                 8
              col                  2
              size                 20
              title                "Orientation:"
              .
           03 radio-button
              line                 8
              group                1
              group-value          1
              line                 8.1
              col                  15
              title                "Horizontal"
              value                p-orientation
              .
           03 radio-button
              group                1
              group-value          2
              line                 8.1
              col                  38
              title                "Vertical"
              value                p-orientation
              .
           03 cb-aliasing
              check-box
              title                "Aliasing:"
              line                 8
              col                  52
              size                 10.5 cells
              left-text
              left-text-alignment  1
              value                p-aliasing
              .

           03 cb-custom-color
              check-box
              title                "Custom Color:"
              line                 10
              col                  2
              size                 15.5 cells
              exception-value      102
              left-text
              left-text-alignment  1
              value                p-custom-color
              .

           03 label
              line                 10
              col                  28
              size                 20
              title                "Foregroud:"
              .
           03 ef-fore
              entry-field
              line                 10
              col                  38
              size                 8 cells
              value                color-fore-hex
              upper 
              max-text             6
              input-filter         "^[0-9a-fA-F]+$"
              enabled              e-custom-color
              .
           03 label
              line                 10
              col                  49
              title                "Background:"
              transparent
              .
           03 ef-back
              entry-field
              line                 10
              col                  60
              size                 8 cells
              value                color-back-hex
              upper 
              max-text             6
              input-filter         "^[0-9a-fA-F]+$"
              enabled              e-custom-color
              .
           03 barcode 
              bitmap
              line                 11.8
              col                  2
              lines                110 pixel|9 cells
              size                 68 cells
              .
           03 push-button
              line                 20
              col                  2
              size                 20 cells
              title                "Generate"
              exception-value      101
              .
           03 push-button
              line                 20
              col                  30
              size                 20 cells
              title                "View &Source [F2]"
              exception-value      2
              .
           03 Pb-exit  
              push-button
              line                 20
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           accept base-sorg-path from environment "home_source".

           perform SET-INITIAL-VALUE

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "W$BITMAP Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           modify cb-position item-to-add ("None"
                                           "Bottom"
                                           "Top")

           modify cb-type item-to-add ("Codabar"
                                       "Code 128"
                                       "Code 39"
                                       "Datamatrix"
                                       "Royal Mail Cbc"
                                       "Usps Intelligent Mail"
                                       "Postnet"
                                       "Interleaved 2 of 5"
                                       "Itf 14"
                                       "Pdf 417"
                                       "Ean 128"
                                       "Ean 13"
                                       "Ean 8"
                                       "Upca"
                                       "Upce"
                                       "QR code")

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue 
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           perform DESTROY-BITMAP.
           if function handle-type (h-logo-icon) = handle-of-bitmap
              call "W$BITMAP" using wbitmap-destroy, h-logo-icon
           end-if
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status 
           when 2
                perform VIEW-SORG
           when 101
                perform GENERATE-IMAGE
           when 102
                perform ENABLE-CUSTOM-COLOR
           end-evaluate
           .

       GENERATE-IMAGE.
           perform DESTROY-BITMAP

           initialize wbitmap-bb-data

           move p-size-w  to wbitmap-bb-width
           move p-size-h  to wbitmap-bb-height 

           evaluate true
           when p-codabar
                set wbitmap-codabar               to true
           when p-code128
                set wbitmap-code128               to true
           when p-code39
                set wbitmap-code39                to true
           when p-datamatrix
                set wbitmap-datamatrix            to true
           when p-royalmailcbc
                set wbitmap-royalmailcbc          to true
           when p-uspsintelligentmail
                set wbitmap-uspsintelligentmail   to true
           when p-postnet
                set wbitmap-postnet               to true
           when p-interleaved2of5
                set wbitmap-interleaved2of5       to true
           when p-itf14
                set wbitmap-itf14                 to true
           when p-pdf417
                set wbitmap-pdf417                to true
           when p-ean128
                set wbitmap-ean128                to true
           when p-ean13
                set wbitmap-ean13                 to true
           when p-ean8
                set wbitmap-ean8                  to true
           when p-upca
                set wbitmap-upca                  to true
           when p-upce
                set wbitmap-upce                  to true
           when p-qrcode
                set wbitmap-qrcode                to true
                if p-logo = 1
                   if function handle-type (h-logo-icon) = 
                                                     handle-is-invalid
                      call "W$BITMAP" using wbitmap-load, 
                                            "files/small-logo.png"
                                     giving h-logo-icon
                   end-if
                   move h-logo-icon            to wbitmap-bb-logo-image
                end-if
           end-evaluate

           evaluate true
           when p-horizontal 
                set wbitmap-or-horizontal   to true
           when p-vertical 
                set wbitmap-or-vertical     to true
           end-evaluate
           if p-aliasing = 1
              set wbitmap-aa-on    to true
           else
              set wbitmap-aa-off   to true
           end-if

           evaluate true
           when p-none 
                set wbitmap-tp-none   to true
           when p-bottom 
                set wbitmap-tp-bottom to true
           when p-top 
                set wbitmap-tp-top    to true
           end-evaluate

           if p-custom-color = 1
              set wbitmap-use-custom-color  to true

              move color-fore-hex  to wrk-color-hex
              perform CALCULATE-COLOR
              move wrk-color       to wbitmap-bb-fg-color

              move color-back-hex  to wrk-color-hex
              perform CALCULATE-COLOR
              move wrk-color       to wbitmap-bb-bg-color
           else
              set wbitmap-use-custom-color  to false
           end-if

           call "w$bitmap" using wbitmap-barcode-box 
                                 p-text
                                 wbitmap-bb-data 
                                 wrk-error-description
                          giving h-bmp-barcode.

           if h-bmp-barcode = 0
              display message "Barcode not generated." x"0D0A"
                              "Wrong number of parameter"
                              icon mb-error-icon
           else
              if h-bmp-barcode = -3 
                 display message "Barcode not generated." x"0D0A"
                                 wrk-error-description
                                 icon mb-error-icon
              end-if
           end-if

           modify barcode bitmap-handle h-bmp-barcode
           .

       SET-INITIAL-VALUE.
           move "www.veryant.com"  to p-text
           set p-qrcode            to true
           move 1                  to p-logo
                                      e-logo
           set p-horizontal        to true
           move 0                  to p-dpi.
           move 0                  to p-aliasing
                                      p-custom-color
                                      e-custom-color.
           move 110                to p-size-h 
                                      p-size-w
           set p-none              to true
           move "495057"           to color-fore-hex
           move "FFFFFF"           to color-back-hex
           .

       ENABLE-CUSTOM-COLOR.
           inquire cb-custom-color VALUE p-custom-color 
           if p-custom-color = 1
              move 1   to e-custom-color
           else
              move 0   to e-custom-color
           end-if
           modify ef-fore ENABLED e-custom-color 
           modify ef-back ENABLED e-custom-color 
           .

       DESTROY-BITMAP.
           if function handle-type (h-bmp-barcode) = handle-of-bitmap
              call "W$BITMAP" using wbitmap-destroy, h-bmp-barcode
           end-if
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       VIEW-SORG.
           initialize command
           string base-sorg-path         delimited by trailing space
                  "s-routines"           delimited by space
                  "/WBITMAP-BARCODE.cbl" delimited by size
                  into command.

           call run "TEXTVIEWER"  using command.

       EVT-TYPE.
           evaluate event-type
           when NTF-SELCHANGE
                inquire cb-type value p-type
                if p-qrcode
                   move 1 to p-logo
                else
                   move 0 to p-logo
                end-if
                modify cb-logo enabled p-logo 
           end-evaluate.
           
       CALCULATE-COLOR.
           move function hex2dec(wrk-hex-r) to wrk-r.
           move function hex2dec(wrk-hex-g) to wrk-g.
           move function hex2dec(wrk-hex-b) to wrk-b.

           compute wrk-color = (wrk-r  * 65536 + 
                                wrk-g  * 256   + 
                                wrk-b) * -1
           .
