      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. WCAPTURE.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "isopensave.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.  
  
       77  control-key             pic 9(5).
       77  H-bitwin                handle of window.
       77  hBmp                    pic s9(9) comp-4.
       77  NomePGM                 pic x(20).

       SCREEN SECTION.
       01  Mask.
           03 push-button  
              line                 2 
              col                  2
              size                 15 cells 
              title                "Capture Window"
              exception-value      102
              .
           03 push-button  
              line                 4 
              col                  2
              size                 15 cells 
              title                "Capture Desktop"
              exception-value      104
              .
           03  Pb-exit  
               push-button
               line                20
               col                 62
               size                8 cells
               title               "Exit" 
               exception-value     27
               .

       PROCEDURE DIVISION.
       Main.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "W$CAPTURE Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue 
              end-accept
              evaluate crt-status
              when 102   
                   perform GET-FILE-NAME
                   if opnsav-filename not = spaces
                      call "W$CAPTURE" using hWin 
                                             opnsav-filename
                                             "png"
                   end-if
              when 104
                   perform GET-FILE-NAME
                   if opnsav-filename not = spaces
                      call "W$CAPTURE" using 0 
                                             opnsav-filename
                                             "png"
                   end-if
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           GOBACK
           .

       GET-FILE-NAME.
           initialize opensave-data 
           call client "C$GETENV" USING "user.home"
                                         opnsav-default-dir
           move "png"                     to opnsav-default-ext
           move "PNG Files (*.png)|*.png" to opnsav-filters
           move "Save capture as"         to opnsav-title
           call "C$OPENSAVEBOX" using opensave-save-box
                                      opensave-data
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
