      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. WPALETTE.   

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       COPY "ispalette.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(4).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  hFloat                  handle of window.
       77  close-win               pic 9 value 0.   
       77  close-float             pic 9 value 0.
       77  result                  pic 9(2).
       78  78color                 value 3.

       77  handle-label            handle of label.
       
       01  rgb-disp.
           03  red-disp            pic 9(3).    
           03  green-disp          pic 9(3). 
           03  blue-disp           pic 9(3).

       77  backup-red              pic x comp-x.
       77  backup-green            pic x comp-x.
       77  backup-blue             pic x comp-x.

       SCREEN SECTION.
       01  Mask.
           03 test-label 
              label  
              line                 3
              col                  2
              size                 30 cells
              color                78color
              title                "Original rgb of GREEN (3): "
              .
           03 pb-choose 
              push-button
              line                 6
              col                  2
              size                 12 cells
              title                "Change RGB"
              exception-value      101
              .                 
           03 pb-restore
              push-button
              line                 6
              col                  15
              size                 12 cells
              title                "Restore RGB"
              exception-value      102
              .                 
           03  Pb-exit  
               push-button
               line                20
               col                 62
               size                8 cells
               title               "Exit" 
               exception-value     27
               .
       01  MaskRGB.
           03 ef-red
              entry-field  
              right
              foreground-color     rgb x#FF0000
              line                 3
              col                  25
              size                 4 cells
              value                red-disp
              .
           03 ef-green
              entry-field
              right
              foreground-color     rgb x#00FF00
              line                 3
              col                  30
              size                 4 cells
              value                green-disp
              .
           03 ef-blue
              entry-field
              right
              foreground-color     rgb x#0000FF
              line                 3
              col                  35
              size                 4 cells
              value                blue-disp
              .

       PROCEDURE DIVISION.
       INI.            

           move zero to handle-label

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "W$PALETTE Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           perform BACKUP-COLOR

           display Mask
           
           display MaskRGB
           perform SHOW-RGB

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue
              end-accept
              evaluate crt-status 
              when 101
                   perform CHANGE-COLOR
                   perform SHOW-RGB
              when 102
                   perform RESTORE-COLOR 
                   perform SHOW-RGB
              end-evaluate
              move 4   to accept-control
           end-perform

           perform RESTORE-COLOR
           destroy Mask
           destroy MaskRGB
           destroy hWin
           destroy control-font
           goback
           .

       SHOW-RGB.
           move wpal-red   to red-disp
           move wpal-green to green-disp
           move wpal-blue  to blue-disp
           display MaskRGB
           
           perform DISPLAY-LABEL-NEW-COLOR.
           
       DISPLAY-LABEL-NEW-COLOR.
           if handle-label not = zero
              destroy handle-label
           end-if

           display label 
              title                "New rgb of GREEN (3)"
              color                78color
              line 3 col 40
              handle in handle-label
           .

       CHANGE-COLOR.
           initialize wpalette-data 
           call "w$palette" using wpalette-choose-color,
                                  wpalette-data,
                           giving result 
           move 78color to wpal-color-id
           call "w$palette" using wpalette-set-color,
                                  wpalette-data,
                           giving result   
           .

       BACKUP-COLOR.    
           initialize wpalette-data
           move 78color to wpal-color-id
           call "w$palette" using wpalette-get-color,
                                  wpalette-data,
                           giving result

           move wpal-red   to backup-red
           move wpal-green to backup-green
           move wpal-blue  to backup-blue
           .

       RESTORE-COLOR.
           initialize wpalette-data
           move 78color      to wpal-color-id

           move backup-red   to wpal-red
           move backup-green to wpal-green
           move backup-blue  to wpal-blue

           call "w$palette" using wpalette-set-color,
                                  wpalette-data,
                           giving result 
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
