      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       >>set "servicebridge" "1"
       >>set "servicebridge.type" "REST"
       program-id. CUSTOMER.
       input-output section.
       file-control.
       data division.
       file section.
       working-storage section.
       copy "constants.def".
       copy "customer.wrk".
       copy "state.wrk".
       77  cust-status pic xx.
       77  status-99   pic 99.
       77  size-para   pic 9(5).
       77  w-key       pic 9(5).
       77  err-code    pic 99.
       77  idx         pic 9(5).
       01              pic 9.
           88 check-ok value 0 false 1.

       linkage section.
       >>elk input
       >>elk name=Code
       01  lk-cust-code               pic 9(5).
       >>elk input
       >>elk name=CustomerRec
       01  customer-in-rec.
       >>elk input
       >>elk name=Code
           05 cust-in-code            pic 9(5).
       >>elk input
       >>elk name=FullName
           05 cust-in-name.
       >>elk input
       >>elk name=FirstName
              10 cust-in-first-name   pic x(30).
       >>elk input
       >>elk name=LastName
              10 cust-in-last-name    pic x(30).
       >>elk input
       >>elk name=Address
           05 cust-in-address.
       >>elk input
       >>elk name=Street
               10 cust-in-street      pic x(30).
       >>elk input
       >>elk name=City
               10 cust-in-city        pic x(20).
       >>elk input
       >>elk name=State
               10 cust-in-state       pic x(3).
       >>elk input
       >>elk name=ZipCode
               10 cust-in-zip         pic x(5).
       >>elk input
       >>elk name=Gender
           05 cust-in-gender          pic x.
       >>elk input
       >>elk name=Phone
           05 cust-in-phone           pic x(15).
       >>elk input
       >>elk name=CellPhone
           05 cust-in-cellphone       pic x(15).

       >>elk output
       >>elk name=CustomerRec
       01  customer-out-rec.
       >>elk output
       >>elk name=Code
           05 cust-out-code           pic 9(5).
       >>elk output
       >>elk name=FullName
           05 cust-out-name.
       >>elk output
       >>elk name=FirstName
              10 cust-out-first-name  pic x(30).
       >>elk output
       >>elk name=LastName
              10 cust-out-last-name   pic x(30).
       >>elk output
       >>elk name=Address
           05 cust-out-address.
       >>elk output
       >>elk name=Street
               10 cust-out-street     pic x(30).
       >>elk output
       >>elk name=City
               10 cust-out-city       pic x(20).
       >>elk output
       >>elk name=State
               10 cust-out-state      pic x(3).
       >>elk output
       >>elk name=ZipCode
               10 cust-out-zip        pic x(5).
       >>elk output
       >>elk name=Gender
           05 cust-out-gender         pic x.
       >>elk output
       >>elk name=Phone
           05 cust-out-phone          pic x(15).
       >>elk output
       >>elk name=CellPhone
           05 cust-out-cellphone      pic x(15).

       >>elk output
       >>elk name=RequestStatus
       01  lk-request-status.
       >>elk output
       >>elk name=Status
           05  lk-status              pic xx.
       >>elk output
       >>elk name=FileStatus
           05  lk-file-status         pic 99.
       >>elk output
       >>elk name=ReturnMessage
           05  lk-message             pic x any length.

       >>elk output
       01  lk-lookup.
           05 lk-lookup-record     occurs dynamic capacity num-lookup.
       >>elk output
       >>elk name=Code
              10 lk-lr-code           pic  z(5).
       >>elk output
       >>elk name=FirstName
              10 lk-lr-first-name     pic  x(30).
       >>elk output
       >>elk name=lastName
              10 lk-lr-last-Name      pic  x(30).

       procedure division.
       main.
           initialize lk-message
           move 0      to lk-file-status.
           move "OK"   to lk-status.
           goback.

       REC-FIRST.
           entry "FIRST" using customer-out-rec,
                               lk-request-status.

           perform OPEN-INPUT.
           if return-code = zero
              move low-value to w-key(1:)
              call "PCUSTOMER" using 78-start-great, w-key
              call "PCUSTOMER" using 78-read-next, customer-out-rec
              perform VALORIZE-RETURN-MESSAGE
              call "PCUSTOMER" using 78-close
           end-if
           goback.

       REC-PREV.  
           entry "PREV" using lk-cust-code
                              customer-out-rec,
                              lk-request-status.
           perform OPEN-INPUT
           if return-code = zero 
              move lk-cust-code to cust-out-code
              call "PCUSTOMER" using 78-read, customer-out-rec
              call "PCUSTOMER" using 78-read-prev, customer-out-rec
              perform VALORIZE-RETURN-MESSAGE
              call "PCUSTOMER" using 78-close
           end-if
           goback.

       REC-NEXT.  
           entry "NEXT" using lk-cust-code,
                              customer-out-rec,
                              lk-request-status.
           perform OPEN-INPUT
           if return-code = zero 
              move lk-cust-code to cust-out-code
              call "PCUSTOMER" using 78-read, customer-out-rec
              call "PCUSTOMER" using 78-read-next, customer-out-rec
              move return-code  to lk-status
              perform VALORIZE-RETURN-MESSAGE
              call "PCUSTOMER" using 78-close
           end-if
           goback.

       REC-SEARCH.  
           entry "SEARCH" using lk-cust-code,
                                customer-out-rec,
                                lk-request-status.
           perform OPEN-INPUT
           if return-code = zero 
              move lk-cust-code to Cust-out-Code
              call "PCUSTOMER" using 78-read, customer-out-rec
              if return-code not = zero
                 initialize customer-out-rec
              end-if
              perform VALORIZE-RETURN-MESSAGE
              call "PCUSTOMER" using 78-close
           end-if
           goback.

       REC-LAST.  
           entry "LAST" using customer-out-rec,
                              lk-request-status.
           perform OPEN-INPUT
           if return-code = zero 
              move high-value to w-key
              call "PCUSTOMER" using 78-start-less, w-key
              call "PCUSTOMER" using 78-read-next, customer-out-rec
              perform VALORIZE-RETURN-MESSAGE
              call "PCUSTOMER" using 78-close
           end-if
           goback.

       REC-DELETE.
           entry "DELETE" using lk-cust-code,
                                lk-request-status.
           perform OPEN-IO
           if return-code = zero
              call "PCUSTOMER" using 78-delete, lk-cust-code
              move return-code  to lk-status
              perform VALORIZE-RETURN-MESSAGE
              call "PCUSTOMER" using 78-close
           end-if
           goback.

       REC-SAVE.
           entry "SAVE" using customer-in-rec,
                              lk-request-status.

           perform CHECK-FIELDS.
           if check-ok

              perform OPEN-IO
              if return-code = zero
                 call "PCUSTOMER" using 78-write, customer-in-rec
                 if return-code = 22
                    call "PCUSTOMER" using 78-rewrite, customer-in-rec
                 end-if
                 move return-code  to lk-status
                 call "PCUSTOMER" using 78-close
              end-if
           else
              move "KO"         to lk-status
              move return-code  to lk-file-status
           end-if
           goback.

       CHECK-FIELDS.
           set check-ok   to true.

           if cust-in-Code = 0
              move "CUSTOMER CODE MANDATORY"   to lk-message
              set check-ok   to false
           end-if

           if check-ok 
              if Cust-in-First-Name = space and 
                 Cust-in-Last-Name = space
                 move "CUSTOMER NAME MANDATORY"  to lk-message
                 set check-ok   to false
              end-if
           end-if
           
           if check-ok
              perform CHECK-STATE
           end-if.
           .

       CHECK-STATE.
           set check-ok   to true
           if Cust-in-State not = space
              perform OPEN-INPUT-STATE
              move Cust-in-State   to state-Code
              call "PSTATE" using 78-read, State-rec
              if return-code > 9
                 move "INVALID STATE CODE"  to lk-message
                 set check-ok   to false
              end-if
              call "PSTATE" using 78-close
           end-if
           .

       LOOKUP.
           entry "LOOKUP" using lk-lookup.

           perform OPEN-INPUT.
           if return-code = zero
              move low-value to w-key(1:)
              call "PCUSTOMER" using 78-start-great, w-key
              move zero   to idx
              perform until 1 = 2
                 call "PCUSTOMER" using 78-read-next, customer-rec
                 if return-code not = zero
                    exit perform
                 end-if
                 add 1 to idx
                 move Cust-Code          to lk-lr-code(idx)
                 move Cust-First-Name    to lk-lr-first-name(idx)
                 move Cust-Last-Name     to lk-lr-last-Name(idx)
              end-perform
              call "PCUSTOMER" using 78-close
           end-if

           goback.
           
       VALORIZE-RETURN-MESSAGE.
           if return-code = 0
              move "OK"               to lk-status
           else
              move "KO"               to lk-status
           end-if.
           move return-code           to lk-file-status.
           
 
           evaluate return-code
           when 0
                initialize lk-message
           when 10
                move "No more records" to lk-message
           when 23
                move "Record not found or file empty" to lk-message
           when 46
                move "No current record defined" to lk-message
           when 98
                move "File is corrupted" to lk-message
           when other
                initialize lk-message
                string "Error " delimited by size
                       return-code delimited by size
                       " on file customer" delimited by size
                       into lk-message
           end-evaluate.
           .

       OPEN-INPUT.
           call "PCUSTOMER" using 78-open-input
           if return-code = 5
              move zero   to return-code
           end-if
           if return-code not = 0
              perform VALORIZE-RETURN-MESSAGE
           end-if.

       OPEN-INPUT-STATE.
           call "PSTATE" using 78-open-input
           if return-code = 5
              move zero   to return-code
           end-if
           if return-code not = 0
              perform VALORIZE-RETURN-MESSAGE
           end-if.
           
       OPEN-IO.
           call "PCUSTOMER" using 78-open-i-o
           if return-code = 5
              move zero   to return-code
           end-if
           if return-code not = 0
              perform VALORIZE-RETURN-MESSAGE
           end-if.
           
