      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. State.

       WORKING-STORAGE SECTION.
       copy "constants.def".
       copy "state.wrk".
       copy "isfonts.def".
       copy "isgui.def".

       77  key-status is special-names crt status pic 999.
       77  h-main               handle of window.
       77  w-key                pic 9(5).
       77  sub-state            pic x(10).
       77  varx3                pic xxx.

       01                       pic 9.
           88 check-ok          value 0 false 1.
       77  err-message          pic x any length.
       77  err-icon             pic 9.
       77  err-code             pic 99.

       SCREEN SECTION.
       01  s1.
           03 label "State code:"                 line 3 col 2.
           03 entry-field using state-code        col + 2 high prompt.
           03 label "Name: "                      line 4 col 2.
           03 entry-field using State-Description col + 2 high prompt.

       01  s-func.
           03 label "F1=Lookup"             line 16 col 2 reverse.
           03 label "F3=Delete"             col + 2  reverse.
           03 label "F5=First"              col + 2 reverse.
           03 label "F6=Prev"               col + 2 reverse.
           03 label "F7=Next"               col + 2 reverse.
           03 label "F8=Last"               col + 2 reverse.
           03 label "F9=Save"               col + 2 reverse.
           03 label "ESC=Exit"              col + 2 reverse.


       PROCEDURE DIVISION.
       MAIN.
           call "PSTATE"    using 78-open-i-o

           display independent graphical window
                   background-low  
                   title "STATE MAINTENANCE"
                   cell size is entry-field font 
                   size 84
                   lines 18
                   label-offset 10
                   control font fixed-font
                   handle h-main.

           display s1.
           display s-func.

           perform until key-status = 27
              accept s1 
                 on exception 
                    continue 
              end-accept
              evaluate key-status
              when 1
                   perform LOOKUP
              when 2
                   continue
              when 3
                   perform REC-DELETE
              when 5
                   perform REC-FIRST
              when 6
                   perform REC-PREV
              when 7
                   perform REC-NEXT
              when 8
                   perform REC-LAST
              when 9
                   perform REC-SAVE
              end-evaluate
           end-perform.
           call "PSTATE"    using 78-close
           destroy h-main 

           goback.
       
       REC-FIRST.
           move low-value to w-key(1:)
           call "PSTATE" using 78-start-great, w-key
           call "PSTATE" using 78-read-next, state-rec
           if return-code > 9
              perform SHOW-FILE-ERROR
           else
              display S1
           end-if.

       REC-PREV.  
           call "PSTATE" using 78-read-prev, state-rec
           if return-code > 9
              perform SHOW-FILE-ERROR
           else
              display S1
           end-if.

       REC-NEXT.  
           call "PSTATE" using 78-read-next, state-rec
           if return-code > 9
              perform SHOW-FILE-ERROR
           else
              display S1
           end-if.

       REC-LAST.  
           move high-value to w-key
           call "PSTATE" using 78-start-less, w-key
           call "PSTATE" using 78-read-next, state-rec
           if return-code > 9
              perform SHOW-FILE-ERROR
           else
              display S1
           end-if.

       REC-DELETE.
           display message 
                 "ARE YOU SURE YOU WANT TO DELETE THIS RECORD?"
                 type mb-yes-no
                 default mb-no 
                 giving varx3
           if varx3 = mb-yes 
              call "PSTATE" using 78-delete, state-code
              if return-code > 9
                 perform SHOW-FILE-ERROR
              else
                 initialize state-rec
                 initialize state-rec
                 display s1
              end-if
           end-if.

       REC-SAVE.
           perform CHECK-FIELDS.

           if check-ok
              call "PSTATE" using 78-write, state-rec
              if return-code = 22
                 call "PSTATE" using 78-rewrite, state-rec
                 if return-code > 9
                    perform SHOW-FILE-ERROR
                 end-if
              end-if
           end-if
           .

       CHECK-FIELDS.
           set check-ok   to true.

           if state-Code = space
              move "STATE CODE MANDATORY"  to err-message
              perform SHOW-ERROR
              set check-ok   to false
           end-if

           if check-ok and State-Description = space
              move "STATE DESCRIPTION MANDATORY"    to err-message
              perform SHOW-ERROR
              set check-ok   to false
           end-if
           .

       SHOW-FILE-ERROR.
           initialize err-message
           
           if return-code = 10
              move "NO MORE RECORDS"  to err-message
              move mb-warning-icon    to err-icon
           else
              move return-code        to err-code 
              move err-code           to err-message
              move mb-error-icon      to err-icon
           end-if
           
           display message box err-message
                   title "ERROR: "
                   icon err-icon 
           .

       SHOW-ERROR.
           display message box err-message
                   title "ERROR: "
                   icon err-icon 
           .

       LOOKUP.
           call "LOOKUP-STATE" using state-rec
           display s1
           .

