       IDENTIFICATION DIVISION.

       CLASS-ID. WCWINHANDLER AS 
                  "WCWINHANDLER" 
                  IMPLEMENTS JWINDOWCREATEHANDLER.

       ENVIRONMENT DIVISION.

       CONFIGURATION SECTION.

       REPOSITORY.
           CLASS JWINDOWATTRIBUTEHOOK AS 
                 "com.iscobol.gui.server.WindowAttributeHook"
           CLASS JWINDOWCREATEOVERFLOWEXCEPTION AS 
                 "com.iscobol.rts.WindowCreateOverflowException"
           CLASS JWINDOWCREATEHANDLER AS 
                 "com.iscobol.rts.WindowCreateHandler"
           .

       IDENTIFICATION DIVISION.
       OBJECT.
       WORKING-STORAGE SECTION.
       PROCEDURE DIVISION.

       IDENTIFICATION DIVISION.
       METHOD-ID. IS-WINDOWCREATE AS "beforeWindowCreate" override.
       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "iscobol.def".

       77  env-code    pic 9 external.
       77  win-type    pic x any length.

       LINKAGE SECTION.
       77  MyWinAttribute OBJECT REFERENCE JWINDOWATTRIBUTEHOOK.

       procedure division using MyWinAttribute 
                          raising jwindowcreateoverflowexception.

       MAIN.
           if env-code = runenv-web-client
              perform CHANGE-WINDOW
           end-if
           goback
           .

       CHANGE-WINDOW.
           set win-type to MyWinAttribute:>getType

           evaluate win-type
           when "INDEPENDENT"
                MyWinAttribute:>setBackground(-16054009)
                MyWinAttribute:>setResizable(1)
                MyWinAttribute:>setLayoutManager("LM-ZOOM")
                MyWinAttribute:>setAction(action-maximize-postponed)
           when "FLOATING"
                MyWinAttribute:>setBackground(-9087437)
           end-evaluate.

           MyWinAttribute:>setUndecorate(1)
           .

       END METHOD.

       IDENTIFICATION DIVISION.
       METHOD-ID. IS-AFTERWINDOWCREATE AS "afterWindowCreate" override.
       WORKING-STORAGE SECTION.
       77  HWND handle of window.
       LINKAGE SECTION.
       77  myWinhandler OBJECT REFERENCE JWINDOWATTRIBUTEHOOK.
       procedure division using myWinhandler
                        raising jwindowcreateoverflowexception.
       MAIN.
       END METHOD.

       END OBJECT.

       