/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.isam;

import IT.picosoft.isam.DictInfo;
import IT.picosoft.isam.FLock;
import IT.picosoft.isam.Isam;
import IT.picosoft.isam.IsamConst;
import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.KeyDesc;
import IT.picosoft.isam.NewNodes;
import IT.picosoft.isam.NodeDesc;
import IT.picosoft.isam.NodeItemDesc;
import IT.picosoft.isam.OSFile;
import IT.picosoft.isam.TreeManager32;
import IT.picosoft.isam.TreeManager64;
import java.io.PrintStream;

public abstract class TreeManager
implements IsamConst {
    static final int NODE_CACHE_SIZE = 32;
    protected final NodeDesc[] nodeCache = new NodeDesc[32];
    static final int ISNOLCK = 0;
    static final int ISRDLCK = 1;
    static final int ISWRLCK = 2;
    static final byte BRANCH_NODE = -65;
    static final byte LEAF_NODE = -1;
    static final byte DELETED_NODE = -33;
    static final byte RECDEL_NODE = -17;
    static final byte KEY_NODE = -49;
    private int headerLock = 0;
    private FLock lock = new FLock();
    protected OSFile fdIndex;
    protected Isam par;

    static TreeManager get(OSFile f, boolean exLck, int rel, Isam p) throws IsamException {
        TreeManager Return2;
        if (rel == 1) {
            Return2 = new TreeManager32(f, exLck);
        } else if (rel == 2 || f.length() == 0L) {
            Return2 = new TreeManager64(f, exLck);
        } else {
            byte[] ver = new byte[1];
            f.seek(7L);
            f.read(ver);
            Return2 = ver[0] == 1 ? new TreeManager32(f, exLck) : new TreeManager64(f, exLck);
        }
        Return2.par = p;
        return Return2;
    }

    abstract void init() throws IsamException;

    abstract void newIndex(int var1, KeyDesc var2, short var3, short var4, byte[] var5) throws IsamException;

    abstract short getIndexSize();

    abstract int getRecSize();

    abstract short getKeyParts(int var1);

    abstract long getNRecords();

    abstract void readHeader(boolean var1) throws IsamException;

    abstract void writeHeader(boolean var1) throws IsamException;

    abstract void write(NodeDesc var1) throws IsamException;

    abstract boolean unchangedNode(short var1, NodeItemDesc var2) throws IsamException;

    abstract NodeItemDesc findKey(byte[] var1, short var2, int var3, int var4) throws IsamException;

    abstract NodeItemDesc prev(short var1, byte[] var2, int var3, long var4, int var6, boolean var7) throws IsamException;

    abstract NodeItemDesc next(short var1, byte[] var2, int var3, long var4, int var6, boolean var7) throws IsamException;

    abstract void insertKeys(byte[][] var1, long var2) throws IsamException;

    abstract long getNewRecNum() throws IsamException;

    abstract void resetGetNewRecNum(long var1) throws IsamException;

    abstract void insertKey(byte[] var1, short var2, long var3) throws IsamException;

    abstract long newRoot(NewNodes var1, short var2) throws IsamException;

    abstract short getKeyNum(KeyDesc var1) throws IsamException;

    abstract short getKeyLen(int var1);

    abstract byte[][] buildAllKeys(byte[] var1, int var2, long var3) throws IsamException;

    abstract void rewriteAllKeys(byte[] var1, byte[] var2, int var3, long var4, byte[][] var6) throws IsamException;

    abstract void buildKey(short var1, byte[] var2, int var3, byte[] var4);

    abstract void delTree(short var1) throws IsamException;

    abstract void deleteKeys(byte[] var1, int var2, long var3) throws IsamException;

    abstract long checkDeleteRecords() throws IsamException;

    abstract long checkDeleteNodes() throws IsamException;

    abstract long addIndex(KeyDesc var1, OSFile var2) throws IsamException;

    abstract OSFile rebuild(OSFile var1, String var2, boolean var3, PrintStream var4) throws IsamException;

    abstract void indexInfo(DictInfo var1) throws IsamException;

    abstract void indexInfo(KeyDesc var1, int var2) throws IsamException;

    abstract long getDelRecNum() throws IsamException;

    abstract int getVersion();

    abstract int getFirstNodeAddr();

    abstract byte[] getCollatingSequence() throws IsamException;

    final OSFile getFd() {
        return this.fdIndex;
    }

    protected final void finalize() throws IsamException {
        this.cacheClear();
        this.fdIndex = null;
    }

    final void headerLock(boolean wlck) throws IsamException {
        if (this.headerLock == 0 || this.headerLock == 1 && wlck) {
            this.lock.l_whence = 0;
            this.lock.l_start = 0L;
            this.lock.l_len = 1;
            this.lock.l_type = (short)(wlck ? 1 : 0);
            this.fdIndex.fcntl(7, this.lock);
            this.headerLock = wlck ? 2 : 1;
        }
    }

    final void headerUnlock() throws IsamException {
        if (this.headerLock != 0) {
            this.lock.l_whence = 0;
            this.lock.l_start = 0L;
            this.lock.l_len = 1;
            this.lock.l_type = (short)2;
            this.fdIndex.fcntl(6, this.lock);
            this.headerLock = 0;
        }
    }

    final void fileExLock(FLock lk, short lkType) throws IsamException {
        lk.l_whence = 0;
        lk.l_start = 1L;
        lk.l_len = 1;
        lk.l_type = lkType;
        this.fdIndex.fcntl(6, lk);
    }

    final void testFileLock(FLock lk) throws IsamException {
        lk.l_whence = 0;
        lk.l_start = 1L;
        lk.l_len = 1;
        lk.l_type = 0;
        this.fdIndex.fcntl(6, lk);
    }

    final boolean isHeadUnlk() {
        return this.headerLock == 0;
    }

    final void cacheClear() throws IsamException {
        for (int i = 0; i < 32 && this.nodeCache[i] != null; ++i) {
            if (this.nodeCache[i].cached) {
                this.write(this.nodeCache[i]);
            }
            this.nodeCache[i] = null;
        }
    }

    final void cachePut(NodeDesc n) throws IsamException {
        int nitems;
        int minIdx = 0;
        int min = Integer.MAX_VALUE;
        for (nitems = 0; nitems < 32; ++nitems) {
            if (this.nodeCache[nitems] == null) {
                min = Integer.MIN_VALUE;
                minIdx = nitems;
                break;
            }
            if (this.nodeCache[nitems].nodeAddr != n.nodeAddr) continue;
            this.nodeCache[nitems] = n;
            return;
        }
        for (int i = 0; i < nitems; ++i) {
            if (this.nodeCache[i].mru < min) {
                min = this.nodeCache[i].mru;
                minIdx = i;
            }
            --this.nodeCache[i].mru;
        }
        if (this.nodeCache[minIdx] != null && this.nodeCache[minIdx].cached) {
            this.write(this.nodeCache[minIdx]);
        }
        n.mru = 1;
        this.nodeCache[minIdx] = n;
    }

    final NodeDesc cacheGet(long addr) {
        NodeDesc nd;
        int i;
        NodeDesc Return2 = null;
        for (i = 0; i < 32 && (nd = this.nodeCache[i]) != null; ++i) {
            if (addr != nd.nodeAddr) continue;
            Return2 = nd;
        }
        if (Return2 != null) {
            --i;
            while (i >= 0) {
                if (this.nodeCache[i].mru > Return2.mru) {
                    --this.nodeCache[i].mru;
                }
                --i;
            }
            Return2.mru = 1;
        }
        return Return2;
    }
}

