/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as.turborun;

import com.iscobol.as.turborun.TRServer;
import com.iscobol.rts.ContextEnv;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;

public class TRContextEnv
extends ContextEnv {
    private final Properties env;
    private final OutputStream sockOut;
    private final String workingDirectory;

    public TRContextEnv(String[] envStr, OutputStream sOut) {
        this.sockOut = sOut;
        this.env = new Properties();
        String ud = null;
        for (String p : envStr) {
            int idx = p.indexOf(61);
            if (idx < 0) continue;
            String propName = p.substring(0, idx);
            String propValue = p.substring(idx + 1);
            if ("${user.dir}".equals(propName)) {
                ud = propValue;
                continue;
            }
            this.env.setProperty(propName.toUpperCase(), propValue);
        }
        this.workingDirectory = ud;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public String getProperty(String propName) {
        return this.env.getProperty(propName);
    }

    @Override
    public void displayUponSysErr(boolean flush, String str, boolean eol) {
        if (eol) {
            str = str + "\n";
        }
        try {
            TRServer.writeString(this.sockOut, str, (byte)69);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

