/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.balancer;

import com.iscobol.as.ServerHandler;
import com.iscobol.balancer.LoadBalancer;
import com.iscobol.rmi.IscobolMessageSerializer;
import com.iscobol.rmi.Worker;
import com.iscobol.rpc.dualrpc.client.AbstractClientRpcHandler;
import com.iscobol.rpc.dualrpc.client.DualRpcClient;
import com.iscobol.rpc.dualrpc.client.NotConnectedException;
import com.iscobol.rpc.dualrpc.common.IRpcMessageDispatcher;
import com.iscobol.rpc.dualrpc.common.IRpcWorkerFactory;
import com.iscobol.rpc.messageserver.common.Message;

public class Server
extends AbstractClientRpcHandler {
    public final int DEF_USERS = 10;
    private final String host;
    private final int port;
    private final int confUsers;
    private final String server = ServerHandler.class.getName();
    private DualRpcClient client;
    private int currUsers;
    private boolean alive;
    private Exception cause;
    private int timeout = 60;

    private static int getInt(String intg, int defInt) {
        try {
            return Integer.parseInt(intg);
        }
        catch (NumberFormatException _ex) {
            return defInt;
        }
    }

    public Server(String prop, int defPort) {
        int colon = prop.indexOf(58);
        int comma = prop.indexOf(44);
        if (colon >= 0) {
            this.host = colon == 0 ? "localhost" : prop.substring(0, colon);
            if (comma < 0) {
                this.port = Server.getInt(prop.substring(colon + 1, prop.length()), defPort);
                this.confUsers = 10;
            } else {
                this.port = Server.getInt(prop.substring(colon + 1, comma), defPort);
                this.confUsers = Server.getInt(prop.substring(comma + 1, prop.length()), 10);
            }
        } else {
            this.port = defPort;
            if (comma >= 0) {
                this.host = comma == 0 ? "localhost" : prop.substring(0, comma);
                this.confUsers = Server.getInt(prop.substring(comma + 1, prop.length()), 10);
            } else {
                this.host = prop.trim();
                this.confUsers = 10;
            }
        }
        this.checkIsAlive();
    }

    String getHost() {
        return this.host;
    }

    int getPort() {
        return this.port;
    }

    int getConfUsers() {
        return this.confUsers;
    }

    int getCurrUsers() {
        return this.currUsers;
    }

    boolean isAlive() {
        return this.alive;
    }

    boolean checkIsAlive() {
        block5: {
            if (this.client == null) {
                this.client = new DualRpcClient(this.host, this.port);
                this.client.setMessageSerializer(new IscobolMessageSerializer());
                this.client.setDefaultCallTimeoutInSeconds(this.timeout);
                this.client.setRpcWorkerFactory(new IRpcWorkerFactory(){

                    @Override
                    public Thread getRpcWorkerThread(IRpcMessageDispatcher dispatcher, Message message) {
                        return new Worker(dispatcher, message, null);
                    }
                });
            }
            try {
                if (!this.alive) {
                    this.client.connect();
                }
                Integer serverVer = (Integer)this.client.call(this.server, "getUserCount");
                this.currUsers = serverVer;
                if (!this.alive) {
                    this.alive = true;
                    LoadBalancer.getLogger().info(this.toString());
                }
            }
            catch (Exception _ex) {
                this.currUsers = -1;
                this.cause = _ex;
                if (!this.alive) break block5;
                this.alive = false;
                LoadBalancer.getLogger().info(this.toString());
            }
        }
        return this.alive;
    }

    public void setTimeout(int sec) {
        this.timeout = sec;
    }

    public void finalize() {
        if (this.alive) {
            try {
                this.client.disconnect();
            }
            catch (NotConnectedException notConnectedException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        StringBuffer Return2 = new StringBuffer("[");
        Return2.append(this.host);
        Return2.append(':');
        Return2.append(this.port);
        Return2.append(',');
        Return2.append(this.confUsers);
        Return2.append("] ");
        Return2.append(this.alive);
        if (this.alive) {
            Return2.append(" currUsers=");
            Return2.append(this.currUsers);
        } else {
            Return2.append(" (");
            Return2.append(this.cause);
            Return2.append(" )");
        }
        return Return2.toString();
    }
}

