/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.clientlstnr;

import com.iscobol.rts.Version;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ManageTray {
    public static final String title = "isCOBOL Client Listener";
    private final String host;
    private final int asPort;
    private final int displayPort;

    public ManageTray(String h, int ap, int dp) {
        this.host = h;
        this.asPort = ap;
        this.displayPort = dp;
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            Image image = Toolkit.getDefaultToolkit().getImage(ManageTray.class.getResource("iscobol.png"));
            ActionListener exitListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Exiting...");
                    System.exit(0);
                }
            };
            PopupMenu popup = new PopupMenu(title);
            MenuItem infoItem = new MenuItem("Info");
            MenuItem aboutItem = new MenuItem("About");
            MenuItem defaultItem = new MenuItem("Exit");
            defaultItem.addActionListener(exitListener);
            popup.add(infoItem);
            popup.add(aboutItem);
            popup.addSeparator();
            popup.add(defaultItem);
            final TrayIcon trayIcon = new TrayIcon(image, title, popup);
            aboutItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    trayIcon.displayMessage(ManageTray.title, "isCOBOL version: " + Version.getVersion(), TrayIcon.MessageType.INFO);
                }
            });
            infoItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    trayIcon.displayMessage(ManageTray.title, "Application Server host: " + ManageTray.this.host + "\nApplication Server port: " + ManageTray.this.asPort + "\nDisplay port: " + ManageTray.this.displayPort, TrayIcon.MessageType.INFO);
                }
            });
            trayIcon.setImageAutoSize(true);
            try {
                tray.add(trayIcon);
            }
            catch (AWTException e) {
                System.err.println("TrayIcon could not be added.");
            }
        } else {
            System.err.println("Info: system tray is currently not supported.");
        }
    }
}

