/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Condition;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.IllegalConditionException;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import java.util.ArrayList;

public class Assert
extends Verb
implements CobolToken,
ErrorsNumbers {
    private Condition cond;
    private ArrayList args = new ArrayList();

    public Assert(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        this.cond = new Condition(this.keyWord, this.parent, this.pc, this.tm, this.error);
        if (!this.cond.isFullCondition()) {
            throw new IllegalConditionException(this.keyWord, this.error);
        }
        Token tk = this.tm.getToken();
        if (tk.getToknum() != 623) {
            throw new ExpectedFoundException(tk, this.error, "OTHERWISE");
        }
        tk = this.tm.getToken();
        block4: while (true) {
            switch (tk.getToknum()) {
                case 10001: 
                case 10002: 
                case 10017: 
                case 10022: {
                    this.args.add(tk);
                    break;
                }
                case 10009: {
                    this.tm.ungetToken();
                    VariableName vn = VariableName.getAny(this.tm, this.error, this.parent, this.pc);
                    MyClass type = vn.getType();
                    if (type != null && type.getName().equals("void")) {
                        throw new GeneralErrorException(149, 4, this.keyWord, vn.getName(), this.error);
                    }
                    this.args.add(vn);
                    break;
                }
                default: {
                    this.tm.ungetToken();
                    break block4;
                }
            }
            tk = this.tm.getToken();
        }
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        Return2.append("assert ");
        Return2.append(this.cond.getCode());
        Return2.append(": \"\"");
        for (Object obj : this.args) {
            Return2.append("+");
            if (obj instanceof Token) {
                Return2.append(this.getCodeLiteral((Token)obj));
                continue;
            }
            Return2.append(((VariableName)obj).getCode());
        }
        Return2.append(";");
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    @Override
    public void check() throws GeneralErrorException {
    }
}

