/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Call;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolMethodList;
import com.iscobol.compiler.DataDivision;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.EnvironmentDivision;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GeneralErrorInfo;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.SelectList;
import com.iscobol.compiler.SpecialNamesClass;
import com.iscobol.compiler.SqlDeclareCursor;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.interfaces.compiler.ICobolClass;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;

public class CobolClass
extends Pcc
implements ICobolClass {
    private EnvironmentDivision environment;
    CobolClass factory;
    private boolean isFactory;
    private CobolMethodList allMethods = new CobolMethodList();
    private StringBuffer declDynPart;
    private StringBuffer declFixedVarPart;
    private String declData;
    private Token firstToken;
    private Token lastToken;
    private StringWriter unnamedMethods;

    public CobolClass(Pcc p, CobolClass fact) {
        super(p);
        this.parent = p;
        this.parent.optionMS = false;
        this.parent.capitalizeNames = false;
        this.parent.tm.optionMs = false;
        if (fact != null) {
            this.factory = fact;
        }
    }

    @Override
    boolean start() {
        this.tm.pushCurrentPcc(this);
        try {
            boolean bl = this._start();
            return bl;
        }
        finally {
            this.tm.popCurrentPcc();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean _start() {
        boolean Return2 = true;
        try {
            Token tk;
            GeneralErrorInfo[] gei = new GeneralErrorInfo[1];
            switch (this.idDivision(gei)) {
                case -1: {
                    return true;
                }
                case -2: {
                    Return2 = false;
                    try {
                        this.tm.skipTill(new int[]{459, 388, 706, 652});
                        if (gei[0] == null) break;
                        this.error.print(gei[0].type, gei[0].severity, gei[0].tk, gei[0].other);
                        break;
                    }
                    catch (EndOfProgramException ex) {
                        return true;
                    }
                }
            }
            try {
                tk = this.tm.getToken();
                if (tk.getToknum() == 459) {
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 411) throw new UnexpectedTokenException(tk, this.error);
                    if (this.tm.getToken().getToknum() != 10006) {
                        this.error.print(188, 3, tk, "'.'");
                        this.tm.ungetToken();
                    }
                } else {
                    this.tm.ungetToken();
                }
                this.environment = new EnvironmentDivision(this, this.tm, this.error, tk);
            }
            catch (GeneralErrorException e) {
                Return2 = false;
                this.tm.skipTill(new int[]{388, 706, 652});
            }
            try {
                tk = this.tm.getToken();
                if (tk.getToknum() == 388) {
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 411) throw new UnexpectedTokenException(tk, this.error);
                    if (this.tm.getToken().getToknum() != 10006) {
                        this.error.print(188, 3, tk, "'.'");
                        this.tm.ungetToken();
                    }
                } else {
                    this.tm.ungetToken();
                }
                this.data = new DataDivision(this, this.tm, this.error, tk);
            }
            catch (GeneralErrorException e) {
                Return2 = false;
                this.tm.skipTill(new int[]{706, 652});
            }
            try {
                this.parent.checkPost();
                if (this.gEnvironment != null) {
                    this.gEnvironment.check(this);
                }
                if (this.environment != null) {
                    this.environment.check(this);
                }
                if (this.data != null) {
                    this.data.check();
                }
            }
            catch (GeneralErrorException e) {
                Return2 = false;
            }
            tk = this.tm.getToken();
            if (tk.getToknum() == 706) {
                if (this.data != null) {
                    try {
                        this.data.scanScreenSection(tk);
                        this.loadVariablesScreenSec();
                    }
                    catch (GeneralErrorException e) {
                        Return2 = false;
                        this.tm.skipTill(new int[]{652});
                    }
                }
            } else {
                this.tm.ungetToken();
            }
            if ((tk = this.tm.getToken()).getToknum() == 652) {
                tk = this.tm.getToken();
                if (tk.getToknum() == 411) {
                    if (this.tm.getToken().getToknum() != 10006) {
                        this.error.print(188, 3, tk, "'.'");
                        this.tm.ungetToken();
                    }
                    while ((tk = this.tm.getToken()).getToknum() == 523 || tk.getToknum() == 522) {
                        this.tm.ungetToken();
                        CobolMethod cm = new CobolMethod(this);
                        if (Return2) {
                            Return2 = cm.start();
                        } else {
                            cm.start();
                        }
                        this.allMethods.addItem(cm);
                    }
                    this.tm.ungetToken();
                } else {
                    this.error.print(15, 4, tk, tk.getWord());
                }
            } else {
                this.tm.ungetToken();
            }
            this.parent.checkUsed();
            tk = this.tm.getToken();
            if (tk.getToknum() == 423) {
                tk = this.tm.getToken();
                if (this.isFactory && tk.getToknum() != 480) {
                    this.error.print(31, 4, tk, "FACTORY/" + tk.getWord());
                    Return2 = false;
                } else if (!this.isFactory && tk.getToknum() != 607) {
                    this.error.print(31, 4, tk, "OBJECT/" + tk.getWord());
                    Return2 = false;
                } else {
                    Token tk1 = this.tm.getToken();
                    if (tk1.getToknum() != 10006) {
                        this.error.print(188, 3, tk, "'.'");
                        this.tm.ungetToken();
                    } else {
                        tk = tk1;
                    }
                }
                this.lastToken = tk;
                return Return2;
            } else {
                Return2 = false;
                if (this.isFactory) {
                    this.error.print(31, 4, tk, "END FACTORY/" + tk.getWord());
                    return Return2;
                } else {
                    this.error.print(31, 4, tk, "END OBJECT/" + tk.getWord());
                }
            }
            return Return2;
        }
        catch (EndOfProgramException e) {
            this.error.print(12, 4, this.tm.getLineNumber(), 0, null, null, this.tm.getFileName());
            return false;
        }
        catch (GeneralErrorException e) {
            this.error.print(11, 4, this.tm.getLineNumber(), 0, e.toString(), null, this.tm.getFileName());
            return false;
        }
    }

    private int idDivision(GeneralErrorInfo[] err) throws GeneralErrorException, EndOfProgramException {
        Token tk;
        try {
            tk = this.tm.getToken();
        }
        catch (EndOfProgramException ex) {
            return -1;
        }
        this.firstToken = tk;
        if ((this.firstToken.getToknum() == 523 || tk.getToknum() == 522) && (tk = this.tm.getToken()).getToknum() == 411) {
            if (this.tm.getToken().getToknum() != 10006) {
                this.error.print(188, 3, tk, "'.'");
                this.tm.ungetToken();
            }
            if ((tk = this.tm.getToken()).getToknum() == 480) {
                this.isFactory = true;
            } else if (tk.getToknum() == 607) {
                this.isFactory = false;
            } else {
                throw new UnexpectedTokenException(tk, this.error);
            }
            tk = this.tm.getToken();
            if (tk.getToknum() != 10006) {
                throw new ExpectedFoundException(tk, this.error, ".");
            }
            return 0;
        }
        err[0] = new GeneralErrorInfo(15, 4, tk, "<" + tk.getWord() + ">", this.error);
        return -2;
    }

    protected void loadVariablesScreenSec() throws GeneralErrorException {
        if (this.data != null && this.data.screenSec != null) {
            VariableDeclaration v = this.data.screenSec.vars.getFirst();
            while (v != null) {
                this.parent.loadVariable(v);
                v.calcOffset(this, 0);
                v = this.data.screenSec.vars.getNext();
            }
        }
    }

    @Override
    public void loadVariable(VariableDeclaration v) {
        this.parent.loadVariable(v);
    }

    @Override
    public boolean addSqlCursor(SqlDeclareCursor scd) {
        if (this.isFactory()) {
            return this.parent.addSqlCursor(scd);
        }
        return super.addSqlCursor(scd);
    }

    protected void doCheck() throws GeneralErrorException {
        if (this.data != null && this.data.screenSec != null) {
            this.data.screenSec.check();
        }
        Enumeration e1 = this.allMethods.elements();
        while (e1.hasMoreElements()) {
            CobolMethod cm2;
            CobolMethod cm1 = (CobolMethod)e1.nextElement();
            cm1.doCheck();
            Enumeration e2 = this.allMethods.elements();
            while (e2.hasMoreElements() && cm1 != (cm2 = (CobolMethod)e2.nextElement())) {
            }
            while (e2.hasMoreElements()) {
                cm2 = (CobolMethod)e2.nextElement();
                if (!cm1.hasSameSignature(cm2)) continue;
                throw new GeneralErrorException(145, 4, 0, 0, cm1.getMethodName(), this.tm.getFileName(), null, this.error);
            }
        }
    }

    @Override
    boolean getSplitFlag() {
        return this.parent.getSplitFlag();
    }

    protected void doCode(PrintWriter progFile) throws GeneralErrorException {
        PrintWriter unpw = null;
        this.writeData(progFile);
        CobolMethod cm = this.allMethods.getFirst();
        while (cm != null) {
            if (cm.isUnnamed()) {
                if (this.unnamedMethods == null) {
                    this.unnamedMethods = new StringWriter();
                    unpw = new PrintWriter(this.unnamedMethods);
                }
                cm.doCode(unpw);
            } else {
                cm.doCode(progFile);
            }
            cm = this.allMethods.getNext();
        }
    }

    protected void doCodeUnnamed(PrintWriter progFile) {
        if (this.unnamedMethods != null) {
            progFile.print(this.unnamedMethods);
        }
    }

    private void writeData(PrintWriter progFile) throws GeneralErrorException {
        StringBuffer dynPart = new StringBuffer();
        if (this.data != null) {
            if (this.isFactory()) {
                this.declData = this.data.getCode(dynPart, null);
            } else {
                progFile.println(this.data.getCode(dynPart, null));
            }
        }
        if (this.environment != null) {
            if (this.isFactory()) {
                this.declData = this.declData + this.environment.getCode(dynPart);
            } else {
                progFile.println(this.environment.getCode(dynPart));
            }
        }
        StringBuffer fixedVarPart = new StringBuffer();
        VariableDeclaration v = this.fixedVars.getFirst();
        while (v != null) {
            progFile.println(v.getCode(fixedVarPart));
            v = this.fixedVars.getNext();
        }
        if (this.isFactory()) {
            this.declDynPart = dynPart;
            this.declFixedVarPart = fixedVarPart;
        } else {
            int innerClassCount = -1;
            String innerPrefix = null;
            if (this.getSplitFlag()) {
                innerClassCount = 0;
                innerPrefix = "oinner_";
            }
            innerClassCount = this.writeDeclaration(progFile, dynPart, fixedVarPart, false, innerClassCount, innerPrefix, false, false);
            if (this.getSplitFlag()) {
                progFile.println("   { new " + innerPrefix + (innerClassCount - 1) + "(); }");
            }
        }
        if (this.calls.size() > 0) {
            Enumeration e = this.calls.elements();
            while (e.hasMoreElements()) {
                Token tk = (Token)e.nextElement();
                progFile.println("public   " + Call.getClassName(tk) + " " + Call.getObjName(tk) + " = new " + Call.getClassName(tk) + "();");
            }
        }
    }

    @Override
    protected int writeLiterals(PrintWriter progFile, boolean factory) {
        if (this.isFactory()) {
            progFile.println(this.declData);
            int innerClassCount = -1;
            String innerPrefix = null;
            if (this.getSplitFlag()) {
                innerClassCount = 0;
                innerPrefix = "finner_";
            }
            innerClassCount = this.writeDeclaration(progFile, this.declDynPart, this.declFixedVarPart, true, innerClassCount, innerPrefix, false, false);
            if (this.getSplitFlag()) {
                progFile.println("   static { new " + innerPrefix + (innerClassCount - 1) + "(); }");
            }
        }
        return 0;
    }

    @Override
    protected boolean isFactory() {
        return this.isFactory;
    }

    @Override
    public String getClassName() {
        return this.parent.getClassName();
    }

    @Override
    public String getFullClassName() {
        return this.parent.getFullClassName();
    }

    @Override
    public String getInheritsClass() {
        return this.parent.getInheritsClass();
    }

    @Override
    public String[] getImplementsClass() {
        return this.parent.getImplementsClass();
    }

    @Override
    public boolean isThisClass(String s) {
        return this.parent.isThisClass(s);
    }

    public CobolMethod[] getAllMethods() {
        return this.allMethods.toArray();
    }

    protected CobolMethod getMethod(String name) {
        CobolMethod[] all = this.getAllMethods();
        CobolMethod Return2 = null;
        for (int i = 0; i < all.length; ++i) {
            if (!all[i].getMethodName().equals(name)) continue;
            Return2 = all[i];
            break;
        }
        return Return2;
    }

    @Override
    public MyClass existsClass(String s) throws ClassNotFoundException {
        return this.parent.existsClass(s);
    }

    @Override
    public SpecialNamesClass getSpecialNamesClass(String name) {
        SpecialNamesClass Return2 = super.getSpecialNamesClass(name);
        if (Return2 == null) {
            Return2 = this.parent.getSpecialNamesClass(name);
        }
        return Return2;
    }

    @Override
    public SelectList getSelectList() {
        SelectList Return2 = this.factory != null && this.factory.environment != null ? this.factory.environment.getSelects() : null;
        return Return2;
    }

    @Override
    public Select getSelect(String fileName) {
        SelectList sl;
        Select Return2;
        if (this.factory != null) {
            Return2 = this.factory.getSelect(fileName);
            if (Return2 != null) {
                return Return2;
            }
        } else {
            Return2 = null;
        }
        if (this.environment != null && (sl = this.environment.getSelects()) != null) {
            Return2 = sl.getFirst();
            while (Return2 != null && !fileName.equals(Return2.fileName.getWord())) {
                Return2 = sl.getNext();
            }
        }
        return Return2;
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    @Override
    public Token getLastToken() {
        return this.lastToken;
    }

    @Override
    VariableDeclaration getTypedefVar(String name) {
        CobolClass cc;
        VariableDeclaration Return2 = super.getTypedefVar(name);
        if (Return2 == null && !this.isFactory() && (cc = this.parent.getFactoryPart()) != null && cc.isFactory()) {
            Return2 = cc.getTypedefVar(name);
        }
        return Return2;
    }

    @Override
    protected String getInlineDeclarationCode() {
        return "";
    }
}

