/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.Verb;

public class OnSizeError
extends Verb
implements CobolToken,
ErrorsNumbers {
    Block sizeErrorBlock;
    Block notSizeErrorBlock;

    public OnSizeError(Token kw, Block par, Verb parentVerb, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        boolean not = false;
        TokenManager.Marker mk = this.tm.getMarker();
        this.tm.setMarker(mk);
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 599) {
            not = true;
            tk = this.tm.getToken();
            if (tk.getToknum() != 614 && tk.getToknum() != 729) {
                this.tm.rewindToMarker(mk);
                return;
            }
        }
        if (tk.getToknum() == 614 && (tk = this.tm.getToken()).getToknum() != 729) {
            this.tm.rewindToMarker(mk);
            return;
        }
        if (tk.getToknum() == 729) {
            tk = this.tm.getToken();
            if (tk.getToknum() != 466) {
                throw new ExpectedFoundException(tk, this.error, "'ERROR'");
            }
            if (not) {
                this.notSizeErrorBlock = new Block(this.parent, this.parent.parent, parentVerb, this.pc, this.tm, this.error, this.parent.nesting + 1, 4);
            } else {
                this.sizeErrorBlock = new Block(this.parent, this.parent.parent, parentVerb, this.pc, this.tm, this.error, this.parent.nesting + 1, 3);
            }
            tk = this.tm.getToken();
            if (!not && tk.getToknum() == 599) {
                tk = this.tm.getToken();
                if (tk.getToknum() == 614) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() == 729) {
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 466) {
                        throw new ExpectedFoundException(tk, this.error, "'ERROR'");
                    }
                    this.notSizeErrorBlock = new Block(this.parent, this.parent.parent, parentVerb, this.pc, this.tm, this.error, this.parent.nesting + 1);
                } else {
                    this.tm.ungetToken();
                }
            } else {
                this.tm.ungetToken();
            }
        } else {
            this.tm.ungetToken();
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    public boolean hasBlocks() {
        return this.sizeErrorBlock != null || this.notSizeErrorBlock != null;
    }

    public Block[] getBlocks() {
        Block[] ret = this.hasBlocks() ? new Block[]{this.sizeErrorBlock, this.notSizeErrorBlock} : null;
        return ret;
    }

    public String getCodeBefore() {
        StringBuffer Return2 = new StringBuffer();
        if (this.sizeErrorBlock != null) {
            Return2.append("if (");
        } else if (this.notSizeErrorBlock != null) {
            Return2.append("if (!(");
        }
        return Return2.toString();
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        if (this.sizeErrorBlock != null || this.notSizeErrorBlock != null) {
            Return2.append(")");
            if (this.sizeErrorBlock != null) {
                Return2.append(this.sizeErrorBlock.getCode());
                if (this.notSizeErrorBlock != null) {
                    Return2.append(" else ");
                    Return2.append(this.notSizeErrorBlock.getCode());
                }
            } else if (this.notSizeErrorBlock != null) {
                Return2.append(")");
                Return2.append(this.notSizeErrorBlock.getCode());
            }
        } else {
            Return2.append(";");
        }
        return Return2.toString();
    }
}

