/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Release
extends Verb
implements CobolToken,
ErrorsNumbers {
    private final VariableName recName;
    private VariableDeclaration record;
    private FileDescriptor fd;
    private VariableName fromVar;
    private Token fromToken;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Release(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk = this.tm.getToken();
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.recName = VariableName.get(this.tm, this.error, this.pc);
        this.record = this.recName.getVarDecl();
        this.fd = this.pc.getFdByRecord(this.record);
        if (this.fd == null) {
            throw new GeneralErrorException(51, 4, this.keyWord, tk.getWord(), this.error);
        }
        if (!this.fd.isSort()) {
            throw new GeneralErrorException(104, 4, tk, this.fd.sel.fileName.getWord(), this.error);
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 499) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 10009) {
                this.tm.ungetToken();
                this.fromVar = VariableName.get(this.tm, this.error, this.pc);
                return;
            } else {
                if (tk.getToknum() != 10001 && tk.getToknum() != 10002 && tk.getToknum() != 10017) throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
                this.fromToken = tk;
            }
            return;
        } else {
            this.tm.ungetToken();
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        this.getCodeDebug(Return2);
        if (this.fromVar != null || this.fromToken != null) {
            Return2.append(this.parent.getIndent());
            if (this.fromVar != null) {
                Return2.append(this.fromVar.getCode());
            } else {
                Return2.append(this.getCodeLiteral(this.fromToken));
            }
            Return2.append(".moveTo(");
            Return2.append(this.record.getQualUnivoqueName());
            Return2.append(");");
            Return2.append(eol);
        }
        if (this.tm.getOptionList().getOption("-cv") != null) {
            Return2.append(this.parent.getIndent());
            Return2.append("if (" + this.getLocalVar("SORT-RETURN") + ".toint()==16) throw new SortAbort();");
            Return2.append(eol);
        }
        Return2.append(this.parent.getIndent());
        Return2.append(this.fd.sel.getName());
        if (this.tm.getOptionList().getOption("-xosrt") == null) {
            Return2.append(".releaseRecord(" + this.recName.getCode() + ".length());");
        } else {
            Return2.append(".releaseSort();");
        }
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public VariableDeclaration getRecord() {
        return this.record;
    }

    public FileDescriptor getFd() {
        return this.fd;
    }

    public VariableName getFromVar() {
        return this.fromVar;
    }

    public Token getFromToken() {
        return this.fromToken;
    }
}

