/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.InvalidKey;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Rewrite
extends Verb
implements CobolToken,
ErrorsNumbers {
    private VariableDeclaration record;
    private FileDescriptor fd;
    private VariableName fromVar;
    private Token fromToken;
    private InvalidKey invKey;
    private boolean lock;
    private VariableName keyName;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Rewrite(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 10009) {
            this.tm.ungetToken();
            this.record = VariableName.get(this.tm, this.error, this.pc).getVarDecl();
            this.fd = this.pc.getFdByRecord(this.record);
        } else {
            if (tk.getToknum() != 483) throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
            tk = this.tm.getToken();
            if (tk.getToknum() != 10009) throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
            this.fd = this.pc.data.fileSec.getFD(tk.getWord());
            if (this.fd != null) {
                this.record = this.fd.recordDesc.getFirst();
            }
        }
        if (this.fd == null) {
            throw new GeneralErrorException(51, 4, this.keyWord, tk.getWord(), this.error);
        }
        if (this.fd.isSort()) {
            throw new GeneralErrorException(103, 4, this.keyWord, this.fd.sel.fileName.getWord(), this.error);
        }
        if (!this.fd.sel.allowsOpenIO()) {
            this.error.print(142, 2, this.keyWord, this.fd.sel.fileName.getWord());
        }
        if (this.fd.isXml()) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 552) {
                tk = this.tm.getToken();
                if (tk.getToknum() == 546) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() != 10009) throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
                this.tm.ungetToken();
                this.keyName = VariableName.get(this.tm, this.error, this.pc);
                return;
            } else {
                this.tm.ungetToken();
            }
            return;
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 671) {
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 499) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 10009) {
                this.tm.ungetToken();
                this.fromVar = VariableName.get(this.tm, this.error, this.pc);
            } else {
                if (tk.getToknum() != 10001) throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
                this.fromToken = tk;
            }
        } else {
            this.tm.ungetToken();
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 814 || tk.getToknum() == 571 || tk.getToknum() == 597) {
            if (tk.getToknum() == 814) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 597) {
                tk = this.tm.getToken();
            } else {
                this.lock = true;
            }
            if (tk.getToknum() != 571) {
                throw new ExpectedFoundException(tk, this.error, "LOCK");
            }
        } else {
            this.tm.ungetToken();
        }
        this.invKey = new InvalidKey(this.keyWord, this.fd.sel, this.parent, this, this.pc, this.tm, this.error);
        tk = this.tm.getToken();
        if (tk.getToknum() != 445) {
            this.tm.ungetToken();
            return;
        } else {
            this.endStmt = true;
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        boolean hasDeclaratives = this.pc.getDeclarative(this.fd.sel) != null || this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        if (this.fromVar != null || this.fromToken != null) {
            Return2.append(this.parent.getIndent());
            if (this.fromVar != null) {
                Return2.append(this.fromVar.getCode());
            } else {
                Return2.append(this.getCodeLiteral(this.fromToken));
            }
            Return2.append(".moveTo(");
            Return2.append(this.record.getQualUnivoqueName());
            Return2.append(");");
            Return2.append(eol);
        }
        Return2.append(this.parent.getIndent());
        Return2.append("try {");
        Return2.append(eol);
        Return2.append(this.parent.getIndent());
        if (this.fd.sel.isXml()) {
            Return2.append(this.fd.sel.getName());
            Return2.append(".rewriteXml(");
            Return2.append(this.record.getUnivoqueName());
            Return2.append(",");
            if (this.keyName != null) {
                Return2.append(this.keyName.getCode());
            } else {
                Return2.append("null");
            }
            Return2.append(");");
            Use.putFileStatus(Return2, this.fd.sel, this.parent.getIndent());
        } else {
            Return2.append(this.invKey.getCodeBefore());
            Return2.append(this.fd.sel.getName());
            Return2.append(".rewrite(");
            Return2.append(this.lock);
            Return2.append(",");
            if (this.fd.getDepending() != null && this.fd.sel.organization != 678) {
                if (this.fd.getDependingOffs() > 0) {
                    Return2.append(this.fd.getDependingOffs() + " + ");
                }
                Return2.append(this.fd.getDepending().getCode());
                Return2.append(".toint()");
            } else {
                Return2.append(this.fd.recordMin > this.record.globalLen() ? this.fd.recordMin : this.record.globalLen());
            }
            Return2.append(");");
            Use.putFileStatus(Return2, this.fd.sel, this.parent.getIndent());
            Return2.append(this.invKey.getCode());
        }
        Use.putDeclaratives(Return2, this.pc, this.fd.sel, this.parent.getIndent(), hasDeclaratives);
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public boolean hasGlobalDecl() {
        return this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    public VariableName getFromVar() {
        return this.fromVar;
    }

    public Token getFromToken() {
        return this.fromToken;
    }

    public VariableDeclaration getRecord() {
        return this.record;
    }

    public boolean isLock() {
        return this.lock;
    }

    public InvalidKey getInvKey() {
        return this.invKey;
    }
}

