/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.XMLStreamConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class ServiceBridgeUtility {
    private static final String eol = System.getProperty("line.separator", "\n");
    private static final String SOAP_ENVELOPE_START = "       01  soap-";
    private static final String SOAP_NS_PFX = "soapenv";
    private static final String ARRAY_OF = "ArrayOf";
    private static final String[] SOAP_ENVELOPE_NS = new String[]{"http://schemas.xmlsoap.org/soap/envelope/", "http://www.w3.org/2003/05/soap-envelope"};
    public static final int V1_1 = 0;
    public static final int V1_2 = 1;
    public static final String NS_WSDL = "http://schemas.xmlsoap.org/wsdl/";
    public static final String NS_SOAPENC = "http://schemas.xmlsoap.org/soap/encoding/";
    public static final String NS_SOAPHTTP = "http://schemas.xmlsoap.org/soap/http";
    private static final Map<String, String> soapTypes = new HashMap<String, String>();
    private final List<Type> types = new ArrayList<Type>();
    private final List<Message> messages = new ArrayList<Message>();
    private final List<PortType> portTypes = new ArrayList<PortType>();
    private final List<Binding> bindings = new ArrayList<Binding>();
    private List<DeferredTypeGetCode> deferredMessageTypes;
    private Set<String> varnames;
    private String targetNamespace;
    private Map<String, String> currPref2ns;
    private Map<String, String> currNs2Pref;
    private Map<String, Integer> arraySizes = new HashMap<String, Integer>();
    private final Map<String, String> globPref2ns = new HashMap<String, String>();
    private final Map<String, String> globNs2Pref = new HashMap<String, String>();
    private final Map<String, String> restrictions = new HashMap<String, String>();
    private boolean schemaElemFormQual;
    private final int version;
    private final String uri;
    private int idProg;
    private int nsProg;
    private Set<String> wsdlImports = new HashSet<String>();

    private static void putSpace(StringBuilder code, int level) {
        code.append("         ");
        for (int i = 0; i < level; ++i) {
            code.append(' ');
        }
    }

    private static void putLevel(StringBuilder code, int level) {
        ServiceBridgeUtility.putSpace(code, level);
        if (level < 10) {
            code.append('0');
        }
        code.append(level);
    }

    public ServiceBridgeUtility(String uri, int v) {
        this.uri = uri;
        this.version = v;
    }

    public Map<String, StringBuilder> generateCopyfiles() throws ParserConfigurationException, IOException, SAXException {
        return this.generateCopyfiles(ServiceBridgeUtility.openXml(this.uri));
    }

    private static Element openXml(String uri) throws IOException, SAXException, ParserConfigurationException {
        InputStream is;
        DocumentBuilderFactory dbf = RtsUtil.newDocumentBuilderFactory();
        dbf.setNamespaceAware(true);
        DocumentBuilder dBuilder = dbf.newDocumentBuilder();
        try {
            URL url = new URL(uri);
            is = url.openStream();
        }
        catch (MalformedURLException ex) {
            is = new FileInputStream(uri);
        }
        Document doc = dBuilder.parse(is);
        is.close();
        doc.getDocumentElement().normalize();
        return doc.getDocumentElement();
    }

    public int getVersion() {
        return this.version;
    }

    public String getURI() {
        return this.uri;
    }

    private String getURI(String pfx) {
        String uri = null;
        if (this.currPref2ns != null) {
            uri = this.currPref2ns.get(pfx);
        }
        if (uri == null) {
            uri = this.globPref2ns.get(pfx);
        }
        return uri;
    }

    private FullName getUriAndNameFromAttr(Element elmnt, String aName) throws SAXException {
        return this.getUriAndNameFromAttr(elmnt, aName, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FullName getUriAndNameFromAttr(Element elmnt, String aName, String ns) throws SAXException {
        String name;
        String uri;
        String str = ns == null ? elmnt.getAttribute(aName) : elmnt.getAttributeNS(ns, aName);
        if (str == null) return null;
        if (str.length() <= 0) return null;
        int colonIdx = str.indexOf(58);
        if (colonIdx > 0) {
            uri = this.getURI(str.substring(0, colonIdx));
            if (uri == null) {
                throw new SAXException("Invalid namespace in element:" + str.substring(0, colonIdx));
            }
            if (++colonIdx >= str.length()) throw new SAXException("Void name in element:" + str);
            name = str.substring(colonIdx);
            return new FullName(uri, name);
        } else {
            uri = this.targetNamespace;
            name = str;
        }
        return new FullName(uri, name);
    }

    private Type getType(Element node, boolean elemFormQual) throws SAXException {
        Type Return2;
        ElementIterator ni = new ElementIterator(node);
        String name = node.getAttribute("name");
        FullName nsType = this.getUriAndNameFromAttr(node, "type");
        if (nsType == null) {
            nsType = this.getUriAndNameFromAttr(node, "element");
            if (nsType == null) {
                FullName tmp;
                nsType = tmp = this.getUriAndNameFromAttr(node, "ref");
            }
            if (nsType != null) {
                name = nsType.name;
            }
        }
        if (nsType != null) {
            if ("http://www.w3.org/2001/XMLSchema".equals(nsType.uri)) {
                if (!XMLStreamConstants.xsdSimpleTypes.containsKey(nsType.name)) {
                    ServiceBridgeUtility.warning("Invalid type '" + nsType.name + "'");
                }
                Return2 = new Type(name, "simple", nsType, elemFormQual, this.currNs2Pref);
            } else {
                String type = XMLStreamConstants.xsdSimpleTypes.containsKey(nsType.name) ? "simple" : "reference";
                Return2 = new Type(name, type, nsType, elemFormQual, this.currNs2Pref);
            }
        } else {
            String nName;
            Element ei;
            Return2 = node.hasChildNodes() ? ((ei = ni.next()) != null ? ((nName = ei.getLocalName()).equalsIgnoreCase("complexType") ? this.scanComplexTypes(ei, name, elemFormQual) : (nName.equalsIgnoreCase("simpleType") ? this.scanSimpleTypes(ei, name, elemFormQual) : null)) : null) : null;
        }
        if (Return2 != null) {
            String maxOcc = node.getAttribute("maxOccurs");
            if (maxOcc != null && maxOcc.length() > 0) {
                int dimSize = -1;
                if (maxOcc.equals("unbounded")) {
                    dimSize = 0;
                } else {
                    try {
                        dimSize = Integer.parseInt(maxOcc);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (dimSize == 0 || dimSize > 1) {
                    Return2.dimensions++;
                    if (Return2.dimensionSize == null) {
                        Type.access$3302(Return2, new int[]{dimSize});
                    } else {
                        int[] tmp = Return2.dimensionSize;
                        Type.access$3302(Return2, new int[tmp.length + 1]);
                        System.arraycopy(tmp, 0, Return2.dimensionSize, 0, tmp.length);
                        ((Type)Return2).dimensionSize[tmp.length] = dimSize;
                    }
                }
            }
            String minOcc = node.getAttribute("minOccurs");
            Return2.optional = "0".equals(minOcc);
        }
        return Return2;
    }

    private static void warning(String msg) {
        System.err.println("Warning: " + msg);
    }

    private void scanComplexTypes(Element node, Type t) throws SAXException {
        if (node.hasChildNodes()) {
            Element ei;
            ElementIterator ni = new ElementIterator(node);
            while ((ei = ni.next()) != null) {
                String nName = ei.getLocalName();
                if (nName.equalsIgnoreCase("element")) {
                    Type t0 = this.getType(ei, this.getElementFormQualified(ei));
                    if (t0 != null) {
                        t.add(t0, ei);
                        continue;
                    }
                    ServiceBridgeUtility.warning("type undefined: '" + ServiceBridgeUtility.nodeToString(ei) + "'");
                    continue;
                }
                ServiceBridgeUtility.warning("type undefined: '" + ServiceBridgeUtility.nodeToString(ei) + "'");
            }
        }
    }

    private Type scanSimpleTypes(Node node, boolean elemFormQual) throws SAXException {
        return this.scanSimpleTypes(node, null, elemFormQual);
    }

    private Type scanSimpleTypes(Node node, String n, boolean elemFormQual) throws SAXException {
        String nName;
        ElementIterator ni;
        Element ei;
        Type Return2 = null;
        Element elmnt = (Element)node;
        String name = elmnt.getAttribute("name");
        if ((name == null || name.length() == 0) && n != null) {
            name = n;
        }
        if (node.hasChildNodes() && (ei = (ni = new ElementIterator(node)).next()) != null && (nName = ei.getLocalName()).equals("restriction")) {
            FullName nsBase = this.getUriAndNameFromAttr(ei, "base");
            if (nsBase == null) {
                throw new SAXException("Missing \"base\" attribute in <restriction>");
            }
            Return2 = new Type(name, "restriction", nsBase, elemFormQual, this.currNs2Pref);
            this.restrictions.put(name, nsBase.name);
        }
        if (Return2 == null) {
            Return2 = new Type(name, "simple", null, elemFormQual, this.currNs2Pref);
        }
        return Return2;
    }

    private Type scanAttribute(String nName, Element elmnt, boolean elemFormQual) throws SAXException {
        Element ei;
        ElementIterator ni = new ElementIterator(elmnt);
        FullName nsArrayType = null;
        while ((ei = ni.next()) != null) {
            FullName nsItem;
            if (!"attribute".equals(ei.getLocalName()) || (nsItem = this.getUriAndNameFromAttr(ei, "ref")) == null || !"arrayType".equals(nsItem.name) || !NS_SOAPENC.equals(nsItem.uri)) continue;
            nsArrayType = this.getUriAndNameFromAttr(ei, "arrayType", NS_WSDL);
        }
        if (nsArrayType != null) {
            int dimensions = 0;
            ArrayList<Integer> dimensionSize = new ArrayList<Integer>();
            int offs = 0;
            boolean first = true;
            String name = nsArrayType.name;
            while ((offs = name.indexOf(91, offs)) > 0) {
                int offs2;
                if (first) {
                    nsArrayType.name = name.substring(0, offs);
                    first = false;
                }
                ++dimensions;
                if ((offs2 = name.indexOf(93, ++offs)) > offs) {
                    try {
                        dimensionSize.add(new Integer(name.substring(offs, offs2)));
                    }
                    catch (NumberFormatException ex) {
                        dimensionSize.add(0);
                    }
                    offs = offs2 + 1;
                    continue;
                }
                Integer sz = this.arraySizes.get(nName);
                if (sz == null) {
                    sz = 0;
                }
                dimensionSize.add(sz);
            }
            if (first) {
                dimensions = 1;
                dimensionSize.add(new Integer(0));
            }
            int[] ds = new int[dimensionSize.size()];
            for (int i = 0; i < ds.length; ++i) {
                ds[i] = (Integer)dimensionSize.get(i);
            }
            if (this.targetNamespace.equals(nsArrayType.uri)) {
                return new Type(nName, "reference", nsArrayType, dimensions, ds, elemFormQual, this.currNs2Pref);
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(nsArrayType.uri)) {
                if (!XMLStreamConstants.xsdSimpleTypes.containsKey(nsArrayType.name)) {
                    throw new SAXException("Invalid type " + nsArrayType.name);
                }
                return new Type(nName, "simple", nsArrayType, dimensions, ds, elemFormQual, this.currNs2Pref);
            }
            throw new SAXException("Unhandled type " + nsArrayType.uri + ":" + nsArrayType.name);
        }
        throw new SAXException("arrayType not found on " + nName);
    }

    private boolean getElementFormQualified(Element elem) {
        String form = elem.getAttribute("form");
        if (form != null && form.length() > 0) {
            return "qualified".equals(form);
        }
        return this.schemaElemFormQual;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Type scanRestriction(String nName, Element elmnt, boolean elemFormQual) throws SAXException {
        FullName nsBase = this.getUriAndNameFromAttr(elmnt, "base");
        if (nsBase == null) {
            throw new SAXException("Missing \"base\" attribute in <restriction>");
        }
        Type Return2 = null;
        if (NS_SOAPENC.equals(nsBase.uri)) {
            if (soapTypes.get(nsBase.name) == null) {
                throw new SAXException("Invalid type " + nsBase.name);
            }
            if ("Array".equals(nsBase.name)) {
                if (!elmnt.hasChildNodes()) throw new SAXException("void array:" + nName);
                return this.scanAttribute(nName, elmnt, elemFormQual);
            }
            Return2 = new Type(nName, "restriction", nsBase, elemFormQual, this.currNs2Pref);
            Return2.add(this.scanComplexTypes(elmnt, elemFormQual), elmnt);
            return Return2;
        } else {
            Return2 = new Type(nName, "restriction", nsBase, elemFormQual, this.currNs2Pref);
            Return2.add(this.scanComplexTypes(elmnt, elemFormQual), elmnt);
        }
        return Return2;
    }

    private Type scanComplexContent(String nName, Element elmnt, boolean elemFormQual) throws SAXException {
        if (elmnt.hasChildNodes()) {
            ElementIterator ni = new ElementIterator(elmnt);
            Element ei = ni.next();
            if (ei != null) {
                String name = ei.getLocalName();
                if ("extension".equalsIgnoreCase(name)) {
                    FullName base = this.getUriAndNameFromAttr(ei, "base");
                    Type t = new Type(nName, "extension", base, elemFormQual, this.currNs2Pref);
                    t.add(this.scanComplexTypes(ei, elemFormQual), ei);
                    return t;
                }
                if ("restriction".equalsIgnoreCase(name)) {
                    return this.scanRestriction(nName, ei, elemFormQual);
                }
                throw new SAXException("Unexpected node <" + name + ">");
            }
            throw new SAXException("Void node <" + nName + ">");
        }
        throw new SAXException("Void node <" + nName + ">");
    }

    private Type scanComplexTypes(Element node, boolean elemFormQual) throws SAXException {
        return this.scanComplexTypes(node, null, elemFormQual);
    }

    private Type scanComplexTypes(Element node, String n, boolean elemFormQual) throws SAXException {
        Type Return2 = null;
        Element elmnt = node;
        String name = elmnt.getAttribute("name");
        if ((name == null || name.length() == 0) && n != null) {
            name = n;
        }
        if (node.hasChildNodes()) {
            Element ei;
            ElementIterator ni = new ElementIterator(node);
            while ((ei = ni.next()) != null) {
                String nName = ei.getLocalName();
                if ("complexContent".equalsIgnoreCase(nName)) {
                    Return2 = this.scanComplexContent(name, ei, elemFormQual);
                    continue;
                }
                Object order = "all".equalsIgnoreCase(nName) ? "all" : ("choice".equalsIgnoreCase(nName) ? "choice" : ("sequence".equalsIgnoreCase(nName) ? "sequence" : ("anyAttribute".equalsIgnoreCase(nName) ? null : "simple")));
                if (order == null) continue;
                Return2 = new Type(name, (String)order, null, elemFormQual, this.currNs2Pref);
                this.scanComplexTypes(ei, Return2);
            }
        }
        return Return2;
    }

    private void scanTypesSchema(Element node) throws SAXException {
        if (node.hasChildNodes()) {
            Element ei;
            this.globNs2Pref.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
            this.globPref2ns.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.currNs2Pref = new HashMap<String, String>();
            this.currPref2ns = new HashMap<String, String>();
            this.schemaElemFormQual = "qualified".equals(node.getAttribute("elementFormDefault"));
            ElementIterator ni = new ElementIterator(node);
            ArrayList<String> imports = new ArrayList<String>();
            while ((ei = ni.next()) != null) {
                Type t;
                boolean isImport = "import".equalsIgnoreCase(ei.getLocalName());
                if (isImport) {
                    String schemaLocation = ei.getAttribute("schemaLocation");
                    if (schemaLocation.length() > 0 && !this.wsdlImports.contains(schemaLocation)) {
                        this.wsdlImports.add(schemaLocation);
                        imports.add(schemaLocation);
                    }
                    t = null;
                } else {
                    t = "complexType".equalsIgnoreCase(ei.getLocalName()) ? this.scanComplexTypes(ei, this.getElementFormQualified(ei)) : ("simpleType".equalsIgnoreCase(ei.getLocalName()) ? this.scanSimpleTypes(ei, this.getElementFormQualified(ei)) : ("element".equalsIgnoreCase(ei.getLocalName()) ? this.getType(ei, this.getElementFormQualified(ei)) : null));
                }
                if (t != null) {
                    if (this.types.contains(t)) {
                        ServiceBridgeUtility.warning("duplicate type: '" + ServiceBridgeUtility.nodeToString(ei) + "'");
                    }
                    this.types.add(t);
                    t.setTypeIndex(this.types.size());
                    continue;
                }
                if (isImport) continue;
                ServiceBridgeUtility.warning("type undefined: '" + ServiceBridgeUtility.nodeToString(ei) + "'");
            }
            this.currNs2Pref = null;
            this.currPref2ns = null;
            for (String schemaLocation : imports) {
                try {
                    Element rootElem;
                    File fUri;
                    File f = new File(schemaLocation);
                    if (!f.isAbsolute() && (fUri = new File(this.uri)).isFile() && fUri.getParent() != null) {
                        schemaLocation = fUri.getParent() + File.separator + schemaLocation;
                    }
                    if (!"schema".equalsIgnoreCase((rootElem = ServiceBridgeUtility.openXml(schemaLocation)).getLocalName())) continue;
                    this.scanTypesSchema(rootElem);
                }
                catch (ParserConfigurationException e) {
                    ServiceBridgeUtility.warning(e.getMessage());
                }
                catch (IOException e) {
                    ServiceBridgeUtility.warning(e.getMessage());
                }
            }
        }
    }

    private void scanTypes(Node node) throws SAXException {
        if (node.hasChildNodes()) {
            Element ei;
            ElementIterator ni = new ElementIterator(node);
            while ((ei = ni.next()) != null) {
                String nName = ei.getLocalName();
                if (!"schema".equalsIgnoreCase(nName)) continue;
                this.scanTypesSchema(ei);
            }
        }
    }

    private void scanMessage(Element node) throws SAXException {
        String name = node.getAttribute("name");
        if (name == null || name.length() == 0) {
            ServiceBridgeUtility.warning("<message> without name: " + ServiceBridgeUtility.nodeToString(node));
        } else if (!node.hasChildNodes()) {
            ServiceBridgeUtility.warning("<message> without part(s): " + ServiceBridgeUtility.nodeToString(node));
        } else {
            Element ei;
            Message msg = new Message(name);
            this.messages.add(msg);
            ElementIterator ni = new ElementIterator(node);
            while ((ei = ni.next()) != null) {
                if (!"part".equalsIgnoreCase(ei.getLocalName())) continue;
                Type t0 = this.getType(ei, this.schemaElemFormQual);
                if (t0 != null) {
                    msg.addPart(t0);
                    continue;
                }
                ServiceBridgeUtility.warning("type undefined: '" + ServiceBridgeUtility.nodeToString(ei) + "'");
            }
        }
    }

    private Operation scanOperation(Element node) throws SAXException {
        FullName nsName = this.getUriAndNameFromAttr(node, "name");
        if (nsName == null) {
            throw new SAXException("<operation> without name");
        }
        String pfx = null;
        if (nsName.uri != null) {
            pfx = this.globNs2Pref.get(nsName.uri);
        }
        Operation Return2 = new Operation(nsName.uri, pfx, nsName.name);
        if (node.hasChildNodes()) {
            Element ei;
            ElementIterator ni = new ElementIterator(node);
            while ((ei = ni.next()) != null) {
                String nName = ei.getLocalName();
                FullName nsMsg = this.getUriAndNameFromAttr(ei, "message");
                if (nsMsg == null) continue;
                Message msg = ServiceBridgeUtility.findMessage(this.messages, nsMsg.name);
                Return2.addParams(nName, msg);
            }
        }
        return Return2;
    }

    private void scanPortType(Element node) throws SAXException {
        String name = node.getAttribute("name");
        if (name == null || name.length() == 0) {
            throw new SAXException("<portType> without name");
        }
        PortType pt = new PortType(name);
        this.portTypes.add(pt);
        if (node.hasChildNodes()) {
            Element ei;
            ElementIterator ni = new ElementIterator(node);
            while ((ei = ni.next()) != null) {
                String nName = ei.getLocalName();
                if (!"operation".equalsIgnoreCase(nName)) continue;
                pt.addOperation(this.scanOperation(ei));
            }
        }
    }

    private void scanBinding2(Element node, Binding binding) throws SAXException {
        String style = node.getAttribute("style");
        String transport = node.getAttribute("transport");
        if (transport == null || transport.length() == 0) {
            ServiceBridgeUtility.warning("Missing 'transport' attribute");
        } else if (!NS_SOAPHTTP.equals(transport)) {
            ServiceBridgeUtility.warning("Invalid 'transport' value: " + transport);
        }
        binding.setStyle(style);
        binding.setTransport(transport);
    }

    private void scanBinding(Element node) throws SAXException {
        String name = node.getAttribute("name");
        FullName type = this.getUriAndNameFromAttr(node, "type");
        Binding binding = new Binding(name, type, this.portTypes);
        this.bindings.add(binding);
        if (node.hasChildNodes()) {
            Element ei;
            ElementIterator ni = new ElementIterator(node);
            while ((ei = ni.next()) != null) {
                String nName = ei.getLocalName();
                if ("binding".equalsIgnoreCase(nName)) {
                    this.scanBinding2(ei, binding);
                    continue;
                }
                if (!"operation".equalsIgnoreCase(nName)) continue;
                this.scanOperation2(ei, binding.portType, "rpc".equalsIgnoreCase(binding.style));
            }
        }
    }

    private void scanOperation2(Element node, PortType pt, boolean rpcStyle) throws SAXException {
        if (pt != null && node.hasChildNodes()) {
            String name = node.getAttribute("name");
            for (Operation op : pt.operations) {
                Element ei;
                if (!op.name.equals(name)) continue;
                ElementIterator ni = new ElementIterator(node);
                block1: while ((ei = ni.next()) != null) {
                    String nName = ei.getLocalName();
                    for (Operation.Param param : op.params) {
                        Element ei2;
                        if (!param.key.equals(nName)) continue;
                        if (!ei.hasChildNodes()) continue block1;
                        ElementIterator ni2 = new ElementIterator(ei);
                        while ((ei2 = ni2.next()) != null) {
                            FullName fn;
                            String nName2 = ei2.getLocalName();
                            if ("body".equals(nName2)) {
                                if (NS_SOAPENC.equals(ei2.getAttribute("encodingStyle")) && "encoded".equals(ei2.getAttribute("use"))) {
                                    param.msg.encoded = true;
                                }
                                if (!rpcStyle) continue;
                                this.setRpcURI(param, ei2);
                                continue;
                            }
                            if (!"header".equals(nName2) || (fn = this.getUriAndNameFromAttr(ei2, "message")) == null) continue;
                            param.hdr = ServiceBridgeUtility.findMessage(this.messages, fn.name);
                            if (param.hdr == null) continue;
                            if (NS_SOAPENC.equals(ei2.getAttribute("encodingStyle")) && "encoded".equals(ei2.getAttribute("use"))) {
                                param.hdr.encoded = true;
                            }
                            param.uri = ei2.getAttribute("namespace");
                            if (!rpcStyle) continue;
                            this.setRpcURI(param, ei2);
                        }
                        continue block1;
                    }
                }
                break block0;
            }
        }
    }

    private void setRpcURI(Operation.Param param, Element ei2) {
        param.uri = ei2.getAttribute("namespace");
        if (param.uri != null && param.uri.length() > 0) {
            String pfx;
            if ("output".equals(param.key)) {
                pfx = "ns" + this.nsProg++;
                if (!this.globNs2Pref.containsKey(param.uri)) {
                    this.globNs2Pref.put(param.uri, pfx);
                }
                this.globPref2ns.put(pfx, param.uri);
            } else {
                pfx = this.globNs2Pref.get(param.uri);
                if (pfx == null) {
                    pfx = "ns" + this.nsProg++;
                    this.globNs2Pref.put(param.uri, pfx);
                    this.globPref2ns.put(pfx, param.uri);
                }
            }
            param.uriPfx = pfx;
        }
    }

    public void setArraySizes(Map<String, Integer> map) {
        this.arraySizes.putAll(map);
    }

    private Map<String, StringBuilder> generateCopyfiles(Node node) throws SAXException, IOException, ParserConfigurationException {
        this.scanRoot(node);
        ServiceBridgeUtility.doReference(this.types, this.types);
        for (Message m : this.messages) {
            ServiceBridgeUtility.doReference(this.types, m.parts);
        }
        LinkedHashMap<String, StringBuilder> copyFilesMap = new LinkedHashMap<String, StringBuilder>();
        for (Binding bnd : this.bindings) {
            boolean rpcStyle;
            PortType pt = bnd.portType;
            boolean bl = rpcStyle = bnd.style != null && bnd.style.equals("rpc");
            if (pt == null || !NS_SOAPHTTP.equals(bnd.transport)) continue;
            for (Operation op : pt.operations) {
                StringBuilder sb = new StringBuilder();
                op.getCode(sb, pt.name, rpcStyle);
                if (sb.length() <= 0) continue;
                copyFilesMap.put(op.name, sb);
            }
        }
        return copyFilesMap;
    }

    private void scanRoot(Node node) throws SAXException, IOException, ParserConfigurationException {
        if (node.getNodeType() != 1 || !"definitions".equalsIgnoreCase(node.getLocalName())) {
            throw new SAXException("Invalid root element: expected <definitions> found <" + node.getLocalName() + ">");
        }
        Element elmnt = (Element)node;
        this.targetNamespace = elmnt.getAttribute("targetNamespace");
        if (node.hasChildNodes()) {
            Element ei;
            ElementIterator ni = new ElementIterator(node);
            while ((ei = ni.next()) != null) {
                String location;
                String nName = ei.getLocalName();
                if ("types".equalsIgnoreCase(nName)) {
                    this.scanTypes(ei);
                    continue;
                }
                if ("message".equalsIgnoreCase(nName)) {
                    this.scanMessage(ei);
                    continue;
                }
                if ("portType".equalsIgnoreCase(nName)) {
                    this.scanPortType(ei);
                    continue;
                }
                if ("binding".equalsIgnoreCase(nName)) {
                    this.scanBinding(ei);
                    continue;
                }
                if (!"import".equalsIgnoreCase(nName) || (location = ei.getAttribute("location")).length() <= 0 || this.wsdlImports.contains(location)) continue;
                this.wsdlImports.add(location);
                this.scanRoot(ServiceBridgeUtility.openXml(location));
            }
        }
    }

    public void debug() {
        for (Binding bnd : this.bindings) {
            System.out.println(bnd);
        }
        for (PortType pt : this.portTypes) {
            System.out.println(pt);
        }
        for (Message msg : this.messages) {
            System.out.println(msg);
        }
        for (Type t : this.types) {
            System.out.println(t);
        }
    }

    private static void doReference(List<Type> allTypes, List<Type> thisTypes) {
        for (Type t : thisTypes) {
            if (t.reference == null && (t.type == "reference" || t.type == "extension")) {
                t.reference = ServiceBridgeUtility.lookFor(allTypes, t);
                if (t.reference != null) {
                    t.reference.parent = t;
                    if (t.ns2Pref == null) {
                        t.ns2Pref = t.reference.ns2Pref;
                    }
                }
                if (t.type != "extension" || t.components == null) continue;
                ServiceBridgeUtility.doReference(allTypes, t.components);
                continue;
            }
            if (t.components == null) continue;
            ServiceBridgeUtility.doReference(allTypes, t.components);
        }
    }

    private static boolean isSameOrAncestor(Type t, Type t0) {
        while (t0 != null) {
            if (t == t0) {
                return true;
            }
            t0 = t0.parent;
        }
        return false;
    }

    private static Type lookFor(List<Type> typesList, Type findme) {
        FullName name = findme.typeName;
        Type Return2 = null;
        for (Type t : typesList) {
            if (ServiceBridgeUtility.isSameOrAncestor(t, findme) || !t.name.equals(name.name) || t.typeName == null || findme.typeName == null || !((Type)t).typeName.uri.equals(((Type)findme).typeName.uri)) continue;
            Return2 = t;
            if (findme.typeIndex >= t.typeIndex) continue;
            return Return2;
        }
        if (Return2 != null) {
            return Return2;
        }
        for (Type t : typesList) {
            if (ServiceBridgeUtility.isSameOrAncestor(t, findme) || !t.name.equals(name.name)) continue;
            Return2 = t;
            if (findme.typeIndex >= t.typeIndex) continue;
            return Return2;
        }
        return Return2;
    }

    private static Message findMessage(List<Message> all, String name) {
        for (Message m : all) {
            if (!name.equals(m.name)) continue;
            return m;
        }
        return null;
    }

    private static boolean isOccursDynamic(String occurs) {
        return occurs != null && occurs.startsWith("dynamic");
    }

    private static String nodeToString(Node n) {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        if (n instanceof Element) {
            Element e = (Element)n;
            sb.append(e.getTagName());
            NamedNodeMap attrs = e.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr a = (Attr)attrs.item(i);
                sb.append(" ");
                sb.append(a.getName());
                sb.append("=\"");
                sb.append(a.getValue());
                sb.append("\"");
            }
        } else {
            sb.append(n.getNodeName());
        }
        sb.append(">");
        return sb.toString();
    }

    static {
        soapTypes.put("string", "S");
        soapTypes.put("Array", "S");
    }

    private class ElementIterator {
        private final NodeList nodeList;
        private final int count;
        private int idx;

        ElementIterator(Node n) {
            this.nodeList = n.getChildNodes();
            this.count = this.nodeList.getLength();
            if (n.getNodeType() == 1) {
                NamedNodeMap atts = n.getAttributes();
                Map p2n = ServiceBridgeUtility.this.currPref2ns != null ? ServiceBridgeUtility.this.currPref2ns : ServiceBridgeUtility.this.globPref2ns;
                Map n2p = ServiceBridgeUtility.this.currNs2Pref != null ? ServiceBridgeUtility.this.currNs2Pref : ServiceBridgeUtility.this.globNs2Pref;
                for (int i = 0; i < atts.getLength(); ++i) {
                    Node a = atts.item(i);
                    String qName = a.getNodeName();
                    if (!qName.startsWith("xmlns:") || qName.length() <= 6) continue;
                    p2n.put(a.getLocalName(), a.getNodeValue());
                    n2p.put(a.getNodeValue(), a.getLocalName());
                }
            }
        }

        Element next() {
            while (this.idx < this.count) {
                Node Return2;
                if ((Return2 = this.nodeList.item(this.idx++)).getNodeType() != 1) continue;
                return (Element)Return2;
            }
            return null;
        }
    }

    private static class DeferredTypeGetCode {
        Type t;
        Type par;
        String uri;
        boolean output;
        String typeUri;
        boolean encoded;
        String occurs;
        int id;

        DeferredTypeGetCode(Type t, Type par, String uri, boolean output, String typeUri, boolean encoded, String occurs, int id) {
            this.t = t;
            this.par = par;
            this.uri = uri;
            this.output = output;
            this.typeUri = typeUri;
            this.encoded = encoded;
            this.occurs = occurs;
            this.id = id;
        }

        void getCode(StringBuilder code, int level) {
            this.t.getCode(code, this.par, level, this.uri, this.output, this.typeUri, this.encoded, this.occurs, this.id);
        }
    }

    private class Binding {
        private final String name;
        private final FullName type;
        private final PortType portType;
        private String style;
        private String transport;

        Binding(String n, FullName fn, List<PortType> ptl) throws SAXException {
            this.name = n;
            this.type = fn;
            int size = ptl.size();
            PortType pt = null;
            for (int i = 0; i < size && !(pt = ptl.get(i)).name.equals(this.type.name); ++i) {
                pt = null;
            }
            this.portType = pt;
            if (this.portType == null) {
                throw new SAXException("<binding>:portType " + this.type.name + " not found");
            }
        }

        void setStyle(String s) {
            this.style = s;
        }

        void setTransport(String t) {
            this.transport = t;
        }

        public String toString() {
            return "binding=" + this.name + ",style=" + this.style + ",transport=" + this.transport + ":" + this.portType;
        }
    }

    private class PortType {
        private final String name;
        private final List<Operation> operations = new ArrayList<Operation>();

        PortType(String n) {
            this.name = n;
        }

        void addOperation(Operation m) {
            this.operations.add(m);
        }

        public String toString() {
            StringBuilder Return2 = new StringBuilder("PortType:");
            Return2.append(this.name);
            Return2.append('\n');
            for (Operation op : this.operations) {
                Return2.append(op);
            }
            return Return2.toString();
        }
    }

    private class Operation {
        private final String uri;
        private final String uriPfx;
        private final String name;
        private final List<Param> params = new ArrayList<Param>();

        Operation(String u, String upfx, String n) {
            this.uri = u;
            this.uriPfx = upfx;
            this.name = n;
        }

        void addParams(String t, Message m) {
            this.params.add(new Param(t, m));
        }

        private void getNamespaces(Message msg, Map<String, String> result) {
            for (Type t : msg.parts) {
                this.getNamespaces(t, result);
            }
        }

        private void getNamespaces(Type t, Map<String, String> result) {
            if (t.typeName != null && ((Type)t).typeName.uri != null && ((Type)t).typeName.uri != "http://www.w3.org/2001/XMLSchema") {
                ((Type)t).typeName.pfx = t.getPrefix(((Type)t).typeName.uri);
                if (((Type)t).typeName.pfx != null) {
                    result.put(((Type)t).typeName.pfx, ((Type)t).typeName.uri);
                } else {
                    ServiceBridgeUtility.warning("unknown namespace: '" + ((Type)t).typeName.uri + "'");
                }
            }
            if (t.reference != null) {
                if (ServiceBridgeUtility.isSameOrAncestor(t.reference, t)) {
                    ServiceBridgeUtility.warning("removed recursive dependence: '" + t.reference.name + "'");
                    t.reference = null;
                } else {
                    this.getNamespaces(t.reference, result);
                }
            }
            if (t.components != null) {
                int i = 0;
                while (i < t.components.size()) {
                    Type c = (Type)t.components.get(i);
                    if (ServiceBridgeUtility.isSameOrAncestor(c, t)) {
                        ServiceBridgeUtility.warning("removed recursive dependence: '" + c.name + "'");
                        t.components.remove(i);
                        continue;
                    }
                    this.getNamespaces(c, result);
                    ++i;
                }
            }
        }

        public void getCode(StringBuilder code, String portTypeName, boolean rpcStyle) {
            code.append("       >>SOURCE FORMAT FREE");
            code.append(eol);
            code.append("      *> binding name=");
            code.append(this.name);
            code.append(", style=");
            code.append(rpcStyle ? "rpc" : "document");
            code.append(eol);
            for (Param p : this.params) {
                LinkedHashMap<String, String> namespacesMap = new LinkedHashMap<String, String>();
                int level = 5;
                boolean output = p.key.equals("output");
                code.append(ServiceBridgeUtility.SOAP_ENVELOPE_START);
                if (output) {
                    code.append("out-");
                } else {
                    code.append("in-");
                }
                if (this.uri != null && this.uriPfx != null) {
                    namespacesMap.put(this.uriPfx, this.uri);
                }
                if (rpcStyle && p.uriPfx != null) {
                    namespacesMap.put(p.uriPfx, p.uri);
                }
                if (p.hdr != null) {
                    this.getNamespaces(p.hdr, namespacesMap);
                }
                if (p.msg != null) {
                    this.getNamespaces(p.msg, namespacesMap);
                }
                code.append(this.name);
                code.append(" identified by 'soapenv:Envelope'." + eol);
                ServiceBridgeUtility.putLevel(code, 3);
                code.append(" identified by 'xmlns:soapenv' is attribute." + eol);
                ServiceBridgeUtility.putLevel(code, 5);
                code.append(" filler pic x(" + SOAP_ENVELOPE_NS[ServiceBridgeUtility.this.version].length() + ") value '" + SOAP_ENVELOPE_NS[ServiceBridgeUtility.this.version] + "'." + eol);
                if (p.msg.encoded) {
                    ServiceBridgeUtility.putLevel(code, 3);
                    code.append(" identified by 'xmlns:xsd' is attribute.");
                    code.append(eol);
                    ServiceBridgeUtility.putLevel(code, 5);
                    code.append(" filler pic x(" + "http://www.w3.org/2001/XMLSchema".length() + ")");
                    code.append(" value \"");
                    code.append("http://www.w3.org/2001/XMLSchema");
                    code.append("\".");
                    code.append(eol);
                    ServiceBridgeUtility.putLevel(code, 3);
                    code.append(" identified by 'xmlns:xsi' is attribute.");
                    code.append(eol);
                    ServiceBridgeUtility.putLevel(code, 5);
                    code.append(" filler pic x(" + "http://www.w3.org/2001/XMLSchema-instance".length() + ")");
                    code.append(" value \"");
                    code.append("http://www.w3.org/2001/XMLSchema-instance");
                    code.append("\".");
                    code.append(eol);
                    ServiceBridgeUtility.putLevel(code, 3);
                    code.append(" identified by 'xmlns:soapenc' is attribute.");
                    code.append(eol);
                    ServiceBridgeUtility.putLevel(code, 5);
                    code.append(" filler pic x(" + ServiceBridgeUtility.NS_SOAPENC.length() + ")");
                    code.append(" value \"");
                    code.append(ServiceBridgeUtility.NS_SOAPENC);
                    code.append("\".");
                    code.append(eol);
                }
                for (String pfx : namespacesMap.keySet()) {
                    String ns = (String)namespacesMap.get(pfx);
                    ServiceBridgeUtility.putLevel(code, 3);
                    code.append(" identified by 'xmlns:" + pfx + "' is attribute." + eol);
                    ServiceBridgeUtility.putLevel(code, 5);
                    code.append(" filler pic x(" + ns.length() + ") value '" + ns + "'." + eol);
                }
                if (p.hdr != null) {
                    ServiceBridgeUtility.putLevel(code, 3);
                    code.append(" identified by 'soapenv:Header'." + eol);
                    p.hdr.getCode(code, level, this.uri, output);
                }
                ServiceBridgeUtility.putLevel(code, 3);
                code.append(" identified by 'soapenv:Body'." + eol);
                if (rpcStyle) {
                    ++level;
                    if (p.msg.encoded) {
                        this.putEncodingStyle(code, level);
                    }
                    ServiceBridgeUtility.putLevel(code, level);
                    code.append(" identified by '");
                    if (p.uriPfx != null) {
                        code.append(p.uriPfx);
                        code.append(":");
                    }
                    code.append(this.name);
                    if (output) {
                        code.append("Response");
                    }
                    code.append("'.");
                    code.append(eol);
                }
                p.msg.getCode(code, level, this.uri, output);
                code.append(eol);
            }
            code.append("       >>SOURCE FORMAT PREVIOUS" + eol);
        }

        private void putEncodingStyle(StringBuilder code, int level) {
            ServiceBridgeUtility.putLevel(code, level);
            code.append(" identified by 'soapenv:encodingStyle' is attribute.");
            code.append(eol);
            ServiceBridgeUtility.putLevel(code, level + 1);
            code.append(" filler pic x(" + ServiceBridgeUtility.NS_SOAPENC.length() + ") value '" + ServiceBridgeUtility.NS_SOAPENC + "'.");
            code.append(eol);
        }

        public String toString() {
            StringBuilder Return2 = new StringBuilder("Operation:");
            Return2.append(this.name);
            Return2.append('\n');
            if (this.params != null) {
                for (Param p : this.params) {
                    Return2.append("<");
                    Return2.append(p.key);
                    Return2.append(">\n");
                    Return2.append(p.msg);
                }
            }
            return Return2.toString();
        }

        class Param {
            private final String key;
            private final Message msg;
            private Message hdr;
            private String uri;
            private String uriPfx;

            private Param(String n, Message m) {
                this.key = n;
                this.msg = m;
            }
        }
    }

    private class Message {
        private final String name;
        private boolean encoded;
        private final List<Type> parts = new ArrayList<Type>();

        Message(String n) {
            this.name = n;
        }

        void addPart(Type p) {
            this.parts.add(p);
        }

        public void getCode(StringBuilder code, int level, String uri, boolean output) {
            ServiceBridgeUtility.this.deferredMessageTypes = new ArrayList();
            ServiceBridgeUtility.this.varnames = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
            for (Type t : this.parts) {
                int mylevel = level;
                int newId = -1;
                if (output && this.encoded) {
                    ServiceBridgeUtility.putLevel(code, ++mylevel);
                    code.append(" identified by '");
                    code.append(t.name);
                    code.append("'");
                    code.append(".");
                    code.append(eol);
                    ServiceBridgeUtility.putLevel(code, mylevel + 1);
                    code.append(" identified by 'href' is attribute.");
                    code.append(eol);
                    ServiceBridgeUtility.putLevel(code, mylevel + 2);
                    newId = ServiceBridgeUtility.this.idProg++;
                    Type type = t;
                    type.name = type.name + "Type";
                    String idStr = Integer.toString(newId);
                    code.append(" filler pic x(");
                    code.append(idStr.length() + 3);
                    code.append(") value \"#id");
                    code.append(newId);
                    code.append("\".");
                    code.append(eol);
                    mylevel = level - 1;
                }
                t.getCode(code, null, mylevel, uri, output, null, this.encoded, null, newId);
            }
            for (DeferredTypeGetCode dtgc : ServiceBridgeUtility.this.deferredMessageTypes) {
                dtgc.getCode(code, level - 1);
            }
        }

        public String toString() {
            StringBuilder Return2 = new StringBuilder("msg:");
            Return2.append(this.name);
            for (int i = 0; i < this.parts.size(); ++i) {
                Return2.append("\n");
                Return2.append(this.parts.get(i));
            }
            return Return2.toString();
        }
    }

    private class Type {
        static final String SIMPLE = "simple";
        static final String ALL = "all";
        static final String CHOICE = "choice";
        static final String SEQUENCE = "sequence";
        static final String REFERENCE = "reference";
        static final String EXTENSION = "extension";
        static final String RESTRICTION = "restriction";
        private String name;
        private final String type;
        private FullName typeName;
        private final List<Type> components;
        private int dimensions;
        private int[] dimensionSize;
        private Type reference;
        private Type parent;
        private boolean optional;
        private Map<String, String> ns2Pref;
        private int typeIndex;
        private final boolean elemFromQual;

        Type(String n, String o, FullName refTo, boolean elemFormQual, Map<String, String> ns2Pref) {
            this(n, o, refTo, 0, null, elemFormQual, ns2Pref);
        }

        Type(String n, String o, FullName refTo, int dims, int[] dimSize, boolean elemFormQual, Map<String, String> ns2Pref) {
            this.ns2Pref = ns2Pref;
            this.elemFromQual = elemFormQual;
            this.name = n;
            this.dimensions = dims;
            this.dimensionSize = dimSize;
            if (o == ALL || o == CHOICE || o == SEQUENCE) {
                this.type = o;
                this.typeName = null;
                this.components = new ArrayList<Type>();
            } else if (o == REFERENCE) {
                this.type = o;
                this.typeName = refTo;
                this.components = null;
            } else if (o == EXTENSION) {
                this.type = o;
                this.typeName = refTo;
                this.components = new ArrayList<Type>();
            } else if (o == RESTRICTION) {
                this.type = o;
                this.typeName = refTo;
                this.components = new ArrayList<Type>();
            } else {
                this.type = null;
                this.typeName = refTo;
                this.components = null;
            }
        }

        private void setTypeIndex(int ti) {
            this.typeIndex = ti;
            if (this.components != null) {
                for (Type c : this.components) {
                    c.setTypeIndex(ti);
                }
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof Type)) {
                return false;
            }
            Type t = (Type)o;
            if (this.name.equals(t.name)) {
                if (this.typeName != null) {
                    if (t.typeName != null) {
                        return this.typeName.uri.equals(t.typeName.uri);
                    }
                    return false;
                }
                return t.typeName == null;
            }
            return false;
        }

        void add(Type t, Element elem) {
            if (t != null) {
                this.components.add(t);
                t.parent = this;
            } else {
                ServiceBridgeUtility.warning("type undefined: '" + ServiceBridgeUtility.nodeToString(elem) + "'");
            }
        }

        private String getPrefix(String uri) {
            String pfx;
            String string = pfx = this.ns2Pref != null ? this.ns2Pref.get(uri) : null;
            if (pfx == null) {
                pfx = (String)ServiceBridgeUtility.this.globNs2Pref.get(uri);
            }
            return pfx;
        }

        private String getNameCode(String uri) {
            FullName typeName = this.reference != null && this.reference.typeName != null && "http://www.w3.org/2001/XMLSchema".equals(this.reference.typeName.uri) ? this.reference.typeName : this.typeName;
            if (typeName != null && typeName.pfx != null) {
                return typeName.pfx + ":" + this.name;
            }
            if (uri != null) {
                String pfx = this.getPrefix(uri);
                if (pfx != null) {
                    return pfx + ":" + this.name;
                }
                return this.name;
            }
            return this.name;
        }

        public void getCode(StringBuilder code, Type par, int level, String uri, boolean output, String parUri, boolean encoded, String occurs, int id) {
            String typeUri;
            FullName fnTmp = null;
            String string = typeUri = this.typeName != null ? this.typeName.uri : parUri;
            if (this.type == REFERENCE) {
                if (encoded && output) {
                    String idStr;
                    if (this.dimensions == 1) {
                        boolean isSimpleType;
                        ServiceBridgeUtility.putLevel(code, ++level);
                        code.append(" identified by 'soapenc:Array'.");
                        code.append(eol);
                        if (id >= 0) {
                            ServiceBridgeUtility.putLevel(code, level + 1);
                            code.append(" identified by 'id' is attribute.");
                            code.append(eol);
                            ServiceBridgeUtility.putLevel(code, level + 2);
                            idStr = Integer.toString(id);
                            code.append(" filler pic x(");
                            code.append(idStr.length() + 2);
                            code.append(") value \"id");
                            code.append(id);
                            code.append("\".");
                            code.append(eol);
                        }
                        ServiceBridgeUtility.putLevel(code, level + 1);
                        code.append(" identified by 'soapenc:arrayType' is attribute.");
                        code.append(eol);
                        ServiceBridgeUtility.putLevel(code, level + 2);
                        String n = this.name;
                        if (n.startsWith(ServiceBridgeUtility.ARRAY_OF) && this.typeName != null) {
                            String s;
                            n = this.typeName.name;
                            if (this.dimensions == 1 && n.endsWith(s = "" + this.dimensionSize[0])) {
                                n = n.substring(0, n.length() - s.length());
                            }
                        }
                        String arrayTypeName = (isSimpleType = XMLStreamConstants.xsdSimpleTypes.containsKey(n)) ? "xsd:" + n : this.getPrefix(ServiceBridgeUtility.this.targetNamespace) + ":" + n;
                        arrayTypeName = this.dimensionSize[0] > 0 ? arrayTypeName + "[" + this.dimensionSize[0] + "]" : arrayTypeName + "[]";
                        code.append(" filler pic x(");
                        code.append(arrayTypeName.length());
                        code.append(") value \"");
                        code.append(arrayTypeName);
                        code.append("\".");
                        code.append(eol);
                        this.putOptional(++level, code);
                        ServiceBridgeUtility.putLevel(code, level);
                        code.append(" identified by '");
                        if (isSimpleType && par != null) {
                            code.append(par.name);
                        } else {
                            code.append(n);
                        }
                        code.append('\'');
                        if ("base64Binary".equals(n) || "hexBinary".equals(n)) {
                            code.append(" " + n);
                        }
                        code.append(" occurs ");
                        occurs = this.getOccurs(0, par);
                        code.append(occurs);
                        code.append(".");
                        code.append(eol);
                        this.putType(code, level, occurs, par);
                    } else {
                        this.putOptional(++level, code);
                        ServiceBridgeUtility.putLevel(code, level);
                        code.append(" identified by '");
                        code.append(this.name);
                        code.append('\'');
                        if (this.typeName != null && ("base64Binary".equals(this.typeName.name) || "hexBinary".equals(this.typeName.name))) {
                            code.append(" " + this.typeName.name);
                        }
                        code.append(".");
                        code.append(eol);
                        if (id >= 0) {
                            ServiceBridgeUtility.putLevel(code, level + 1);
                            code.append(" identified by 'id' is attribute.");
                            code.append(eol);
                            ServiceBridgeUtility.putLevel(code, level + 2);
                            idStr = Integer.toString(id);
                            code.append(" filler pic x(");
                            code.append(idStr.length() + 2);
                            code.append(") value \"id");
                            code.append(id);
                            code.append("\".");
                            code.append(eol);
                        }
                        if (this.typeName != null && !this.typeName.name.startsWith(ServiceBridgeUtility.ARRAY_OF)) {
                            this.putType(code, level, occurs, par);
                        }
                    }
                } else if (par == null || par.type != REFERENCE || this.reference == null || !this.reference.name.equals(this.name) || this.reference.type != REFERENCE) {
                    if (encoded && !output && this.reference != null && this.reference.dimensions == 1) {
                        String tmp = this.name;
                        this.name = this.reference.name;
                        this.reference.name = tmp;
                        fnTmp = this.typeName;
                        this.typeName = new FullName(null, "Array");
                        this.typeName.pfx = "soapenc";
                    }
                    occurs = this.addLevel(++level, encoded, output, par, occurs, uri, code);
                    if (fnTmp != null) {
                        this.typeName = fnTmp;
                    }
                    this.putArrayType(code, level, occurs, par);
                }
                if (this.reference != null) {
                    if (encoded && output && id < 0 && this.reference.type == REFERENCE && !XMLStreamConstants.xsdSimpleTypes.containsKey(this.reference.name) && occurs == null) {
                        ServiceBridgeUtility.putLevel(code, level + 1);
                        code.append(" identified by 'href' is attribute.");
                        code.append(eol);
                        ServiceBridgeUtility.putLevel(code, level + 2);
                        int newId = ServiceBridgeUtility.this.idProg++;
                        String idStr = Integer.toString(newId);
                        code.append(" filler pic x(");
                        code.append(idStr.length() + 3);
                        code.append(") value \"#id");
                        code.append(newId);
                        code.append("\".");
                        code.append(eol);
                        ServiceBridgeUtility.this.deferredMessageTypes.add(new DeferredTypeGetCode(this.reference, this, uri, output, typeUri, encoded, occurs, newId));
                        return;
                    }
                    if (this.reference.typeName != null && "http://www.w3.org/2001/XMLSchema".equals(this.reference.typeName.uri)) {
                        ServiceBridgeUtility.putLevel(code, ++level);
                        code.append(" ");
                        code.append(this.getVarName("a-", par));
                        code.append(" pic " + this.reference.getPicture() + ".");
                        code.append(eol);
                    } else {
                        this.reference.getCode(code, this, level, uri, output, typeUri, encoded, occurs, -1);
                    }
                } else if (this.typeName != null) {
                    ServiceBridgeUtility.putLevel(code, ++level);
                    code.append(" ");
                    code.append(this.getVarName("a-", par));
                    code.append(" pic " + this.getPicture() + ".");
                    code.append(eol);
                }
            } else {
                boolean isSimple;
                if (this.type == EXTENSION && this.reference != null) {
                    this.reference.getCode(code, par, level, typeUri, output, parUri, encoded, occurs, id);
                }
                if (isSimple = this.isSimpleType()) {
                    this.putOptional(++level, code);
                    ServiceBridgeUtility.putLevel(code, level);
                    code.append(" identified by '");
                    if (encoded) {
                        code.append(this.name);
                    } else if (this.elemFromQual || par == null) {
                        code.append(this.getNameCode(uri));
                    } else {
                        code.append(this.name);
                    }
                    code.append('\'');
                    if (this.typeName != null && ("base64Binary".equals(this.typeName.name) || "hexBinary".equals(this.typeName.name))) {
                        code.append(" " + this.typeName.name);
                    }
                    if (this.dimensions > 0) {
                        code.append(" occurs ");
                        code.append(this.getOccurs(0, par));
                    }
                    code.append(".");
                    code.append(eol);
                    if (encoded && this.typeName != null) {
                        this.putType(code, level, occurs, par);
                    }
                }
                if (this.components == null) {
                    if (this.dimensions > 0) {
                        int i = 0;
                        if (isSimple) {
                            ++i;
                        }
                        while (i < this.dimensions) {
                            ServiceBridgeUtility.putLevel(code, ++level);
                            occurs = this.getOccurs(i, par);
                            code.append(" filler occurs " + occurs + ".");
                            code.append(eol);
                            ++i;
                        }
                    }
                    if (isSimple) {
                        ServiceBridgeUtility.putLevel(code, ++level);
                        code.append(" ");
                        code.append(this.getVarName("a-", par));
                        code.append(" pic " + this.getPicture() + ".");
                        code.append(eol);
                    } else if (this.reference != null) {
                        this.reference.getCode(code, this, level, uri, output, typeUri, encoded, occurs, -1);
                    }
                } else if (!this.components.isEmpty()) {
                    for (Type t : this.components) {
                        if (t.type == SEQUENCE && this.type != EXTENSION) {
                            occurs = t.addLevel(++level, encoded, output, this, occurs, uri, code);
                        }
                        t.getCode(code, this, level, uri, output, typeUri, encoded, occurs, -1);
                    }
                } else if (this.type != EXTENSION) {
                    ServiceBridgeUtility.putLevel(code, ++level);
                    if (this.name != null) {
                        code.append(" ");
                        code.append(this.getVarName("a-", par));
                    } else {
                        code.append("filler");
                    }
                    code.append(" pic " + this.getPicture() + ".");
                    code.append(eol);
                }
            }
            if (fnTmp != null) {
                String tmp = this.name;
                this.name = this.reference.name;
                this.reference.name = tmp;
            }
        }

        private String addLevel(int level, boolean encoded, boolean output, Type par, String occurs, String uri, StringBuilder code) {
            this.putOptional(level, code);
            ServiceBridgeUtility.putLevel(code, level);
            code.append(" identified by '");
            if (encoded) {
                String s;
                if (!output && this.dimensions == 1 && this.typeName != null && XMLStreamConstants.xsdSimpleTypes.containsKey(this.typeName.name)) {
                    code.append("item");
                } else if (this.name.startsWith(ServiceBridgeUtility.ARRAY_OF) && this.reference != null && this.reference.dimensions == 1 && this.name.endsWith(s = "" + this.reference.dimensionSize[0])) {
                    code.append(this.name.substring(0, this.name.length() - s.length()));
                } else {
                    code.append(this.name);
                }
            } else if (this.elemFromQual || par == null) {
                code.append(this.getNameCode(uri));
            } else {
                code.append(this.name);
            }
            code.append('\'');
            if (this.typeName != null && ("base64Binary".equals(this.typeName.name) || "hexBinary".equals(this.typeName.name))) {
                code.append(" " + this.typeName.name);
            }
            if (this.dimensions == 1) {
                code.append(" occurs ");
                occurs = this.getOccurs(0, par);
                code.append(occurs);
            }
            code.append(".");
            code.append(eol);
            if (encoded && this.typeName != null) {
                this.putType(code, level, occurs, par);
            }
            return occurs;
        }

        private void putOptional(int level, StringBuilder code) {
            if (this.optional) {
                ServiceBridgeUtility.putSpace(code, level);
                code.append("*> optional");
                code.append(eol);
            }
        }

        private void putType(StringBuilder code, int level, String occurs, Type par) {
            ServiceBridgeUtility.putLevel(code, level + 1);
            code.append(" identified by 'xsi:type' is attribute.");
            code.append(eol);
            ServiceBridgeUtility.putLevel(code, level + 2);
            String typeStr = XMLStreamConstants.xsdSimpleTypes.containsKey(this.typeName.name) ? "xsd:" + this.typeName.name : (this.typeName.pfx != null ? this.typeName.pfx + ":" + this.typeName.name : this.typeName.name);
            boolean dyn = ServiceBridgeUtility.isOccursDynamic(occurs);
            if (dyn) {
                code.append(" " + this.getVarName("t-", par));
            } else {
                code.append(" filler");
            }
            code.append(" pic x(" + typeStr.length() + ")");
            code.append(" value '" + typeStr + "'");
            code.append(".");
            code.append(eol);
        }

        private String getVarName(String prefix, Type par) {
            String vn = this.name.startsWith(ServiceBridgeUtility.ARRAY_OF) && this.type == REFERENCE && this.dimensions == 1 && par != null ? prefix + par.name : prefix + this.name;
            String Return2 = vn;
            int i = 0;
            while (ServiceBridgeUtility.this.varnames.contains(Return2)) {
                Return2 = vn + "--" + i;
                ++i;
            }
            ServiceBridgeUtility.this.varnames.add(Return2);
            return Return2;
        }

        private void putArrayType(StringBuilder code, int level, String occurs, Type par) {
            if (!this.typeName.name.startsWith(ServiceBridgeUtility.ARRAY_OF) || this.reference == null || this.reference.dimensions != 1) {
                return;
            }
            ServiceBridgeUtility.putLevel(code, level + 1);
            code.append(" identified by 'soapenc:arrayType' is attribute.");
            code.append(eol);
            ServiceBridgeUtility.putLevel(code, level + 2);
            String type = this.typeName.name.substring(7);
            String s = "" + this.reference.dimensionSize[0];
            if (type.endsWith(s)) {
                type = type.substring(0, type.length() - s.length());
            }
            String typeStr = XMLStreamConstants.xsdSimpleTypes.containsKey(type) ? "xsd:" + type : (this.typeName.pfx != null ? this.typeName.pfx + ":" + type : type);
            typeStr = typeStr + "[]";
            boolean dyn = ServiceBridgeUtility.isOccursDynamic(occurs);
            if (dyn) {
                code.append(" " + this.getVarName("at-", par));
            } else {
                code.append(" filler");
            }
            code.append(" pic x(" + typeStr.length() + ")");
            code.append(" value '" + typeStr + "'");
            code.append(".");
            code.append(eol);
        }

        private boolean isSimpleType() {
            return this.type == null || this.type == SIMPLE || this.type == RESTRICTION;
        }

        private String getSimpleType() {
            if (this.typeName != null) {
                String n = this.typeName.name;
                while (n != null) {
                    String simpleType = XMLStreamConstants.xsdSimpleTypes.get(n);
                    if (simpleType != null) {
                        return simpleType;
                    }
                    n = (String)ServiceBridgeUtility.this.restrictions.get(n);
                }
            }
            return null;
        }

        private String getPicture() {
            String t = this.getSimpleType();
            String pic = t != null ? (t == "I8" ? "x(1)" : (t == "I16" ? "s9(5)" : (t == "I32" ? "s9(10)" : (t == "I64" ? "s9(18)" : (t == "F" ? "s9(12)v9(6)" : (t == "D" ? "s9(12)v9(6)" : "x any length")))))) : "x any length";
            return pic;
        }

        private String getOccurs(int idx, Type par) {
            if (this.dimensionSize != null && idx < this.dimensionSize.length && this.dimensionSize[idx] > 0) {
                return "" + this.dimensionSize[idx] + " times";
            }
            return "dynamic capacity " + this.getVarName("a-c-", par) + " initialized";
        }

        private String toString(String indent) {
            StringBuilder sb = new StringBuilder();
            if (this.components == null) {
                sb.append(indent);
                sb.append(this.name);
                if (this.dimensions > 0) {
                    sb.append('[');
                    sb.append(this.dimensions);
                    sb.append(']');
                }
                sb.append(':');
                if (this.type == null) {
                    sb.append(this.typeName);
                } else if (this.reference == null) {
                    sb.append("->");
                    sb.append(this.typeName);
                } else {
                    sb.append("->");
                    sb.append(this.reference.toString(indent + ' '));
                }
            } else {
                sb.append(indent + this.name);
                if (this.reference != null) {
                    sb.append(":->" + this.reference.toString(indent + ' '));
                } else {
                    sb.append(":" + this.type);
                }
                indent = indent + ' ';
                int count = this.components.size();
                for (int i = 0; i < count; ++i) {
                    sb.append("\n");
                    sb.append(this.components.get(i).toString(indent));
                }
            }
            return sb.toString();
        }

        public String toString() {
            return this.toString("");
        }

        static /* synthetic */ int[] access$3302(Type x0, int[] x1) {
            x0.dimensionSize = x1;
            return x1;
        }
    }

    private class FullName {
        final String uri;
        String name;
        String pfx;

        public FullName(String ns, String n) {
            this.uri = ns;
            this.name = n;
        }

        public boolean equals(Object o) {
            return o instanceof FullName && this.uri.equals(((FullName)o).uri) && this.name.equals(((FullName)o).name);
        }

        public String toString() {
            return "uri=" + this.uri + ", name=" + this.name;
        }
    }
}

