/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Alphabet;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SpecialNamesClass;
import com.iscobol.compiler.Switch;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import com.iscobol.interfaces.compiler.ISpecialNames;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SpecialNames
implements CobolToken,
ErrorsNumbers,
ISpecialNames {
    static final int FIRST_SWITCH = 0;
    static final int MAX_SWITCH = 26;
    static final char[] invalidCurrencyChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'G', 'N', 'P', 'R', 'S', 'U', 'V', 'X', 'Z', ' ', '*', '+', '-', ',', '.', ':', ';', '/', '\'', '(', ')', '\"', '='};
    private TokenManager tm;
    private Errors error;
    private boolean decimalPointIsComma;
    String[][] currency = new String[][]{{"$", "$"}};
    private Switch[] switches;
    private VariableDeclarationList symChars;
    private VariableName screenControl;
    private VariableName eventStatus;
    private VariableName crtStatus;
    private VariableName cursor;
    private VariableName eventObject;
    private VariableName eventSource;
    String consName = "";
    Token[] xmlSchema;
    Object[] xmlSchemaFile;
    private Vector alphabets;
    private final Pcc pcc;
    private Token firstToken;

    public SpecialNames(Pcc pc, TokenManager t, Errors err, Token programCollSeq) throws GeneralErrorException, EndOfProgramException {
        this(pc, t, err, programCollSeq, null);
    }

    public SpecialNames(Pcc pc, TokenManager t, Errors err, Token programCollSeq, Token firstToken) throws GeneralErrorException, EndOfProgramException {
        this.firstToken = firstToken;
        this.pcc = pc;
        this.error = err;
        this.tm = t;
        boolean cvFlag = pc.getOption("-cv") != null;
        boolean isInterface = pc.isInterfaceChild();
        Token tk = this.tm.getToken();
        if (tk.getToknum() != 10006) {
            this.error.print(188, 3, tk, "'.'");
            this.tm.ungetToken();
        }
        ArrayList<String[]> al = new ArrayList<String[]>();
        block75: while ((tk = this.tm.getToken()).getToknum() != 10006) {
            String wrd;
            switch (tk.getToknum()) {
                case 368: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 546) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 383) {
                        pc.consoleIsCrt = true;
                    }
                    this.consName = tk.getWord();
                    continue block75;
                }
                case 383: {
                    if (isInterface) {
                        throw new GeneralErrorException(246, 4, tk, tk.getWord(), this.error);
                    }
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 743) {
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 546) {
                            tk = this.tm.getToken();
                        }
                        if (tk.getToknum() == 10009) {
                            this.tm.ungetToken();
                            this.crtStatus = VariableName.get(this.tm, this.error);
                            continue block75;
                        }
                        new UnexpectedTokenException(tk, this.error);
                        continue block75;
                    }
                    new UnexpectedTokenException(tk, this.error);
                    continue block75;
                }
                case 386: {
                    if (isInterface) {
                        throw new GeneralErrorException(246, 4, tk, tk.getWord(), this.error);
                    }
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 546) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 10009) {
                        this.tm.ungetToken();
                        this.cursor = VariableName.get(this.tm, this.error);
                        continue block75;
                    }
                    new UnexpectedTokenException(tk, this.error);
                    continue block75;
                }
                case 706: {
                    if (isInterface) {
                        throw new GeneralErrorException(246, 4, tk, tk.getWord(), this.error);
                    }
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 373) {
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 546) {
                            tk = this.tm.getToken();
                        }
                        if (tk.getToknum() == 10009) {
                            this.tm.ungetToken();
                            this.screenControl = VariableName.get(this.tm, this.error);
                            continue block75;
                        }
                        new UnexpectedTokenException(tk, this.error);
                        continue block75;
                    }
                    new UnexpectedTokenException(tk, this.error);
                    continue block75;
                }
                case 469: {
                    if (isInterface) {
                        throw new GeneralErrorException(246, 4, tk, tk.getWord(), this.error);
                    }
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 743) {
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 546) {
                            tk = this.tm.getToken();
                        }
                        if (tk.getToknum() == 10009) {
                            this.tm.ungetToken();
                            this.eventStatus = VariableName.get(this.tm, this.error);
                            continue block75;
                        }
                        new UnexpectedTokenException(tk, this.error);
                        continue block75;
                    }
                    if (tk.getToknum() == 607) {
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 546) {
                            tk = this.tm.getToken();
                        }
                        if (tk.getToknum() == 10009) {
                            this.tm.ungetToken();
                            this.eventObject = VariableName.getObject(this.tm, this.error, null, null);
                            if (this.eventObject != null) continue block75;
                            new GeneralErrorException(75, 4, tk, tk.getWord(), this.error);
                            continue block75;
                        }
                        new UnexpectedTokenException(tk, this.error);
                        continue block75;
                    }
                    if (tk.getToknum() == 10009 && tk.getWord().equalsIgnoreCase("SOURCE")) {
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 546) {
                            tk = this.tm.getToken();
                        }
                        if (tk.getToknum() == 10009) {
                            this.tm.ungetToken();
                            this.eventSource = VariableName.getObject(this.tm, this.error, null, null);
                            if (this.eventSource != null) continue block75;
                            new GeneralErrorException(75, 4, tk, tk.getWord(), this.error);
                            continue block75;
                        }
                        new UnexpectedTokenException(tk, this.error);
                        continue block75;
                    }
                    new UnexpectedTokenException(tk, this.error);
                    continue block75;
                }
                case 394: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 546) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 339) {
                        this.decimalPointIsComma = true;
                        this.tm.setDecimalPointIsComma();
                        continue block75;
                    }
                    new UnexpectedTokenException(tk, err);
                    continue block75;
                }
                case 604: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 725) {
                        throw new ExpectedFoundException(tk, this.error, "SIGN");
                    }
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 546) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() != 777) {
                        throw new ExpectedFoundException(tk, this.error, "TRAILING");
                    }
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 716) {
                        throw new ExpectedFoundException(tk, this.error, "SEPARATE");
                    }
                    pc.setNumericSignTrailingSeparate(true);
                    continue block75;
                }
                case 385: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 725) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 546) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 10001 && tk.getWord().length() >= 3) {
                        Token tkSign = tk;
                        String sign = tk.getWord().substring(1, tk.getWord().length() - 1);
                        boolean smb = false;
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 814) {
                            tk = this.tm.getToken();
                            if (tk.getToknum() != 635) {
                                throw new ExpectedFoundException(tk, err, "PICTURE");
                            }
                            smb = true;
                        } else if (tk.getToknum() == 635) {
                            smb = true;
                        } else {
                            this.tm.ungetToken();
                        }
                        if (smb) {
                            tk = this.tm.getToken();
                            if (!"SYMBOL".equals(tk.getWord())) {
                                throw new ExpectedFoundException(tk, err, "SYMBOL");
                            }
                            tk = this.tm.getToken();
                            if (tk.getToknum() == 10001 && tk.getWord().length() == 3 && this.isValidCurrencyChar(tk.getWord().charAt(1))) {
                                al.add(new String[]{sign, tk.getWord().substring(1, 2)});
                                continue block75;
                            }
                            new GeneralErrorException(16, 4, tk, "<" + tk.getWord() + ">", err);
                            continue block75;
                        }
                        if (sign.length() == 1 && this.isValidCurrencyChar(sign.charAt(0))) {
                            al.add(new String[]{sign, sign});
                            continue block75;
                        }
                        new GeneralErrorException(16, 4, tkSign, "<" + tkSign.getWord() + ">", err);
                        continue block75;
                    }
                    new GeneralErrorException(16, 4, tk, "<" + tk.getWord() + ">", err);
                    continue block75;
                }
                case 325: {
                    while ((tk = this.tm.getToken()).getToknum() == 10009) {
                        SpecialNamesClass snc = new SpecialNamesClass(pc, t, err, tk);
                        if (pc.putSpecialNamesClass(snc)) continue;
                        new GeneralErrorException(63, 4, tk, tk.getWord(), err);
                    }
                    this.tm.ungetToken();
                    continue block75;
                }
                case 750: {
                    this.parseSwitch(tk, isInterface, -1);
                    continue block75;
                }
                case 751: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 324) {
                        tk = this.tm.getToken();
                    }
                    Vector<String> symbolicNames = new Vector<String>();
                    Vector<Token> symbolicNumbers = new Vector<Token>();
                    while (true) {
                        if (tk.getToknum() == 10009) {
                            symbolicNames.addElement(tk.getWord());
                            tk = this.tm.getToken();
                            continue;
                        }
                        if (symbolicNames.size() == 0) {
                            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
                        }
                        if (tk.getToknum() == 546 || tk.getToknum() == 277) {
                            tk = this.tm.getToken();
                        }
                        while (tk.getToknum() == 10002) {
                            symbolicNumbers.addElement(tk);
                            tk = this.tm.getToken();
                        }
                        if (symbolicNames.size() != symbolicNumbers.size()) {
                            throw new GeneralErrorException(129, 4, tk, "", this.error);
                        }
                        if (tk.getToknum() != 10009) break;
                    }
                    this.tm.ungetToken();
                    if (this.symChars == null) {
                        this.symChars = new VariableDeclarationList();
                    }
                    for (int i = symbolicNames.size() - 1; i >= 0; --i) {
                        VariableDeclaration v = VariableDeclaration.getConstant(pc, this.tm, (String)symbolicNames.elementAt(i), this.getSymChar((Token)symbolicNumbers.elementAt(i)));
                        v.getValueToken().setHexdecimal(true);
                        this.symChars.addItem(v);
                        pc.loadVariable(v);
                        this.tm.addConstVar(v);
                    }
                    continue block75;
                }
                case 265: {
                    if (isInterface) {
                        throw new GeneralErrorException(246, 4, tk, tk.getWord(), this.error);
                    }
                    if (this.alphabets == null) {
                        this.alphabets = new Vector();
                    }
                    Alphabet alph = new Alphabet(pc, this.tm, this.error);
                    this.alphabets.addElement(alph);
                    if (programCollSeq == null || !programCollSeq.getCode().equals(alph.getName().getCode())) continue block75;
                    this.tm.setLowHighValues(alph.getLowValue(), alph.getHighValue());
                    continue block75;
                }
            }
            switch (wrd = tk.getWord()) {
                case "ENVIRONMENT-VALUE": {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 546) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 10009) {
                        this.tm.setEnvValue(tk.getWord());
                        break;
                    }
                    new UnexpectedTokenException(tk, this.error);
                    break;
                }
                case "ENVIRONMENT-NAME": {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 546) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 10009) {
                        this.tm.setEnvName(tk.getWord());
                        break;
                    }
                    new UnexpectedTokenException(tk, this.error);
                    break;
                }
                case "CSP": 
                case "C01": 
                case "C02": 
                case "C03": 
                case "C04": 
                case "C05": 
                case "C06": 
                case "C07": 
                case "C08": 
                case "C09": 
                case "C10": 
                case "C11": 
                case "C12": 
                case "AFP-5A": {
                    if (cvFlag) {
                        String c = tk.getWord();
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 546) {
                            tk = this.tm.getToken();
                        }
                        if (tk.getToknum() == 10009) {
                            pc.putSNFunc(tk.getWord(), c);
                            break;
                        }
                        throw new UnexpectedTokenException(tk, err);
                    }
                    this.tm.ungetToken();
                    break block75;
                }
                case "SYSIN": 
                case "SYSOUT": 
                case "SYSERR": 
                case "SYSOUT-FLUSH": 
                case "CONSOLE": 
                case "SYSLST": 
                case "SYSLIST": {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 546) {
                        tk = this.tm.getToken();
                    }
                    pc.putMnemonicSystem(tk.getWord(), wrd);
                    break;
                }
                case "SWITCH-0": 
                case "SWITCH-1": 
                case "SWITCH-2": 
                case "SWITCH-3": 
                case "SWITCH-4": 
                case "SWITCH-5": 
                case "SWITCH-6": 
                case "SWITCH-7": 
                case "SWITCH-8": 
                case "SWITCH-9": 
                case "SWITCH-10": 
                case "SWITCH-11": 
                case "SWITCH-12": 
                case "SWITCH-13": 
                case "SWITCH-14": 
                case "SWITCH-15": 
                case "SWITCH-16": 
                case "SWITCH-17": 
                case "SWITCH-18": 
                case "SWITCH-19": 
                case "SWITCH-20": 
                case "SWITCH-21": 
                case "SWITCH-22": 
                case "SWITCH-23": 
                case "SWITCH-24": 
                case "SWITCH-25": 
                case "SWITCH-26": {
                    this.parseSwitch(tk, isInterface, Integer.parseInt(wrd.substring(wrd.indexOf(45) + 1)));
                    break;
                }
                case "XML-SCHEMA": {
                    Vector<Token> xs = new Vector<Token>();
                    Vector<CobolToken> xsf = new Vector<CobolToken>();
                    int i = 0;
                    while (true) {
                        if ((tk = this.tm.getToken()).getToknum() != 10009) {
                            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
                        }
                        xs.addElement(tk);
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 546) {
                            tk = this.tm.getToken();
                        }
                        if (tk.getToknum() == 10009) {
                            this.tm.ungetToken();
                            xsf.addElement(VariableName.get(this.tm, this.error));
                        } else if (tk.getToknum() == 10001) {
                            xsf.addElement(tk);
                        } else {
                            throw new UnexpectedTokenException(tk, this.error);
                        }
                        if (!this.tm.getToken().getWord().equals("XML-SCHEMA")) break;
                        ++i;
                    }
                    this.tm.ungetToken();
                    this.xmlSchema = new Token[xs.size()];
                    this.xmlSchemaFile = new Object[xs.size()];
                    for (i = 0; i < xs.size(); ++i) {
                        this.xmlSchema[i] = (Token)xs.elementAt(i);
                        this.xmlSchemaFile[i] = xsf.elementAt(i);
                    }
                    continue block75;
                }
                default: {
                    this.tm.ungetToken();
                    break block75;
                }
            }
        }
        if (al.size() > 0) {
            this.currency = (String[][])al.toArray((T[])new String[al.size()][]);
            this.pcc.setSdcsIgnored();
        }
        if (this.hasSwitches()) {
            for (int i = 0; i <= 26; ++i) {
                Switch sw = this.switches[i];
                if (sw == null) continue;
                sw.var = VariableDeclaration.getSwitchVar(pc, sw.mnemonic, sw.condNameOn, sw.condNameOff, false, this.tm, this.error);
                pc.loadVariable(sw.var);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseSwitch(Token tk, boolean isInterface, int switchNum) throws GeneralErrorException, EndOfProgramException {
        Switch sw;
        if (isInterface) {
            throw new GeneralErrorException(246, 4, tk, tk.getWord(), this.error);
        }
        if (this.pcc.getRoot().getIdentificationDivision().getClassId() != null) {
            throw new GeneralErrorException(19, 4, tk, ": switch in cobol class", this.error);
        }
        if (switchNum < 0) {
            String plain;
            tk = this.tm.getToken();
            if (tk.getToknum() == 10001 && (plain = tk.getPlain()).length() == 1) {
                char c = plain.charAt(0);
                if (c < 'A' || c > 'Z') throw new UnexpectedTokenException(tk, this.error);
                switchNum = '\u0001' + c - 65;
            } else {
                if (tk.getToknum() != 10002) throw new UnexpectedTokenException(tk, this.error);
                switchNum = Integer.parseInt(tk.getWord());
                if (switchNum < 0 || switchNum > 26) {
                    throw new GeneralErrorException(30, 4, tk, "" + switchNum, this.error);
                }
            }
        }
        if (this.switches == null) {
            this.switches = new Switch[27];
        }
        if ((sw = this.switches[switchNum]) == null) {
            sw = this.switches[switchNum] = new Switch(switchNum);
        }
        if ((tk = this.tm.getToken()).getToknum() == 546) {
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 10009) {
            sw.mnemonic = tk.getWord();
            tk = this.tm.getToken();
        }
        while (tk.getToknum() == 614 || tk.getToknum() == 611) {
            Token onOff = tk;
            tk = this.tm.getToken();
            if (tk.getToknum() == 743) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 546) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() != 10009) throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
            if (onOff.getToknum() == 614) {
                sw.condNameOn = tk.getWord();
            } else {
                sw.condNameOff = tk.getWord();
            }
            tk = this.tm.getToken();
        }
        this.tm.ungetToken();
    }

    private String getSymChar(Token tk) throws GeneralErrorException {
        String Return2 = "";
        try {
            int i = Integer.parseInt(tk.getCode());
            if (i < 1 || i > 256) {
                throw new GeneralErrorException(235, 4, tk, "", this.error);
            }
            Return2 = "" + (char)(i - 1);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Return2;
    }

    public void check(Pcc pc) throws GeneralErrorException {
        VariableDeclaration vd = null;
        if (this.screenControl != null) {
            this.screenControl.check(pc);
            vd = this.screenControl.getVarDecl();
            vd.setUsed();
            pc.setSNScreenControl(vd);
        }
        if (this.crtStatus != null) {
            this.crtStatus.check(pc);
            vd = this.crtStatus.getVarDecl();
            vd.setUsed();
            pc.setSNCrtStatus(vd);
        }
        if (this.cursor != null) {
            this.cursor.check(pc);
            vd = this.cursor.getVarDecl();
            vd.setUsed();
            pc.setSNCursor(vd);
        }
        if (this.eventStatus != null) {
            this.eventStatus.check(pc);
            vd = this.eventStatus.getVarDecl();
            vd.setUsed();
            pc.setSNEventStatus(vd);
        }
        if (this.eventObject != null) {
            this.eventObject.checkObject(pc);
            if (!this.eventObject.getType().getName().equals("java.util.EventObject")) {
                new GeneralErrorException(75, 4, this.eventObject.getNameToken(), this.eventObject.getName(), this.error);
            }
            vd = this.eventObject.getVarDecl();
            vd.setUsed();
            pc.setSNEventObject(vd);
        }
        if (this.eventSource != null) {
            this.eventSource.checkObject(pc);
            if (!this.eventSource.getType().getName().equals("com.iscobol.gui.server.CobolGUIJavaBean")) {
                new GeneralErrorException(75, 4, this.eventSource.getNameToken(), this.eventSource.getName(), this.error);
            }
            vd = this.eventSource.getVarDecl();
            vd.setUsed();
            pc.setSNEventSource(vd);
        }
        if (this.xmlSchemaFile != null) {
            for (Object o : this.xmlSchemaFile) {
                if (!(o instanceof VariableName)) continue;
                VariableName xs = (VariableName)o;
                xs.check(pc);
                if (xs.isNumeric() || xs.getVarDecl().isPic1()) {
                    new GeneralErrorException(316, 4, xs.getNameToken(), xs.getName(), this.error);
                }
                xs.getVarDecl().setUsed();
            }
        }
    }

    private boolean isValidCurrencyChar(char c) {
        c = Character.toUpperCase(c);
        for (int i = 0; i < invalidCurrencyChars.length; ++i) {
            if (c != invalidCurrencyChars[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasSwitches() {
        return this.switches != null;
    }

    public String getCode(StringBuffer dynPart) {
        Hashtable sncHt;
        StringBuffer Return2 = new StringBuffer();
        Return2.append("/* currency = [" + this.currency + "] */" + eol);
        Return2.append("/* decimalPointIsComma = [" + this.decimalPointIsComma + "] */" + eol);
        if (!this.pcc.optionMS && this.hasSwitches()) {
            for (int i = 0; i <= 26; ++i) {
                if (this.switches[i] == null) continue;
                Return2.append(this.switches[i].var.getCode(dynPart));
            }
        }
        if (this.symChars != null) {
            VariableDeclaration v = this.symChars.getFirst();
            while (v != null) {
                Return2.append(v.getCode(dynPart));
                v = this.symChars.getNext();
            }
        }
        if ((sncHt = this.pcc.getSpecialNamesClasses()) != null && sncHt.size() > 0) {
            Enumeration e = sncHt.elements();
            while (e.hasMoreElements()) {
                SpecialNamesClass.Values val;
                int i;
                SpecialNamesClass snc = (SpecialNamesClass)e.nextElement();
                Vector values = snc.getValues();
                int classSize = 0;
                for (i = values.size() - 1; i >= 0; --i) {
                    val = (SpecialNamesClass.Values)values.elementAt(i);
                    if (val.thruValue == null) {
                        classSize += val.fromValue.getWord().length() - 2;
                        continue;
                    }
                    ++classSize;
                }
                Return2.append("SNClass " + snc.uniqueName + "= new SNClass (" + classSize + ")");
                for (i = values.size() - 1; i >= 0; --i) {
                    val = (SpecialNamesClass.Values)values.elementAt(i);
                    if (snc.isNational()) {
                        Return2.append(".add ( ");
                    } else {
                        Return2.append(".addB ( ");
                    }
                    Return2.append(this.tm.getCodeLiteral(val.fromValue));
                    if (val.thruValue != null) {
                        Return2.append(",");
                        Return2.append(this.tm.getCodeLiteral(val.thruValue));
                    }
                    Return2.append(")");
                    Return2.append(eol);
                }
                Return2.append(";");
                Return2.append(eol);
            }
        }
        return Return2.toString();
    }

    public String getSwitchesCode(StringBuffer dynPart) {
        if (this.hasSwitches()) {
            StringBuffer swArray = new StringBuffer();
            swArray.append("Factory.setSwitches (new NumericVar[] {");
            swArray.append(eol);
            int i = 0;
            while (true) {
                swArray.append("            ");
                if (this.switches[i] != null) {
                    swArray.append(this.switches[i].var.getUnivoqueName());
                } else {
                    swArray.append("null");
                }
                if (i == 26) break;
                swArray.append(",");
                swArray.append(eol);
                ++i;
            }
            swArray.append("});");
            swArray.append(eol);
            return swArray.toString();
        }
        return "";
    }

    public Alphabet[] getAlphabets() {
        if (this.alphabets != null && this.alphabets.size() > 0) {
            Alphabet[] afs = new Alphabet[this.alphabets.size()];
            this.alphabets.toArray(afs);
            return afs;
        }
        return null;
    }

    public Alphabet getAlphabet(Token name) {
        String s = name.getCode();
        if (this.alphabets != null) {
            for (int i = this.alphabets.size() - 1; i >= 0; --i) {
                Alphabet Return2 = (Alphabet)this.alphabets.elementAt(i);
                if (!Return2.getName().getCode().equals(s)) continue;
                return Return2;
            }
        }
        return null;
    }

    public Switch[] getSwitches() {
        return this.switches;
    }

    @Override
    public char getCurrency() {
        return this.currency[0][1].charAt(0);
    }

    @Override
    public boolean isDecimalPointIsComma() {
        return this.decimalPointIsComma;
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }
}

