/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.bincode;

import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.bincode.AbstractJavaCompiler;
import com.iscobol.compiler.bincode.Callable;
import com.iscobol.compiler.bincode.NoJavaCompilerException;
import com.iscobol.compiler.remote.server.RemoteCompilerClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class InProcessJavaCompiler
extends AbstractJavaCompiler {
    private final List<String> options;

    public InProcessJavaCompiler(OptionList ol) {
        super(ol);
        ArrayList<String> cmdLine = new ArrayList<String>();
        this.addCompilerOptions(cmdLine);
        this.options = Collections.unmodifiableList(cmdLine);
    }

    @Override
    protected Callable getCompilationTaskImpl(String[] sourceUnits) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            return () -> {
                throw new NoJavaCompilerException();
            };
        }
        StandardJavaFileManager manager = compiler.getStandardFileManager(null, null, null);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl instanceof RemoteCompilerClassLoader) {
            ArrayList<File> classPath = new ArrayList<File>();
            Iterable<? extends File> it = manager.getLocation(StandardLocation.CLASS_PATH);
            if (it != null) {
                for (File file : it) {
                    classPath.add(file);
                }
            }
            classPath.addAll(((RemoteCompilerClassLoader)cl).getPaths());
            try {
                manager.setLocation(StandardLocation.CLASS_PATH, classPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ArrayList<String> myOptions = new ArrayList<String>();
        myOptions.addAll(this.options);
        this.addSourcePathOption(myOptions, sourceUnits);
        ArrayList<JavaFileObject> compilationUnits = new ArrayList<JavaFileObject>();
        PrintWriter pw = new PrintWriter(System.err);
        for (JavaFileObject javaFileObject : manager.getJavaFileObjects(sourceUnits)) {
            compilationUnits.add(javaFileObject);
        }
        JavaCompiler.CompilationTask compilationTask = compiler.getTask(pw, manager, diagnostic -> {
            if (diagnostic.getKind() != Diagnostic.Kind.NOTE) {
                System.err.println(diagnostic);
            }
        }, myOptions, null, compilationUnits);
        return () -> task.call() != false ? 0 : 1;
    }
}

