/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.IscobolDebugger;
import com.iscobol.debugger.commands.AutoOffCommand;
import com.iscobol.debugger.commands.AutoOnCommand;
import com.iscobol.debugger.commands.ClearBreakpointCommand;
import com.iscobol.debugger.commands.ClearMonitorCommand;
import com.iscobol.debugger.commands.CompositeCommand;
import com.iscobol.debugger.commands.ContinueCommand;
import com.iscobol.debugger.commands.CurrentLineCommand;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.debugger.commands.DirectoryCommand;
import com.iscobol.debugger.commands.DisplayCommand;
import com.iscobol.debugger.commands.DownCommand;
import com.iscobol.debugger.commands.EnvCommand;
import com.iscobol.debugger.commands.ExitCommand;
import com.iscobol.debugger.commands.FindBackwardsCommand;
import com.iscobol.debugger.commands.FindForwardsCommand;
import com.iscobol.debugger.commands.FindFromTopCommand;
import com.iscobol.debugger.commands.FirstExLineCommand;
import com.iscobol.debugger.commands.GCCommand;
import com.iscobol.debugger.commands.GetFileCommand;
import com.iscobol.debugger.commands.GetInfoCommand;
import com.iscobol.debugger.commands.GetVariablesCommand;
import com.iscobol.debugger.commands.HelpCommand;
import com.iscobol.debugger.commands.JumpCommand;
import com.iscobol.debugger.commands.LastLineCommand;
import com.iscobol.debugger.commands.LengthCommand;
import com.iscobol.debugger.commands.LetCommand;
import com.iscobol.debugger.commands.ListCommand;
import com.iscobol.debugger.commands.LoadCommand;
import com.iscobol.debugger.commands.MemoryCommand;
import com.iscobol.debugger.commands.MethodBreakpointCommand;
import com.iscobol.debugger.commands.OffsetCommand;
import com.iscobol.debugger.commands.ProgramBreakpointCommand;
import com.iscobol.debugger.commands.QuitCommand;
import com.iscobol.debugger.commands.RawTextCommand;
import com.iscobol.debugger.commands.RepeatFindCommand;
import com.iscobol.debugger.commands.RunCommand;
import com.iscobol.debugger.commands.SaveCommand;
import com.iscobol.debugger.commands.SetBreakpointCommand;
import com.iscobol.debugger.commands.SetMonitorCommand;
import com.iscobol.debugger.commands.SetRedirectStreamsCommand;
import com.iscobol.debugger.commands.ShowLineCommand;
import com.iscobol.debugger.commands.StackInfoCommand;
import com.iscobol.debugger.commands.StepIntoCommand;
import com.iscobol.debugger.commands.StepOutParagraphCommand;
import com.iscobol.debugger.commands.StepOutProgramCommand;
import com.iscobol.debugger.commands.StepOverCommand;
import com.iscobol.debugger.commands.StepToCommand;
import com.iscobol.debugger.commands.StepToNextProgramCommand;
import com.iscobol.debugger.commands.SuspendCommand;
import com.iscobol.debugger.commands.ThreadCommand;
import com.iscobol.debugger.commands.TraceOffCommand;
import com.iscobol.debugger.commands.TraceOnCommand;
import com.iscobol.debugger.commands.UpCommand;
import com.iscobol.rts.IscobolCall;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class DebuggerConstants {
    public static final int GLOBAL_STATUS_NOT_DEBUG = 0;
    public static final int GLOBAL_STATUS_SUSPENDED = 1;
    public static final int GLOBAL_STATUS_RUNNING = 2;
    public static final int GLOBAL_STATUS_DISCONNECTED = 3;
    public static final int GLOBAL_STATUS_CONNECTED = 4;
    public static final int GLOBAL_STATUS_SUSPENDING = 5;
    public static final int STATUS_NOT_DEBUG = 0;
    public static final int STATUS_STEP_INTO = 1;
    public static final int STATUS_STEP_OVER = 2;
    public static final int STATUS_NOT_RUNNING = 3;
    public static final int STATUS_GO = 4;
    public static final int STATUS_STEP_OUT_PAR = 5;
    public static final int STATUS_STEP_OUT_PROG = 6;
    public static final int STATUS_STEP_TO = 7;
    public static final int STATUS_JUMP_TO = 8;
    public static final int STATUS_JUMP_OUT_PAR = 9;
    public static final int STATUS_JUMP_OUT_PROG = 10;
    public static final int STATUS_STEP_TO_PROG = 11;
    public static final int STATUS_JUMP_OVER = 12;
    public static final String OK = "+";
    public static final String KO = "-";
    public static final int CMD_ERROR = -2;
    public static final int CMD_NULL = -1;
    public static final int SET_BREAKPOINT_COMMAND = 0;
    public static final int CONTINUE_COMMAND = 1;
    public static final int RUN_COMMAND = 2;
    public static final int STEP_INTO_COMMAND = 3;
    public static final int STEP_OVER_COMMAND = 4;
    public static final int DISPLAY_COMMAND = 5;
    public static final int LET_COMMAND = 6;
    public static final int SHOW_LINE_COMMAND = 7;
    public static final int LIST_COMMAND = 8;
    public static final int CLEAR_BREAKPOINT_COMMAND = 9;
    public static final int STEP_OUT_PARAGRAPH_COMMAND = 10;
    public static final int STEP_OUT_PROGRAM_COMMAND = 11;
    public static final int STEP_TO_COMMAND = 12;
    public static final int SET_MONITOR_COMMAND = 13;
    public static final int CLEAR_MONITOR_COMMAND = 14;
    public static final int STACK_INFO_COMMAND = 15;
    public static final int THREAD_COMMAND = 16;
    public static final int TRACE_ON_COMMAND = 17;
    public static final int TRACE_OFF_COMMAND = 18;
    public static final int SET_PROGRAM_BREAKPOINT_COMMAND = 19;
    public static final int HELP_COMMAND = 20;
    public static final int QUIT_COMMAND = 21;
    public static final int LOAD_COMMAND = 22;
    public static final int SAVE_COMMAND = 23;
    public static final int GC_COMMAND = 24;
    public static final int MEMORY_COMMAND = 25;
    public static final int ENV_COMMAND = 26;
    public static final int EXIT_COMMAND = 27;
    public static final int SUSPEND_COMMAND = 28;
    public static final int JUMP_COMMAND = 29;
    public static final int GET_INFO_COMMAND = 30;
    public static final int FIND_FORWARDS_COMMAND = 31;
    public static final int FIND_BACKWARDS_COMMAND = 32;
    public static final int FIND_FROM_TOP_COMMAND = 33;
    public static final int REPEAT_FIND_COMMAND = 34;
    public static final int FIRST_LINE_COMMAND = 35;
    public static final int LAST_LINE_COMMAND = 36;
    public static final int CURRENT_LINE_COMMAND = 37;
    public static final int FIRST_EXECUTABLE_LINE_COMMAND = 38;
    public static final int START_AUTOSTEP_COMMAND = 39;
    public static final int STOP_AUTOSTEP_COMMAND = 40;
    public static final int CONNECT_COMMAND = 41;
    public static final int GET_THREADS_COMMAND = 42;
    public static final int GET_VARIABLES_COMMAND = 43;
    public static final int UP_COMMAND = 44;
    public static final int DOWN_COMMAND = 45;
    public static final int DIRECTORY_COMMAND = 46;
    public static final int PUSH_COMMAND = 47;
    public static final int ENABLE_ALL_BREAKPOINTS_COMMAND = 48;
    public static final int DISABLE_ALL_BREAKPOINTS_COMMAND = 49;
    public static final int ENABLE_ALL_MONITORS_COMMAND = 50;
    public static final int DISABLE_ALL_MONITORS_COMMAND = 51;
    public static final int SET_METHOD_BREAKPOINT_COMMAND = 52;
    public static final int GET_FILE_COMMAND = 53;
    public static final int LENGTH_COMMAND = 54;
    public static final int OFFSET_COMMAND = 55;
    public static final int STEP_TO_NEXT_PROGRAM_COMMAND = 56;
    public static final int SET_REDIRECT_STREAMS_COMMAND = 57;
    public static final int RESTART_COMMAND = 58;
    public static final int COMPOSITE_COMMAND = 1000;
    public static final int RAW_TEXT_COMMAND = 1001;
    public static final int NORMAL_RESPONSE = 1;
    public static final int ERROR_RESPONSE = 2;
    public static final int RAW_TEXT_RESPONSE = 3;
    public static final Class DEBUGGER_CLASS = IscobolDebugger.class;
    public static final Class CALL_CLASS = IscobolCall.class;
    public static final String COMMAND_DELIMITERS = " ,;(:=)+*\"<>";
    public static final int SUCCESS = 0;
    public static final int FAIL = 1;
    public static final int NO_VERB_ON_LINE = 2;
    public static final int NO_SUCH_PARAGRAPH = 3;
    public static final int NO_SUCH_FILE = 4;
    public static final int SYNTAX_ERROR = 5;
    public static final int SUBSCRIPT_EXPECTED = 6;
    public static final int UNKNOWN_VARIABLE = 7;
    public static final int AMBIGUOUS_IDENTIFIER = 8;
    public static final int NOT_STARTED = 9;
    public static final int ALREADY_STARTED = 10;
    public static final int MONITOR_NOT_FOUND = 11;
    public static final int BREAKPOINT_NOT_FOUND = 12;
    public static final int VARIABLE_IS_LEVEL78 = 13;
    public static final int INVALID_HANDLE = 14;
    public static final int NOT_COBOL_VAR = 15;
    public static final int TRACING_ALREADY_STARTED = 16;
    public static final int TRACING_NOT_STARTED = 17;
    public static final int FILE_NOT_FOUND = 18;
    public static final int THREAD_NOT_FOUND = 19;
    public static final int COBOL_VAR_REQUIRED = 20;
    public static final int NUMERIC_VAR_REQUIRED = 21;
    public static final int PROPERTY_REQUIRED = 22;
    public static final int NO_SUCH_PROGRAM = 23;
    public static final int BOOLEAN_VALUE_REQUIRED = 24;
    public static final int INDEX_OUT_OF_BOUNDS = 25;
    public static final int INTERNAL_ERROR = 26;
    public static final int UNKNOWN_ENV_VARIABLE = 27;
    public static final int PARAGRAPH_BREAKPOINT_NOT_FOUND = 28;
    public static final int LINE_BREAKPOINT_NOT_FOUND = 29;
    public static final int ENV_MONITOR_NOT_FOUND = 30;
    public static final int VARIABLE_NOT_LINKED = 31;
    public static final int HEX_VALUE_REQUIRED = 32;
    public static final int UNKNOWN_COMMAND = 33;
    public static final int AMBIGUOUS_COMMAND = 34;
    public static final int EVALUATION_ERROR = 35;
    public static final int JUMP_UNSUPPORTED = 36;
    public static final int JUMP_TO_DECL = 37;
    public static final int JUMP_TO_NOT_DECL = 38;
    public static final int UNSUPPORTED_FEATURE = 39;
    public static final int NO_SUCH_METHOD = 40;
    public static final int DYNAMIC_ITEM_NOT_ALLOCATED = 41;
    public static final int AMBIGUOUS_PAR_NAME = 42;
    public static final int BREAKPOINT_HIT = 101;
    public static final int MONITOR_CHANGE = 102;
    public static final int PROGRAM_FINISHED = 103;
    public static final int JAVA_EXCEPTION_CAUGHT = 104;
    public static final int CONNECTION_CLOSED = 105;
    public static final int CONNECTION_REFUSED = 106;
    public static final int CANNOT_LOAD_PROGRAM = 201;
    public static final int NOT_ISCOBOL_PROGRAM = 202;
    public static final int DEBUGGING_INFORMATION_NOT_FOUND = 203;
    public static final int I_MON_CHANGE = 1;
    public static final int I_HIT_PAR_BP = 2;
    public static final int I_HIT_LINE_BP = 3;
    public static final int I_GC_DONE = 4;
    public static final int W_DBG_INFO_NOT_FOUND = 5;
    public static final int I_B0_SET = 6;
    public static final int I_LINE_BP_SET = 7;
    public static final int I_PAR_BP_SET = 8;
    public static final int I_PAR_BP_CLEAR = 9;
    public static final int I_ALL_BP_CLEAR = 10;
    public static final int I_ENV_MON_CLEAR = 11;
    public static final int I_MON_ADD = 12;
    public static final int I_MON_CLEAR = 13;
    public static final int I_ALL_MON_CLEAR = 14;
    public static final int I_TREE_BUILT = 15;
    public static final int I_START_TRACING = 16;
    public static final int I_STOP_TRACING = 17;
    public static final int I_LINE_BP_CLEAR = 18;
    public static final int I_ENV_MON_ADD = 19;
    public static final int I_JUMP_INSIDE_BLOCK = 20;
    public static final int I_M0_SET = 21;
    public static final int W_UNABLE_TO_CHECK_LINE = 1;
    public static final int W_UNABLE_TO_CHECK_PARAGRAPH = 2;
    public static final long DEBUGGER_SERIAL_VERSION_UID = 1000007L;
    public static final String NULL_VALUE = new String("<null>");
    public static final String EMPTY_VALUE = new String("<empty>");
    public static final String NON_NUMERIC_VALUE = new String("<non-numeric>");
    public static final String ERROR_VALUE = new String("<error>");
    public static final String DYNDATA_VALUE = new String("<dyndata>");
    public static final Map<Integer, Class<? extends DebugCommand>> commandClasses;

    private DebuggerConstants() {
    }

    static {
        HashMap<Integer, Class> map = new HashMap<Integer, Class>();
        map.put(40, AutoOffCommand.class);
        map.put(39, AutoOnCommand.class);
        map.put(9, ClearBreakpointCommand.class);
        map.put(14, ClearMonitorCommand.class);
        map.put(1, ContinueCommand.class);
        map.put(37, CurrentLineCommand.class);
        map.put(46, DirectoryCommand.class);
        map.put(5, DisplayCommand.class);
        map.put(45, DownCommand.class);
        map.put(26, EnvCommand.class);
        map.put(27, ExitCommand.class);
        map.put(32, FindBackwardsCommand.class);
        map.put(31, FindForwardsCommand.class);
        map.put(33, FindFromTopCommand.class);
        map.put(38, FirstExLineCommand.class);
        map.put(24, GCCommand.class);
        map.put(53, GetFileCommand.class);
        map.put(30, GetInfoCommand.class);
        map.put(43, GetVariablesCommand.class);
        map.put(20, HelpCommand.class);
        map.put(29, JumpCommand.class);
        map.put(36, LastLineCommand.class);
        map.put(54, LengthCommand.class);
        map.put(6, LetCommand.class);
        map.put(8, ListCommand.class);
        map.put(22, LoadCommand.class);
        map.put(25, MemoryCommand.class);
        map.put(52, MethodBreakpointCommand.class);
        map.put(55, OffsetCommand.class);
        map.put(19, ProgramBreakpointCommand.class);
        map.put(21, QuitCommand.class);
        map.put(34, RepeatFindCommand.class);
        map.put(2, RunCommand.class);
        map.put(23, SaveCommand.class);
        map.put(0, SetBreakpointCommand.class);
        map.put(13, SetMonitorCommand.class);
        map.put(57, SetRedirectStreamsCommand.class);
        map.put(7, ShowLineCommand.class);
        map.put(15, StackInfoCommand.class);
        map.put(3, StepIntoCommand.class);
        map.put(10, StepOutParagraphCommand.class);
        map.put(11, StepOutProgramCommand.class);
        map.put(4, StepOverCommand.class);
        map.put(12, StepToCommand.class);
        map.put(56, StepToNextProgramCommand.class);
        map.put(28, SuspendCommand.class);
        map.put(16, ThreadCommand.class);
        map.put(18, TraceOffCommand.class);
        map.put(17, TraceOnCommand.class);
        map.put(44, UpCommand.class);
        map.put(1000, CompositeCommand.class);
        map.put(1001, RawTextCommand.class);
        commandClasses = Collections.unmodifiableMap(map);
    }
}

