/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.dialogs.treetable.model.VariableNode;
import com.iscobol.debugger.tree.Tree;
import com.iscobol.debugger.tree.TreeNode;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;

public class GraphUtilities {
    public static final String CONNECT_IMAGE = "connect.gif";
    public static final String RUN_IMAGE = "rundebug.gif";
    public static final String RESTART_IMAGE = "restart.png";
    public static final String CONTINUE_IMAGE = "continue.gif";
    public static final String SUSPEND_IMAGE = "suspend.gif";
    public static final String STEP_OVER_IMAGE = "stepover.gif";
    public static final String STEP_INTO_IMAGE = "stepinto.gif";
    public static final String STEP_OUT_IMAGE = "stepout.gif";
    public static final String STEP_OUT_PROG_IMAGE = "stepoutprog.gif";
    public static final String STEP_TO_IMAGE = "runtilcurs.gif";
    public static final String STEP_TO_PROGRAM_IMAGE = "runtilpgm.gif";
    public static final String JUMP_IMAGE = "jump.gif";
    public static final String JUMP_OUT_IMAGE = "jumpout.gif";
    public static final String JUMP_OUT_PROG_IMAGE = "jumpoutprog.gif";
    public static final String JUMP_OVER_IMAGE = "jumpover.gif";
    public static final String DISCONNECT_IMAGE = "disconnect.gif";
    public static final String QUIT_IMAGE = "stop.gif";
    public static final String FIND_IMAGE = "find.gif";
    public static final String REPEAT_FIND_IMAGE = "find_repeat.gif";
    public static final String AUTOSTEP_IMAGE = "autostep.gif";
    public static final String BREAKPOINT_IMAGE = "breakpoint.gif";
    public static final String CURR_LINE_IMAGE = "currline.gif";
    public static final String GO_TO_CURR_LINE_IMAGE = "gotocurrline.gif";
    public static final String CHANGE_VALUE_IMAGE = "changevalue.gif";
    public static final String EXPAND_ALL_IMAGE = "expandall.gif";
    public static final String COLLAPSE_ALL_IMAGE = "collapseall.gif";
    public static final String EXPAND_IMAGE = "expand.gif";
    public static final String COLLAPSE_IMAGE = "collapse.gif";
    public static final String CHECKALL_IMAGE = "checkall.gif";
    public static final String UNCHECKALL_IMAGE = "uncheckall.gif";
    public static final String REFRESH_IMAGE = "refresh.gif";
    public static final String HEX_IMAGE = "hex.gif";
    public static final String NEWMONITOR_IMAGE = "newmonitor.gif";
    public static final String EDIT_IMAGE = "edit.gif";
    public static final String REMOVE_IMAGE = "remove.gif";
    public static final String REMOVE_ALL_IMAGE = "removeall.gif";
    public static final String BACK_IMAGE = "backward.png";
    public static final String FORWARD_IMAGE = "forward.png";
    public static final String EXECUTE_IMAGE = "execute.gif";
    public static final String ADD_ITEM_IMAGE = "add_item.gif";
    public static final String ATTACHED_IMAGE = "attached.gif";
    public static final String CLEAR_CONSOLE_IMAGE = "clearconsole.png";
    public static final String SHOW_CONSOLE_IMAGE = "showconsole.png";
    private static final Map IMAGES = new HashMap();
    public static final PrintStream systemOut = System.out;
    public static final PrintStream systemErr = System.err;
    private static final OutputStreamManager osm = new OutputStreamManager();

    public static void setOut(PrintStream out) {
        osm.setOut(out);
    }

    public static void setErr(PrintStream err) {
        osm.setErr(err);
    }

    public static void enableOutputStream() {
        osm.enableOutputStream();
    }

    public static void disableOutputStream() {
        osm.disableOutputStream();
    }

    public static void enableErrorStream() {
        osm.enableErrorStream();
    }

    public static void disableErrorStream() {
        osm.disableErrorStream();
    }

    public static Image getImage(String name) {
        Image Return2 = (Image)IMAGES.get(name);
        if (Return2 == null) {
            Return2 = Toolkit.getDefaultToolkit().getImage(GraphUtilities.class.getResource(name));
            IMAGES.put(name, Return2);
        }
        return Return2;
    }

    public static Font createFont(String family, int style, float size) {
        HashMap<TextAttribute, Object> attrs = new HashMap<TextAttribute, Object>();
        attrs.put(TextAttribute.SIZE, new Float((double)(size * (float)Toolkit.getDefaultToolkit().getScreenResolution()) / 72.0));
        attrs.put(TextAttribute.FAMILY, family);
        if ((style & 1) != 0) {
            attrs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if ((style & 2) != 0) {
            attrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        return new Font(attrs);
    }

    public static int pixelsToOffset(FontMetrics fm, String text, int x) {
        int i;
        int len = text.length();
        for (i = 0; i < len && (x < fm.stringWidth(text.substring(0, i)) || x > fm.stringWidth(text.substring(0, i + 1))); ++i) {
        }
        return i;
    }

    public static VariableNode buildVariableNode(Tree tree) {
        VariableNode rootNode = new VariableNode(tree.getRoot().getVarName(), tree.getClassName(), "", null);
        TreeNode[] children = tree.getRoot().getChildren();
        if (children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                GraphUtilities.buildVariableNode(children[i], children[i].getVarName(), tree.getClassName(), rootNode, tree.isHex());
            }
        } else {
            GraphUtilities.buildVariableNode(tree.getRoot(), tree.getRoot().getVarName(), tree.getClassName(), rootNode, tree.isHex());
        }
        rootNode.setHasChildren(tree.getRoot().hasChildren());
        return rootNode;
    }

    public static VariableNode buildVariableNode(TreeNode node, String className, VariableNode parent, boolean hex) {
        return GraphUtilities.buildVariableNode(node, node.getVarName(), className, parent, hex);
    }

    public static VariableNode buildVariableNode(TreeNode node, String nodeName, String className, VariableNode parent, boolean hex) {
        VariableNode varNode;
        if (hex) {
            varNode = new VariableNode(nodeName, className, node.getVarValue(), node.getVarOffset(), node.getVarLength(), parent);
        } else {
            varNode = new VariableNode(nodeName, className, "", node.getVarOffset(), node.getVarLength(), parent);
            varNode.setTextValue(node.getVarValue());
        }
        varNode.setHasChildren(node.hasChildren());
        TreeNode[] children = node.getChildren();
        for (int i = 0; i < children.length; ++i) {
            GraphUtilities.buildVariableNode(children[i], className, varNode, hex);
        }
        return varNode;
    }

    public static void expandNode(JTree tree, VariableNode node) {
        tree.expandPath(new TreePath(node.getPath()));
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            GraphUtilities.expandNode(tree, (VariableNode)node.getChildAt(i));
        }
    }

    public static void collapseNode(JTree tree, VariableNode node) {
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            GraphUtilities.collapseNode(tree, (VariableNode)node.getChildAt(i));
        }
        if (node.getParent() != null) {
            tree.collapsePath(new TreePath(node.getPath()));
        }
    }

    public static ValueEditor getValueEditor(JComponent parent) {
        return new ValueEditor(parent);
    }

    public static void setFirstFocusedComponent(final JComponent component) {
        component.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent e) {
                component.requestFocusInWindow();
                component.removeAncestorListener(this);
            }

            @Override
            public void ancestorMoved(AncestorEvent e) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent e) {
            }
        });
    }

    private static class OutputStreamManager {
        final PrintStream dummyOutputStream = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        });
        PrintStream out = System.out;
        PrintStream err = System.err;
        int outputStreamDisableCount;
        int errorStreamDisableCount;

        private OutputStreamManager() {
        }

        synchronized void enableOutputStream() {
            if (this.outputStreamDisableCount > 0) {
                --this.outputStreamDisableCount;
                if (this.outputStreamDisableCount == 0) {
                    System.setOut(this.out);
                }
            }
        }

        synchronized void enableErrorStream() {
            if (this.errorStreamDisableCount > 0) {
                --this.errorStreamDisableCount;
                if (this.errorStreamDisableCount == 0) {
                    System.setErr(this.err);
                }
            }
        }

        synchronized void disableOutputStream() {
            if (this.outputStreamDisableCount == 0) {
                System.setOut(this.dummyOutputStream);
            }
            ++this.outputStreamDisableCount;
        }

        synchronized void disableErrorStream() {
            if (this.errorStreamDisableCount == 0) {
                System.setErr(this.dummyOutputStream);
            }
            ++this.errorStreamDisableCount;
        }

        synchronized void setOut(PrintStream out) {
            this.out = out;
            if (this.outputStreamDisableCount == 0) {
                System.setOut(this.out);
            }
        }

        synchronized void setErr(PrintStream err) {
            this.err = err;
            if (this.errorStreamDisableCount == 0) {
                System.setErr(this.err);
            }
        }
    }

    public static class TextFieldDefaultPopup
    extends PopupMouseListener {
        protected JTextComponent textComponent;
        protected JPopupMenu popup;
        protected JMenuItem cutItem;
        protected JMenuItem copyItem;
        protected JMenuItem pasteItem;
        protected JMenuItem selectAllItem;

        public TextFieldDefaultPopup(JTextComponent tc) {
            this.textComponent = tc;
            this.popup = new JPopupMenu();
            this.fillPopup();
        }

        public JPopupMenu getPopupMenu() {
            return this.popup;
        }

        protected void fillPopup() {
            if (this.textComponent.isEditable()) {
                this.cutItem = new JMenuItem("Cut");
                this.cutItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        textComponent.cut();
                    }
                });
                this.popup.add(this.cutItem);
            }
            this.copyItem = new JMenuItem("Copy");
            this.copyItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    textComponent.copy();
                }
            });
            this.popup.add(this.copyItem);
            if (this.textComponent.isEditable()) {
                this.pasteItem = new JMenuItem("Paste");
                this.pasteItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        textComponent.paste();
                    }
                });
                this.popup.add(this.pasteItem);
            }
            this.selectAllItem = new JMenuItem("Select All");
            this.selectAllItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    textComponent.requestFocus();
                    textComponent.selectAll();
                }
            });
            this.popup.add(this.selectAllItem);
        }

        @Override
        public void showPopup(MouseEvent e) {
            boolean hasSelection;
            boolean bl = hasSelection = this.textComponent.getSelectedText() != null && this.textComponent.getSelectedText().length() > 0;
            if (this.cutItem != null) {
                this.cutItem.setEnabled(this.textComponent.isEditable() && hasSelection);
            }
            if (this.copyItem != null) {
                this.copyItem.setEnabled(hasSelection);
            }
            if (this.pasteItem != null) {
                this.pasteItem.setEnabled(this.textComponent.isEditable());
            }
            this.popup.show(this.textComponent, e.getX(), e.getY());
        }
    }

    public static abstract class PopupMouseListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.getSource() instanceof Component && ((Component)e.getSource()).isEnabled() && e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        public abstract void showPopup(MouseEvent var1);
    }

    public static class ValueEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;
        private JTextField tf;
        private JComponent parent;
        private TextFieldDefaultPopup popup;

        private ValueEditor(JComponent p) {
            super(new JTextField());
            this.parent = p;
            this.tf = (JTextField)this.editorComponent;
            this.tf.setEditable(false);
            this.tf.setBackground(this.parent.getBackground());
            this.tf.setForeground(this.parent.getForeground());
            this.tf.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    Caret caret = tf.getCaret();
                    if (caret != null) {
                        caret.setVisible(true);
                        caret.setSelectionVisible(true);
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (!e.isTemporary()) {
                        this.stopCellEditing();
                    }
                }
            });
            this.popup = new TextFieldDefaultPopup(this.tf);
            this.tf.addMouseListener(this.popup);
            this.parent.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("background".equals(evt.getPropertyName())) {
                        tf.setBackground(parent.getBackground());
                    } else if ("foreground".equals(evt.getPropertyName())) {
                        tf.setForeground(parent.getForeground());
                    }
                }
            });
        }

        public TextFieldDefaultPopup getTextFieldDefaultPopup() {
            return this.popup;
        }
    }
}

