/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commandline;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Stack;

public class VIStyleConsole {
    private static final int COMMAND_HOME = 1;
    private static final int COMMAND_END = 2;
    private static final int COMMAND_CHANGE_FROM_CURSOR = 3;
    private static final int COMMAND_DELETE_FROM_CURSOR = 4;
    private static final int COMMAND_APPEND_AFTER_CURSOR = 5;
    private static final int COMMAND_APPEND_TO_END = 6;
    private static final int COMMAND_PREVIOUS_WORD = 7;
    private static final int COMMAND_NEXT_WORD = 8;
    private static final int COMMAND_INSERT = 9;
    private static final int COMMAND_UP = 10;
    private static final int COMMAND_DOWN = 11;
    private static final int COMMAND_LEFT = 12;
    private static final int COMMAND_RIGHT = 13;
    private static final int COMMAND_DELETE_AT_CURSOR = 14;
    private static final int COMMAND_DELETE_BEFORE_CURSOR = 15;
    private static final int COMMAND_OVERWRITE = 16;
    private static final int COMMAND_OVERWRITE_1CHAR = 17;
    private static final int COMMAND_CHANGE_WORD = 18;
    private static final int COMMAND_DELETE_WORD = 19;
    private static final int COMMAND_CHANGE_LINE = 20;
    private static final int COMMAND_DELETE_LINE = 21;
    private static final int COMMAND_INSERT_AT_HOME = 22;
    private static final int COMMAND_UNDO = 23;
    private static final Hashtable commandTable = new Hashtable();
    private static final int COMMAND_MODE = 0;
    private static final int INSERTION_MODE = 1;
    private static final int OVERWRITE_MODE = 2;
    private static final int OVERWRITE_1CHAR_MODE = 3;
    private static final int ENTER_CODE = 13;
    private static final int ESCAPE_CODE = 27;
    private static final int FIRST_PRINTABLE_CHAR_CODE = 32;
    private static final int LAST_PRINTABLE_CHAR_CODE = 126;
    private static final int BACKSPACE_CODE = 127;
    private Stack undoStack = new Stack();
    private StringBuffer commandLine = new StringBuffer();
    private int cursorPosition = 0;
    private ArrayList history = new ArrayList();
    private int historyIndex = -1;
    private BufferedInputStream input;
    private String prompt;
    private PrintStream sysOut;
    private byte[] buffer = new byte[16];
    private StringBuffer commandBuffer = new StringBuffer();

    public VIStyleConsole(String prompt) {
        this(prompt, System.out, System.in);
    }

    public VIStyleConsole(String prompt, PrintStream sysOut, InputStream sysIn) {
        this.sysOut = sysOut;
        this.input = new BufferedInputStream(sysIn);
        this.prompt = prompt;
        if (this.prompt == null) {
            this.prompt = "";
        }
    }

    private static boolean isWordCharacter(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_';
    }

    private int getCommand(int c) {
        this.commandBuffer.append((char)c);
        String cmdStr = this.commandBuffer.toString();
        while (cmdStr.length() > 0) {
            Integer I2 = (Integer)commandTable.get(cmdStr);
            if (I2 != null) {
                this.commandBuffer.delete(0, this.commandBuffer.length());
                return I2;
            }
            cmdStr = cmdStr.substring(1);
        }
        return 0;
    }

    private void saveUndo() {
        if (this.undoStack.isEmpty() || !((Undo)this.undoStack.peek()).commandLine.equals(this.commandLine.toString())) {
            this.undoStack.push(new Undo(this.commandLine.toString(), this.cursorPosition));
        }
    }

    private void undo() {
        while (!this.undoStack.isEmpty()) {
            Undo u = (Undo)this.undoStack.pop();
            if (u.commandLine.equals(this.commandLine.toString())) continue;
            this.sysOut.print("\r" + VIStyleConsole.spaces(this.prompt.length() + this.commandLine.length()));
            this.sysOut.print("\r" + this.prompt + u.commandLine);
            this.commandLine.delete(0, this.commandLine.length());
            this.commandLine.append(u.commandLine);
            this.setCursorPosition(u.cursorPosition);
            break;
        }
    }

    public String readLine() {
        int mode = 1;
        while (true) {
            int count;
            try {
                count = this.input.read(this.buffer);
            }
            catch (IOException e) {
                break;
            }
            if (count != 1) continue;
            byte c = this.buffer[0];
            if (c == 127) {
                if (mode == 0) {
                    this.saveUndo();
                }
                this.deleteBeforeCursor();
                continue;
            }
            if (c == 13) {
                this.undoStack.clear();
                return this.addCommand();
            }
            if (c == 27 && mode != 0) {
                mode = 0;
                this.left();
                continue;
            }
            if (mode == 1) {
                if (c < 32 || c > 126) continue;
                if (this.cursorPosition < this.commandLine.length()) {
                    this.commandLine.insert(this.cursorPosition, (char)c);
                    this.sysOut.print("\r" + this.prompt + this.commandLine);
                    this.setCursorPosition(this.cursorPosition + 1);
                    continue;
                }
                this.commandLine.append((char)c);
                this.sysOut.print((char)c);
                ++this.cursorPosition;
                continue;
            }
            if (mode == 2 || mode == 3) {
                if (c < 32 || c > 126) continue;
                if (this.cursorPosition < this.commandLine.length()) {
                    this.commandLine.setCharAt(this.cursorPosition, (char)c);
                    this.sysOut.print("\r" + this.prompt + this.commandLine);
                    this.setCursorPosition(mode == 2 ? this.cursorPosition + 1 : this.cursorPosition);
                }
                if (mode != 3) continue;
                mode = 0;
                continue;
            }
            switch (this.getCommand(c)) {
                case 1: {
                    this.home();
                    break;
                }
                case 2: {
                    this.end();
                    break;
                }
                case 3: {
                    this.saveUndo();
                    this.deleteFromCursor();
                    mode = 1;
                    break;
                }
                case 4: {
                    this.saveUndo();
                    this.deleteFromCursor();
                    break;
                }
                case 5: {
                    this.saveUndo();
                    this.right();
                    mode = 1;
                    break;
                }
                case 6: {
                    this.saveUndo();
                    this.setCursorPosition(this.commandLine.length());
                    mode = 1;
                    break;
                }
                case 7: {
                    this.prevWord();
                    break;
                }
                case 8: {
                    this.nextWord();
                    break;
                }
                case 9: {
                    this.saveUndo();
                    mode = 1;
                    break;
                }
                case 11: {
                    this.clearUndoStack();
                    this.down();
                    break;
                }
                case 10: {
                    this.clearUndoStack();
                    this.up();
                    break;
                }
                case 12: {
                    this.left();
                    break;
                }
                case 13: {
                    this.right();
                    break;
                }
                case 14: {
                    this.saveUndo();
                    this.deleteAtCursor();
                    break;
                }
                case 15: {
                    this.saveUndo();
                    this.deleteBeforeCursor();
                    break;
                }
                case 17: {
                    this.saveUndo();
                    mode = 3;
                    break;
                }
                case 16: {
                    this.saveUndo();
                    mode = 2;
                    break;
                }
                case 18: {
                    this.saveUndo();
                    this.deleteToNextWord();
                    mode = 1;
                    break;
                }
                case 19: {
                    this.saveUndo();
                    this.deleteToNextWord();
                    break;
                }
                case 20: {
                    this.saveUndo();
                    this.deleteLine();
                    mode = 1;
                    break;
                }
                case 21: {
                    this.saveUndo();
                    this.deleteLine();
                    break;
                }
                case 22: {
                    this.saveUndo();
                    this.home();
                    mode = 1;
                    break;
                }
                case 23: {
                    this.undo();
                    break;
                }
            }
        }
        return null;
    }

    private void clearUndoStack() {
        this.undoStack.clear();
    }

    private void deleteToNextWord() {
        int d;
        int nextWordIndex = this.getNextWordIndex();
        if (nextWordIndex == -1 && this.cursorPosition < this.commandLine.length()) {
            nextWordIndex = this.commandLine.length();
        }
        if ((d = nextWordIndex - this.cursorPosition) > 0) {
            this.commandLine.delete(this.cursorPosition, nextWordIndex);
            this.sysOut.print("\r" + this.prompt + this.commandLine + VIStyleConsole.spaces(d));
            this.setCursorPosition(this.cursorPosition);
        }
    }

    private void deleteFromCursor() {
        int d = this.commandLine.length() - this.cursorPosition;
        if (d > 0) {
            this.commandLine.delete(this.cursorPosition, this.commandLine.length());
            this.sysOut.print("\r" + this.prompt + this.commandLine + VIStyleConsole.spaces(d));
            this.setCursorPosition(this.cursorPosition);
        }
    }

    private void deleteLine() {
        this.sysOut.print("\r" + VIStyleConsole.spaces(this.prompt.length() + this.commandLine.length()));
        this.sysOut.print("\r" + this.prompt);
        this.commandLine.delete(0, this.commandLine.length());
        this.cursorPosition = 0;
    }

    private void deleteAtCursor() {
        if (this.cursorPosition < this.commandLine.length()) {
            this.commandLine.deleteCharAt(this.cursorPosition);
            this.sysOut.print("\r" + this.prompt + this.commandLine + " ");
            this.setCursorPosition(this.cursorPosition);
        }
    }

    private void deleteBeforeCursor() {
        if (this.cursorPosition > 0) {
            this.commandLine.deleteCharAt(this.cursorPosition - 1);
            this.sysOut.print("\r" + this.prompt + this.commandLine + " ");
            this.setCursorPosition(this.cursorPosition - 1);
        }
    }

    private void home() {
        if (this.commandLine.length() > 0) {
            this.setCursorPosition(0);
        }
    }

    private int getNextWordIndex() {
        int wordIndex = -1;
        if (this.cursorPosition < this.commandLine.length()) {
            boolean foundWordChar = false;
            boolean foundNotWordChar = false;
            boolean breakOnNextWhitespace = false;
            for (int i = this.cursorPosition + 1; i < this.commandLine.length() && wordIndex == -1; ++i) {
                char c = this.commandLine.charAt(i);
                if (breakOnNextWhitespace) {
                    if (c == ' ') continue;
                    wordIndex = i;
                    continue;
                }
                if (foundWordChar) {
                    if (c == ' ') {
                        breakOnNextWhitespace = true;
                        continue;
                    }
                    if (VIStyleConsole.isWordCharacter(c)) continue;
                    wordIndex = i;
                    continue;
                }
                if (foundNotWordChar) {
                    if (c == ' ') {
                        breakOnNextWhitespace = true;
                        continue;
                    }
                    if (!VIStyleConsole.isWordCharacter(c)) continue;
                    wordIndex = i;
                    continue;
                }
                if (VIStyleConsole.isWordCharacter(c)) {
                    foundWordChar = true;
                    foundNotWordChar = false;
                    breakOnNextWhitespace = false;
                    continue;
                }
                if (c == ' ') {
                    breakOnNextWhitespace = true;
                    continue;
                }
                foundWordChar = false;
                foundNotWordChar = true;
                breakOnNextWhitespace = false;
            }
        }
        return wordIndex;
    }

    private void nextWord() {
        int wordIndex = this.getNextWordIndex();
        if (wordIndex == -1 && this.cursorPosition < this.commandLine.length()) {
            wordIndex = this.commandLine.length() - 1;
        }
        if (wordIndex >= 0) {
            this.setCursorPosition(wordIndex);
        }
    }

    private int getPrevWordIndex() {
        int wordIndex = -1;
        if (this.cursorPosition > 0) {
            boolean foundWordChar = false;
            boolean foundNotWordChar = false;
            wordIndex = 0;
            for (int i = this.cursorPosition - 1; i >= 0 && wordIndex == 0; --i) {
                char c = this.commandLine.charAt(i);
                if (foundWordChar) {
                    if (VIStyleConsole.isWordCharacter(c)) continue;
                    wordIndex = i + 1;
                    continue;
                }
                if (foundNotWordChar) {
                    if (!VIStyleConsole.isWordCharacter(c) && c != ' ') continue;
                    wordIndex = i + 1;
                    continue;
                }
                if (VIStyleConsole.isWordCharacter(c)) {
                    foundWordChar = true;
                    foundNotWordChar = false;
                    continue;
                }
                if (c == ' ') continue;
                foundWordChar = false;
                foundNotWordChar = true;
            }
        }
        return wordIndex;
    }

    private void prevWord() {
        int prevWordIndex = this.getPrevWordIndex();
        if (prevWordIndex >= 0) {
            this.setCursorPosition(prevWordIndex);
        }
    }

    private void end() {
        if (this.commandLine.length() > 0) {
            this.setCursorPosition(this.commandLine.length() - 1);
        }
    }

    private void left() {
        if (this.cursorPosition > 0) {
            this.setCursorPosition(this.cursorPosition - 1);
        }
    }

    private void right() {
        if (this.cursorPosition < this.commandLine.length()) {
            this.setCursorPosition(this.cursorPosition + 1);
        }
    }

    private void down() {
        if (this.historyIndex >= 0 && this.historyIndex < this.history.size() - 1) {
            this.setHistoryIndex(this.historyIndex + 1);
        } else {
            this.deleteLine();
            this.historyIndex = -1;
        }
    }

    private void up() {
        if (this.historyIndex > 0) {
            this.setHistoryIndex(this.historyIndex - 1);
        } else if (this.historyIndex < 0 && this.history.size() > 0) {
            this.setHistoryIndex(this.history.size() - 1);
        }
    }

    private void setHistoryIndex(int index) {
        this.historyIndex = index;
        this.sysOut.print("\r" + VIStyleConsole.spaces(this.prompt.length() + this.commandLine.length()));
        this.sysOut.print("\r" + this.prompt + this.history.get(this.historyIndex));
        this.commandLine.delete(0, this.commandLine.length());
        this.commandLine.append(this.history.get(this.historyIndex).toString());
        this.cursorPosition = this.commandLine.length();
    }

    private void setCursorPosition(int index) {
        this.cursorPosition = index;
        this.sysOut.print("\r" + this.prompt + this.commandLine.substring(0, this.cursorPosition));
    }

    private String addCommand() {
        String cmdStr = this.commandLine.toString();
        if (cmdStr.length() > 0) {
            if (this.history.size() == 0 || !this.history.get(this.history.size() - 1).equals(cmdStr)) {
                this.history.add(cmdStr);
            }
            this.commandLine.delete(0, this.commandLine.length());
            this.cursorPosition = 0;
            this.historyIndex = -1;
        }
        this.sysOut.print("\n\r");
        return cmdStr;
    }

    private static String spaces(int n) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    static {
        commandTable.put("$", new Integer(2));
        commandTable.put("0", new Integer(1));
        commandTable.put("A", new Integer(6));
        commandTable.put("a", new Integer(5));
        commandTable.put("b", new Integer(7));
        commandTable.put("C", new Integer(3));
        commandTable.put("cc", new Integer(20));
        commandTable.put("cw", new Integer(18));
        commandTable.put("D", new Integer(4));
        commandTable.put("dd", new Integer(21));
        commandTable.put("dw", new Integer(19));
        commandTable.put("h", new Integer(12));
        commandTable.put("I", new Integer(22));
        commandTable.put("i", new Integer(9));
        commandTable.put("j", new Integer(10));
        commandTable.put("k", new Integer(11));
        commandTable.put("l", new Integer(13));
        commandTable.put("R", new Integer(16));
        commandTable.put("r", new Integer(17));
        commandTable.put("u", new Integer(23));
        commandTable.put("w", new Integer(8));
        commandTable.put("X", new Integer(15));
        commandTable.put("x", new Integer(14));
    }

    private static class Undo {
        private String commandLine;
        private int cursorPosition;

        public Undo(String commandLine, int cursorPosition) {
            this.commandLine = commandLine;
            this.cursorPosition = cursorPosition;
        }
    }
}

