/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.DebuggerInvoker;
import com.iscobol.debugger.Settings;
import com.iscobol.debugger.dialogs.AbstractSettingsDialog;
import com.iscobol.debugger.dialogs.LMResize;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BreakpointsSettingsDialog
extends AbstractSettingsDialog {
    private static final long serialVersionUID = 1L;
    private JComboBox breakpointEnabledCmb;

    public BreakpointsSettingsDialog(JFrame parent, String title) {
        super(parent, title, true);
    }

    @Override
    protected void createContents(JPanel mainPanel) {
        boolean defaultBpEnState = Settings.getDefaultBreakpointEnabledState();
        LMResize layout = new LMResize(10, 10, 5, 0);
        mainPanel.setLayout(layout);
        JLabel breakpointEnabledLbl = new JLabel("Breakpoint default state:");
        this.breakpointEnabledCmb = new JComboBox<String>(new String[]{"Enabled", "Disabled"});
        this.breakpointEnabledCmb.setSelectedIndex(defaultBpEnState ? 0 : 1);
        Dimension d = layout.getPreferredSize(breakpointEnabledLbl);
        breakpointEnabledLbl.setBounds(10, 10, d.width, d.height);
        mainPanel.add(breakpointEnabledLbl);
        d = layout.getPreferredSize(this.breakpointEnabledCmb);
        this.breakpointEnabledCmb.setBounds(LMResize.getRight(breakpointEnabledLbl) + 5, LMResize.getTop(breakpointEnabledLbl), 100, d.height);
        mainPanel.add(this.breakpointEnabledCmb);
        ActionListener actionListener = e -> this.setDirty(true);
        this.breakpointEnabledCmb.addActionListener(actionListener);
    }

    @Override
    protected void performApply() {
        Settings.setDefaultBreakpointEnabledState(this.breakpointEnabledCmb.getSelectedIndex() == 0);
        DebuggerInvoker.setDefaultBreakpointEnabledState(this.breakpointEnabledCmb.getSelectedIndex() == 0);
        super.performApply();
    }

    @Override
    protected String validateInput() {
        return null;
    }
}

