/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.GraphDebugger;
import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.Settings;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import com.iscobol.debugger.dialogs.NamesRecorder;
import com.iscobol.debugger.dialogs.treetable.model.VariableModel;
import com.iscobol.debugger.dialogs.treetable.model.VariableNode;
import com.iscobol.debugger.tree.Tree;
import com.iscobol.debugger.tree.TreeNode;
import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.client.swing.treetable.JTreeTable;
import com.iscobol.gui.client.swing.treetable.TreeTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeCellRenderer;

public class QuickWatchDialog
extends DebugDialog {
    private static final long serialVersionUID = 123L;
    private GraphDebugger graphDebug;
    private GraphUtilities.ValueEditor valueEditor;
    private JButton refresh;
    private JButton addWatch;
    private JButton modifyValue;
    private JButton displayTree;
    private JButton close;
    private JComboBox variableName;
    private JTextField propertyName;
    private JTextField moduleName;
    private JTreeTable variableTree;
    private JScrollPane variableScrollPane;
    private JCheckBox asHex;
    private VariableModel variableModel;
    private int lastCommand;
    private String currVarname;
    private boolean executingDisplayCommand;
    private boolean active;
    private NamesRecorder nRec = NamesRecorder.getInstance("varname");

    public QuickWatchDialog(GraphDebugger graphDebug, JFrame parent, String title) {
        super(parent, title, true);
        this.graphDebug = graphDebug;
        LMResize layout = new LMResize(10, 10, 5, 0);
        this.getContentPane().setLayout(layout);
        this.refresh = new JButton("Refresh");
        this.refresh.setMnemonic(82);
        this.refresh.addActionListener(e -> this.refresh());
        this.displayTree = new JButton("Show in Watched Variables");
        this.displayTree.setMnemonic(86);
        this.displayTree.addActionListener(e -> this.displayTree());
        this.modifyValue = new JButton("Change value");
        this.modifyValue.setMnemonic(72);
        this.modifyValue.addActionListener(e -> this.modifyValue());
        this.addWatch = new JButton("Add monitor");
        this.addWatch.setMnemonic(65);
        this.addWatch.addActionListener(e -> this.addMonitor());
        this.close = new JButton("Close");
        this.close.addActionListener(e -> this.closeDialog());
        this.close.setMnemonic(67);
        Dimension d = layout.getPreferredSize(this.displayTree);
        this.refresh.setBounds(870 - d.width, 10, d.width, d.height);
        this.getContentPane().add((Component)this.refresh, new LMResizeData(2));
        this.displayTree.setBounds(LMResize.getLeft(this.refresh), LMResize.getBottom(this.refresh) + 10, d.width, d.height);
        this.getContentPane().add((Component)this.displayTree, new LMResizeData(2));
        this.modifyValue.setBounds(LMResize.getLeft(this.refresh), LMResize.getBottom(this.displayTree) + 10, d.width, d.height);
        this.getContentPane().add((Component)this.modifyValue, new LMResizeData(2));
        this.addWatch.setBounds(LMResize.getLeft(this.refresh), LMResize.getBottom(this.modifyValue) + 10, d.width, d.height);
        this.getContentPane().add((Component)this.addWatch, new LMResizeData(2));
        this.close.setBounds(LMResize.getLeft(this.refresh), LMResize.getBottom(this.addWatch) + 10, d.width, d.height);
        this.getContentPane().add((Component)this.close, new LMResizeData(2));
        JLabel lblvar = new JLabel("Variable name: ");
        d = layout.getPreferredSize(lblvar);
        lblvar.setBounds(10, 10, d.width, d.height);
        this.getContentPane().add(lblvar);
        this.variableName = new JComboBox();
        Component c = this.variableName.getEditor().getEditorComponent();
        if (c instanceof JTextComponent) {
            c.addMouseListener(new GraphUtilities.TextFieldDefaultPopup((JTextComponent)c));
        }
        this.variableName.setEditable(true);
        JLabel lblmodule = new JLabel("Method/Program: ");
        d = layout.getPreferredSize(lblmodule);
        lblmodule.setBounds(LMResize.getLeft(lblvar), LMResize.getBottom(lblvar) + 20, d.width, d.height);
        this.getContentPane().add(lblmodule);
        this.moduleName = new JTextField();
        this.moduleName.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.moduleName));
        int l = LMResize.getRight(lblmodule) + 5;
        this.moduleName.setBounds(l, LMResize.getTop(lblmodule), LMResize.getLeft(this.refresh) - 10 - l, this.moduleName.getPreferredSize().height);
        this.getContentPane().add((Component)this.moduleName, new LMResizeData(1));
        this.variableName.setBounds(LMResize.getLeft(this.moduleName), LMResize.getTop(lblvar), this.moduleName.getSize().width, this.variableName.getPreferredSize().height);
        this.getContentPane().add((Component)this.variableName, new LMResizeData(1));
        JLabel lblprop = new JLabel("Property: ");
        d = layout.getPreferredSize(lblprop);
        lblprop.setBounds(LMResize.getLeft(lblvar), LMResize.getBottom(lblmodule) + 15, d.width, d.height);
        this.getContentPane().add(lblprop);
        this.propertyName = new JTextField();
        this.propertyName.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.propertyName));
        this.propertyName.setBounds(LMResize.getLeft(this.moduleName), LMResize.getTop(lblprop), this.moduleName.getSize().width, this.propertyName.getPreferredSize().height);
        this.getContentPane().add((Component)this.propertyName, new LMResizeData(1));
        this.asHex = new JCheckBox("Show Hex Values");
        this.asHex.setMnemonic(88);
        this.asHex.addActionListener(e -> {
            this.variableModel.setShowHexValues(this.asHex.isSelected());
            this.refreshCurrent();
        });
        d = layout.getPreferredSize(this.asHex);
        this.asHex.setBounds(LMResize.getLeft(lblvar) + 5, LMResize.getBottom(lblprop) + 15, d.width, d.height);
        this.getContentPane().add(this.asHex);
        VariableNode root = new VariableNode("", null, "", null);
        this.variableTree = this.createVariableTree(root, false);
        this.variableScrollPane = new JScrollPane(this.variableTree);
        l = LMResize.getLeft(lblvar);
        this.variableScrollPane.setBounds(l, LMResize.getBottom(this.asHex) + 10, LMResize.getLeft(this.refresh) - 10 - l, 400);
        this.getContentPane().add((Component)this.variableScrollPane, new LMResizeData(5));
        this.pack();
        this.setDefaultButton(this.refresh);
    }

    private boolean getHexFlag() {
        return this.propertyName.getText().length() == 0 && Settings.getHexOption();
    }

    public boolean isExecutingDisplayCommand() {
        return this.executingDisplayCommand;
    }

    private JTreeTable createVariableTree(VariableNode root, boolean showRootNode) {
        this.variableModel = new VariableModelExt(root, this.asHex.isSelected(), showRootNode);
        this.variableTree = new JTreeTable(this.variableModel);
        this.variableTree.setRootVisible(showRootNode);
        this.variableTree.getTreeTableCellRenderer().setShowsRootHandles(true);
        this.variableTree.setSelectionMode(0);
        this.variableTree.setRowSelectionAllowed(true);
        this.variableTree.setFillsViewportHeight(true);
        this.variableTree.setColumnSelectionAllowed(false);
        this.variableTree.getTableHeader().setReorderingAllowed(false);
        this.valueEditor = GraphUtilities.getValueEditor(this.variableTree);
        this.graphDebug.addPopupMenu(this.valueEditor.getTextFieldDefaultPopup().getPopupMenu());
        this.variableTree.setDefaultEditor(String.class, this.valueEditor);
        this.variableTree.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.variableTree.getColumnModel().getColumn(1).setMaxWidth(80);
        this.variableTree.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.variableTree.getColumnModel().getColumn(2).setMaxWidth(80);
        JTree jtree = this.variableTree.getTreeTableCellRenderer();
        jtree.setCellRenderer(new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                this.setIcon(null);
                this.doLayout();
                return this;
            }
        });
        this.variableTree.getTreeTableCellRenderer().addTreeSelectionListener(e -> {
            VariableNode n = (VariableNode)jtree.getLastSelectedPathComponent();
            if (n != null) {
                String varname = n.getQualifiedName();
                int idx = varname.indexOf("::");
                if (idx >= 0) {
                    varname = varname.substring(0, idx);
                }
                this.variableName.getEditor().setItem(varname);
            }
        });
        return this.variableTree;
    }

    private void addMonitor() {
        Object item = this.variableName.getEditor().getItem();
        String varname = null;
        if (item != null && (varname = item.toString()).length() > 0) {
            String cmd;
            String propname = this.propertyName.getText();
            DebugResponse resp = this.executeDisplayCommand(varname, propname);
            boolean hex = this.getHexFlag();
            if (resp != null && resp.getReturnCode() == 0 && resp.getVarType() == 12) {
                hex = false;
            }
            String modulename = null;
            if (this.moduleName.getText().length() > 0) {
                modulename = this.moduleName.getText();
            }
            if ((cmd = this.graphDebug.showMonitorDialog(varname, modulename, propname, true, hex)) != null) {
                this.lastCommand = 13;
            }
            this.removeAndInsert(varname);
        }
    }

    private void displayTree() {
        this.executingDisplayCommand = true;
        this.refresh();
    }

    public void setVariableName(String varname) {
        if (varname != null && varname.length() > 0) {
            this.variableName.getEditor().setItem(varname.trim());
        }
    }

    public void setModuleName(String modulename) {
        if (modulename != null && modulename.length() > 0) {
            this.moduleName.setText(modulename);
        }
    }

    public boolean commandExecuted(DebugResponse resp) {
        if (resp.getReturnCode() == 0) {
            switch (this.lastCommand) {
                case 5: {
                    this.updateTree(resp);
                    return true;
                }
                case 6: {
                    this.refreshCurrent();
                    break;
                }
            }
        }
        return false;
    }

    private void refreshCurrent() {
        if (this.currVarname != null) {
            String cmd = this.getDisplayCommand(this.currVarname);
            DebugResponse r2 = this.graphDebug.getInvoker().processCommand(cmd);
            if (r2 != null && r2.getReturnCode() == 0) {
                this.updateTree(r2);
            }
        }
    }

    private void updateTree(DebugResponse resp) {
        boolean showRootNode;
        VariableNode rootNode;
        this.executingDisplayCommand = false;
        Tree tree = resp.getTree();
        if (tree != null) {
            rootNode = GraphUtilities.buildVariableNode(tree);
            TreeNode r = tree.getRoot();
            int cc = r.getChildCount();
            showRootNode = cc > 1 || cc == 1 && !r.getVarName().equals(r.getChildren()[0].getVarName());
        } else {
            rootNode = new VariableNode(resp.getVarName(), null, "", null);
            VariableNode child = new VariableNode(resp.getVarName(), null, "", rootNode);
            child.setTextValue(resp.getVarValue());
            showRootNode = false;
        }
        this.variableTree = this.createVariableTree(rootNode, showRootNode);
        this.variableScrollPane.getViewport().setView(this.variableTree);
        new IsguiWorker(false, () -> {
            this.variableScrollPane.doLayout();
            GraphUtilities.expandNode(this.variableTree.getTreeTableCellRenderer(), this.variableModel.getRootNode());
        }).start();
    }

    private DebugResponse executeDisplayCommand(String varname, String propname) {
        String cmd = "display";
        if (this.getHexFlag()) {
            cmd = cmd + " -x";
        }
        cmd = cmd + " " + varname;
        if (propname.length() > 0) {
            cmd = cmd + " property " + propname;
        }
        return this.graphDebug.getInvoker().processCommand(cmd);
    }

    private void modifyValue() {
        Object item = this.variableName.getEditor().getItem();
        String varname = null;
        if (item != null && (varname = item.toString()).length() > 0) {
            String defmodule;
            String cmd;
            String propname = this.propertyName.getText();
            String defValue = null;
            boolean hex = this.getHexFlag();
            DebugResponse resp = this.executeDisplayCommand(varname, propname);
            if (resp != null && resp.getReturnCode() == 0) {
                if (resp.getVarType() == 12) {
                    defValue = resp.getVarValue().trim();
                    defValue = defValue.substring(0, defValue.indexOf(32));
                    hex = false;
                } else {
                    defValue = resp.getVarValue().replaceAll("\\s+$", "");
                }
            }
            if ((cmd = this.graphDebug.showAcceptVariableDialog(varname, defmodule = this.moduleName.getText().length() > 0 ? this.moduleName.getText() : null, defValue, propname, hex)) != null) {
                this.lastCommand = 6;
                this.graphDebug.setTextCommand(cmd);
            } else {
                NamesRecorder.removeLastInstance();
            }
            this.removeAndInsert(varname);
        }
    }

    private String getDisplayCommand(String varname) {
        String propname = this.propertyName.getText();
        StringBuffer cmd = new StringBuffer();
        cmd.append("display");
        if (propname.length() == 0) {
            cmd.append(" ");
            cmd.append("-tree");
        }
        if (this.moduleName.getText().length() > 0) {
            cmd.append(" ");
            cmd.append("-c");
            cmd.append(" ");
            cmd.append(this.moduleName.getText());
        }
        cmd.append(" ");
        cmd.append(varname);
        if (propname.length() > 0) {
            cmd.append(" ");
            cmd.append("property");
            cmd.append(" ");
            cmd.append(propname);
        }
        return cmd.toString();
    }

    private void refresh() {
        Object item = this.variableName.getEditor().getItem();
        String varname = null;
        if (item != null && (varname = item.toString()).length() > 0) {
            String cmd = this.getDisplayCommand(varname);
            this.lastCommand = 5;
            this.graphDebug.setTextCommand(cmd);
            this.currVarname = varname;
            this.removeAndInsert(varname);
        }
    }

    private void removeAndInsert(String item) {
        Object sel = this.variableName.getEditor().getItem();
        this.nRec.removeAndInsert(item);
        this.variableName.removeAllItems();
        Iterator<String> it = this.nRec.names();
        while (it.hasNext()) {
            this.variableName.addItem(it.next());
        }
        this.variableName.setSelectedItem(sel);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void closeDialog() {
        this.active = false;
        NamesRecorder.removeLastInstance();
        super.closeDialog();
    }

    @Override
    public void setVisible(boolean b) {
        this.active = b;
        if (b) {
            NamesRecorder.setLastInstance(this.nRec);
            this.propertyName.setText("");
            this.variableTree.clearSelection();
            this.variableTree = this.createVariableTree(new VariableNode("", null, "", null), false);
            this.variableScrollPane.getViewport().setView(this.variableTree);
            this.variableScrollPane.doLayout();
            Object item = this.variableName.getEditor().getItem();
            if (item == null || item.toString().length() == 0) {
                this.variableName.removeAllItems();
                Iterator<String> it = this.nRec.names();
                while (it.hasNext()) {
                    this.variableName.addItem(it.next());
                }
            }
            this.refresh();
        }
        super.setVisible(b);
    }

    private static class VariableModelExt
    extends VariableModel {
        private final boolean showRootNode;

        public VariableModelExt(VariableNode root, boolean showHexValues, boolean showRootNode) {
            super(root, showHexValues);
            this.showRootNode = showRootNode;
        }

        @Override
        protected Class[] getColumnTypes() {
            return new Class[]{TreeTableModel.class, String.class, String.class, String.class, String.class};
        }

        @Override
        protected String[] getColumnNames() {
            return new String[]{"Name", "Offset", "Length", "Value", "Hex"};
        }

        @Override
        public Object getValueAt(Object node, int column) {
            if (node == null || node == this.root && !this.showRootNode) {
                return null;
            }
            switch (column) {
                case 0: {
                    return ((VariableNode)node).getName();
                }
                case 1: {
                    return String.valueOf(((VariableNode)node).getOffset());
                }
                case 2: {
                    return String.valueOf(((VariableNode)node).getLength());
                }
                case 3: {
                    return ((VariableNode)node).getTextValue();
                }
                case 4: {
                    return this.showHexValues ? ((VariableNode)node).getHexDump() : "";
                }
            }
            return null;
        }
    }
}

