/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.easydb;

import com.iscobol.easydb.Condition;
import com.iscobol.easydb.ConditionList;
import com.iscobol.easydb.EdbiIs;
import com.iscobol.easydb.EdbiIsCommon;
import com.iscobol.easydb.Field;
import com.iscobol.easydb.FieldList;
import com.iscobol.easydb.Index;
import com.iscobol.easydb.IndexList;
import com.iscobol.easydb.Segment;
import com.iscobol.easydb.StringList;
import com.iscobol.easydb.TableList;
import com.iscobol.easydb.XmlDocument;

public class Table
implements EdbiIsCommon {
    String cobtabname;
    String tabname;
    String dbname;
    int dbtype;
    String viewname;
    boolean haveIndicator;
    boolean haveDups = false;
    boolean haveSameBuffs;
    boolean haveDefaultCond = false;
    String dbpath;
    FieldList fields = new FieldList();
    FieldList fieldsRedefines = new FieldList();
    FieldList sqlfields = new FieldList();
    IndexList indexes = new IndexList();
    String currline;
    int currtype;
    int currnum;
    int recLen;
    int maxRecLen;
    int minRecLen;
    int keyCount;
    EdbiIs edbi;
    String tableSpace;
    String storIni;
    String storNext;
    String storIncr;
    String temporary = "noTemp";
    int fileOrg;
    public int numConditions = 0;
    public int numSimplConditions = 0;
    public boolean isMasterTable;
    public boolean isChildTable;
    public boolean hasRedefines;
    public boolean hasRedefinesOfMulti;
    public boolean hasTime;
    public ConditionList conditions = new ConditionList();
    public TableList multiTables = new TableList();

    public Table(EdbiIs edb, XmlDocument doc) {
        this.edbi = edb;
        this.dbtype = this.edbi.getDbt();
        this.fileOrg = 0;
        this.tableSpace = this.edbi.getOption("-ott=") != null ? this.edbi.getOption("-ott=") : "";
        this.storIni = this.edbi.getOption("-oit=") != null ? this.edbi.getOption("-oit=") : "";
        this.storNext = this.edbi.getOption("-ont=") != null ? this.edbi.getOption("-ont=") : "";
        this.storIncr = this.edbi.getOption("-opt=") != null ? this.edbi.getOption("-opt=") : "";
        doc.carTable(this);
        if (this.edbi.getReturnCode() != 0) {
            return;
        }
        this.haveSameBuffs = true;
        this.hasTime = false;
        this.isMasterTable = false;
        this.isChildTable = false;
        this.hasRedefines = false;
        this.hasRedefinesOfMulti = false;
        this.dbname = this.tabname;
        this.recLen = this.maxRecLen;
        doc.carIndexes(this);
        if (!this.isIndexed()) {
            Index idx = null;
            idx = new Index(this.edbi, false);
            this.indexes.addItem(idx);
            idx.isSplit = false;
            idx.idxdups = false;
            idx.segNum = 1;
            Segment seg = new Segment();
            idx.segments.addItem(seg);
            idx.idxfields.addItem(new Field(this.edbi, "RELSEQ_DUMMY_KEY", "Numeric", 0, -1, this.maxRecLen, 18, 18, 0, 0, 0, false, 2, false, false, false, 0, 1, false));
        }
        if (this.edbi.getReturnCode() != 0) {
            return;
        }
        doc.carConditions(this);
        if (this.edbi.getReturnCode() != 0) {
            return;
        }
        doc.carFields(this);
        if (this.edbi.getReturnCode() != 0) {
            return;
        }
        this.carIdxFields();
        if (this.edbi.getReturnCode() != 0) {
            return;
        }
        this.manageConditions();
        if (this.edbi.getReturnCode() != 0) {
            return;
        }
        this.currnum = 0;
        if (this.edbi.hasDebug()) {
            System.err.println("This is tabname " + this.tabname);
        }
        if (this.edbi.hasDebug()) {
            System.err.println("Record's length = " + this.recLen);
        }
        if (this.fieldsRedefines.getItemNum() > 0) {
            this.changeRedefinesFieldInCond();
        }
    }

    public Table(EdbiIs edb, Table tab, Condition con) {
        int actOffs = 0;
        this.edbi = edb;
        this.currnum = 0;
        this.cobtabname = con.tabname;
        this.tabname = con.tabname.replace('-', '_');
        if (this.cobtabname == null) {
            this.edbi.printErr(23, "Invalid tablename in multitable [" + this.tabname + "] unknown!", 1);
            return;
        }
        con.dbname = this.tabname;
        if (this.edbi.hasDebug()) {
            System.err.println("This is tabname " + this.tabname);
        }
        this.dbname = tab.dbname;
        this.recLen = tab.recLen;
        this.tableSpace = tab.tableSpace;
        this.storIni = tab.storIni;
        this.storNext = tab.storNext;
        this.storIncr = tab.storIncr;
        this.haveIndicator = tab.haveIndicator();
        this.haveDefaultCond = tab.haveDefaultCond();
        this.haveSameBuffs = tab.haveSameBuffs;
        this.haveDups = tab.haveDups;
        this.hasTime = tab.hasTime;
        this.isMasterTable = false;
        this.isChildTable = true;
        this.hasRedefinesOfMulti = false;
        if (con.childsCond.getItemNum() > 0) {
            this.hasRedefines = true;
        }
        this.conditions.addItem(con);
        this.manageConditions();
        this.maxRecLen = tab.maxRecLen;
        this.minRecLen = tab.minRecLen;
        this.keyCount = tab.keyCount;
        this.dbtype = tab.dbtype;
        this.temporary = tab.temporary;
        Field fld = tab.fields.getFirst();
        while (fld != null) {
            if (this.edbi.hasDebug()) {
                System.err.println("While [" + fld.getCobName() + "] found [" + fld.xmlcondition + "] for [" + con.number + "]");
            }
            if (fld.satisfy(con)) {
                if (this.edbi.hasDebug()) {
                    System.err.println("XmlOffs [" + fld.xmloffset + "] actOffs [" + actOffs + "]");
                }
                if (fld.getIntType() != fld.getCobType() || fld.getFldType() == 4) {
                    this.haveSameBuffs = false;
                }
                this.fields.addItem(fld);
                actOffs = fld.xmloffset + fld.xmlsize;
                if (!fld.getCobName().equalsIgnoreCase("FILLER")) {
                    this.sqlfields.addItem(fld);
                }
                if (this.edbi.hasDebug()) {
                    System.err.println("Add [" + fld.getCobName() + "] found [" + fld.xmlcondition + "] for [" + con.number + "]");
                }
            }
            fld = tab.fields.getNext();
        }
        Index idx = tab.indexes.getFirst();
        while (idx != null) {
            Index nidx = new Index(this.edbi, tab.fields, idx, con, this);
            if (this.edbi.getReturnCode() != 0) {
                return;
            }
            if (this.edbi.hasDebug()) {
                System.err.println("Added index on cond [" + con.number + "]");
            }
            this.indexes.addItem(nidx);
            idx = tab.indexes.getNext();
        }
    }

    Field getByName(String name) {
        Field fld = null;
        String cobname = name.replace('_', '-');
        fld = this.fields.getFirst();
        while (fld != null && !fld.getCobName().equalsIgnoreCase(cobname)) {
            if (this.edbi.hasDebug() && fld != null) {
                System.err.println("Found [" + fld.getCobName() + "] search for [" + cobname + "]");
            }
            fld = this.fields.getNext();
        }
        return fld;
    }

    Field getByOffset(int offset) {
        Field fld = null;
        fld = this.fields.getFirst();
        while (fld != null && fld.xmloffset != offset) {
            fld = this.fields.getNext();
        }
        return fld;
    }

    public String getCobName() {
        return this.cobtabname;
    }

    public void setTabname(String str) {
        this.tabname = str;
    }

    public String getTabName() {
        return this.tabname;
    }

    public String getDbName() {
        return this.dbname;
    }

    public String getViewname() {
        return this.viewname;
    }

    public boolean haveIndicator() {
        return this.haveIndicator;
    }

    public boolean haveDefaultCond() {
        return this.haveDefaultCond;
    }

    public void setDefaultCond(boolean d) {
        this.haveDefaultCond = d;
    }

    public int getMaxRecLen() {
        return this.maxRecLen;
    }

    public int getMinRecLen() {
        return this.minRecLen;
    }

    public int getDbType() {
        return this.dbtype;
    }

    public String getDbPath() {
        return this.dbpath;
    }

    public FieldList getField() {
        return this.fields;
    }

    public FieldList getSqlField() {
        return this.sqlfields;
    }

    public IndexList getIndex() {
        return this.indexes;
    }

    public ConditionList getCondition() {
        return this.conditions;
    }

    public Index getPrimaryKey() {
        return this.indexes.getFirst();
    }

    boolean isRedefOfIndex(Field fld) {
        Index ip = null;
        ip = this.indexes.getFirst();
        while (ip != null) {
            Segment seg = ip.segments.getFirst();
            while (seg != null) {
                if (fld.xmloffset >= seg.offset && fld.xmloffset < seg.offset + seg.size) {
                    return true;
                }
                seg = ip.segments.getNext();
            }
            ip = this.indexes.getNext();
        }
        return false;
    }

    void carIdxFields() {
        int i = 0;
        Index idx = this.indexes.getFirst();
        while (idx != null) {
            Field fld;
            ++i;
            if (this.edbi.hasDebug()) {
                System.err.println("Index " + i + " of " + this.indexes.getMaxIdx() + " numSeg " + idx.segNum + " duplicate " + idx.idxdups);
            }
            boolean noErr = false;
            String tmpPart = "";
            String part = idx.namePart.getFirst();
            while (part != null && !noErr) {
                fld = this.getByName(part);
                if (fld != null) {
                    idx.idxfields.addItem(fld);
                    fld.isPartKey = true;
                } else {
                    tmpPart = part;
                    noErr = true;
                }
                part = idx.namePart.getNext();
            }
            if (noErr) {
                int actOffs = 0;
                int lastOffs = 0;
                idx.clearIndex();
                Segment seg = idx.segments.getFirst();
                while (seg != null) {
                    lastOffs = seg.offset + seg.size;
                    for (actOffs = seg.offset; actOffs < lastOffs; actOffs += fld.xmlsize) {
                        if (actOffs == 36) {
                            fld = null;
                        }
                        if ((fld = this.getByOffset(actOffs)) == null || fld.getSqlName().equalsIgnoreCase("FILLER")) {
                            if (tmpPart.equalsIgnoreCase("FILLER")) {
                                this.edbi.printErr(18, tmpPart + " is invalid name in key part tag! ", idx.xmlLine);
                            } else {
                                this.edbi.printErr(18, tmpPart + " part key not found! ", idx.xmlLine);
                            }
                            return;
                        }
                        idx.idxfields.addItem(fld);
                        if (!this.edbi.hasDebug()) continue;
                        System.err.println("Index " + i + " by offset added " + fld.getSqlName() + " in part[" + seg.offset + "," + seg.size + "] actOffs " + actOffs + " lastOffs " + lastOffs);
                    }
                    seg = idx.segments.getNext();
                }
            }
            if (this.dbtype == 0) {
                if (this.edbi.hasDebug()) {
                    System.err.println("Hint Calc Index " + i);
                }
                if (idx.hint != "") {
                    idx.hint = "/*+ " + idx.hint + " */";
                }
                if (this.edbi.hasDebug()) {
                    System.err.println("Hint Calculated [" + idx.hint + "][" + idx.hintIdx + "]");
                }
            }
            if ((this.edbi.getOption("-dpld") != null || this.edbi.getOption("-dsld") != null || this.edbi.getOption("-dmld") != null) && idx.idxdups) {
                fld = new Field(this.edbi, this.edbi.getOidName(), "ALPHANUM", 0, -1, 0, 18, -1, -1, 0, 0, false, 0, false, false, false, 0, 0, false);
                idx.idxfields.addItem(fld);
            }
            idx = this.indexes.getNext();
        }
    }

    void manageConditions() {
        if (this.conditions.getItemNum() > 0) {
            Condition con = this.conditions.getFirst();
            while (con != null) {
                if (!con.tabname.equalsIgnoreCase(this.tabname) && con.tabname.length() > 0) {
                    this.isMasterTable = true;
                    this.multiTables.addItem(new Table(this.edbi, this, con));
                    if (this.edbi.getReturnCode() != 0) {
                        return;
                    }
                } else if (!con.tabname.equalsIgnoreCase(this.tabname) || this.conditions.getItemNum() != 1 || !this.isChildTable) {
                    con.isRedefines = true;
                    this.hasRedefines = true;
                }
                con = this.conditions.getNext();
            }
        }
    }

    Table getMulti(String name) {
        Table tab = null;
        if (this.multiTables.getItemNum() > 0) {
            tab = this.multiTables.getFirst();
            while (tab != null) {
                if (tab.tabname.equalsIgnoreCase(name)) {
                    return tab;
                }
                tab = this.multiTables.getNext();
            }
        }
        return tab;
    }

    int getFileOrg() {
        return this.fileOrg;
    }

    void setFileOrg(int fo) {
        this.fileOrg = fo;
    }

    public boolean isIndexed() {
        return this.fileOrg == 0;
    }

    boolean isSequential() {
        return this.fileOrg == 2;
    }

    boolean isLineSequential() {
        return this.fileOrg == 3;
    }

    public boolean isRelative() {
        return this.fileOrg == 1;
    }

    public int getFieldNum(Field fld) {
        int num = 0;
        Field f = this.fields.getFirst();
        while (f != null) {
            ++num;
            if (f == fld) {
                return num;
            }
            f = this.fields.getNext();
        }
        return num;
    }

    void changeRedefinesFieldInCond() {
        Field newFld = null;
        Field fld = this.fieldsRedefines.getFirst();
        while (fld != null) {
            newFld = null;
            Field flR = this.fields.getFirst();
            while (flR != null && newFld == null) {
                if (fld.xmloffset == flR.xmloffset && fld.xmlsize == flR.xmlsize) {
                    newFld = flR;
                }
                flR = this.fields.getNext();
            }
            if (newFld != null) {
                Condition con = this.conditions.getFirst();
                while (con != null) {
                    if (con.field.equalsIgnoreCase(fld.xmlname)) {
                        con.field = newFld.xmlname;
                        con.condition = con.condition.replaceAll(fld.xmlname, newFld.xmlname);
                    }
                    StringList intFieldCond = new StringList();
                    String str = con.fieldCond.getFirst();
                    while (str != null) {
                        if (str.equalsIgnoreCase(fld.xmlname)) {
                            intFieldCond.addItem(newFld.xmlname);
                            con.condition = con.condition.replaceAll(fld.xmlname, newFld.xmlname);
                        } else {
                            intFieldCond.addItem(str);
                        }
                        str = con.fieldCond.getNext();
                    }
                    con.fieldCond = intFieldCond;
                    Condition conC = con.childsCond.getFirst();
                    while (conC != null) {
                        if (conC.field.equalsIgnoreCase(fld.xmlname)) {
                            conC.field = newFld.xmlname;
                            conC.condition = conC.condition.replaceAll(fld.xmlname, newFld.xmlname);
                        }
                        StringList intFieldCond1 = new StringList();
                        String str2 = conC.fieldCond.getFirst();
                        while (str2 != null) {
                            if (str2.equalsIgnoreCase(fld.xmlname)) {
                                intFieldCond1.addItem(newFld.xmlname);
                                conC.condition = conC.condition.replaceAll(str2, newFld.xmlname);
                            } else {
                                intFieldCond1.addItem(str2);
                            }
                            str2 = conC.fieldCond.getNext();
                        }
                        conC.fieldCond = intFieldCond1;
                        conC = con.childsCond.getNext();
                    }
                    con = this.conditions.getNext();
                }
            }
            fld = this.fieldsRedefines.getNext();
        }
    }
}

