/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.FontAttribute;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Label;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.util.Hashtable;
import java.util.Map;

public abstract class LocalFontCmp {
    private Font font;
    private FontMetrics screenMetrics;
    private FontRenderContext frc;
    private float height;
    private float width;
    private float ascent;
    private float descent;
    private float leading;
    private int cellWidth;
    private int cellHeight;
    private boolean printer;
    protected AbstractGuiFactoryImpl gf;
    private boolean frompe;

    public LocalFontCmp() {
    }

    public LocalFontCmp(AbstractGuiFactoryImpl gf, Hashtable attrs, boolean prn) {
        this.gf = gf;
        this.init(this.createFont(attrs, prn), prn);
    }

    public LocalFontCmp(AbstractGuiFactoryImpl gf, String name, int style, float size, boolean prn) {
        this.gf = gf;
        this.init(this.createFont(name, style, size, prn), prn);
    }

    public LocalFontCmp(AbstractGuiFactoryImpl gf, Font f) {
        this.gf = gf;
        this.init(f, false);
    }

    public LocalFontCmp(AbstractGuiFactoryImpl gf, Font f, boolean prn) {
        this.gf = gf;
        this.init(f, prn);
    }

    private Font createFont(Hashtable attrs, boolean printer) {
        Font Return2;
        attrs = (Hashtable)attrs.clone();
        if (!printer) {
            float size = ((Float)attrs.get(FontAttribute.SIZE)).floatValue();
            if (size < 1.0f) {
                size = 12.0f;
            }
            float pnt = this.pix2pnt(size);
            if (this.gf.shouldRoundFontSize()) {
                pnt = Math.round(pnt);
            }
            attrs.put(FontAttribute.SIZE, new Float(pnt));
        }
        if ((Return2 = this.gf.getAllFonts().get(attrs)) == null) {
            try {
                Return2 = this.intGetFont(attrs);
                this.gf.getAllFonts().put(attrs, Return2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Return2;
    }

    public void addCreatedFont(Font f) {
        this.gf.getCreatedFonts().put(f.getFamily(), f);
    }

    public Font getCreatedFont(String family) {
        return this.gf.getCreatedFonts().get(family);
    }

    private Font createFont(String name, int style, float size, boolean prn) {
        Hashtable<FontAttribute, Object> attrs = new Hashtable<FontAttribute, Object>();
        attrs.put(FontAttribute.FAMILY, name);
        attrs.put(FontAttribute.SIZE, new Float(size));
        if ((style & 1) != 0) {
            attrs.put(FontAttribute.WEIGHT, FontAttribute.WEIGHT_BOLD);
        }
        if ((style & 2) != 0) {
            attrs.put(FontAttribute.POSTURE, FontAttribute.POSTURE_OBLIQUE);
        }
        return this.createFont(attrs, prn);
    }

    private void init(Font f, boolean prn) {
        this.font = f;
        this.printer = prn;
        if (this.printer) {
            this.frc = new FontRenderContext(null, false, true);
            TextLayout tl = new TextLayout("0123456789", this.font, this.frc);
            this.width = tl.getAdvance() / 10.0f;
            this.height = tl.getAscent() + tl.getDescent() + tl.getLeading();
            this.ascent = tl.getAscent();
            this.descent = tl.getDescent();
            this.leading = tl.getLeading();
        } else {
            this.screenMetrics = new Label().getFontMetrics(this.font);
            this.width = this.screenMetrics.stringWidth("0123456789") / 10;
            this.height = this.screenMetrics.getHeight();
            this.ascent = this.screenMetrics.getAscent();
            this.descent = this.screenMetrics.getDescent();
            this.leading = this.screenMetrics.getLeading();
        }
        this.gf.getAllLocalFonts().addElement(this);
    }

    public float computeScreenSizes(String str) {
        if (str == null) {
            return 0.0f;
        }
        if (this.printer) {
            TextLayout tl = new TextLayout(str, this.font, this.frc);
            TextLayout tl10 = new TextLayout("0123456789", this.font, this.frc);
            return tl.getAdvance() * 10.0f / tl10.getAdvance();
        }
        if (this.screenMetrics != null) {
            return (float)this.screenMetrics.stringWidth(str) / this.width;
        }
        return str.length();
    }

    public int computeScreenWidth(String str) {
        if (str == null) {
            return 0;
        }
        if (this.printer) {
            return Math.round(new TextLayout(str, this.font, this.frc).getAdvance());
        }
        if (this.screenMetrics != null) {
            return this.screenMetrics.stringWidth(str);
        }
        return str.length();
    }

    public FontMetrics getFontMetrics() {
        return this.screenMetrics;
    }

    public float computeScreenWidth(float w) {
        return Math.round(w * this.width);
    }

    public int getAscent() {
        return Math.round(this.ascent);
    }

    public int getDescent() {
        return Math.round(this.descent);
    }

    public int getLeading() {
        return Math.round(this.leading);
    }

    public Font getFont() {
        return this.font;
    }

    public int getHeight() {
        return Math.round(this.height);
    }

    public int getWidth() {
        return Math.round(this.width);
    }

    public Map getAttributes() {
        return this.font.getAttributes();
    }

    public String getFamily() {
        return this.font.getFamily();
    }

    public String getName() {
        return this.font.getName();
    }

    public int getSize() {
        if (this.printer) {
            return this.font.getSize();
        }
        return Math.round(this.pnt2pix(this.font.getSize()));
    }

    float pix2pnt(float px) {
        return px * (float)this.gf.getScreenRes() / 72.0f;
    }

    float pnt2pix(float pt) {
        return pt * 72.0f / (float)this.gf.getScreenRes();
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public void setCellWidth(int cellWidth) {
        this.cellWidth = cellWidth;
        if (cellWidth > 0) {
            this.width = cellWidth;
        }
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public void setCellHeight(int cellHeight) {
        this.cellHeight = cellHeight;
        if (cellHeight > 0) {
            this.height = cellHeight;
        }
    }

    public int getStyle() {
        return this.font.getStyle();
    }

    public boolean isBold() {
        return this.font.isBold();
    }

    public boolean isFixedPitch() {
        FontMetrics fm = new Label().getFontMetrics(this.font);
        return fm.charWidth('W') == fm.charWidth('i');
    }

    public boolean isItalic() {
        return this.font.isItalic();
    }

    public boolean isPrinter() {
        return this.printer;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocalFontCmp)) {
            return false;
        }
        LocalFontCmp f = (LocalFontCmp)o;
        return LocalFontCmp.equals(this, f.getName(), f.getStyle(), f.getSize());
    }

    public void setFrompe(boolean b) {
        this.frompe = b;
    }

    public boolean isFrompe() {
        return this.frompe;
    }

    public static boolean equals(LocalFontCmp f, String name, int style, int size) {
        return f.getName().equalsIgnoreCase(name) && f.getStyle() == style && f.getSize() == size;
    }

    public abstract Font intGetFont(Hashtable var1);
}

