/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.client.IRemoteBaseGUIWindow;
import com.iscobol.gui.client.IscobolLayout;
import com.iscobol.gui.client.ScaleLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class ResponsiveLayout
extends ScaleLayout {
    private static final Component DEF_CMP = new Label();
    private static final Map<String, Integer> scaleConstants = new HashMap<String, Integer>();
    private final IRemoteBaseGUIWindow parentWindow;
    private List<Format> formats = new ArrayList<Format>();

    public ResponsiveLayout(Container container) {
        this(container, null, null);
    }

    public ResponsiveLayout(Container container, String settings, IRemoteBaseGUIWindow parentWindow) {
        super(container, ResponsiveLayout.getScaleLayoutDefaults(settings));
        this.parentWindow = parentWindow;
        if (settings != null) {
            int idx = settings.indexOf(59);
            if (idx >= 0) {
                settings = settings.substring(0, idx);
            }
            StringTokenizer st = new StringTokenizer(settings, ",");
            while (st.hasMoreTokens()) {
                String tk = st.nextToken().trim();
                StringTokenizer st2 = new StringTokenizer(tk);
                float minWidth = 1.0f;
                String name = st2.nextToken().trim();
                boolean cells = true;
                idx = name.indexOf(61);
                if (idx > 0) {
                    if (idx < name.length() - 1) {
                        try {
                            minWidth = ResponsiveLayout.parseFloat(name.substring(idx + 1)).floatValue();
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    name = name.substring(0, idx);
                    cells = !st2.hasMoreTokens() || "cells".equalsIgnoreCase(st2.nextToken().trim());
                }
                boolean added = false;
                Format newFrm = new Format(name.toLowerCase(), minWidth, cells);
                for (int i = 0; i < this.formats.size(); ++i) {
                    Format frm = this.formats.get(i);
                    if (frm.name.equalsIgnoreCase(newFrm.name)) {
                        throw new IllegalArgumentException("Duplicate format name: '" + name + "'");
                    }
                    int d = frm.getMinWidth() - newFrm.getMinWidth();
                    if (d == 0) {
                        throw new IllegalArgumentException("Duplicate format minimun width: " + minWidth + (cells ? " cells" : ""));
                    }
                    if (added || d <= 0) continue;
                    this.formats.add(i, newFrm);
                    added = true;
                }
                if (added) continue;
                this.formats.add(newFrm);
            }
            if (this.formats.size() > 0) {
                Format first = this.formats.get(0);
                first.firstLimit = first.minWidth;
                first.minWidth = 1.0f;
            }
        }
    }

    @Override
    public IscobolLayout.LayoutData createLayoutData(Component comp, int maxWidth, int minWidth, int maxHeight, int minHeight, String ld, String controlType) {
        return new ResponsiveLayoutData(comp, maxWidth, minWidth, maxHeight, minHeight, ld, controlType);
    }

    @Override
    public int getAction(String ldString) {
        return new ResponsiveLayoutData(ldString).getAction();
    }

    @Override
    public String getDefaultLayoutDataString(String controltype) {
        int ld = Integer.parseInt(super.getDefaultLayoutDataString(controltype));
        String ldstr = "";
        if ((ld & 1) == 1) {
            ldstr = ldstr + "resize-x ";
        }
        if ((ld & 2) == 2) {
            ldstr = ldstr + "move-x ";
        }
        if ((ld & 4) == 4) {
            ldstr = ldstr + "no-min-x ";
        }
        if ((ld & 0x10) == 16) {
            ldstr = ldstr + "resize-y ";
        }
        if ((ld & 0x20) == 32) {
            ldstr = ldstr + "move-y ";
        }
        if ((ld & 0x40) == 64) {
            ldstr = ldstr + "no-min-y ";
        }
        return ldstr;
    }

    @Override
    protected void layoutContainer(Dimension currContainerSize) {
        Format frm = this.getCurrentFormat(currContainerSize);
        this.containerWidthDelta = (float)currContainerSize.width / (float)this.origContainerSize.width;
        this.containerHeightDelta = (float)currContainerSize.height / (float)this.origContainerSize.height;
        int width = 1;
        if (frm != null) {
            int minW = frm.getMinWidth();
            if (minW > 1) {
                width = minW;
            } else {
                minW = frm.getFirstLimit();
                if (minW > 1 && currContainerSize.width > minW) {
                    width = minW;
                }
            }
        }
        float widthDelta = width > 1 ? (float)currContainerSize.width / (float)width : 1.0f;
        for (Component comp : this.constraintsTable.keySet()) {
            int newHeight;
            int newY;
            int newWidth;
            int w;
            int newX;
            float delta;
            int x;
            ResponsiveLayoutData lData = (ResponsiveLayoutData)this.constraintsTable.get(comp);
            if (lData.noActions) continue;
            Bounds bds = null;
            if (frm != null) {
                bds = lData.getFormatBounds(frm.name);
            }
            if (bds == null) {
                bds = new Bounds();
            }
            if (bds.visible == Boolean.FALSE) {
                comp.setVisible(false);
            } else {
                comp.setVisible(lData.origVisible);
            }
            int action = bds.action > 0 ? bds.action : (bds.action == -1 ? 0 : lData.getAction());
            boolean noMinX = (action & 4) == 4;
            boolean noMinY = (action & 0x40) == 64;
            boolean resizeX = (action & 1) == 1;
            boolean resizeY = (action & 0x10) == 16;
            boolean moveX = (action & 2) == 2;
            boolean moveY = (action & 0x20) == 32;
            Rectangle currCompBounds = comp.getBounds();
            Rectangle ob = lData.getOrigBounds();
            if (bds.x != null) {
                x = bds.getValue(bds.x, bds.cx, true, 0);
                delta = widthDelta;
            } else {
                x = ob.x;
                delta = this.containerWidthDelta;
            }
            if (moveX) {
                newX = (int)((float)x * delta);
                newX = !noMinX ? Math.max(x, newX) : Math.max(0, newX);
            } else {
                newX = x;
            }
            if (bds.w != null) {
                w = bds.getValue(bds.w, bds.cw, true, 0);
                delta = widthDelta;
            } else {
                w = ob.width;
                delta = this.containerWidthDelta;
            }
            if (resizeX) {
                newWidth = (int)((float)w * delta);
                int minWidth = noMinX ? lData.getMinWidth() : w;
                newWidth = Math.max(minWidth, Math.min(lData.getMaxWidth(), newWidth));
            } else {
                newWidth = w;
            }
            delta = this.containerHeightDelta;
            int y = bds.y != null ? bds.getValue(bds.y, bds.cy, false, 0) : ob.y;
            if (moveY) {
                newY = (int)((float)y * delta);
                newY = !noMinY ? Math.max(y, newY) : Math.max(0, newY);
            } else {
                newY = y;
            }
            int h = bds.h != null ? bds.getValue(bds.h, bds.ch, false, 0) : ob.height;
            if (resizeY) {
                newHeight = (int)((float)h * delta);
                int minHeight = noMinY ? lData.getMinHeight() : h;
                newHeight = Math.max(minHeight, Math.min(lData.getMaxHeight(), newHeight));
            } else {
                newHeight = h;
            }
            if (newWidth == currCompBounds.width && newHeight == currCompBounds.height && newX == currCompBounds.x && newY == currCompBounds.y) continue;
            comp.setBounds(newX, newY, newWidth, newHeight);
        }
    }

    private Format getCurrentFormat(Dimension currContainerSize) {
        Format currentFormat = null;
        for (int i = this.formats.size() - 1; i >= 0; --i) {
            int minW = this.formats.get(i).getMinWidth();
            if (minW > currContainerSize.width) continue;
            currentFormat = this.formats.get(i);
            break;
        }
        return currentFormat;
    }

    private static String getScaleLayoutDefaults(String str) {
        int idx;
        if (str == null || (idx = str.indexOf(59)) <= 0 || idx == str.length() - 1) {
            return null;
        }
        return str.substring(idx + 1);
    }

    private static Float parseFloat(String s) throws NumberFormatException {
        if (s.endsWith(",")) {
            s = s.substring(0, s.length() - 1);
        }
        return new Float(s.replace(',', '.'));
    }

    static {
        scaleConstants.put("resize-x", 1);
        scaleConstants.put("move-x", 2);
        scaleConstants.put("no-min-x", 4);
        scaleConstants.put("resize-y", 16);
        scaleConstants.put("move-y", 32);
        scaleConstants.put("no-min-y", 64);
        scaleConstants.put("resize-x-any", 5);
        scaleConstants.put("move-x-any", 6);
        scaleConstants.put("resize-y-any", 80);
        scaleConstants.put("move-y-any", 96);
        scaleConstants.put("resize-both", 17);
        scaleConstants.put("move-both", 34);
        scaleConstants.put("resize-both-any", 85);
        scaleConstants.put("move-both-any", 102);
        scaleConstants.put("no-scale", -1);
    }

    private class Format {
        String name;
        float minWidth;
        boolean cells;
        float firstLimit;

        Format(String n, float w, boolean c) {
            this.name = n;
            this.minWidth = w;
            this.cells = c;
        }

        int getMinWidth() {
            float r = this.cells && ResponsiveLayout.this.parentWindow != null && this.minWidth > 1.0f ? this.minWidth * (float)ResponsiveLayout.this.parentWindow.getCellWidth() : this.minWidth;
            return Math.round(r);
        }

        int getFirstLimit() {
            float r = this.cells && ResponsiveLayout.this.parentWindow != null && this.firstLimit > 1.0f ? this.firstLimit * (float)ResponsiveLayout.this.parentWindow.getCellWidth() : this.firstLimit;
            return Math.round(r);
        }
    }

    public class ResponsiveLayoutData
    extends IscobolLayout.DefaultLayoutData {
        private Map<String, Bounds> formatBounds;
        private final boolean noActions;
        private boolean origVisible;

        private ResponsiveLayoutData(String ldString) {
            this(DEF_CMP, 0, 0, 0, 0, ldString, "");
        }

        public ResponsiveLayoutData(Component comp, int maxWidth, int minWidth, int maxHeight, int minHeight, String ldString, String controltype) {
            super(comp, maxWidth, minWidth, maxHeight, minHeight, ldString, controltype);
            this.origVisible = true;
            this.noActions = "0".equals(ldString);
        }

        @Override
        public void initialize(String ldString, String controltype) {
            Bounds bds;
            StringTokenizer st = new StringTokenizer(ldString, " ,");
            String[] tks = new String[st.countTokens()];
            for (int i = 0; i < tks.length; ++i) {
                tks[i] = st.nextToken();
            }
            int action = 0;
            int visCount = 0;
            int hidCount = 0;
            block9: for (int i = 0; i < tks.length; ++i) {
                String tk = tks[i].trim().toLowerCase();
                if (",".equals(tk)) continue;
                Integer v = (Integer)scaleConstants.get(tk);
                if (v != null) {
                    if (v == -1) {
                        action = -1;
                        continue;
                    }
                    if (action < 0) continue;
                    action += v.intValue();
                    continue;
                }
                for (Format frm : ResponsiveLayout.this.formats) {
                    Bounds bds2;
                    String suffix = "-" + frm.name;
                    if (!tk.endsWith(suffix)) continue;
                    String tk2 = tk.substring(0, tk.length() - suffix.length());
                    if ("visible".equals(tk2)) {
                        this.getFormatBounds((String)frm.name).visible = Boolean.TRUE;
                        ++visCount;
                        continue block9;
                    }
                    if ("hidden".equals(tk2)) {
                        this.getFormatBounds((String)frm.name).visible = Boolean.FALSE;
                        ++hidCount;
                        continue block9;
                    }
                    v = (Integer)scaleConstants.get(tk2);
                    if (v != null) {
                        bds2 = this.getFormatBounds(frm.name);
                        if (v == -1) {
                            bds2.action = -1;
                            continue block9;
                        }
                        if (bds2.action < 0) continue block9;
                        bds2.action += v.intValue();
                        continue block9;
                    }
                    if (i >= tks.length - 1) continue;
                    if ("line".equals(tk2)) {
                        bds2 = this.getFormatBounds(frm.name);
                        ++i;
                        try {
                            bds2.y = ResponsiveLayout.parseFloat(tks[i]);
                            bds2.cy = true;
                            if (i >= tks.length - 1) continue block9;
                            if ("cells".equalsIgnoreCase(tks[i + 1])) {
                                ++i;
                                bds2.cy = true;
                                continue block9;
                            }
                            if (!"pixel".equalsIgnoreCase(tks[i + 1])) continue block9;
                            ++i;
                            bds2.cy = false;
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue block9;
                    }
                    if ("col".equals(tk2) || "column".equals(tk2)) {
                        bds2 = this.getFormatBounds(frm.name);
                        ++i;
                        try {
                            bds2.x = ResponsiveLayout.parseFloat(tks[i]);
                            bds2.cx = true;
                            if (i >= tks.length - 1) continue block9;
                            if ("cells".equalsIgnoreCase(tks[i + 1])) {
                                ++i;
                                bds2.cx = true;
                                continue block9;
                            }
                            if (!"pixel".equalsIgnoreCase(tks[i + 1])) continue block9;
                            ++i;
                            bds2.cx = false;
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue block9;
                    }
                    if ("lines".equals(tk2)) {
                        bds2 = this.getFormatBounds(frm.name);
                        ++i;
                        try {
                            bds2.h = ResponsiveLayout.parseFloat(tks[i]);
                            bds2.ch = true;
                            if (i >= tks.length - 1) continue block9;
                            if ("cells".equalsIgnoreCase(tks[i + 1])) {
                                ++i;
                                bds2.ch = true;
                                continue block9;
                            }
                            if (!"pixel".equalsIgnoreCase(tks[i + 1])) continue block9;
                            ++i;
                            bds2.ch = false;
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue block9;
                    }
                    if (!"size".equals(tk2)) continue;
                    bds2 = this.getFormatBounds(frm.name);
                    ++i;
                    try {
                        bds2.w = ResponsiveLayout.parseFloat(tks[i]);
                        bds2.cw = true;
                        if (i >= tks.length - 1) continue block9;
                        if ("cells".equalsIgnoreCase(tks[i + 1])) {
                            ++i;
                            bds2.cw = true;
                            continue block9;
                        }
                        if (!"pixel".equalsIgnoreCase(tks[i + 1])) continue block9;
                        ++i;
                        bds2.cw = false;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue block9;
                }
            }
            if (action > 0) {
                this.setAction(action);
            } else if (action == -1) {
                this.setAction(0);
            } else {
                this.setAction(Integer.parseInt(ResponsiveLayout.super.getDefaultLayoutDataString(controltype)));
            }
            if (visCount > 0 && hidCount == 0) {
                for (Format frm : ResponsiveLayout.this.formats) {
                    bds = this.getFormatBounds(frm.name);
                    if (bds.visible != null) continue;
                    bds.visible = Boolean.FALSE;
                }
            }
            if (hidCount > 0 && visCount == 0) {
                for (Format frm : ResponsiveLayout.this.formats) {
                    bds = this.getFormatBounds(frm.name);
                    if (bds.visible != null) continue;
                    bds.visible = Boolean.TRUE;
                }
            }
        }

        private Map<String, Bounds> getFormatBoundsTable() {
            if (this.formatBounds == null) {
                this.formatBounds = new HashMap<String, Bounds>();
            }
            return this.formatBounds;
        }

        private Bounds getFormatBounds(String name) {
            Map<String, Bounds> table = this.getFormatBoundsTable();
            Bounds r = table.get(name);
            if (r == null) {
                r = new Bounds();
                table.put(name, r);
            }
            return r;
        }

        public boolean isOrigVisible() {
            return this.origVisible;
        }

        public void setOrigVisible(boolean origVisible) {
            this.origVisible = origVisible;
        }
    }

    private class Bounds {
        Float x;
        Float y;
        Float w;
        Float h;
        boolean cx;
        boolean cy;
        boolean cw;
        boolean ch;
        Boolean visible;
        int action;

        private Bounds() {
        }

        int getValue(Float f, boolean cell, boolean x, int def) {
            if (f != null) {
                float val = f.floatValue() - 1.0f;
                if (cell && ResponsiveLayout.this.parentWindow != null) {
                    return Math.round(val * (float)(x ? ResponsiveLayout.this.parentWindow.getCellWidth() : ResponsiveLayout.this.parentWindow.getCellHeight()));
                }
                return Math.round(val);
            }
            return def;
        }
    }
}

