/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.charva;

import charva.awt.Component;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.IllegalComponentStateException;
import charva.awt.Insets;
import charva.awt.Toolkit;
import charva.awt.event.FocusEvent;
import charva.awt.event.FocusListener;
import charva.awt.event.KeyEvent;
import charva.awt.event.KeyListener;
import com.iscobol.gui.CobolFocusEvent;
import com.iscobol.gui.CobolFocusable;
import com.iscobol.gui.Constants;
import com.iscobol.gui.Events;
import com.iscobol.gui.LocLinkedList;
import com.iscobol.gui.MouseInfo;
import com.iscobol.gui.ParamElementIntString;
import com.iscobol.gui.ParamElementWindowLocation;
import com.iscobol.gui.ParamVector;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.VirtualKeyboard;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.charva.BorderedFrame;
import com.iscobol.gui.client.charva.CobolEventCouple;
import com.iscobol.gui.client.charva.GuiFactoryImpl;
import com.iscobol.gui.client.charva.KeyboardBufferQueue;
import com.iscobol.gui.client.charva.MyKeyEvent;
import com.iscobol.gui.client.charva.RemoteBaseGUIControl;
import com.iscobol.gui.client.charva.RemoteBaseGUIWindow;
import com.iscobol.gui.client.charva.RemoteFrame;
import com.iscobol.gui.client.charva.RemoteSubWindow;
import com.iscobol.gui.client.charva.RemoteTerminalAccept;
import com.iscobol.gui.client.charva.RemoteTerminalDisplay;
import com.iscobol.gui.client.charva.Terminal;
import com.iscobol.gui.client.charva.TerminalAccept;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RemoteDisplayWindow
extends RemoteBaseGUIWindow
implements Constants,
KeyListener {
    private static boolean defaultIcon = true;
    private PicobolTimer pTimer;
    protected int type = -1;
    protected boolean resizable = false;
    protected boolean autoResize = false;
    protected float maxColumns;
    protected float maxLines;
    protected float minColumns;
    protected float minLines;
    protected boolean withSystemMenu;
    protected int fontId = -1;
    protected LocalFontCmp font;
    protected float cellWidth = 1.0f;
    protected float cellHeight = 1.0f;
    public BorderedFrame mainWindow = null;
    protected RemoteDisplayWindow parent;
    private int modalWindowChildren = 0;
    private int foregroundIndex = -1;
    private int backgroundIndex = -1;
    private Rectangle maxBounds;
    private int mouseFlags;
    private RemoteTerminalAccept acceptOmittedField;
    private boolean isinitialized = false;
    private boolean updown_like_prevnext;
    private boolean firstlast_on_screen;
    private int width;
    private int height;
    private LocLinkedList childSubWindow;
    private boolean noCloseStyle;
    private CobolFocusable focusOwner;
    private CobolFocusable previousFocusOwner;
    private Hashtable mnemonicTable = new Hashtable();
    private boolean firstActivation = true;
    private boolean visible = true;
    private boolean hasLayout;
    private Component componentfoo;
    private boolean acceptbeforetimerepeat;
    private long beforetimehs = -1L;
    private CobolFocusable newLocalFocusOwner;
    private ParamVector oldfocusvalues;
    private Hashtable oldfocushnd;
    private RemoteSubWindow rswcurrent;
    public static final int TITLE_TOP_LEFT = 1;
    public static final int TITLE_TOP_CENTER = 2;
    public static final int TITLE_TOP_RIGHT = 3;
    public static final int TITLE_BOTTOM_LEFT = 4;
    public static final int TITLE_BOTTOM_CENTER = 5;
    public static final int TITLE_BOTTOM_RIGHT = 6;
    public static final int TITLE_FULL_CENTER = 7;
    private static final int INVALID_COOR = -99999;

    public RemoteDisplayWindow(Events evs, GuiFactoryImpl gf, int t, int pwId) {
        super(gf);
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (tk.hasColors()) {
            tk.startColors();
        }
        this.initW(evs, t, pwId);
        this.childSubWindow = new LocLinkedList();
        this.componentfoo = new TerminalAccept(gf);
        this.componentfoo.setBounds(0, 0, 1, 1);
        this.updown_like_prevnext = gf.getCsProperty().get("iscobol.keystroke.updown_like_prevnext", false);
        this.firstlast_on_screen = gf.getCsProperty().get("iscobol.keystroke.firstlast_on_screen", false);
    }

    public void setId(int wId) {
        this.theObject = wId;
    }

    public int getId() {
        return this.theObject;
    }

    public void setFocusOwner(CobolFocusable cf) {
        if (this.focusOwner != null) {
            this.previousFocusOwner = this.focusOwner;
        }
        this.focusOwner = cf;
    }

    public CobolFocusable getFocusOwner() {
        return this.focusOwner;
    }

    public CobolFocusable getPreviousFocusOwner() {
        return this.previousFocusOwner;
    }

    @Override
    public void addMnemonic(char c, RemoteBaseGUIControl comp) {
        this.mnemonicTable.put(new Character(Character.toUpperCase(c)), comp);
    }

    @Override
    public void removeMnemonic(RemoteBaseGUIControl comp) {
        Object[] keys = this.mnemonicTable.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            if (this.mnemonicTable.get(keys[i]) != comp) continue;
            this.mnemonicTable.remove(keys[i]);
        }
    }

    public void removeMnemonic(char c, RemoteBaseGUIControl comp) {
        Object[] keys = this.mnemonicTable.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            if (((Character)keys[i]).charValue() != Character.toUpperCase(c) || this.mnemonicTable.get(keys[i]) != comp) continue;
            this.mnemonicTable.remove(keys[i]);
        }
    }

    public RemoteBaseGUIControl getMnemonic(char c) {
        return (RemoteBaseGUIControl)this.mnemonicTable.get(new Character(Character.toUpperCase(c)));
    }

    public void checkMnemonic(KeyEvent evt) {
    }

    @Override
    public void clearFocusOwner() {
        if (this.focusOwner != null) {
            this.previousFocusOwner = this.focusOwner;
            this.focusOwner.processCobolFocusEvent(new CobolFocusEvent(this.focusOwner, null, 1, false));
            this.focusOwner = null;
        }
        this.isonexceptionaccept = false;
    }

    public MouseInfo getMouseStatus() {
        int lastX = KeyboardBufferQueue.getInstance().getLastCursorX();
        int lastY = KeyboardBufferQueue.getInstance().getLastCursorY();
        int lastRow = 0;
        int lastCol = 0;
        if (lastX >= 0 && lastY >= 0) {
            lastCol = lastX * 100 / this.getCellWidth() + 100;
            lastRow = lastY * 100 / this.getCellHeight() + 100;
        }
        return new MouseInfo(lastRow, lastCol, lastY + 1, lastX + 1, KeyboardBufferQueue.getInstance().isLeftButtonDown(), KeyboardBufferQueue.getInstance().isMiddleButtonDown(), KeyboardBufferQueue.getInstance().isRightButtonDown());
    }

    private void initW(Events evs, int t, int pwId) {
        this.type = t;
        this.events = evs;
        this.parent = (RemoteDisplayWindow)this.gf.getClient().getId(pwId);
        BorderedFrame borderedFrame = this.mainWindow = this.parent != null ? new BorderedFrame(this, this.parent.getMainWindow(), this.type) : new BorderedFrame(this, null, this.type);
        if (this.mainWindow.getPanel() != null) {
            this.addwlistener();
        }
    }

    void addwlistener() {
        this.mainWindow.getPanel().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent fe) {
            }

            public void focusLost(FocusEvent fe) {
            }
        });
        this.mainWindow.getPanel().addKeyListener((KeyListener)this);
    }

    public void keyTyped(KeyEvent evt) {
        this.keyPressed(evt);
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyPressed(KeyEvent evt) {
        this.stopTimer();
        Object cc = null;
        MyKeyEvent eawt = new MyKeyEvent();
        eawt.setKeyChar(evt.getKeyChar());
        eawt.setKeyCode(evt.getKeyCode());
        int cobFun = this.gf.getMyRemoteVirtualKeyboard().mapKey(eawt);
        if ((cobFun & 0x300000) == 0x300000) {
            return;
        }
        if (this.mainWindow != null) {
            if (VirtualKeyboard.isHotkey(cobFun)) {
                this.mainWindow.push(new CobolEventCouple(this, RemoteRecordAccept.getHotkeyEvent(cobFun, false, this.gf.getMyRemoteVirtualKeyboard().getHotKey(cobFun, false, false, false))));
            } else if (VirtualKeyboard.isException(cobFun)) {
                RemoteRecordAccept rra = new RemoteRecordAccept(4, VirtualKeyboard.exception(cobFun), 0, true, true);
                rra.setWait(false);
                this.mainWindow.push(new CobolEventCouple(this, rra));
            } else if (VirtualKeyboard.isTermination(cobFun)) {
                this.mainWindow.push(new CobolEventCouple(this, new RemoteRecordAccept(3, VirtualKeyboard.termination(cobFun), 0, true, false)));
            }
        }
    }

    @Override
    public boolean isMainApplicationWindow() {
        return this.type == 3 || this.type == 6;
    }

    public BorderedFrame getMainWindow() {
        return this.mainWindow;
    }

    @Override
    public int setFont(String name, int style, int size) {
        return this.fontId;
    }

    @Override
    public void setFont(int fi) {
    }

    @Override
    public Insets getInsets() {
        if (this.mainWindow != null) {
            return this.mainWindow.getInsets();
        }
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public void setLocation(int x, int y) {
        if (this.mainWindow != null) {
            this.mainWindow.setLocation(x, y);
        }
    }

    @Override
    public void setDefaultLocation(int ownerWindowID) {
        int startY;
        RemoteDisplayWindow rw = (RemoteDisplayWindow)this.gf.getClient().getId(ownerWindowID);
        if (rw == null || rw.mainWindow == null || this.mainWindow == null) {
            return;
        }
        Rectangle rwBounds = rw.mainWindow.getBounds();
        Dimension sz = this.mainWindow.getSize();
        int startX = rwBounds.x + (rwBounds.width - sz.width) / 2;
        if (startX < 0) {
            startX = 0;
        }
        if ((startY = rwBounds.y + (rwBounds.height - sz.height) / 2) < 0) {
            startY = 0;
        }
        this.mainWindow.setLocation(startX, startY);
    }

    @Override
    public void setSize(float cols, float lines) {
        if (this.mainWindow == null) {
            return;
        }
        this.width = (int)(cols * (float)this.getCellWidth());
        this.height = (int)(lines * (float)this.getCellHeight());
        boolean isresized = this.mainWindow.isResizable();
        this.mainWindow.setResizable(true);
        this.mainWindow.setInitD(this.width, this.height, cols, lines, this.font);
        this.mainWindow.setResizable(isresized);
        if (this.autoResize) {
            if (this.maxColumns == 0.0f) {
                this.maxColumns = cols;
            }
            if (this.maxLines == 0.0f) {
                this.maxLines = lines;
            }
        }
    }

    @Override
    public void remove(int controlID) {
        this.remove(controlID, true);
    }

    @Override
    public void remove(int controlID, boolean wait) {
        Object o = this.gf.getClient().getId(controlID);
        if (o instanceof RemoteBaseGUIControl) {
            RemoteBaseGUIControl comp = (RemoteBaseGUIControl)o;
            if (this.mainWindow != null) {
                try {
                    Container c = this.mainWindow.getPanel();
                    if (c.getComponentCount() == 1 && c.getCurrentFocus() != null && c.getCurrentFocus() == (Component)comp.getComponent()) {
                        c.add(this.componentfoo);
                    }
                    c.remove((Component)comp.getComponent());
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    // empty catch block
                }
            }
            if (this.childGraphics != null) {
                this.childGraphics.remove(comp.getComponent());
            }
        }
    }

    @Override
    public void close(int controlID, boolean nodisp) {
        Object o = this.gf.getClient().getId(controlID);
        if (o != null && o instanceof RemoteSubWindow) {
            ((RemoteSubWindow)o).restorePopupArea(nodisp);
            ((RemoteSubWindow)o).destroy();
        }
    }

    private static int getZOrder(RemoteBaseGUIControl rbgc) {
        if (rbgc.isInputField()) {
            return 1;
        }
        return 2;
    }

    private static boolean contains(RemoteBaseGUIControl rbgc1, RemoteBaseGUIControl rbgc2) {
        return false;
    }

    private void addchild(RemoteBaseGUIControl rbgc) {
        if (rbgc instanceof RemoteTerminalDisplay && !rbgc.isInputField() || rbgc.getType() == "statusbar") {
            return;
        }
        int index = 0;
        if (!(rbgc instanceof RemoteFrame) && this.mainWindow != null && this.mainWindow.getPanel() != null) {
            this.mainWindow.getPanel().add((Component)rbgc.getComponent(), (Object)new Integer(index));
            Component[] controls = this.mainWindow.getPanel().getComponents();
            for (int i = 0; i < controls.length - 1; ++i) {
                if (controls[i] != this.componentfoo) continue;
                this.mainWindow.getPanel().remove(this.componentfoo);
            }
        }
        if (rbgc.isInputField() && !this.isinitialized) {
            this.isinitialized = true;
            if (this.mainWindow != null) {
                this.mainWindow.internalsetVisible(true);
            }
        }
        if (this.childGraphics != null) {
            this.childGraphics.put(rbgc.getComponent(), rbgc);
        }
    }

    @Override
    public void add(int controlID) {
        Object o = this.gf.getClient().getId(controlID);
        if (o instanceof RemoteBaseGUIControl) {
            RemoteBaseGUIControl comp = (RemoteBaseGUIControl)o;
            this.addchild(comp);
        } else if (o instanceof RemoteSubWindow) {
            RemoteSubWindow comp = (RemoteSubWindow)o;
            this.childSubWindow.addLast(o);
        }
    }

    @Override
    public void add(int controlID, int index) {
        RemoteBaseGUIControl comp = (RemoteBaseGUIControl)this.gf.getClient().getId(controlID);
        this.addchild(comp);
    }

    @Override
    public void setActiveWindow(boolean a) {
        this.activeWindow = a;
        if (this.mainWindow != null) {
            this.mainWindow.setActive(a);
        }
    }

    @Override
    public void setTitle(String t) {
        if (this.mainWindow != null) {
            this.mainWindow.setTitle(t);
        }
    }

    @Override
    public void setTitlePosition(int t) {
    }

    @Override
    public void setBackground(int r, int b, int g) {
        if (this.mainWindow != null) {
            Color newC = new Color(r, g, b);
            this.mainWindow.setBackground(newC);
        }
    }

    @Override
    public void setBackgroundIdx(int idx) {
        this.setBackgroundIdx(idx, false);
    }

    @Override
    public void setBackgroundIdx(int idx, boolean issubwin) {
        Color newC;
        if (this.mainWindow != null && (newC = this.gf.getRemotePalette().getDefaultColor(idx)) != null) {
            this.backgroundIndex = idx;
            if (!issubwin) {
                this.mainWindow.setBackground(newC);
            } else {
                Terminal charTerminal = this.mainWindow.getCharTerminal();
                charTerminal.setBackColor(new charva.awt.Color(newC.getRed(), newC.getGreen(), newC.getBlue()));
            }
        }
    }

    @Override
    public void setForeground(int r, int b, int g) {
        if (this.mainWindow != null) {
            Color newC = new Color(r, g, b);
            this.mainWindow.setForeground(newC);
        }
    }

    @Override
    public void setForegroundIdx(int idx) {
        this.setForegroundIdx(idx, false);
    }

    @Override
    public void setForegroundIdx(int idx, boolean issubwin) {
        Color newC;
        if (this.mainWindow != null && (newC = this.gf.getRemotePalette().getDefaultColor(idx)) != null) {
            this.foregroundIndex = idx;
            if (!issubwin) {
                this.mainWindow.setForeground(newC);
            } else {
                Terminal charTerminal = this.mainWindow.getCharTerminal();
                charTerminal.setForeColor(new charva.awt.Color(newC.getRed(), newC.getGreen(), newC.getBlue()));
            }
        }
    }

    @Override
    public void setScreenSize(int size) {
    }

    public int getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (this.childGraphics != null) {
            Hashtable hashtable = this.childGraphics;
            synchronized (hashtable) {
                Enumeration ctlLI = this.childGraphics.elements();
                while (ctlLI.hasMoreElements()) {
                    RemoteBaseGUIControl ctl = (RemoteBaseGUIControl)ctlLI.nextElement();
                    ctl.destroy();
                }
            }
        }
        this.gf.getClient().delId(this.terminalDisplayGateId);
        if (this.parent != null && this.mainWindow != null && this.mainWindow.isModal()) {
            --this.parent.modalWindowChildren;
        }
        if (this.mainWindow != null) {
            this.mainWindow.dispose();
            this.mainWindow = null;
        }
        this.events = null;
    }

    @Override
    public void toFront() {
    }

    @Override
    public Rectangle getMainBounds() {
        if (this.mainWindow == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return this.mainWindow.getBounds();
    }

    @Override
    public Rectangle getBounds() {
        if (this.mainWindow == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle Return2 = new Rectangle();
        return Return2;
    }

    @Override
    public Color getBackground() {
        return null;
    }

    @Override
    public int getBackgroundIdx() {
        return this.backgroundIndex;
    }

    @Override
    public boolean getBoxed() {
        return false;
    }

    @Override
    public int getFont() {
        LocalFontCmp tmpfont = (LocalFontCmp)this.gf.getClient().getId(this.fontId);
        if (tmpfont != null) {
            this.fontId = 0;
        }
        return this.fontId;
    }

    @Override
    public Color getForeground() {
        return null;
    }

    @Override
    public int getForegroundIdx() {
        return this.foregroundIndex;
    }

    public int getTheObjectId() {
        return this.theObject;
    }

    @Override
    public String getTitle() {
        if (this.mainWindow == null) {
            return "";
        }
        return this.mainWindow.getTitle();
    }

    @Override
    public boolean getWrap() {
        return false;
    }

    @Override
    public boolean isGraphical() {
        return false;
    }

    @Override
    public void setAutoResize(boolean as) {
        this.autoResize = as;
        if (this.mainWindow != null) {
            this.mainWindow.setAutoResize(as);
        }
    }

    public boolean getAutoResize() {
        return this.autoResize;
    }

    @Override
    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    @Override
    public void setMaxSize(int maxSize) {
        this.maxColumns = maxSize;
    }

    @Override
    public void setMinLines(int minLines) {
        this.minLines = minLines;
    }

    @Override
    public void setMinSize(int minSize) {
        this.minColumns = minSize;
    }

    @Override
    public void setPopupArea() {
    }

    @Override
    public void setResizable(boolean r) {
        this.resizable = r;
        if (this.mainWindow != null) {
            this.mainWindow.setResizable(r);
        }
    }

    public boolean getResizable() {
        return this.resizable;
    }

    @Override
    public void setScroll(boolean s) {
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.mainWindow != null) {
            this.mainWindow.setEnabled(b);
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.mainWindow != null) {
            return this.mainWindow.isEnabled();
        }
        return false;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            if (!this.visible) {
                this.firstActivation = true;
            }
            if (this.maxBounds == null) {
                this.setMaximizedBounds();
            }
        }
        this.visible = b;
        if (this.mainWindow != null) {
            this.mainWindow.setVisible(b);
        }
    }

    private void setMaximizedBounds() {
    }

    @Override
    public void setWithSystemMenu(boolean b) {
        this.withSystemMenu = b;
    }

    @Override
    public int getCellHeight() {
        if (this.cellHeight < 1.0f) {
            return 1;
        }
        return (int)this.cellHeight;
    }

    @Override
    public int getCellWidth() {
        if (this.cellWidth < 1.0f) {
            return 1;
        }
        return (int)this.cellWidth;
    }

    @Override
    public void setCellHeight(float ch) {
    }

    @Override
    public void setCellWidth(float cw) {
    }

    @Override
    public void setCellWidth(String fontName, int fontStyle, int fontSize) {
    }

    @Override
    public void setCellHeight(String fontName, int fontStyle, int fontSize) {
    }

    @Override
    public void setMouseFlags(int mf) {
        this.mouseFlags = mf;
    }

    @Override
    public int getMouseFlags() {
        return this.mouseFlags;
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra) {
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra, boolean foo) {
    }

    @Override
    public boolean isInitialized() {
        return this.mainWindow != null;
    }

    void addParentModalChildrenCount() {
        if (this.parent != null) {
            ++this.parent.modalWindowChildren;
        }
    }

    void removeParentModalChildrenCount() {
        if (this.parent != null && this.parent.modalWindowChildren > 0) {
            --this.parent.modalWindowChildren;
        }
    }

    @Override
    public void setModal(boolean m) {
        if (this.type == 5 && this.mainWindow != null) {
            this.mainWindow.setModal(m);
        }
    }

    @Override
    public void setStyle(int s) {
        if (s == 157) {
            this.noCloseStyle = true;
        }
    }

    @Override
    public void setAction(float cv) {
    }

    @Override
    public void setTitleBar(boolean b) {
        if (this.mainWindow != null) {
            this.mainWindow.setTitleBar(b);
        }
    }

    @Override
    public void startTimer(long hSeconds) {
        this.pTimer = new PicobolTimer(hSeconds);
        this.pTimer.start();
    }

    public void stopTimer() {
        if (this.pTimer != null && !this.pTimer.isInterrupted()) {
            this.pTimer.interrupt();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private void buildOmitted() {
        if (this.acceptOmittedField == null && this.mainWindow != null && this.mainWindow.getPanel() != null) {
            this.acceptOmittedField = new RemoteTerminalAccept(this.gf);
            this.acceptOmittedField.setSize(0, 0);
            this.acceptOmittedField.setLocation(0, 0);
            this.acceptOmittedField.setParentWindow(this.getId());
            this.acceptOmittedField.initialize();
            ((TerminalAccept)this.acceptOmittedField.getComponent()).repaint();
            this.mainWindow.getPanel().add((Component)this.acceptOmittedField.getComponent());
            if (!this.isinitialized) {
                this.isinitialized = true;
                this.mainWindow.internalsetVisible(true);
            }
            this.acceptOmittedField.getComponent().requestFocus();
        }
    }

    @Override
    public void requestFocus() {
        this.buildOmitted();
        if (this.focusOwner == null && this.mainWindow != null) {
            this.mainWindow.getCharTerminal().repaint();
        }
        this.clearFocusOwner();
        if (this.acceptOmittedField != null && this.acceptOmittedField.getComponent() != null) {
            this.acceptOmittedField.getComponent().requestFocus();
        }
    }

    @Override
    public void setIcon(int id) {
    }

    @Override
    public void unsetStyle(int s) {
    }

    @Override
    public void setActiveAccept(boolean a) {
        if (this.mainWindow != null) {
            if (!a) {
                this.stopTimer();
                Container c = null;
                if (this.mainWindow != null && this.mainWindow.getPanel() != null && (c = this.mainWindow.getPanel()) != null) {
                    if (this.acceptOmittedField != null) {
                        try {
                            this.mainWindow.getPanel().remove((Component)this.acceptOmittedField.getComponent());
                        }
                        catch (IllegalComponentStateException illegalComponentStateException) {
                            // empty catch block
                        }
                    }
                    this.acceptOmittedField = null;
                }
            }
            this.mainWindow.setActiveAccept(a);
        }
    }

    @Override
    public boolean isActiveAccept() {
        if (this.mainWindow != null) {
            return this.mainWindow.isActiveAccept();
        }
        return false;
    }

    @Override
    public void erase(int flg, int col, int line, charva.awt.Color bgColor) {
        if (this.mainWindow != null) {
            this.mainWindow.erase(flg, col, line, bgColor);
        }
    }

    @Override
    public void display(String str, boolean eol) {
        if (this.mainWindow != null) {
            this.mainWindow.display(str, eol);
        }
    }

    private void setLocation(int x, int y, ParamElementWindowLocation pwl) {
        int l = -99999;
        int c = -99999;
        if (x != -99999 && y != -99999) {
            c = x;
            l = y;
        } else {
            Rectangle myBounds = this.getMainBounds();
            c = x == -99999 ? myBounds.x : x;
            l = y == -99999 ? myBounds.y : y;
        }
        if (!pwl.changescreenlc && pwl.parentid != -1) {
            RemoteDisplayWindow rw = (RemoteDisplayWindow)this.gf.getClient().getId(pwl.parentid);
            Rectangle rwBounds = rw.getMainBounds();
            Insets is = rw.getInsets();
            this.setLocation(rwBounds.x + c + is.left, (int)((float)(rwBounds.y + l + is.top) + pwl.toolbarsheight));
        } else {
            this.setLocation(c, l);
        }
    }

    private void setDefaultLocation(ParamElementWindowLocation pwl) {
        if (pwl.parentid != -1) {
            this.setDefaultLocation(pwl.parentid);
            Rectangle mainBounds = this.getMainBounds();
            pwl.screenline = mainBounds.y;
            pwl.screencolumn = mainBounds.x;
        }
    }

    @Override
    public void paramsetLocation(ParamElementWindowLocation pwl) {
        float l = -99999.0f;
        float c = -99999.0f;
        if (pwl.changescreenlc) {
            l = pwl.screenline;
            c = pwl.screencolumn;
        }
        if (l == -99999.0f && c == -99999.0f) {
            l = pwl.getatline;
            c = pwl.getatcolumn;
            if (l != -99999.0f || c != -99999.0f) {
                if (l != -99999.0f) {
                    l -= 1.0f;
                    l *= (float)this.getCellHeight();
                }
                if (c != -99999.0f) {
                    c -= 1.0f;
                    c *= (float)this.getCellWidth();
                }
            }
        }
        if (l != -99999.0f || c != -99999.0f) {
            this.setLocation((int)(c + pwl.add_sub_columns), (int)(l + pwl.add_sub_lines), pwl);
        } else if (pwl.firstdisplay && pwl.screenline == -99999.0f && pwl.screencolumn == -99999.0f) {
            this.setDefaultLocation(pwl);
        }
    }

    @Override
    public int[] componentgetControlSamePosition(RemoteBaseGUIControl rbgc) {
        if (this.mainWindow != null) {
            return this.getControlSamePosition(rbgc, this.mainWindow.getPanel());
        }
        return null;
    }

    @Override
    public int[] componentsetErase(int flgerase, int col, int row, charva.awt.Color bgColor, int[] fieldsid) {
        return this.setErase(this.mainWindow.getPanel(), flgerase, col, row, bgColor, fieldsid);
    }

    @Override
    protected void repaintTerminal(Component cc) {
        if (this.mainWindow != null) {
            super.repaintTerminal(this.mainWindow.getCharTerminal());
        }
    }

    public void chrepaintD() {
        if (this.mainWindow != null && this.mainWindow.getCharTerminal() != null) {
            this.mainWindow.getCharTerminal().chrepaintD();
        }
    }

    public void chrepaint() {
        if (this.mainWindow != null && this.mainWindow.getCharTerminal() != null) {
            this.mainWindow.getCharTerminal().chrepaint();
        }
    }

    @Override
    public int[] componentsetEraseArea(int[] limit) {
        return this.componentsetEraseArea(limit, true);
    }

    public int[] componentsetEraseArea(int[] limit, boolean ismain) {
        if (this.mainWindow != null && this.mainWindow.getPanel() != null && this.mainWindow.getCharTerminal() != null && this.mainWindow.getCharTerminal().getTerminalModel() != null) {
            this.mainWindow.getCharTerminal().getTerminalModel().clrarea(limit[1], limit[2], limit[3], limit[4]);
            this.mainWindow.getCharTerminal().repaint();
            this.mainWindow.getCharTerminal().chrepaint();
            return this.setEraseArea(this.mainWindow.getPanel(), limit, ismain);
        }
        return null;
    }

    @Override
    public void componentsetScroll(int flg, int col, int line) {
        if (this.mainWindow != null) {
            this.mainWindow.scroll(flg, col, line);
        }
    }

    @Override
    public String acceptFromScreen(int line, int col, int size) {
        if (this.mainWindow != null) {
            return this.mainWindow.getCharTerminal().acceptFromScreen(line, col, size);
        }
        return "";
    }

    @Override
    public String attrFromScreen(int line, int col, int size) {
        if (this.mainWindow != null) {
            return this.mainWindow.getCharTerminal().attrFromScreen(line, col, size);
        }
        return "";
    }

    @Override
    public void writeToScreen(int line, int col, int size, String chr, String atr) {
        if (this.mainWindow != null) {
            this.mainWindow.getCharTerminal().writeToScreen(line, col, size, chr, atr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Integer srvheadid) {
        if (this.childGraphics != null && this.childGraphics.contains(srvheadid)) {
            Hashtable hashtable = this.childGraphics;
            synchronized (hashtable) {
                this.childGraphics.remove(srvheadid);
            }
        }
    }

    @Override
    public void enableKeyboard() {
        if (this.mainWindow == null) {
            return;
        }
        if (this.focusOwner != null) {
            RemoteBaseGUIControl rbgc = (RemoteBaseGUIControl)this.focusOwner;
            rbgc.setCursorValue(this);
        }
        KeyboardBufferQueue.getInstance().enable(this.mainWindow.getMFWindow());
        this.mainWindow.resumeRunBody();
    }

    @Override
    public void disableKeyboard() {
        KeyboardBufferQueue.getInstance().disable();
    }

    public boolean haveDefaultIcon() {
        return defaultIcon;
    }

    public static void setDefaultIcon(boolean b) {
        defaultIcon = b;
    }

    @Override
    public void destroyChild(Vector destroyvect) {
        boolean dorepaint = destroyvect != null && destroyvect.size() > 0;
        super.destroyChild(destroyvect);
    }

    @Override
    public int getLastFocusOwnerID() {
        if (this.previousFocusOwner != null) {
            return ((RemoteBaseGUIControl)this.previousFocusOwner).getServerId();
        }
        return 0;
    }

    @Override
    protected void endAcceptOmitted() {
    }

    @Override
    protected void endAccept() {
        if (this.mainWindow == null || this.mainWindow.getPanel() == null) {
            return;
        }
        Component[] controls = this.mainWindow.getPanel().getComponents();
        if (controls.length == 0) {
            this.buildOmitted();
        } else if (controls.length > 1) {
            this.removeComponentFoo();
        }
    }

    public ParamVector getOldFocusValues() {
        return this.oldfocusvalues;
    }

    public void resetOldFocusValues() {
        this.oldfocusvalues = null;
        if (this.oldfocushnd != null) {
            this.oldfocushnd.clear();
        }
        this.oldfocushnd = null;
    }

    public void setNewLocalFocusOwner(RemoteBaseGUIControl currfocus, CobolFocusable cf) {
        this.newLocalFocusOwner = cf;
        if (currfocus != null && currfocus.getActiveAccept() && currfocus.isInputField()) {
            ParamElementIntString peis = null;
            if (this.oldfocusvalues == null) {
                this.oldfocusvalues = new ParamVector();
                this.oldfocushnd = new Hashtable();
            }
            this.removeFocusInOldValues(currfocus.getServerId());
            if (currfocus.getValue() != null) {
                peis = new ParamElementIntString(1042, currfocus.getServerId(), currfocus.getValue());
                this.oldfocusvalues.add(peis);
                this.oldfocushnd.put(new Integer(currfocus.getServerId()), peis);
            }
        }
        this.setFocusOwner(cf);
    }

    public void removeFocusInOldValues(int sid) {
        if (this.oldfocusvalues != null && this.oldfocushnd != null) {
            Integer srvid = new Integer(sid);
            ParamElementIntString peis = null;
            peis = (ParamElementIntString)this.oldfocushnd.get(srvid);
            if (peis != null) {
                this.oldfocushnd.remove(srvid);
                this.oldfocusvalues.remove(peis);
            }
        }
    }

    public RemoteBaseGUIControl getNewLocalFocusOwner() {
        return (RemoteBaseGUIControl)this.newLocalFocusOwner;
    }

    public void resetNewLocalFocusOwner() {
        this.newLocalFocusOwner = null;
    }

    @Override
    protected void addComponentFoo() {
        if (this.mainWindow == null) {
            return;
        }
        try {
            Container c = this.mainWindow.getPanel();
            if (c != null) {
                c.add(this.componentfoo);
            }
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    @Override
    protected void removeComponentFoo() {
        if (this.mainWindow == null) {
            return;
        }
        try {
            Container c = this.mainWindow.getPanel();
            if (c != null) {
                c.remove(this.componentfoo);
            }
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    @Override
    public Dimension getCharDim() {
        if (this.mainWindow != null && this.mainWindow.getCharTerminal() != null) {
            return this.mainWindow.getCharTerminal().getCharDim();
        }
        return new Dimension(0, 0);
    }

    public void removeChildSubWindow(RemoteSubWindow rsw) {
        if (this.childSubWindow != null && this.childSubWindow.contains(rsw)) {
            this.childSubWindow.remove(rsw);
            if (rsw == this.rswcurrent) {
                this.rswcurrent = null;
            }
        }
    }

    public boolean getUpdownLikePrevnext() {
        return this.updown_like_prevnext;
    }

    public boolean getFirstLastOnScreen() {
        return this.firstlast_on_screen;
    }

    public void setCurrentSW(RemoteSubWindow rsw) {
        this.rswcurrent = rsw;
    }

    public RemoteSubWindow getCurrentSW() {
        return this.rswcurrent;
    }

    private class PicobolTimer
    extends Thread {
        private long delay;

        public PicobolTimer(long h_seconds) {
            this.delay = h_seconds * 10L;
        }

        @Override
        public void run() {
            try {
                PicobolTimer.sleep(this.delay);
                if (RemoteDisplayWindow.this.mainWindow != null) {
                    RemoteDisplayWindow.this.mainWindow.pushWithPriority(new CobolEventCouple(RemoteDisplayWindow.this, new RemoteRecordAccept(19, 90000, 0)));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

