/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.charva;

import charva.awt.Color;
import charva.awt.Component;
import charva.awt.Dimension;
import charva.awt.Rectangle;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.Justification;
import com.iscobol.gui.client.charva.Graphics;
import com.iscobol.gui.client.charva.TerminalModel;
import java.awt.Font;
import java.awt.Point;

public class Terminal
extends Component {
    private TerminalModel tm;
    private boolean notEmpty;
    private Graphics g;
    private int cols;
    private int lines;
    private Dimension charDim;
    AbstractGuiFactoryImpl gf;

    public Terminal(AbstractGuiFactoryImpl gf) {
        this.gf = gf;
        this.tm = new TerminalModel(gf);
    }

    private void init() {
        try {
            Class[] params = new Class[]{Boolean.TYPE};
            Terminal.class.getMethod("setFocusable", params).invoke((Object)this, new Boolean(true));
            Terminal.class.getMethod("setFocusTraversalKeysEnabled", params).invoke((Object)this, new Boolean(false));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.g = new Graphics();
    }

    public void init(float colf, float linef, int w, int h) {
        this.cols = (int)Math.ceil(colf);
        this.lines = (int)Math.ceil(linef);
        this.init();
        this.charDim = new Dimension();
        this.charDim.width = w / this.cols;
        this.charDim.height = h / this.lines;
        if (w % this.cols > this.cols / 2) {
            ++this.charDim.width;
        }
        if (h % this.lines > this.lines / 2) {
            ++this.charDim.height;
        }
        this.tm.init(this.cols, this.lines, this.charDim);
    }

    public boolean moveAt(int col, int line) {
        return this.tm.move(col, line);
    }

    public Rectangle display(int col, int line, String data, int size, Color fore, int attrs, Color back, Justification j) {
        this.notEmpty = true;
        if (this.moveAt(col, line)) {
            this.repaint();
        }
        return this.tm.addstr(j.get(data, size), size, fore, attrs, back);
    }

    public TerminalModel getTerminalModel() {
        this.notEmpty = true;
        return this.tm;
    }

    public Dimension getPreferredSize() {
        return this.tm.getPreferredSize();
    }

    public void repaint() {
        if (this.notEmpty) {
            this.tm.paint(this.g);
        } else {
            super.repaint();
        }
    }

    public void repaint(int sx, int ex, int y) {
        if (this.notEmpty) {
            this.tm.paint(this.g, sx, ex, y);
        } else {
            super.repaint();
        }
    }

    public void setBackground(int x, int y, int w, int h, Color c) {
        this.tm.setBackground(x, y, w, h, c);
    }

    public void setForeground(int x, int y, int w, int h, Color c, int attr) {
        this.tm.setForeground(x, y, w, h, c, attr);
    }

    public void setBackground(Color c) {
        this.tm.setBackground(c);
        super.setBackground(c);
    }

    public void setBackColor(Color c) {
        this.tm.setBackColor(c);
    }

    public void setForeColor(Color c) {
        this.tm.setForeColor(c);
    }

    public String acceptFromScreen(int line, int col, int size) {
        return this.tm.acceptFromScreen(line, col, size);
    }

    public String attrFromScreen(int line, int col, int size) {
        return this.tm.attrFromScreen(line, col, size);
    }

    public void writeToScreen(int line, int col, int size, String chr, String atr) {
        this.tm.writeToScreen(line, col, size, chr, atr);
    }

    public void changeWidth(int nw) {
        this.tm.changeWidth(nw);
    }

    public Graphics getGraphics() {
        return this.g;
    }

    public void debug(int i) {
    }

    public Dimension minimumSize() {
        return this.getSize();
    }

    public int getHeight() {
        return this.lines;
    }

    public int getWidth() {
        return this.cols;
    }

    public Dimension getSize() {
        return new Dimension(this.cols, this.lines);
    }

    public void draw() {
    }

    public void setFont(Font d) {
    }

    public void setLocation(Point d) {
    }

    public void end() {
        this.tm.end();
        this.tm = null;
        this.gf = null;
    }

    public Dimension getCharDim() {
        return this.charDim;
    }

    public void chrepaint() {
        if (this.g != null) {
            this.g.repaint();
        }
    }

    public void chrepaintD() {
        if (this.g != null) {
            this.g.repaintD();
        }
    }

    public void drawCaretOn() {
        if (this.tm != null && this.g != null) {
            this.tm.intdrawCaretOn(this.g, this.tm.getyx().x, this.tm.getyx().y, true);
        }
    }

    public void drawCaretOff() {
        if (this.tm != null && this.g != null) {
            this.tm.intdrawCaretOff(this.g, this.tm.getyx().x, this.tm.getyx().y);
        }
    }
}

