/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.charva;

import charva.awt.Color;
import charva.awt.Component;
import charva.awt.Dimension;
import charva.awt.Point;
import charva.awt.Rectangle;
import charva.awt.Toolkit;
import com.iscobol.gui.Constants;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.charva.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class TerminalModel
implements Constants,
PropertyChangeListener {
    public static final int A_BOLD = 0x1000000;
    public static final int A_UNDERLINE = 0x2000000;
    public static final int A_REVERSE = 0x4000000;
    public static final int A_BLINK = 0x8000000;
    public static final int A_NOECHO = 0x10000000;
    public static final int A_GRAPHIC = 0x20000000;
    public static final int A_NORESET = 0x30000000;
    public static final int A_MASK = -16777216;
    public static final char ACS_HLINE = '\u0003';
    public static final char ACS_LHLINE = '\u0002';
    public static final char ACS_RHLINE = '\u0001';
    public static final char ACS_VLINE = '\f';
    public static final char ACS_TVLINE = '\u0004';
    public static final char ACS_BVLINE = '\b';
    public static final char ACS_ULCORNER = '\u0006';
    public static final char ACS_URCORNER = '\u0005';
    public static final char ACS_LLCORNER = '\n';
    public static final char ACS_LRCORNER = '\t';
    public static final char ACS_BTEE = '\u000b';
    public static final char ACS_TTEE = '\u0007';
    public static final char ACS_LTEE = '\u000e';
    public static final char ACS_RTEE = '\r';
    public static final char ACS_PLUS = '\u000f';
    public static final boolean DEF_AUTOWRAP = false;
    public static final int CURSOR_INVIS = 0;
    public static final int CURSOR_UNDER = 1;
    public static final int CURSOR_BLOCK = 2;
    public static final int CURSOR_MIXED = 3;
    public static final int CURSOR_VLINE = 4;
    public static final int DEF_CURSTYPE = 2;
    public static final char defChar = ' ';
    public static final int defAttr = 0xFFFFFF;
    private int x0Orig;
    private int y0Orig;
    private int x0;
    private int y0;
    private int heightOrig;
    private int widthOrig;
    private int width;
    private int height;
    private int heightOutBound;
    private int[][] backMatrix;
    private int[][] attrMatrix;
    private char[][] charMatrix;
    private Point cursor;
    private Point caret;
    private Component withFocus;
    private Point lastCaret;
    private Color lastCaretColor;
    private int backColor;
    private int termAttr;
    private Dimension charDim;
    private int cursorType;
    boolean insertCursor;
    private boolean autowrap;
    private AbstractGuiFactoryImpl gf;
    private int lastx = -1;
    private int lasty = -1;
    private Point wgetcxy;
    private boolean wgetcrunning;

    public TerminalModel(AbstractGuiFactoryImpl gf) {
        this.gf = gf;
        this.setBackColor(Color.black);
        this.setForeColor(Color.white);
    }

    public synchronized void init(int cols, int rows, Dimension ch) {
        this.x0 = 0;
        this.x0Orig = 0;
        this.y0 = 0;
        this.y0Orig = 0;
        this.widthOrig = this.width = cols;
        this.heightOrig = this.height = rows;
        this.charDim = ch;
        this.backMatrix = new int[cols][rows];
        this.attrMatrix = new int[cols][rows];
        this.charMatrix = new char[cols][rows];
        this.cursor = new Point(0, 0);
        this.caret = new Point(-1, -1);
        this.lastCaret = new Point(-1, -1);
        this.autowrap = this.gf.getCsProperty().get("iscobol.terminal.autowrap", false);
        this.cursorType = this.gf.getCsProperty().get("iscobol.terminal.cursor_type", 2);
        this.gf.getCsProperty().addPropertyChangeListener(this);
        this.erase();
    }

    public synchronized void changeWidth(int nw) {
        int j;
        int i;
        int minw;
        int maxw;
        if (nw > this.widthOrig) {
            maxw = nw;
            minw = this.widthOrig;
        } else {
            maxw = this.widthOrig;
            minw = nw;
        }
        int[][] nBackMatrix = new int[nw][this.heightOrig];
        int[][] nAttrMatrix = new int[nw][this.heightOrig];
        char[][] nCharMatrix = new char[nw][this.heightOrig];
        for (i = 0; i < minw; ++i) {
            for (j = 0; j < this.heightOrig; ++j) {
                nBackMatrix[i][j] = this.backMatrix[i][j];
                nAttrMatrix[i][j] = this.attrMatrix[i][j];
                nCharMatrix[i][j] = this.charMatrix[i][j];
            }
        }
        while (i < nw) {
            for (j = 0; j < this.heightOrig; ++j) {
                nBackMatrix[i][j] = this.backColor;
                nAttrMatrix[i][j] = this.termAttr;
                nCharMatrix[i][j] = 32;
            }
            ++i;
        }
        this.backMatrix = nBackMatrix;
        this.attrMatrix = nAttrMatrix;
        this.charMatrix = nCharMatrix;
        if (this.width == this.widthOrig) {
            this.width = nw;
        }
        this.widthOrig = nw;
    }

    private void mySetBackColor(Color c) {
        if (c != null) {
            this.backColor = c.getCursesColor();
        }
    }

    private void mySetForeColor(Color c) {
        if (c != null) {
            this.termAttr = c.getCursesColor() & 0xFFFFFF | this.termAttr & 0xFF000000;
        }
    }

    public void setSubwindow(int x, int y, int w, int h) {
        if (x >= 0 && x < this.widthOrig) {
            this.x0 = x;
        }
        if (y >= 0 && y < this.heightOrig) {
            this.y0 = y;
        }
        if (w >= 0 && w < this.widthOrig) {
            this.width = w;
        }
        if (h >= 0 && h < this.heightOrig) {
            this.height = h;
        }
        this.cursor.x = this.x0;
        this.cursor.y = this.y0;
    }

    public void resetSubwindow() {
        this.x0 = this.x0Orig;
        this.y0 = this.y0Orig;
        this.width = this.widthOrig;
        this.height = this.heightOrig;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.charDim.width * this.widthOrig, this.charDim.height * this.heightOrig);
    }

    public void setBackground(Color c) {
        if (c != null) {
            this.setBackground(this.x0, this.y0, this.width - this.x0, this.height - this.y0, c);
        }
    }

    public void setForeground(Color c, int attr) {
        if (c != null) {
            this.setForeground(this.x0, this.y0, this.width - this.x0, this.height - this.y0, c, attr);
        }
    }

    public void setBackColor(Color c) {
        if ((this.termAttr & 0x4000000) != 0) {
            this.mySetForeColor(c);
        } else {
            this.mySetBackColor(c);
        }
    }

    public void setForeColor(Color c) {
        if ((this.termAttr & 0x4000000) != 0) {
            this.mySetBackColor(c);
        } else {
            this.mySetForeColor(c);
        }
    }

    private void swapForeBack() {
        int swap = this.termAttr;
        this.termAttr = this.backColor & 0xFFFFFF | this.termAttr & 0xFF000000;
        this.backColor = swap & 0xFFFFFF;
    }

    public void setCaretAt(int x, int y, Component wf) {
        this.withFocus = wf;
        this.caret.y = y < 0 ? 0 : (y >= this.heightOrig ? this.heightOrig - 1 : y);
        this.caret.x = x < 0 ? 0 : (x > this.widthOrig ? this.widthOrig : x);
    }

    public void caretLeft() {
        if (this.caret.x < this.width - 1) {
            ++this.caret.x;
        }
    }

    public void caretRight() {
        if (this.caret.x > this.x0) {
            --this.caret.x;
        }
    }

    public void unsetCaret(Component wf) {
        if (wf == this.withFocus) {
            this.caret.y = -1;
            this.caret.x = -1;
            this.withFocus = null;
        }
    }

    public void setAttr(int a) {
        boolean swap = (a & 0x4000000) != 0 && (this.termAttr & 0x4000000) == 0;
        this.termAttr = this.termAttr & 0xFFFFFF | a & 0xFF000000;
        if (swap) {
            this.swapForeBack();
        }
    }

    public void unsetAttr(int a) {
        boolean swap = (a & 0x4000000) != 0 && (this.termAttr & 0x4000000) != 0;
        this.termAttr &= ~(a & 0xFF000000);
        if (swap) {
            this.swapForeBack();
        }
    }

    public void clearAttr() {
        if ((this.termAttr & 0x4000000) != 0) {
            this.swapForeBack();
        }
        this.termAttr &= 0xFFFFFF;
    }

    public boolean move(int x, int y) {
        boolean Return2 = false;
        boolean scrollable = true;
        if (x == this.lastx && y == this.lasty) {
            scrollable = false;
        }
        this.lastx = x;
        this.lasty = y;
        if (y >= this.height) {
            if (scrollable) {
                if (this.heightOutBound > 0 && y > this.heightOutBound) {
                    this.scroll(y - this.heightOutBound);
                } else {
                    this.scroll(y - this.height + 1);
                }
                this.heightOutBound = y;
            }
            y = this.height - 1;
            Return2 = true;
        } else {
            this.heightOutBound = 0;
        }
        if (x > this.width) {
            x = this.width;
        }
        this.imove(x, y);
        return Return2;
    }

    private void imove(int x, int y) {
        this.cursor.y = y < 0 ? 0 : (y >= this.heightOrig ? this.heightOrig - 1 : y);
        this.cursor.x = x < 0 ? 0 : (x > this.widthOrig ? this.widthOrig : x);
    }

    public Point getyx() {
        return this.cursor;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private synchronized void clearToLine(int yEnd) {
        int x;
        int y = this.cursor.y;
        if (this.cursor.x > this.x0) {
            for (x = this.cursor.x; x < this.width; ++x) {
                this.backMatrix[x][y] = this.backColor;
                this.attrMatrix[x][y] = this.termAttr;
                this.charMatrix[x][y] = 32;
            }
            ++y;
        }
        while (y <= yEnd) {
            for (x = this.x0; x < this.width; ++x) {
                this.backMatrix[x][y] = this.backColor;
                this.attrMatrix[x][y] = this.termAttr;
                this.charMatrix[x][y] = 32;
            }
            ++y;
        }
    }

    public void erase() {
        this.imove(this.x0, this.y0);
        this.clrtobot();
        this.imove(this.x0, this.y0);
    }

    public void clrtoeol() {
        this.clearToLine(this.cursor.y);
    }

    public void clrtobot() {
        this.clearToLine(this.height - 1);
    }

    public synchronized void scroll(int lines) {
        int x;
        int y1;
        if (lines > 0) {
            int y = this.y0;
            y1 = this.y0 + lines;
            while (y < this.height - lines) {
                for (x = this.x0; x < this.width; ++x) {
                    this.backMatrix[x][y] = this.backMatrix[x][y1];
                    this.attrMatrix[x][y] = this.attrMatrix[x][y1];
                    this.charMatrix[x][y] = this.charMatrix[x][y1];
                }
                ++y;
                ++y1;
            }
            x = this.cursor.x;
            y1 = this.cursor.y - 1;
            this.imove(this.x0, y);
            this.clearToLine(this.height - 1);
        } else if (lines == 0) {
            x = this.cursor.x;
            y1 = this.cursor.y;
        } else {
            int y = this.height - (lines *= -1) - 1;
            y1 = this.height - 1;
            while (y >= this.y0) {
                for (x = this.x0; x < this.width; ++x) {
                    this.backMatrix[x][y1] = this.backMatrix[x][y];
                    this.attrMatrix[x][y1] = this.attrMatrix[x][y];
                    this.charMatrix[x][y1] = this.charMatrix[x][y];
                }
                --y;
                --y1;
            }
            x = this.cursor.x;
            y1 = this.cursor.y - 1;
            this.imove(this.x0, this.y0);
            this.clearToLine(this.y0 + lines - 1);
        }
        if (y1 < 0) {
            y1 = 0;
        }
        this.imove(x, y1);
    }

    public void setForeground(int x, int y, int w, int h, Color c, int attr) {
        this.setForeColor(c);
        if (w < 1 || h < 1) {
            return;
        }
        attr &= 0xFF000000;
        if (y < 0) {
            y = 0;
        } else if (y >= this.heightOrig) {
            y = this.heightOrig - 1;
        }
        if (x < 0) {
            x = 0;
        } else if (x > this.widthOrig) {
            x = this.widthOrig - 1;
        }
        if (x + w > this.widthOrig) {
            w = this.widthOrig - x;
        }
        if (y + h > this.heightOrig) {
            h = this.heightOrig - y;
        }
        if (c == null) {
            for (int i = y + h - 1; i >= y; --i) {
                for (int j = x + w - 1; j >= x; --j) {
                    this.attrMatrix[j][i] = this.attrMatrix[j][i] & 0x20FFFFFF | attr;
                }
            }
        } else {
            int fore = c.getCursesColor() & 0xFFFFFF;
            for (int i = y + h - 1; i >= y; --i) {
                for (int j = x + w - 1; j >= x; --j) {
                    this.attrMatrix[j][i] = fore | this.attrMatrix[j][i] & 0x20000000 | attr;
                }
            }
        }
    }

    public synchronized void setBackground(int x, int y, int w, int h, Color c) {
        this.setBackColor(c);
        if (w < 1 || h < 1 || c == null) {
            return;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= this.heightOrig) {
            y = this.heightOrig - 1;
        }
        if (x < 0) {
            x = 0;
        } else if (x > this.widthOrig) {
            x = this.widthOrig - 1;
        }
        if (w > this.widthOrig) {
            w = this.widthOrig;
        }
        if (h > this.heightOrig) {
            h = this.heightOrig;
        }
        int back = c.getCursesColor();
        for (int i = y + h - 1; i >= y; --i) {
            for (int j = x + w - 1; j >= x; --j) {
                this.backMatrix[j][i] = back;
            }
        }
    }

    public void clrarea(int x, int y, int w, int h, Color fore, int attr, Color back) {
        int taSave = this.termAttr;
        int bcSave = this.backColor;
        this.termAttr &= 0xFFFFFF;
        this.setAttr(attr);
        this.setForeColor(fore);
        this.setBackColor(back);
        this.clrarea(x, y, w, h);
        this.termAttr = taSave;
        this.backColor = bcSave;
    }

    public synchronized void clrarea(int x, int y, int w, int h) {
        if (w < 0 || h < 0) {
            return;
        }
        if (y < this.y0) {
            y = this.y0;
        } else if (y >= this.height) {
            y = this.height - 1;
        }
        if (x < this.x0) {
            x = this.x0;
        } else if (x > this.width) {
            x = this.width - 1;
        }
        if (x + w > this.width) {
            w = this.width - x;
        }
        if (y + h > this.height) {
            h = this.height - y;
        }
        int taSave = this.termAttr;
        this.termAttr &= 0xFFFFFF;
        for (int i = y + h - 1; i >= y; --i) {
            for (int j = x + w - 1; j >= x; --j) {
                this.backMatrix[j][i] = this.backColor;
                this.attrMatrix[j][i] = this.termAttr;
                this.charMatrix[j][i] = 32;
            }
        }
        this.termAttr = taSave;
    }

    private synchronized void rawGLAdd(char c, boolean cross) {
        if (!cross || (this.attrMatrix[this.cursor.x][this.cursor.y] & 0x20000000) == 0) {
            this.rawadd(c);
        } else {
            this.rawadd((char)(c | this.charMatrix[this.cursor.x][this.cursor.y]));
        }
    }

    boolean dblWidth(char c) {
        return false;
    }

    private synchronized void rawadd(char c) {
        this.charMatrix[this.cursor.x][this.cursor.y] = c;
        this.backMatrix[this.cursor.x][this.cursor.y] = this.backColor;
        this.attrMatrix[this.cursor.x][this.cursor.y] = this.termAttr;
        if (this.cursor.x < this.widthOrig - 1) {
            ++this.cursor.x;
        }
        if (this.dblWidth(c)) {
            this.rawadd(' ');
        }
    }

    private synchronized void addchonly(char c) {
        int x;
        int cw = this.dblWidth(c) ? 2 : 1;
        int n = x = this.cursor.x <= this.width - cw ? this.cursor.x : this.width - cw;
        if ((this.cursor.x += cw) >= this.width && this.autowrap) {
            if (++this.cursor.y >= this.height) {
                this.scroll(1);
            }
            this.cursor.x = this.x0;
            x = this.cursor.x++;
        }
        if (c != '\u0000') {
            this.charMatrix[x][this.cursor.y] = c;
        }
    }

    private synchronized void addch(char c) {
        int cw = this.dblWidth(c) ? 2 : 1;
        int x = this.cursor.x <= this.width - cw ? this.cursor.x : this.width - cw;
        this.backMatrix[x][this.cursor.y] = this.backColor;
        if (this.cursor.x++ >= this.width && this.autowrap) {
            if (++this.cursor.y >= this.height) {
                this.scroll(1);
            }
            this.cursor.x = this.x0;
            x = this.cursor.x++;
        }
        if (c != '\u0000') {
            this.attrMatrix[x][this.cursor.y] = this.termAttr;
            this.charMatrix[x][this.cursor.y] = c;
        } else {
            int[] nArray = this.attrMatrix[x];
            int n = this.cursor.y;
            nArray[n] = nArray[n] & 0x30000000;
            int[] nArray2 = this.attrMatrix[x];
            int n2 = this.cursor.y;
            nArray2[n2] = nArray2[n2] | this.termAttr;
        }
        if (cw > 1) {
            this.addch(' ');
        }
    }

    public void right() {
        if (this.cursor.x < this.width) {
            int cw;
            int n = cw = this.dblWidth(this.charMatrix[this.cursor.x][this.cursor.y]) ? 2 : 1;
            if (this.cursor.x <= this.width - cw) {
                this.cursor.x += cw;
            }
        }
    }

    public void left() {
        if (this.cursor.x > this.x0) {
            --this.cursor.x;
        }
    }

    public void crlf() {
        if (this.cursor.y < this.height - 1) {
            ++this.cursor.y;
        }
        this.cursor.x = this.x0;
    }

    public Rectangle addstr(char[] c) {
        Rectangle Return2 = new Rectangle(0, 0, 80, 24);
        if (c == null) {
            return Return2;
        }
        this.upperLeft(Return2);
        for (int i = 0; i < c.length; ++i) {
            this.addch(c[i]);
        }
        this.bottomRight(Return2);
        return Return2;
    }

    public Rectangle addstr(String s, int len, Color fore, int attr, Color back) {
        int i;
        Rectangle Return2 = new Rectangle(0, 0, 80, 24);
        this.upperLeft(Return2);
        int taSave = this.termAttr;
        int bcSave = this.backColor;
        this.termAttr &= 0xFFFFFF;
        this.setAttr(attr);
        this.setForeColor(fore);
        this.setBackColor(back);
        char[] sc = new char[len];
        char[] cc = s != null ? s.toCharArray() : new char[len];
        int minLen = sc.length < cc.length ? sc.length : cc.length;
        for (i = 0; i < minLen; ++i) {
            sc[i] = cc[i];
        }
        while (i < sc.length) {
            sc[i] = 32;
            ++i;
        }
        for (i = 0; i < len; ++i) {
            this.addch(sc[i]);
        }
        this.termAttr = taSave;
        this.backColor = bcSave;
        this.bottomRight(Return2);
        return Return2;
    }

    private void paintBack(Graphics g, int c, int sx, int sy, int ex, int ey) {
        g.setBackColor(Color.fromCursesColor((int)(c & 0xFFFFFF)));
        if (sx > 0 && ey > sy) {
            g.fillRect(sx * this.charDim.width, sy * this.charDim.height, this.widthOrig * this.charDim.width, sy * this.charDim.height + this.charDim.height);
            sx = 0;
            ++sy;
        }
        if (sx == 0 && ey > sy) {
            g.fillRect(0, sy * this.charDim.height, this.widthOrig * this.charDim.width, (ey - 1) * this.charDim.height + this.charDim.height);
            sx = 0;
            sy = ey;
        }
        g.fillRect(sx * this.charDim.width, sy * this.charDim.height, ex * this.charDim.width, sy * this.charDim.height + this.charDim.height);
    }

    private void myDrawString(Graphics g, StringBuffer buf, int sx, int y, int a) {
        int len = buf.length();
        char[] c = new char[1];
        for (int i = 0; i < len; ++i) {
            c[0] = buf.charAt(i);
            if (c[0] == ' ' && (a & 0x1000000) != 0x1000000 && (a & 0x2000000) != 0x2000000 && (a & 0x8000000) != 0x8000000 && (a & 0x4000000) != 0x4000000) continue;
            g.addChar(c[0], a, (sx + i) * this.charDim.width, y);
        }
    }

    private void paintForeLine(Graphics g, int a, int b, int sx, int sy, int ex) {
        g.setForeColor(Color.fromCursesColor((int)(a & 0xFFFFFF)));
        g.setBackColor(Color.fromCursesColor((int)(b & 0xFFFFFF)));
        int acs = a & 0x20000000;
        if (acs != 0) {
            int y = sy * this.charDim.height + this.charDim.height / 2;
            int mx = this.charDim.width / 2;
            int my = this.charDim.height / 2;
            block15: for (int x = sx; x < ex; ++x) {
                switch (this.charMatrix[x][sy]) {
                    default: {
                        continue block15;
                    }
                    case '\u0003': {
                        g.addChar(Toolkit.ACS_HLINE, x, y);
                        continue block15;
                    }
                    case '\u000f': {
                        g.addChar(Toolkit.ACS_PLUS, x, y);
                        continue block15;
                    }
                    case '\f': {
                        g.addChar(Toolkit.ACS_VLINE, x, y);
                        continue block15;
                    }
                    case '\u0001': 
                    case '\u0002': {
                        g.addChar(Toolkit.ACS_HLINE, x, y);
                        continue block15;
                    }
                    case '\u0004': 
                    case '\b': {
                        g.addChar(Toolkit.ACS_VLINE, x, y);
                        continue block15;
                    }
                    case '\u0006': {
                        g.addChar(Toolkit.ACS_ULCORNER, x, y);
                        continue block15;
                    }
                    case '\u0005': {
                        g.addChar(Toolkit.ACS_URCORNER, x, y);
                        continue block15;
                    }
                    case '\t': {
                        g.addChar(Toolkit.ACS_LRCORNER, x, y);
                        continue block15;
                    }
                    case '\n': {
                        g.addChar(Toolkit.ACS_LLCORNER, x, y);
                        continue block15;
                    }
                    case '\u0007': {
                        g.addChar(Toolkit.ACS_TTEE, x, y);
                        continue block15;
                    }
                    case '\u000b': {
                        g.addChar(Toolkit.ACS_BTEE, x, y);
                        continue block15;
                    }
                    case '\u000e': {
                        g.addChar(Toolkit.ACS_LTEE, x, y);
                        continue block15;
                    }
                    case '\r': {
                        g.addChar(Toolkit.ACS_RTEE, x, y);
                    }
                }
            }
        } else if (ex > sx) {
            int y;
            int ul = y = sy * this.charDim.height;
            StringBuffer buf = new StringBuffer();
            for (int x = sx; x < ex; ++x) {
                buf.append(this.charMatrix[x][sy]);
            }
            if ((a & 0x1000000) != 0) {
                // empty if block
            }
            if ((a & 0x10000000) == 0) {
                this.myDrawString(g, buf, sx, y, a);
            }
            if ((a & 0x2000000) != 0) {
                // empty if block
            }
        }
    }

    public void shadow(int x, int y, int w, int h, boolean boxed) {
        if (w > 1 && h > 1) {
            int i;
            int bcSave = this.backColor;
            this.setBackColor(Color.black);
            if (x + w < this.widthOrig) {
                if (boxed) {
                    this.imove(x + w, y + 1);
                    this.rawadd(' ');
                } else {
                    this.imove(x + w, y);
                    this.rawadd(' ');
                    this.imove(x + w, y + 1);
                    this.rawadd(' ');
                }
                for (i = y + 2; i < y + h && i < this.heightOrig; ++i) {
                    this.imove(x + w, i);
                    this.rawadd(' ');
                }
            }
            if (y + h < this.heightOrig) {
                this.imove(x + 1, y + h);
                this.rawadd(' ');
                for (i = x + 2; i < x + w && i < this.widthOrig; ++i) {
                    this.rawadd(' ');
                }
                this.rawadd(' ');
            }
            this.backColor = bcSave;
        }
    }

    private void box(int x, int y, int w, int h, boolean cross, boolean vertical, Graphics g) {
        if (x < 0) {
            x = 0;
        } else if (x >= this.widthOrig) {
            x = this.widthOrig - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= this.heightOrig) {
            y = this.heightOrig - 1;
        }
        if (x + w > this.widthOrig) {
            w = this.widthOrig - x;
        }
        if (y + h > this.heightOrig) {
            h = this.heightOrig - y;
        }
        this.setAttr(0x20000000);
        if (h == 1 && !vertical) {
            if (w > 0) {
                this.imove(x, y);
                if (w > 1) {
                    this.rawGLAdd('\u0002', cross);
                    for (int i = 1; i < w - 1; ++i) {
                        this.rawGLAdd('\u0003', cross);
                    }
                    this.rawGLAdd('\u0001', cross);
                } else {
                    this.rawGLAdd('\u0003', cross);
                }
            }
        } else if (w == 1) {
            if (h > 0) {
                this.imove(x, y);
                if (h > 1) {
                    int i;
                    this.rawGLAdd('\u0004', cross);
                    for (i = 1; i < h - 1; ++i) {
                        this.imove(x, y + i);
                        this.rawGLAdd('\f', cross);
                    }
                    this.imove(x, y + i);
                    this.rawGLAdd('\b', cross);
                } else {
                    this.rawGLAdd('\f', cross);
                }
            }
        } else {
            int i;
            this.imove(x, y);
            this.rawGLAdd('\u0006', cross);
            for (i = 2; i < w; ++i) {
                this.rawGLAdd('\u0003', cross);
            }
            this.rawGLAdd('\u0005', cross);
            for (i = 1; i < h - 1; ++i) {
                this.imove(x, y + i);
                this.rawGLAdd('\f', cross);
                this.imove(x + w - 1, y + i);
                this.rawGLAdd('\f', cross);
            }
            this.imove(x, y + h - 1);
            this.rawGLAdd('\n', cross);
            for (i = 2; i < w; ++i) {
                this.rawGLAdd('\u0003', cross);
            }
            this.rawGLAdd('\t', cross);
        }
        this.unsetAttr(0x20000000);
    }

    private void printtitle(int x, int y, int w, int h, String title, int tPos) {
        if (title != null) {
            int len = title.length();
            if (len > w - 6) {
                len = w - 6;
                title = title.substring(0, len);
            }
            title = " " + title + " ";
            len += 2;
            switch (tPos) {
                default: {
                    this.move(x + (w - len) / 2, y);
                    break;
                }
                case 1: {
                    this.move(x + 2, y);
                    break;
                }
                case 3: {
                    this.move(x + w - len - 2, y);
                    break;
                }
                case 5: {
                    this.imove(x + (w - len) / 2, y + h - 1);
                    break;
                }
                case 4: {
                    this.imove(x + 2, y + h - 1);
                    break;
                }
                case 6: {
                    this.imove(x + w - len - 2, y + h - 1);
                }
            }
            this.addstr(title.toCharArray());
            this.imove(x + w, y + h - 1);
        }
    }

    public void box(int x, int y, int w, int h, Color fore, int attr, Color back, String[] titles, int[] tPoss, boolean cross, Graphics g) {
        this.box(x, y, w, h, fore, attr, back, titles, tPoss, cross, false, g);
    }

    public void box(int x, int y, int w, int h, Color fore, int attr, Color back, String[] titles, int[] tPoss, boolean cross, boolean vert, Graphics g) {
        int taSave = this.termAttr;
        int bcSave = this.backColor;
        this.termAttr &= 0xFFFFFF;
        this.setAttr(attr);
        this.setForeColor(fore);
        this.setBackColor(back);
        this.box(x, y, w, h, cross, vert, g);
        if (titles[0] != null) {
            this.printtitle(x, y, w, h, titles[0], tPoss[0]);
        }
        if (titles[1] != null) {
            this.printtitle(x, y, w, h, titles[1], tPoss[1]);
        }
        this.termAttr = taSave;
        this.backColor = bcSave;
    }

    public void intdrawCaretOn(Graphics g, int x, int y, boolean wgetcrunning) {
        Color b;
        this.lastCaretColor = Color.fromCursesColor((int)(this.attrMatrix[x][y] & 0xFFFFFF));
        Color back = b = Color.fromCursesColor((int)(this.backMatrix[x][y] & 0xFFFFFF));
        Color fore = this.lastCaretColor;
        g.setForeColor(fore);
        g.setBackColor(back);
        switch (this.cursorType) {
            default: 
        }
        g.fillCursorOn(this.charMatrix[x][y], this.attrMatrix[x][y], x * this.charDim.width, y * this.charDim.height, this.charDim.width, this.charDim.height);
        if (wgetcrunning) {
            this.wgetcxy = new Point(x, y);
        }
        this.wgetcrunning = wgetcrunning;
    }

    private void drawCaretOn(Graphics g) {
        if (this.wgetcrunning && this.wgetcxy != null) {
            this.intdrawCaretOn(g, this.wgetcxy.x, this.wgetcxy.y, true);
        } else if (this.caret.x >= 0) {
            this.lastCaret.x = this.caret.x;
            this.lastCaret.y = this.caret.y;
            int lastCaret_x = this.lastCaret.x < this.widthOrig ? this.lastCaret.x : this.widthOrig - 1;
            this.intdrawCaretOn(g, lastCaret_x, this.lastCaret.y, false);
        }
    }

    public void intdrawCaretOff(Graphics g, int x, int y) {
        g.setForeColor(this.lastCaretColor);
        Color b = Color.fromCursesColor((int)(this.backMatrix[x][y] & 0xFFFFFF));
        g.setBackColor(b);
        g.fillCursorOff(x * this.charDim.width, y * this.charDim.height, this.charDim.width, this.charDim.height);
        this.lastCaret.y = -1;
        this.lastCaret.x = -1;
        this.lastCaretColor = null;
        this.wgetcrunning = false;
    }

    public void drawCaretOff(Graphics g) {
        if (this.wgetcrunning && this.wgetcxy != null) {
            this.intdrawCaretOn(g, this.wgetcxy.x, this.wgetcxy.y, true);
        } else if (this.lastCaret.x >= 0) {
            int lastCaret_x = this.lastCaret.x < this.widthOrig ? this.lastCaret.x : this.widthOrig - 1;
            this.intdrawCaretOff(g, lastCaret_x, this.lastCaret.y);
        }
    }

    public synchronized void paint(Graphics g, int startx, int endx, int yline) {
        int x = 0;
        int curBack = this.backMatrix[startx][yline];
        int sx = startx;
        this.drawCaretOff(g);
        for (x = startx; x < endx; ++x) {
            if (this.backMatrix[x][yline] == curBack) continue;
            this.paintBack(g, curBack, sx, yline, x, yline);
            curBack = this.backMatrix[x][yline];
            sx = x;
        }
        if (sx == startx || sx < endx) {
            this.paintBack(g, curBack, sx, yline, endx, yline);
        }
        sx = startx;
        int curAttr = this.attrMatrix[startx][yline];
        curBack = this.backMatrix[startx][yline];
        for (x = startx; x < endx; ++x) {
            if (this.attrMatrix[x][yline] == curAttr) continue;
            g.setForeColor(Color.fromCursesColor((int)(curAttr & 0xFF000000)));
            this.paintForeLine(g, curAttr, curBack, sx, yline, x);
            curAttr = this.attrMatrix[x][yline];
            curBack = this.backMatrix[x][yline];
            sx = x;
        }
        if (sx == startx || sx < endx) {
            this.paintForeLine(g, curAttr, curBack, sx, yline, endx);
        }
        this.drawCaretOn(g);
    }

    public synchronized void paint(Graphics g) {
        int y;
        int x = 0;
        int curBack = this.backMatrix[0][0];
        int sx = 0;
        int sy = 0;
        this.drawCaretOff(g);
        for (y = 0; y < this.heightOrig; ++y) {
            for (x = 0; x < this.widthOrig; ++x) {
                if (this.backMatrix[x][y] == curBack) continue;
                this.paintBack(g, curBack, sx, sy, x, y);
                curBack = this.backMatrix[x][y];
                sx = x;
                sy = y;
            }
        }
        this.paintBack(g, curBack, sx, sy, x, y);
        int curAttr = this.attrMatrix[0][0];
        curBack = this.backMatrix[0][0];
        sx = 0;
        sy = 0;
        for (y = 0; y < this.heightOrig; ++y) {
            for (x = 0; x < this.widthOrig; ++x) {
                if (this.attrMatrix[x][y] == curAttr && this.charMatrix[x][y] == ' ') continue;
                g.setForeColor(Color.fromCursesColor((int)(curAttr & 0xFF000000)));
                while (sy < y) {
                    this.paintForeLine(g, curAttr, curBack, sx, sy, this.widthOrig);
                    sx = 0;
                    ++sy;
                }
                this.paintForeLine(g, curAttr, curBack, sx, sy, x);
                curAttr = this.attrMatrix[x][y];
                curBack = this.backMatrix[x][y];
                sx = x;
                sy = y;
            }
        }
        while (sy < y - 1) {
            this.paintForeLine(g, curAttr, curBack, sx, sy, this.widthOrig);
            sx = 0;
            ++sy;
        }
        this.paintForeLine(g, curAttr, curBack, sx, sy, x);
        this.drawCaretOn(g);
    }

    public Area getArea(int x, int y, int w, int h) {
        if (x < 0) {
            x = 0;
        } else if (x >= this.widthOrig) {
            x = this.widthOrig - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= this.heightOrig) {
            y = this.heightOrig - 1;
        }
        if (x + w > this.widthOrig) {
            w = this.widthOrig - x;
        }
        if (y + h > this.heightOrig) {
            h = this.heightOrig - y;
        }
        return new Area(x, y, w, h, this.backMatrix, this.attrMatrix, this.charMatrix);
    }

    public synchronized void restoreArea(Area a, int x, int y, int w, int h) {
        if (x + w > this.widthOrig) {
            w = this.widthOrig - x;
        }
        if (y + h > this.heightOrig) {
            h = this.heightOrig - y;
        }
        int j = y + h - 1;
        int ye = y + h - a.y0 - 1;
        while (j >= y) {
            int i = x + w - 1;
            int xe = x + w - a.x0 - 1;
            while (i >= x) {
                this.backMatrix[i][j] = a.backMatrix[xe][ye];
                this.attrMatrix[i][j] = a.attrMatrix[xe][ye];
                this.charMatrix[i][j] = a.charMatrix[xe][ye];
                --i;
                --xe;
            }
            --j;
            --ye;
        }
    }

    private void upperLeft(Rectangle repArea) {
    }

    private void bottomRight(Rectangle repArea) {
    }

    public Dimension getCharDim() {
        return this.charDim;
    }

    public synchronized String acceptFromScreen(int line, int col, int size) {
        char[] Return2 = new char[size];
        int i = 0;
        line = line < 1 ? this.cursor.y : --line;
        col = col < 1 ? this.cursor.x : --col;
        if (col < this.width && line < this.height) {
            while (size > 0 && line < this.height) {
                Return2[i++] = this.charMatrix[col][line];
                if (++col >= this.width) {
                    col = 0;
                    ++line;
                }
                --size;
            }
        }
        return new String(Return2);
    }

    protected synchronized char[] getTextAt(int line, int col, int size) {
        if (line < 0 || col < 0 || size < 1 || line >= this.height || col >= this.width) {
            return new char[0];
        }
        char[] Return2 = new char[Math.min(size, this.width - col)];
        int c = col;
        for (int i = 0; i < Return2.length; ++i) {
            Return2[i] = this.charMatrix[c][line];
            ++c;
        }
        return Return2;
    }

    private char getVirtualAttr(int x, int y) {
        int attr = this.attrMatrix[x][y] & 0xFF000000;
        int fore = this.attrMatrix[x][y] & 0xFFFFFF;
        int back = this.backMatrix[x][y] & 0xFFFFFF;
        int Return2 = fore == 0 ? (back == 0 ? attr | 0x10000000 : attr | 0x4000000) : (fore == 0xFFFFFF ? attr | 0x1000000 : (back == 0xFFFFFF ? (fore == 0x808080 ? attr | 0x4000000 | 0x1000000 : attr | 0x4000000) : attr));
        return (char)(Return2 >>> 24);
    }

    private void setVirtualAttr(char c, int x, int y) {
        int attr = c << 24;
        this.attrMatrix[x][y] = attr | 0xC0C0C0;
        switch (attr & 0x5000000) {
            case 0x4000000: {
                this.attrMatrix[x][y] = attr;
                this.backMatrix[x][y] = 0xFFFFFF | this.backMatrix[x][y] & 0xFF000000;
                break;
            }
            case 0x1000000: {
                this.attrMatrix[x][y] = attr | 0xFFFFFF;
                this.backMatrix[x][y] = this.backMatrix[x][y] & 0xFF000000;
                break;
            }
            case 0x5000000: {
                this.attrMatrix[x][y] = attr | 0x808080;
                this.backMatrix[x][y] = 0xFFFFFF | this.backMatrix[x][y] & 0xFF000000;
            }
        }
    }

    public synchronized String attrFromScreen(int line, int col, int size) {
        char[] Return2 = new char[size];
        int i = 0;
        line = line < 1 ? this.cursor.y : --line;
        col = col < 1 ? this.cursor.x : --col;
        if (col < this.width && line < this.height) {
            while (size > 0 && line < this.height) {
                Return2[i++] = this.getVirtualAttr(col, line);
                if (++col >= this.width) {
                    col = 0;
                    ++line;
                }
                --size;
            }
        }
        return new String(Return2);
    }

    public synchronized void writeToScreen(int line, int col, int size, String c, String a) {
        char[] chr = c.toCharArray();
        char[] attr = a.toCharArray();
        int i = 0;
        line = line < 1 ? this.cursor.y : --line;
        col = col < 1 ? this.cursor.x : --col;
        if (col < this.width && line < this.height) {
            while (size > 0 && line < this.height) {
                this.charMatrix[col][line] = chr[i];
                this.setVirtualAttr(attr[i], col, line);
                ++i;
                if (++col >= this.width) {
                    col = 0;
                    ++line;
                }
                --size;
            }
        }
    }

    public int getBackColor() {
        return this.backColor;
    }

    public int getTermAttr() {
        return this.termAttr;
    }

    public void setBackColor(int b) {
        this.backColor = b;
    }

    public void setTermAttr(int a) {
        this.termAttr = a;
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if (this.gf != null && key.equals("iscobol.terminal.autowrap")) {
            this.autowrap = this.gf.getCsProperty().get("iscobol.terminal.autowrap", false);
        }
        if (this.gf != null && key.equals("iscobol.terminal.cursor_type")) {
            this.cursorType = this.gf.getCsProperty().get("iscobol.terminal.cursor_type", 2);
        }
    }

    public synchronized void end() {
        this.gf.getCsProperty().removePropertyChangeListener(this);
        this.gf = null;
        this.backMatrix = null;
        this.attrMatrix = null;
        this.charMatrix = null;
        this.cursor = null;
        this.caret = null;
    }

    public static class Area {
        private int[][] backMatrix;
        private int[][] attrMatrix;
        private char[][] charMatrix;
        int x0;
        int y0;
        int width;
        int height;

        private Area(int x, int y, int w, int h, int[][] bm, int[][] am, char[][] cm) {
            this.x0 = x;
            this.y0 = y;
            this.width = w;
            this.height = h;
            this.backMatrix = new int[this.width][this.height];
            this.attrMatrix = new int[this.width][this.height];
            this.charMatrix = new char[this.width][this.height];
            for (int j = 0; j < this.height; ++j) {
                for (int i = 0; i < this.width; ++i) {
                    this.backMatrix[i][j] = bm[i + x][j + y];
                    this.attrMatrix[i][j] = am[i + x][j + y];
                    this.charMatrix[i][j] = cm[i + x][j + y];
                }
            }
        }
    }
}

