/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.io;

import com.iscobol.gui.RemoteIO;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.io.BaseFile;
import com.iscobol.io.DynamicRemote;
import com.iscobol.io.IndexFile;
import com.iscobol.lib.I$IO;
import com.iscobol.rmi.server.UnicastRemoteObject;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.Factory;
import com.iscobol.rts.IOUtil;
import com.iscobol.rts.KeyDescription;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardOpenOption;
import javax.swing.JOptionPane;

public class RemoteIOImpl
extends UnicastRemoteObject
implements RemoteIO {
    private static final byte[] outputEol = System.getProperty("line.separator", "\n").getBytes();
    private byte[] inputEol;
    private DynamicFile inputIndexFile;
    private DynamicFile outputIndexFile;
    private File inputFile;
    private File outputFile;
    private byte cr;
    private InputStream input;
    private OutputStream output;

    @Override
    public int getTheObjectId() throws IOException {
        return 0;
    }

    @Override
    public final String getSystemProperty(String propName) throws IOException {
        return System.getProperty(propName);
    }

    @Override
    public final String getHostAddress() throws IOException {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "";
        }
    }

    @Override
    public String[] openInputFile(String fileName, int encryptionFlag) throws IOException {
        String fsUrl;
        this.inputIndexFile = IndexFile.isIdxInConfig(fileName);
        if (this.inputIndexFile == null) {
            this.inputIndexFile = IndexFile.getDefaultDynamicFile(fileName);
        }
        if (this.inputIndexFile instanceof DynamicRemote && (fsUrl = BaseFile.getFileServerUrl(fileName)) != null) {
            fileName = fsUrl;
            ((DynamicRemote)this.inputIndexFile).setFSUrl(fileName);
            int idx = fileName.lastIndexOf(58);
            if (idx >= 0) {
                fileName = fileName.substring(idx + 1);
            }
        }
        int lockType = 1;
        if (encryptionFlag > 0) {
            lockType += 4096;
        }
        if (this.inputIndexFile.open(fileName, 3, lockType, null, 0, 0, 0, 3, false, false) != 0) {
            return new String[]{"1"};
        }
        return new String[]{Integer.toString(0), Integer.toString(I$IO.getFErrno(this.inputIndexFile)), this.inputIndexFile.getErrMsg()};
    }

    @Override
    public int[] getInputFileInfo() throws IOException {
        return new int[]{this.inputIndexFile.getMaxRecordSize(), this.inputIndexFile.getMinRecordSize(), this.inputIndexFile.getNumKeys()};
    }

    @Override
    public byte[] getInputFileCollatingSequence() throws IOException {
        return this.inputIndexFile.getSequence();
    }

    @Override
    public Object[] getInputFileKeyInfo(int keyNum) throws IOException {
        KeyDescription kd = this.inputIndexFile.getKey(keyNum);
        if (kd != null) {
            return new Object[]{kd.toByteArray()};
        }
        return new Object[]{Integer.toString(0), Integer.toString(I$IO.getFErrno(this.inputIndexFile))};
    }

    @Override
    public String[] openOutputFile(String fileName, int maxRecordSize, int minRecordSize, int numKeys, byte[] keysDescriptions, byte[] collatingSeq, int encryptionFlag) throws IOException {
        String fsUrl;
        KeyDescription[] keys = new KeyDescription[numKeys];
        int[] k_params = IOUtil.csv2Int(keysDescriptions);
        int i = 0;
        for (int j = 0; j < numKeys; ++j) {
            KeyDescription kd;
            int nSegs = k_params[i++];
            boolean dup = k_params[i++] == 1;
            keys[j] = kd = new KeyDescription(nSegs, dup);
            for (int k = 0; k < nSegs; ++k) {
                int size = k_params[i++];
                int offs = k_params[i++];
                kd.setSegment(k, size, offs);
            }
        }
        this.outputIndexFile = IndexFile.isIdxInConfig(fileName);
        if (this.outputIndexFile == null) {
            this.outputIndexFile = IndexFile.getDefaultDynamicFile(fileName);
        }
        if (this.outputIndexFile instanceof DynamicRemote && (fsUrl = BaseFile.getFileServerUrl(fileName)) != null) {
            fileName = fsUrl;
            ((DynamicRemote)this.outputIndexFile).setFSUrl(fileName);
            int idx = fileName.lastIndexOf(58);
            if (idx >= 0) {
                fileName = fileName.substring(idx + 1);
            }
        }
        boolean buildOk = this.outputIndexFile.build(fileName, "", 0, 0, 0, 0, encryptionFlag > 0 ? 1 : 0, maxRecordSize, minRecordSize, keys, collatingSeq, false) != 0;
        int lockType = 512;
        if (encryptionFlag > 0) {
            lockType += 4096;
        }
        if (buildOk && this.outputIndexFile.open(fileName, 2, lockType, null, maxRecordSize, minRecordSize, numKeys, 3, false, false) != 0) {
            return new String[]{"1"};
        }
        return new String[]{Integer.toString(0), Integer.toString(I$IO.getFErrno(this.outputIndexFile)), this.outputIndexFile.getErrMsg()};
    }

    @Override
    public Object[] readInputFileRecord() throws IOException {
        byte[] buffer = new byte[this.inputIndexFile.getMaxRecordSize()];
        long rc = this.inputIndexFile.next(buffer, 0, 0);
        return new Object[]{buffer, Integer.toString((int)rc)};
    }

    @Override
    public String[] writeOutputFileRecord(byte[] record, int len) throws IOException {
        if (this.outputIndexFile.write(record, 0, len, true) != 0L) {
            return new String[]{"1"};
        }
        return new String[]{Integer.toString(0), Integer.toString(I$IO.getFErrno(this.outputIndexFile)), this.outputIndexFile.getErrMsg()};
    }

    @Override
    public String[] closeIndexFiles() throws IOException {
        int rci = 1;
        int rco = 1;
        String[] Return2 = new String[6];
        if (this.inputIndexFile != null) {
            rci = this.inputIndexFile.close();
        }
        if (this.outputIndexFile != null) {
            rco = this.outputIndexFile.close();
        }
        if (rci == 1) {
            Return2[0] = "1";
            Return2[1] = "";
            Return2[2] = "";
        } else {
            Return2[0] = Integer.toString(0);
            Return2[1] = Integer.toString(I$IO.getFErrno(this.inputIndexFile));
            Return2[2] = this.inputIndexFile.getErrMsg();
        }
        if (rco == 1) {
            Return2[3] = "1";
            Return2[4] = "";
            Return2[5] = "";
        } else {
            Return2[3] = Integer.toString(0);
            Return2[4] = Integer.toString(I$IO.getFErrno(this.outputIndexFile));
            Return2[5] = this.outputIndexFile.getErrMsg();
        }
        return Return2;
    }

    @Override
    public String openInputFile(String fileName) throws IOException {
        this.inputFile = new File(fileName);
        try {
            this.input = new FileInputStream(this.inputFile);
            return "1";
        }
        catch (FileNotFoundException e) {
            return e.toString();
        }
    }

    @Override
    public String openOutputFile(String fileName, String inputEol) throws IOException {
        this.inputEol = inputEol != null ? inputEol.getBytes() : null;
        this.outputFile = new File(fileName);
        try {
            this.output = new FileOutputStream(this.outputFile);
            return "1";
        }
        catch (FileNotFoundException e) {
            return e.toString();
        }
    }

    @Override
    public Object[] readFromInputFile(int maxLen) throws IOException {
        byte[] buffer = new byte[maxLen];
        try {
            int rc = this.input.read(buffer);
            return new Object[]{buffer, Integer.toString(rc)};
        }
        catch (IOException ex) {
            return new Object[]{ex.toString()};
        }
    }

    @Override
    public String writeToOutputFile(byte[] buffer, int len) throws IOException {
        try {
            int i = 0;
            int tmplen = 0;
            if (this.inputEol != null) {
                byte[] tmp = new byte[len * 2 + 1];
                if (this.cr > 0) {
                    if (len > 0 && buffer[i] == this.inputEol[1]) {
                        switch (outputEol.length) {
                            case 2: {
                                tmp[tmplen + 1] = outputEol[1];
                            }
                            case 1: {
                                tmp[tmplen] = outputEol[0];
                            }
                        }
                        tmplen += outputEol.length;
                        ++i;
                    } else {
                        tmp[tmplen++] = this.cr;
                    }
                    this.cr = 0;
                }
                while (i < len) {
                    if (buffer[i] == this.inputEol[0]) {
                        if (this.inputEol.length == 1) {
                            switch (outputEol.length) {
                                case 2: {
                                    tmp[tmplen + 1] = outputEol[1];
                                }
                                case 1: {
                                    tmp[tmplen] = outputEol[0];
                                }
                            }
                            tmplen += outputEol.length;
                        } else if (i < len - 1) {
                            if (buffer[i + 1] == this.inputEol[1]) {
                                switch (outputEol.length) {
                                    case 2: {
                                        tmp[tmplen + 1] = outputEol[1];
                                    }
                                    case 1: {
                                        tmp[tmplen] = outputEol[0];
                                    }
                                }
                                tmplen += outputEol.length;
                            } else {
                                tmp[tmplen++] = buffer[i];
                                tmp[tmplen++] = buffer[i + 1];
                            }
                            ++i;
                        } else {
                            this.cr = buffer[i];
                        }
                    } else {
                        tmp[tmplen++] = buffer[i];
                    }
                    ++i;
                }
                this.output.write(tmp, 0, tmplen);
            } else {
                this.output.write(buffer, 0, len);
            }
            return "1";
        }
        catch (IOException ex) {
            return ex.toString();
        }
    }

    @Override
    public String[] getInputFileAttributes() throws IOException {
        String[] Return2 = new String[]{this.inputFile.canRead() ? "1" : "0", this.inputFile.canWrite() ? "1" : "0", this.inputFile.canExecute() ? "1" : "0", Long.toString(this.inputFile.lastModified())};
        return Return2;
    }

    @Override
    public String setOutputFileAttributes(String[] attrs) throws IOException {
        try {
            this.outputFile.setReadable("1".equals(attrs[0]));
            this.outputFile.setWritable("1".equals(attrs[1]));
            this.outputFile.setExecutable("1".equals(attrs[2]));
            this.outputFile.setLastModified(Long.parseLong(attrs[3]));
            return "1";
        }
        catch (Exception ex) {
            return ex.toString();
        }
    }

    @Override
    public String[] closeFiles() throws IOException {
        String erri = "1";
        String erro = "1";
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException ex) {
                erri = ex.toString();
            }
        }
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException ex) {
                erro = ex.toString();
            }
        }
        return new String[]{erri, erro};
    }

    @Override
    public String getAbsolutePath(String path, boolean useTmpDir) throws IOException {
        if (!com.iscobol.rts.File.isAbsolute(path, new File(path))) {
            String dir;
            String string = dir = useTmpDir ? System.getProperty("java.io.tmpdir") : com.iscobol.rts.File.getcwd();
            if (dir != null) {
                path = dir + File.separator + path;
            }
        }
        return path;
    }

    @Override
    public boolean deleteFile(String fileName) throws IOException {
        return new File(fileName).delete();
    }

    @Override
    public boolean deleteIndexFile(String fileName) throws IOException {
        int rc;
        DynamicFile theFile = IndexFile.isIdxInConfig(fileName);
        if (theFile == null) {
            theFile = IndexFile.getDefaultDynamicFile(fileName);
        }
        return (rc = theFile.remove(fileName)) != 0;
    }

    @Override
    public boolean checkLock(String fileName, boolean showRetryDialog) throws IOException {
        return RemoteIOImpl.checkLock(fileName, showRetryDialog, null);
    }

    public static boolean checkLock(String fileName, boolean showRetryDialog, Component component) throws IOException {
        while (true) {
            try {
                FileChannel fc = FileChannel.open(new File(fileName).toPath(), StandardOpenOption.WRITE);
                fc.close();
                return true;
            }
            catch (NoSuchFileException ex) {
                return true;
            }
            catch (FileSystemException ex) {
                String retry;
                if (!showRetryDialog) {
                    return false;
                }
                KeyboardBuffer.setBufferOff();
                String cancel = Factory.getSysMsg("msg_cancel");
                int idx = cancel.indexOf(38);
                if (idx >= 0) {
                    cancel = new StringBuilder(cancel).deleteCharAt(idx).toString();
                }
                if ((idx = (retry = Factory.getSysMsg("msg_retry")).indexOf(38)) >= 0) {
                    retry = new StringBuilder(retry).deleteCharAt(idx).toString();
                }
                int ret = JOptionPane.showOptionDialog(component, Factory.getSysMsg("file_locked"), Factory.getSysMsg("error_msg_title"), 2, 3, null, new String[]{retry, cancel}, retry);
                KeyboardBuffer.setBufferOn();
                if (0 == ret) continue;
                return false;
            }
            break;
        }
    }
}

