/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.Events;
import com.iscobol.gui.FontAttribute;
import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.ImageToByteArray;
import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.JavaBeanUtilities;
import com.iscobol.gui.MouseInfo;
import com.iscobol.gui.ParamElementFont;
import com.iscobol.gui.ParamElementGeneric;
import com.iscobol.gui.ParamElementInt;
import com.iscobol.gui.ParamElementString;
import com.iscobol.gui.ParamVElement;
import com.iscobol.gui.ParamVector;
import com.iscobol.gui.RemoteContainer;
import com.iscobol.gui.RemoteFileDialog;
import com.iscobol.gui.RemoteFontComponent;
import com.iscobol.gui.RemoteImage;
import com.iscobol.gui.RemoteProgressDialog;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.ScreenInfo;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.VirtualKeyboard;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.Client;
import com.iscobol.gui.client.Hint;
import com.iscobol.gui.client.ImageSelection;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.LocalImage;
import com.iscobol.gui.client.MyFinalizeComponent;
import com.iscobol.gui.client.swing.AdvancedFontChooser;
import com.iscobol.gui.client.swing.BorderedFrame;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.HamburgerMenuAttrs;
import com.iscobol.gui.client.swing.MainPanel;
import com.iscobol.gui.client.swing.MenuManager;
import com.iscobol.gui.client.swing.RemoteContainerImpl;
import com.iscobol.gui.client.swing.RemoteDisplayToolBar;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.RemoteFileDialogImpl;
import com.iscobol.gui.client.swing.RemoteFontComponentImpl;
import com.iscobol.gui.client.swing.RemoteMessageBox;
import com.iscobol.gui.client.swing.RemoteMessageBoxCustom;
import com.iscobol.gui.client.swing.RemotePlaySound;
import com.iscobol.gui.client.swing.RemoteProgressDialogImpl;
import com.iscobol.gui.client.swing.RemoteSubWindow;
import com.iscobol.gui.client.swing.SwingErrorBox;
import com.iscobol.gui.client.swing.SwingFontCmp;
import com.iscobol.gui.client.swing.WebClientEvent;
import com.iscobol.gui.client.swing.WebClientUtility;
import com.iscobol.logger.Logger;
import com.iscobol.rmi.Remote;
import com.iscobol.rpc.messageserver.common.InboundMessageHandler;
import com.iscobol.rts.Config;
import com.iscobol.rts.ErrorBox;
import com.iscobol.rts.Finalizable;
import com.iscobol.rts.RtsUtil;
import com.iscobol.types.CobolVar;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class GuiFactoryImpl
extends AbstractGuiFactoryImpl
implements GuiFactory,
Remote,
PropertyChangeListener,
Finalizable {
    private static final long serialVersionUID = 6647656748564784L;
    private static final Map<String, SpecialKey> specialKeys = new HashMap<String, SpecialKey>();
    private static final Map<String, String> specialKeyNames = new HashMap<String, String>();
    private static final KeyBuf keybuf = new KeyBuf();
    private static JLabel targetLabel;
    private final String iscobolEncoding;
    protected int gui_exclude_events = -1;
    protected Vector gui_event_list;
    private boolean guikdbupper;
    private boolean guikdblower;
    private Logger[] guiLog;
    private Logger[] devLog;
    private boolean[] tracegui;
    private HamburgerMenuAttrs hamburgerMenuAttrs;
    private WebClientUtility wcUtility;
    private boolean m27901initdcalledineventqueue;
    private Image chipsboxmouseentered;
    private Image chipsboxmouseexited;
    private Image tabclosemouseentered;
    private Image tabclosemouseexited;
    private boolean m31715callsetstatecheckbox;
    private Object conditionMsgBoxSync = new Object();
    private boolean msgboxcall = false;

    public GuiFactoryImpl() throws IOException {
        if (!(Thread.currentThread() instanceof InboundMessageHandler)) {
            this.getCsProperty().addPropertyChangeListener(this);
            if (Config.getProperty("iscobol.gui.keyboard_buffering", -1) != -1) {
                KeyboardBuffer.setKeyboardBuffering(Config.getProperty("iscobol.gui.keyboard_buffering", -1));
            }
            this.m27901initdcalledineventqueue = Config.getProperty("iscobol.m27901", true);
            this.m31715callsetstatecheckbox = Config.getProperty("iscobol.m31715", true);
        }
        this.iscobolEncoding = CobolVar.encoding;
    }

    public GuiFactoryImpl(InputStream sshin, OutputStream sshout, int sshhandlecl, byte[] sshentercode) {
        super(sshin, sshout, sshhandlecl, sshentercode);
        this.getCsProperty().addPropertyChangeListener(this);
        this.iscobolEncoding = CobolVar.encoding;
    }

    WebClientUtility getWebClient() {
        if (this.wcUtility == null && Client.isWebClient()) {
            this.wcUtility = WebClientUtility.getInstance();
        }
        return this.wcUtility;
    }

    private static JLabel getTargetLabel() {
        if (targetLabel == null) {
            targetLabel = new JLabel();
        }
        return targetLabel;
    }

    public String getIscobolEncoding() {
        return this.iscobolEncoding;
    }

    @Override
    public void finalize() {
    }

    @Override
    public void myFinalize() {
        Vector objids;
        if (this.csProperty != null) {
            this.csProperty.removePropertyChangeListener(this);
        }
        this.allLocalFonts = null;
        this.allFonts = null;
        this.createdFonts = null;
        this.enabledwindows = null;
        this.remoteVirtualKeyboard = null;
        if (this.client != null && (objids = this.client.getObjectsId()) != null) {
            Object obj = null;
            for (int i = 0; i < objids.size(); ++i) {
                obj = objids.get(i);
                if (!(obj instanceof MyFinalizeComponent)) continue;
                ((MyFinalizeComponent)obj).finalizeComponent();
            }
        }
        this.client = null;
    }

    @Override
    public RemoteContainer getDisplayToolbar(Events evs, int parentWindowId) throws IOException {
        RemoteContainerImpl Return2 = new RemoteContainerImpl(this);
        RemoteDisplayToolBar rdtb = new RemoteDisplayToolBar(evs, this, parentWindowId);
        Return2.setTheObjectId(this.getClient().setId(rdtb));
        rdtb.setId(Return2.getTheObjectId());
        return Return2;
    }

    @Override
    public RemoteContainer getMenuManager() throws IOException {
        RemoteContainerImpl Return2 = new RemoteContainerImpl(this);
        MenuManager mm = (MenuManager)this.getClient().getId(this.getMenuManagerId());
        if (mm == null) {
            mm = new MenuManager(this);
            this.setMenuManagerId(this.getClient().setId(mm));
        }
        Return2.setTheObjectId(this.getMenuManagerId());
        return Return2;
    }

    @Override
    public RemoteContainer getDisplayWindow(Events evs, int t) throws IOException {
        return this.getDisplayWindow(evs, t, -1);
    }

    @Override
    public RemoteContainer getDisplayWindow(Events evs, int t, int parentWindowId) throws IOException {
        RemoteContainerImpl Return2 = new RemoteContainerImpl(this);
        RemoteDisplayWindow rdw = new RemoteDisplayWindow(evs, this, t, parentWindowId);
        Return2.setTheObjectId(this.getClient().setId(rdw));
        rdw.setId(Return2.getTheObjectId());
        return Return2;
    }

    @Override
    public RemoteContainer getSubWindow(int parentWindowId) throws IOException {
        RemoteContainerImpl Return2 = new RemoteContainerImpl(this);
        RemoteSubWindow rdw = new RemoteSubWindow(this, parentWindowId);
        Return2.setTheObjectId(this.getClient().setId(rdw));
        rdw.setId(Return2.getTheObjectId());
        return Return2;
    }

    @Override
    public RemoteContainer getMessageBox(Events evs, int wId, int fontId, String text, String title, int type, int icon, int btnDefault) throws IOException {
        return this.getMessageBox(evs, wId, fontId, text, title, type, icon, btnDefault, -1, -1, -1L);
    }

    @Override
    public RemoteContainer getMessageBox(Events evs, int wId, int fontId, String text, String title, int type, int icon, int btnDefault, int backidx, int foreidx, long timeout) throws IOException {
        return this.getMessageBox(evs, wId, fontId, text, title, type, icon, btnDefault, backidx, foreidx, timeout, null, false);
    }

    @Override
    public RemoteContainer getMessageBox(Events evs, int wId, int fontId, String text, String title, int type, int icon, int btnDefault, int backidx, int foreidx, long timeout, String[] attributes, boolean iscp) throws IOException {
        return this.getMessageBox(evs, wId, fontId, text, title, type, icon, btnDefault, backidx, foreidx, timeout, attributes, iscp, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteContainer getMessageBox(Events evs, int wId, int fontId, String text, String title, int type, int icon, int btnDefault, int backidx, int foreidx, long timeout, String[] attributes, boolean iscp, String name) throws IOException {
        RemoteContainerImpl Return2 = new RemoteContainerImpl(this);
        if (name == null || name.length() == 0 || this.msgboxcall) {
            Return2.setTheObjectId(this.getClient().setId(new RemoteMessageBox(this, evs, wId, fontId, text, title, type, icon, btnDefault, backidx, foreidx, timeout, attributes)));
        } else {
            try {
                Object object = this.conditionMsgBoxSync;
                synchronized (object) {
                    RemoteMessageBoxCustom rmbc = null;
                    this.msgboxcall = true;
                    rmbc = new RemoteMessageBoxCustom(this, evs);
                    Return2.setTheObjectId(this.getClient().setId(rmbc));
                    rmbc.callmsg(name, wId, fontId, text, title, type, icon, btnDefault, backidx, foreidx, timeout, attributes, iscp);
                    this.msgboxcall = false;
                }
            }
            catch (Exception e) {
                ErrorBox.show(e);
            }
        }
        return Return2;
    }

    public RemoteContainer getSubwindow(Events evs) throws IOException {
        return null;
    }

    @Override
    public void exit() throws IOException {
        this.exit(null);
    }

    @Override
    public void exit(String errStr) throws IOException {
        boolean isErrorCode = false;
        int errorCode = 0;
        try {
            errorCode = Integer.parseInt(errStr);
            isErrorCode = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!isErrorCode && errStr != null) {
            System.out.println(errStr);
        }
        final int c = errorCode;
        new Thread(){

            @Override
            public void run() {
                try {
                    1.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                System.exit(c);
            }
        }.start();
    }

    @Override
    public RemoteFontComponent getFont(Hashtable attrs, boolean printer) throws IOException {
        RemoteFontComponentImpl Return2 = new RemoteFontComponentImpl(this);
        Return2.setTheObjectId(this.getClient().setId(new SwingFontCmp(this, attrs, printer)));
        return Return2;
    }

    @Override
    public RemoteFontComponent getFont(Hashtable attrs, int cellWidth, int cellHeight, boolean printer) throws IOException {
        return this.getFont(attrs, cellWidth, cellHeight, printer, false);
    }

    private RemoteFontComponent getFont(Hashtable attrs, int cellWidth, int cellHeight, boolean printer, boolean frompe) throws IOException {
        RemoteFontComponentImpl Return2 = new RemoteFontComponentImpl(this);
        SwingFontCmp lfcmp = new SwingFontCmp(this, attrs, printer);
        lfcmp.setCellWidth(cellWidth);
        lfcmp.setCellHeight(cellHeight);
        lfcmp.setFrompe(frompe);
        Return2.setTheObjectId(this.getClient().setId(lfcmp));
        return Return2;
    }

    @Override
    public RemoteFontComponent getFont(String name, int style, float size, boolean printer) throws IOException {
        RemoteFontComponentImpl Return2 = new RemoteFontComponentImpl(this);
        Return2.setTheObjectId(this.getClient().setId(new SwingFontCmp(this, name, style, size, printer)));
        return Return2;
    }

    @Override
    public RemoteFontComponent getFont(String name, int style, float size, int cellWidth, int cellHeight, boolean printer) throws IOException {
        RemoteFontComponentImpl Return2 = new RemoteFontComponentImpl(this);
        SwingFontCmp lfcmp = new SwingFontCmp(this, name, style, size, printer);
        lfcmp.setCellHeight(cellHeight);
        lfcmp.setCellWidth(cellWidth);
        Return2.setTheObjectId(this.getClient().setId(lfcmp));
        return Return2;
    }

    @Override
    public ParamElementFont getFontPE(Hashtable attrs, int cellWidth, int cellHeight, boolean printer) throws IOException {
        RemoteFontComponent rfci = this.getFont(attrs, cellWidth, cellHeight, printer, true);
        return new ParamElementFont(2071, rfci, rfci.getTheObjectId(), rfci.getFamily());
    }

    @Override
    public RemoteFontComponent chooseFont(int chooseFlags, int minSize, int maxSize, Hashtable font) throws IOException {
        RemoteFontComponentImpl Return2 = new RemoteFontComponentImpl(this);
        Font f = AdvancedFontChooser.choose(this, chooseFlags, minSize, maxSize, font);
        if (f != null) {
            Return2.setTheObjectId(this.getClient().setId(new SwingFontCmp(this, f)));
        }
        return Return2;
    }

    @Override
    public String createFont(int fontType, byte[] fontStream) throws IOException {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(fontStream);
            Font f = Font.createFont(fontType, bais);
            bais.close();
            this.addCreatedFont(f);
            return f.getFamily();
        }
        catch (IOException ioe) {
            return null;
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        catch (Exception fontFormatException) {
            return null;
        }
    }

    @Override
    public Font getFont(Hashtable attrs) throws IOException {
        Font Return2;
        Map tattr = FontAttribute.convertToTextAttributes(attrs);
        String family = (String)attrs.get(FontAttribute.FAMILY);
        if (family == null) {
            family = "";
        }
        if (!(Return2 = Font.getFont(tattr)).getFamily().equalsIgnoreCase(family)) {
            Font cf = this.getCreatedFont(family);
            if (cf != null) {
                tattr.remove(TextAttribute.FAMILY);
                Return2 = cf.deriveFont(tattr);
            } else {
                if (this.devLog == null) {
                    this.devLog = new Logger[]{KeyboardBuffer.devLog};
                }
                if (this.devLog[0] != null) {
                    this.devLog[0].warning("Font '" + family + "' not found, using '" + Return2.getFamily() + "'");
                }
            }
        }
        return Return2;
    }

    @Override
    public void showError(String msg, String stackTrace, int currentWindowId) throws IOException {
        RemoteDisplayWindow dw = (RemoteDisplayWindow)this.getClient().getId(currentWindowId);
        BorderedFrame owner = null;
        if (!SwingErrorBox.printMessage(msg, stackTrace)) {
            try {
                SwingErrorBox eb = dw != null && (owner = dw.getMainWindow()) != null ? (owner.isJFrame() ? new SwingErrorBox(this, msg, stackTrace, owner.getJFrame()) : (owner.isJDialog() ? new SwingErrorBox(this, msg, stackTrace, owner.getJDialog()) : (owner.isDockable() ? new SwingErrorBox(this, msg, stackTrace, owner.getDockable().getRootWindow()) : (owner.isMDIChild() ? new SwingErrorBox(this, msg, stackTrace, owner.getMyWindow().getRootWindow()) : null)))) : new SwingErrorBox(this, msg, stackTrace);
                if (eb != null) {
                    eb.setTimeout(Config.getProperty("iscobol.display_message_timeout", 0));
                    eb.setVisible(true);
                }
            }
            catch (Throwable e) {
                System.err.println(SwingErrorBox.buildMessage(msg, stackTrace));
            }
        }
    }

    @Override
    public Color getColor(int idx) throws IOException {
        return this.getRemotePalette().getColor(idx);
    }

    @Override
    public boolean setColor(int idx, int r, int g, int b) throws IOException {
        return this.getRemotePalette().setColor(idx, r, g, b);
    }

    @Override
    public Color chooseColor(int flags, int r, int g, int b) throws IOException {
        KeyboardBuffer.enable(null);
        return this.getRemotePalette().chooseColor(flags, r, g, b);
    }

    @Override
    public boolean setUserColor(int idx, int userColorId) throws IOException {
        return this.getRemotePalette().setUserColor(idx, userColorId);
    }

    @Override
    public void setUserGray(boolean b) throws IOException {
        this.getRemotePalette().setUserGray(b);
    }

    @Override
    public void setUserWhite(boolean b) throws IOException {
        this.getRemotePalette().setUserWhite(b);
    }

    @Override
    public RemoteImage loadImage(int size, int[] fontId, String[] charSeq, int[] color) throws IOException {
        JLabel tl = GuiFactoryImpl.getTargetLabel();
        ArrayList[] list = new ArrayList[fontId.length];
        Font[] f = new Font[fontId.length];
        FontMetrics[] fm = new FontMetrics[fontId.length];
        int[] fontHeight = new int[fontId.length];
        int totSize = 0;
        for (int i = 0; i < fontId.length; ++i) {
            Object id = this.getClient().getId(fontId[i]);
            if (!(id instanceof LocalFontCmp)) {
                return null;
            }
            Font font = ((LocalFontCmp)id).getFont();
            char[] chars = charSeq[i].toCharArray();
            Font targetFont = font.deriveFont(10000.0f);
            FontMetrics targetFM = tl.getFontMetrics(targetFont);
            float targetFontH = targetFM.getHeight();
            float targetFontW = 0.0f;
            list[i] = new ArrayList();
            for (int j = 0; j < chars.length; ++j) {
                String s;
                if (Character.isHighSurrogate(chars[j]) && j < chars.length - 1 && Character.isLowSurrogate(chars[j + 1])) {
                    s = new String(chars, j, 2);
                    ++j;
                } else {
                    s = new String(chars, j, 1);
                }
                float cw = targetFM.stringWidth(s);
                if (cw > targetFontW) {
                    targetFontW = cw;
                }
                list[i].add(s);
            }
            float ratio = 10000.0f / Math.max(targetFontH, targetFontW);
            f[i] = font.deriveFont((float)size * ratio);
            fm[i] = tl.getFontMetrics(f[i]);
            fontHeight[i] = fm[i].getHeight();
            totSize += list[i].size();
        }
        BufferedImage img = new BufferedImage(size * totSize, size, 2);
        Graphics2D g = img.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        int x = 0;
        for (int i = 0; i < fontId.length; ++i) {
            g.setColor(this.getRemotePalette().getDefaultColor(color[i]));
            int pady = size > fontHeight[i] ? (size - fontHeight[i]) / 2 : 0;
            for (String s : list[i]) {
                int cw = fm[i].stringWidth(s);
                int padx = size > cw ? (size - cw) / 2 : 0;
                if (size < cw) {
                    float size0 = size;
                    float cw0 = cw;
                    Font f0 = f[i].deriveFont(f[i].getSize2D() * size0 / cw0);
                    g.setFont(f0);
                } else {
                    g.setFont(f[i]);
                }
                g.drawString(s, x + padx, fm[i].getAscent() + pady);
                x += size;
            }
        }
        g.dispose();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "png", baos);
        baos.close();
        return this.loadImage(baos.toByteArray());
    }

    @Override
    public RemoteImage loadImage(int size, int shape, int fontId, String text, int fgColor, int bgColor, int grdOr, int bgColor2) throws IOException {
        int newSize;
        Object id = this.getClient().getId(fontId);
        if (!(id instanceof LocalFontCmp)) {
            return null;
        }
        Font font = ((LocalFontCmp)id).getFont();
        Color fg = this.getRemotePalette().getDefaultColor(fgColor);
        Color bg = this.getRemotePalette().getDefaultColor(bgColor);
        Color bg2 = null;
        boolean hasGrd = false;
        if (grdOr >= 0 && grdOr <= 7) {
            bg2 = this.getRemotePalette().getDefaultColor(bgColor2);
            hasGrd = true;
        }
        int origSize = size;
        AffineTransform at = new AffineTransform();
        at.scale(10.0, 10.0);
        font = font.deriveFont(at);
        BufferedImage img = new BufferedImage(size *= 10, size, 2);
        Graphics2D g = img.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        RectangularShape area = shape == 1 ? new Rectangle2D.Double(0.0, 0.0, size, size) : new Ellipse2D.Double(0.0, 0.0, size, size);
        Rectangle rect = area.getBounds();
        if (hasGrd && bg2 != null) {
            GradientPaint gp;
            switch (grdOr) {
                case 1: {
                    gp = new GradientPaint(rect.width - 1, 0.0f, bg, 0.0f, rect.height - 1, bg2);
                    break;
                }
                case 2: {
                    gp = new GradientPaint(rect.width - 1, 0.0f, bg, 0.0f, 0.0f, bg2);
                    break;
                }
                case 3: {
                    gp = new GradientPaint(rect.width - 1, rect.height - 1, bg, 0.0f, 0.0f, bg2);
                    break;
                }
                case 4: {
                    gp = new GradientPaint(0.0f, rect.height - 1, bg, 0.0f, 0.0f, bg2);
                    break;
                }
                case 5: {
                    gp = new GradientPaint(0.0f, rect.height - 1, bg, rect.width - 1, 0.0f, bg2);
                    break;
                }
                case 6: {
                    gp = new GradientPaint(0.0f, 0.0f, bg, rect.width - 1, 0.0f, bg2);
                    break;
                }
                case 7: {
                    gp = new GradientPaint(0.0f, 0.0f, bg, rect.width - 1, rect.height - 1, bg2);
                    break;
                }
                default: {
                    gp = new GradientPaint(0.0f, 0.0f, bg, 0.0f, rect.height - 1, bg2);
                }
            }
            g.setPaint(gp);
        } else {
            g.setPaint(bg);
        }
        g.fill(area);
        JLabel lbl = GuiFactoryImpl.getTargetLabel();
        FontMetrics fm = lbl.getFontMetrics(font);
        int textWidth = fm.stringWidth(text);
        int x = size > textWidth ? (size - textWidth) / 2 : 0;
        int textHeight = fm.getHeight();
        int y = size > textHeight ? (size - textHeight) / 2 : 0;
        g.setColor(fg);
        g.setFont(font);
        g.drawString(text, x, y += fm.getAscent());
        g.dispose();
        do {
            if ((newSize = size / 2) < origSize) {
                newSize = origSize;
            }
            double ratio = (double)newSize / (double)size;
            BufferedImage newImg = new BufferedImage(newSize, newSize, 2);
            Graphics2D g2 = newImg.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.scale(ratio, ratio);
            g2.drawImage((Image)img, 0, 0, null);
            g2.dispose();
            img = newImg;
            size = newSize;
        } while (newSize != origSize);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "png", baos);
        baos.close();
        return this.loadImage(baos.toByteArray());
    }

    @Override
    public byte[] videoCapture(int winId, String path, String fmt) throws IOException {
        BufferedImage img;
        RemoteDisplayWindow dw;
        Rectangle r = winId > 0 && (dw = (RemoteDisplayWindow)this.getClient().getId(winId)) != null ? dw.getMainBounds() : new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        try {
            img = new Robot().createScreenCapture(r);
        }
        catch (AWTException e) {
            System.err.println(e);
            img = null;
        }
        if (img != null) {
            if (path != null && path.length() > 0) {
                File file = com.iscobol.rts.File.get(path);
                try {
                    ImageIO.write((RenderedImage)img, fmt, file);
                }
                catch (IOException iOException) {}
            } else {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new ImageSelection(img), null);
            }
            return ImageToByteArray.get(img);
        }
        return null;
    }

    @Override
    public RemoteFileDialog getRemoteFileDialog(boolean forceSwing) throws IOException {
        boolean acuCompatibility = this.getCsProperty().get("iscobol.properties.acu_compat", false);
        boolean intFilterEn = this.getCsProperty().get("iscobol.m14778", false);
        return new RemoteFileDialogImpl(acuCompatibility, intFilterEn, this);
    }

    @Override
    public boolean setCursor(int type, int winId, int imageId, int x, int y) throws IOException {
        boolean Return2;
        try {
            RemoteDisplayWindow dw;
            if (winId > 0 && (dw = (RemoteDisplayWindow)this.getClient().getId(winId)) != null) {
                Cursor c = null;
                switch (type) {
                    case -1: {
                        Object o = this.getClient().getId(imageId);
                        if (!(o instanceof LocalImage)) break;
                        Image img = ((LocalImage)o).getImage();
                        c = Toolkit.getDefaultToolkit().createCustomCursor(img, new Point(x, y), "_");
                        break;
                    }
                    default: {
                        c = new Cursor(type);
                    }
                }
                BorderedFrame.MyWindow myw = dw.mainWindow.getMyWindow();
                this.mySetCursor(myw.getRootWindow(), c);
                if (myw instanceof JInternalFrame) {
                    ((JInternalFrame)((Object)myw)).setCursor(c);
                }
                Return2 = true;
            } else {
                Return2 = false;
            }
        }
        catch (Exception _ex) {
            Return2 = false;
        }
        return Return2;
    }

    private void mySetCursor(Window win, Cursor c) {
        win.setCursor(c);
        Window[] wl = win.getOwnedWindows();
        for (int i = 0; i < wl.length; ++i) {
            this.mySetCursor(wl[i], c);
        }
    }

    @Override
    public boolean playSound(byte[] sound, int flags) throws IOException {
        RemotePlaySound rps = new RemotePlaySound(sound, flags);
        boolean Return2 = rps.start();
        return Return2;
    }

    @Override
    public void setHintsOn(int milliseconds) throws IOException {
        if (milliseconds <= 0) {
            ToolTipManager.sharedInstance().setEnabled(false);
        } else {
            ToolTipManager.sharedInstance().setEnabled(true);
            if (milliseconds <= 100) {
                milliseconds = 100;
            }
            ToolTipManager.sharedInstance().setInitialDelay(milliseconds);
        }
    }

    @Override
    public void setHintsOff(int milliseconds) throws IOException {
        if (milliseconds <= 0) {
            ToolTipManager.sharedInstance().setDismissDelay(1000000000);
        } else {
            ToolTipManager.sharedInstance().setDismissDelay(milliseconds);
        }
    }

    @Override
    public void setMenubarDefaultKeyboardActionsEnabled(boolean b) throws IOException {
        this.setDefaultKeyboardActionsEnabled(b);
    }

    @Override
    public void enableKeyboard(int winId) throws IOException {
        if (winId > 0) {
            RemoteDisplayWindow dw;
            Object o = this.getClient().getId(winId);
            if (o instanceof RemoteDisplayToolBar) {
                winId = ((RemoteDisplayToolBar)o).getParentWindowId();
            }
            if (winId > 0 && (dw = (RemoteDisplayWindow)this.getClient().getId(winId)) != null) {
                KeyboardBuffer.enable(dw.mainWindow.getWindow());
                dw.setEnabledKeyboard(true);
            }
        }
        if (KeyboardBuffer.isDebugEnabled()) {
            if (this.guiLog == null) {
                this.guiLog = new Logger[]{KeyboardBuffer.guiLog};
            }
            if (this.guiLog[0] != null) {
                this.guiLog[0].info("GuiFactoryImpl: enableKeyboard [" + winId + "]");
            }
        }
    }

    @Override
    public int getNumColors() throws IOException {
        return this.getRemotePalette().getNumColors();
    }

    @Override
    public boolean getInputStatus(int activeWindowId, boolean onlyChar) throws IOException {
        RemoteDisplayWindow dw = (RemoteDisplayWindow)this.getClient().getId(activeWindowId);
        if (dw == null || !dw.getMainWindow().isActiveAccept()) {
            KeyboardBuffer.enableInputStatus();
        }
        return KeyboardBuffer.getInputStatus(onlyChar);
    }

    @Override
    public String getChar(int activeWindowId, boolean onlyChar) throws IOException {
        RemoteDisplayWindow dw = (RemoteDisplayWindow)this.getClient().getId(activeWindowId);
        if (dw == null || !dw.getMainWindow().isActiveAccept()) {
            KeyboardBuffer.enableInputStatus();
        }
        KeyEvent ke = KeyboardBuffer.popKeyEvent();
        if (onlyChar) {
            if (ke != null) {
                if (ke.getKeyChar() != '\uffff') {
                    return "" + ke.getKeyChar();
                }
                return "0";
            }
            return "0";
        }
        if (ke != null) {
            String n = specialKeyNames.get(new SpecialKey("", ke.getKeyCode(), ke.getModifiersEx()).getKey());
            if (n != null) {
                return n;
            }
            if (ke.getKeyChar() != '\uffff') {
                return " " + ke.getKeyChar();
            }
            return "-1";
        }
        return "-1";
    }

    @Override
    public PrintService serverPrintDialog(GraphicsConfiguration gc, int x, int y, PrintService[] services, PrintService defaultService, DocFlavor flavor, PrintRequestAttributeSet attributes) {
        KeyboardBuffer.setBufferOff();
        PrintService Return2 = super.serverPrintDialog(gc, x, y, services, defaultService, flavor, attributes);
        KeyboardBuffer.setBufferOn();
        return Return2;
    }

    @Override
    public void setDefaultLightWeightPopupEnabled(boolean b) throws IOException {
        JPopupMenu.setDefaultLightWeightPopupEnabled(b);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(b);
    }

    @Override
    public MouseInfo getMouseStatus(int activeWindowId) throws IOException {
        RemoteDisplayWindow rdw = (RemoteDisplayWindow)this.getClient().getId(activeWindowId);
        if (rdw == null) {
            return null;
        }
        return rdw.getMouseStatus();
    }

    private void loadControlEvents(Vector v, String controlStr) {
        StringTokenizer st;
        int numTok;
        if (controlStr != null && (numTok = (st = new StringTokenizer(controlStr, ",")).countTokens()) > 0) {
            for (int i = 0; i < numTok; ++i) {
                String temp = st.nextToken().trim().toUpperCase();
                boolean error = false;
                int v1 = -1;
                try {
                    if (temp != null) {
                        v1 = (int)Float.parseFloat(temp);
                    }
                }
                catch (NumberFormatException e) {
                    error = true;
                }
                if (!error) {
                    v.addElement(v1);
                    continue;
                }
                if (temp.equals("CMD-CLOSE")) {
                    v.addElement(1);
                    continue;
                }
                if (temp.equals("CMD-GOTO")) {
                    v.addElement(3);
                    continue;
                }
                if (temp.equals("CMD-CLICKED")) {
                    v.addElement(4);
                    continue;
                }
                if (temp.equals("CMD-DBLCLICK")) {
                    v.addElement(5);
                    continue;
                }
                if (temp.equals("CMD-ACTIVATE")) {
                    v.addElement(6);
                    continue;
                }
                if (temp.equals("CMD-TABCHANGED")) {
                    v.addElement(7);
                    continue;
                }
                if (temp.equals("CMD-HELP")) {
                    v.addElement(8);
                    continue;
                }
                if (temp.equals("CMD-AFTER")) {
                    v.addElement(9);
                    continue;
                }
                if (temp.equals("CMD-BEFORE")) {
                    v.addElement(10);
                    continue;
                }
                if (temp.equals("CMD-EXCEPTION")) {
                    v.addElement(11);
                    continue;
                }
                if (temp.equals("CMD-EXIT")) {
                    v.addElement(12);
                    continue;
                }
                if (temp.equals("NTF-SELCHANGE")) {
                    v.addElement(4099);
                    continue;
                }
                if (temp.equals("NTF-CHANGED")) {
                    v.addElement(4100);
                    continue;
                }
                if (temp.equals("NTF-PL-NEXT")) {
                    v.addElement(4101);
                    continue;
                }
                if (temp.equals("NTF-PL-PREV")) {
                    v.addElement(4102);
                    continue;
                }
                if (temp.equals("NTF-PL-NEXTPAGE")) {
                    v.addElement(4103);
                    continue;
                }
                if (temp.equals("NTF-PL-PREVPAGE")) {
                    v.addElement(4104);
                    continue;
                }
                if (temp.equals("NTF-PL-FIRST")) {
                    v.addElement(4105);
                    continue;
                }
                if (temp.equals("NTF-PL-LAST")) {
                    v.addElement(4106);
                    continue;
                }
                if (temp.equals("NTF-PL-SEARCH")) {
                    v.addElement(4107);
                    continue;
                }
                if (temp.equals("NTF-RESIZED")) {
                    v.addElement(4114);
                    continue;
                }
                if (temp.equals("MSG-SB-NEXT")) {
                    v.addElement(16385);
                    continue;
                }
                if (temp.equals("MSG-SB-PREV")) {
                    v.addElement(16386);
                    continue;
                }
                if (temp.equals("MSG-SB-NEXTPAGE")) {
                    v.addElement(16387);
                    continue;
                }
                if (temp.equals("MSG-SB-PREVPAGE")) {
                    v.addElement(16388);
                    continue;
                }
                if (temp.equals("MSG-SB-THUMB")) {
                    v.addElement(16389);
                    continue;
                }
                if (temp.equals("MSG-SB-THUMBTRACK")) {
                    v.addElement(16390);
                    continue;
                }
                if (temp.equals("MSG-VALIDATE")) {
                    v.addElement(16391);
                    continue;
                }
                if (temp.equals("MSG-BEGIN-ENTRY")) {
                    v.addElement(16392);
                    continue;
                }
                if (temp.equals("MSG-FINISH-ENTRY")) {
                    v.addElement(16393);
                    continue;
                }
                if (temp.equals("MSG-CANCEL-ENTRY")) {
                    v.addElement(16394);
                    continue;
                }
                if (temp.equals("MSG-GOTO-CELL")) {
                    v.addElement(16395);
                    continue;
                }
                if (temp.equals("MSG-GOTO-CELL-MOUSE")) {
                    v.addElement(16396);
                    continue;
                }
                if (temp.equals("MSG-GOTO-CELL-OUT-NEXT")) {
                    v.addElement(16440);
                    continue;
                }
                if (temp.equals("MSG-GOTO-CELL-OUT-PREV")) {
                    v.addElement(16439);
                    continue;
                }
                if (temp.equals("MSG-MENU-INPUT")) {
                    v.addElement(16397);
                    continue;
                }
                if (temp.equals("MSG-INIT-MENU")) {
                    v.addElement(16398);
                    continue;
                }
                if (temp.equals("MSG-END-MENU")) {
                    v.addElement(16399);
                    continue;
                }
                if (temp.equals("MSG-BITMAP-CLICKED")) {
                    v.addElement(16400);
                    continue;
                }
                if (temp.equals("MSG-BITMAP-DBLCLICK")) {
                    v.addElement(16401);
                    continue;
                }
                if (temp.equals("MSG-HEADING-CLICKED")) {
                    v.addElement(16402);
                    continue;
                }
                if (temp.equals("MSG-HEADING-DBLCLICK")) {
                    v.addElement(16403);
                    continue;
                }
                if (temp.equals("MSG-GOTO-CELL-DRAG")) {
                    v.addElement(16404);
                    continue;
                }
                if (temp.equals("MSG-HEADING-DRAGGED")) {
                    v.addElement(16405);
                    continue;
                }
                if (temp.equals("MSG-BEGIN-DRAG")) {
                    v.addElement(16406);
                    continue;
                }
                if (temp.equals("MSG-END-DRAG")) {
                    v.addElement(16407);
                    continue;
                }
                if (temp.equals("MSG-BEGIN-HEADING-DRAG")) {
                    v.addElement(16408);
                    continue;
                }
                if (temp.equals("MSG-END-HEADING-DRAG")) {
                    v.addElement(16409);
                    continue;
                }
                if (temp.equals("MSG-COL-WIDTH-CHANGED")) {
                    v.addElement(16410);
                    continue;
                }
                if (temp.equals("MSG-TV-SELCHANGING")) {
                    v.addElement(16411);
                    continue;
                }
                if (temp.equals("MSG-TV-SELCHANGE")) {
                    v.addElement(16412);
                    continue;
                }
                if (temp.equals("MSG-TV-EXPANDING")) {
                    v.addElement(16413);
                    continue;
                }
                if (temp.equals("MSG-TV-EXPANDED")) {
                    v.addElement(16414);
                    continue;
                }
                if (temp.equals("MSG-CLOSE")) {
                    v.addElement(16415);
                    continue;
                }
                if (temp.equals("MSG-SPIN-UP")) {
                    v.addElement(16416);
                    continue;
                }
                if (temp.equals("MSG-SPIN-DOWN")) {
                    v.addElement(16417);
                    continue;
                }
                if (temp.equals("MSG-PAGED-NEXT")) {
                    v.addElement(16419);
                    continue;
                }
                if (temp.equals("MSG-PAGED-PREV")) {
                    v.addElement(16420);
                    continue;
                }
                if (temp.equals("MSG-PAGED-NEXTPAGE")) {
                    v.addElement(16421);
                    continue;
                }
                if (temp.equals("MSG-PAGED-PREVPAGE")) {
                    v.addElement(16422);
                    continue;
                }
                if (temp.equals("MSG-PAGED-FIRST")) {
                    v.addElement(16423);
                    continue;
                }
                if (temp.equals("MSG-PAGED-LAST")) {
                    v.addElement(16424);
                    continue;
                }
                if (temp.equals("MSG-GRID-RBUTTON_DOWN")) {
                    v.addElement(16426);
                    continue;
                }
                if (temp.equals("MSG-GRID-RBUTTON_UP")) {
                    v.addElement(16427);
                    continue;
                }
                if (temp.equals("MSG-TV-DBLCLICK")) {
                    v.addElement(16428);
                    continue;
                }
                if (temp.equals("MSG-WB-BEFORE-NAVIGATE")) {
                    v.addElement(16429);
                    continue;
                }
                if (temp.equals("MSG-WB-NAVIGATE-COMPLETE")) {
                    v.addElement(16430);
                    continue;
                }
                if (temp.equals("MSG-WB-DOWNLOAD-BEGIN")) {
                    v.addElement(16431);
                    continue;
                }
                if (temp.equals("MSG-WB-DOWNLOAD-COMPLETE")) {
                    v.addElement(16432);
                    continue;
                }
                if (temp.equals("MSG-WB-PROGRESS-CHANGE")) {
                    v.addElement(16433);
                    continue;
                }
                if (temp.equals("MSG-WB-STATUS_TEXT-CHANGE")) {
                    v.addElement(16434);
                    continue;
                }
                if (temp.equals("MSG-WB-TITLE-CHANGE")) {
                    v.addElement(16435);
                    continue;
                }
                if (temp.equals("MSG-AX-EVENT")) {
                    v.addElement(16436);
                    continue;
                }
                if (temp.equals("MSG-GRID-BEGIN-SORT")) {
                    v.addElement(16437);
                    continue;
                }
                if (temp.equals("MSG-ROW-HEIGHT-CHANGED")) {
                    v.addElement(16438);
                    continue;
                }
                if (temp.equals("MSG-SL-THUMB")) {
                    v.addElement(17001);
                    continue;
                }
                if (temp.equals("MSG-JB-EVENT")) {
                    v.addElement(17011);
                    continue;
                }
                if (temp.equals("MSG-MOUSE-CLICKED")) {
                    v.addElement(17021);
                    continue;
                }
                if (temp.equals("MSG-MOUSE-DBLCLICK")) {
                    v.addElement(17022);
                    continue;
                }
                if (temp.equals("MSG-MOUSE-ENTERED")) {
                    v.addElement(17023);
                    continue;
                }
                if (temp.equals("MSG-MOUSE-EXITED")) {
                    v.addElement(17024);
                    continue;
                }
                if (temp.equals("MSG-SB-DBLCLICK")) {
                    v.addElement(17031);
                    continue;
                }
                if (!temp.equals("MSG-FINISH-FILTER")) continue;
                v.addElement(17036);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        String value = (String)e.getNewValue();
        if (prop.equals(Config.getPrefix() + "gui.exclude_events")) {
            int intValue = -1;
            try {
                intValue = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                return;
            }
            this.gui_exclude_events = intValue;
        } else if (prop.equals(Config.getPrefix() + "gui.events_list")) {
            if (this.gui_event_list == null) {
                this.gui_event_list = new Vector();
            }
            this.loadControlEvents(this.gui_event_list, value);
        } else if (prop.equals("iscobol.gui.treeview.selection_delay")) {
            int treeViewSelectionDelay = this.getCsProperty().get("iscobol.gui.treeview.selection_delay", -1);
            if (treeViewSelectionDelay >= 0) {
                UIManager.put("Tree.timeFactor", treeViewSelectionDelay);
            }
        } else if (prop.equals("iscobol.gui.keyboard_buffering")) {
            KeyboardBuffer.setKeyboardBuffering(this.getCsProperty().get("iscobol.gui.keyboard_buffering", -1));
        }
    }

    public boolean isExcludedEvent(String type, int e) {
        boolean Return2 = false;
        boolean found = false;
        if (this.gui_exclude_events == -1) {
            return Return2;
        }
        if (this.gui_event_list != null) {
            found = this.gui_event_list.contains(e);
        }
        if (this.gui_exclude_events == 1) {
            Return2 = found;
        } else if (this.gui_exclude_events == 0 && this.gui_event_list != null) {
            Return2 = !found;
        }
        return Return2;
    }

    @Override
    public void exitGUI() {
        Vector objs = this.getClient().getObjectsId();
        Object o = null;
        RemoteDisplayWindow rdw = null;
        if (objs != null && objs.size() > 0) {
            for (int i = 0; i < objs.size(); ++i) {
                o = objs.elementAt(i);
                if (!(o instanceof RemoteDisplayWindow)) continue;
                rdw = o;
                rdw.destroy();
            }
        }
    }

    @Override
    public Vector disableAllGUI() {
        Vector<RemoteDisplayWindow> Return2 = new Vector<RemoteDisplayWindow>();
        Vector objs = this.getClient().getObjectsId();
        Object o = null;
        RemoteDisplayWindow rdw = null;
        if (objs != null && objs.size() > 0) {
            for (int i = 0; i < objs.size(); ++i) {
                o = objs.elementAt(i);
                if (!(o instanceof RemoteDisplayWindow) || !(rdw = (RemoteDisplayWindow)o).isEnabled()) continue;
                Return2.add(rdw);
                rdw.setEnabled(false);
            }
        }
        return Return2;
    }

    @Override
    public void enableAllGUI(Vector objs) {
        RemoteDisplayWindow rdw = null;
        if (objs != null && objs.size() > 0) {
            for (int i = 0; i < objs.size(); ++i) {
                rdw = (RemoteDisplayWindow)objs.elementAt(i);
                rdw.setEnabled(true);
            }
        }
    }

    @Override
    public Object callStaticMethod(String className, String methodName, String signature, Object[] parameters) {
        try {
            Class<?> clazz = Class.forName(className);
            Object ret = JavaBeanUtilities.callMethod(clazz, null, clazz.getMethods(), methodName, signature, parameters);
            if (!Client.isClient() && Config.getProperty("iscobol.gui.javabean.serialization_check", false)) {
                RtsUtil.serializationCheck(ret);
            }
            return ret;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ParamVector getDisplayWindowAll(Events evs, int t, int parentWindowId, ParamVector pv) throws IOException {
        ParamVectorCover ret = new ParamVectorCover();
        ParamVElement pe = null;
        Enumeration params = pv.elements();
        pe = (ParamVElement)params.nextElement();
        if (pe != null && pe.getType() == 2074) {
            this.setProperties(((ParamElementString)pe).getValueString());
            pv.remove(pe);
        }
        new IsguiWorker(true, () -> {
            try {
                ret.setParamVector(this.intgetdisplaywindowAll(evs, t, parentWindowId, pv));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
        return ret.getParamVector();
    }

    private ParamVector intgetdisplaywindowAll(Events evs, int t, int parentWindowId, ParamVector pv) throws IOException {
        ParamVector ret = null;
        RemoteContainer Return2 = this.getDisplayWindow(evs, t, parentWindowId);
        if (Return2 != null) {
            pv.addFirst(new ParamElementInt(9999, 9999));
            ret = Return2.sendParams(pv);
            if (ret == null) {
                ret = new ParamVector();
            }
            ret.addFirst(new ParamElementInt(2073, Return2.getTheObjectId()));
            ret.addFirst(new ParamElementGeneric(Return2));
        }
        return ret;
    }

    @Override
    public RemoteProgressDialog getRemoteProgressDialog(String title, String cancelMessage, int flags, int imageId, int activeWindowId) throws IOException {
        RemoteDisplayWindow rdw = (RemoteDisplayWindow)this.getClient().getId(activeWindowId);
        return new RemoteProgressDialogImpl(title, cancelMessage, flags, (LocalImage)this.getClient().getId(imageId), rdw != null ? rdw.getMainWindow() : null, this);
    }

    @Override
    public void showHint(String text, float x, float y, int timeout, int activeWindowId) throws IOException {
        RemoteDisplayWindow rdw = (RemoteDisplayWindow)this.getClient().getId(activeWindowId);
        if (rdw == null || rdw.getMainWindow() == null) {
            return;
        }
        x = Math.max(1.0f, x);
        y = Math.max(1.0f, y);
        final JToolTip tt = new JToolTip();
        tt.setTipText(text);
        MainPanel mainPanel = rdw.getMainWindow().getPanel();
        Point p = mainPanel.getLocationOnScreen();
        Popup popup = PopupFactory.getSharedInstance().getPopup(mainPanel, tt, p.x + Math.round((x - 1.0f) * (float)rdw.getCellWidth()), p.y + Math.round((y - 1.0f) * (float)rdw.getCellHeight()));
        popup.show();
        class MyHint
        implements Hint {
            Popup p;

            MyHint(Popup p) {
                this.p = p;
            }

            @Override
            public void hide() {
                this.p.hide();
            }
        }
        final MyHint mh = new MyHint(popup);
        KeyboardBuffer.addActiveHint(mh);
        timeout = timeout > 0 ? (timeout *= 10) : ToolTipManager.sharedInstance().getDismissDelay();
        Timer t = new Timer(timeout, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (tt.isDisplayable()) {
                    mh.hide();
                    KeyboardBuffer.removeActiveHint(mh);
                }
            }
        });
        t.setRepeats(false);
        t.start();
    }

    public boolean isGuiTraced() {
        if (this.tracegui == null) {
            this.tracegui = new boolean[]{KeyboardBuffer.tracegui};
        }
        return this.tracegui[0];
    }

    @Override
    public int desktop(String operation, String uri) throws IOException {
        return ScreenUtility.desktop(operation, uri);
    }

    @Override
    public int desktop(String operation, String fileName, byte[] contents) throws IOException {
        String ext = null;
        int idx = fileName.lastIndexOf(46);
        if (idx >= 0) {
            ext = fileName.substring(idx);
            fileName = fileName.substring(0, idx);
        }
        while (fileName.length() < 3) {
            fileName = fileName + "0";
        }
        File tmp = File.createTempFile(fileName, ext);
        FileOutputStream out = new FileOutputStream(tmp);
        out.write(contents);
        out.close();
        return ScreenUtility.desktop(operation, tmp.getAbsolutePath());
    }

    @Override
    public String keybuf(int opCode, String[] args) throws IOException {
        String Return2 = String.valueOf(1);
        switch (opCode) {
            case 1: 
            case 2: {
                BorderedFrame bf;
                int currWinId = Integer.parseInt(args[0]);
                RemoteDisplayWindow rdw = (RemoteDisplayWindow)this.getClient().getId(currWinId);
                if (rdw == null || (bf = rdw.getMainWindow()) == null || !(bf.getWindow() instanceof Window)) break;
                keybuf.sendKeys(args[1], rdw);
                Return2 = String.valueOf(0);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                int maxSize = 0;
                if (args.length > 0) {
                    maxSize = Integer.parseInt(args[0]);
                }
                keybuf.startRecording(maxSize);
                Return2 = String.valueOf(0);
                break;
            }
            case 5: {
                Return2 = keybuf.stopRecording();
                break;
            }
            case 6: {
                Return2 = String.valueOf(keybuf.isRecordingActive() ? "1" : "0");
            }
        }
        return Return2;
    }

    @Override
    public ScreenInfo getScreenInfo() {
        ScreenInfo Return2 = null;
        GraphicsDevice[] gs = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gddefault = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        Rectangle[] physicalmonitorbounds = null;
        Insets[] insetsmonitor = null;
        int numberofmonitors = 0;
        int indexofmainmonitor = -1;
        if (ge != null && (gs = ge.getScreenDevices()) != null && gs.length > 0) {
            int j;
            GraphicsDevice gd = null;
            GraphicsConfiguration gc = null;
            int k = 0;
            for (j = 0; j < gs.length; ++j) {
                gd = gs[j];
                if (gd == null || gd.getType() != 0) continue;
                ++numberofmonitors;
            }
            physicalmonitorbounds = new Rectangle[numberofmonitors];
            insetsmonitor = new Insets[numberofmonitors];
            for (j = 0; j < gs.length; ++j) {
                gd = gs[j];
                if (gd == null || gd.getType() != 0) continue;
                if (gd == gddefault) {
                    indexofmainmonitor = k + 1;
                }
                if ((gc = gd.getDefaultConfiguration()) == null || gc.getBounds() == null) continue;
                insetsmonitor[k] = Toolkit.getDefaultToolkit().getScreenInsets(gc);
                physicalmonitorbounds[k] = gc.getBounds();
                ++k;
            }
        }
        Return2 = new ScreenInfo(numberofmonitors, indexofmainmonitor, physicalmonitorbounds, insetsmonitor);
        return Return2;
    }

    public void setGuiKdbUpper(boolean b) {
        this.guikdbupper = b;
    }

    public void setGuiKdbLower(boolean b) {
        this.guikdblower = b;
    }

    public boolean getGuiKdbUpper() {
        return this.guikdbupper;
    }

    public boolean getGuiKdbLower() {
        return this.guikdblower;
    }

    @Override
    public boolean modifyKey(String name, String values) throws IOException {
        if (name.equals("gui.kbd_case")) {
            boolean Return2 = true;
            if (values.equalsIgnoreCase("upper")) {
                this.setGuiKdbUpper(true);
            } else if (values.equalsIgnoreCase("lower")) {
                this.setGuiKdbLower(true);
            } else if (values.equalsIgnoreCase("both")) {
                this.setGuiKdbUpper(false);
                this.setGuiKdbLower(false);
            } else {
                Return2 = false;
            }
            return Return2;
        }
        return super.modifyKey(name, values);
    }

    @Override
    public Remote getFactoryExtension(String className) throws IOException {
        try {
            Class<?> cls = Class.forName(className);
            try {
                return (Remote)cls.getConstructor(GuiFactory.class).newInstance(this);
            }
            catch (NoSuchMethodException ex) {
                return (Remote)cls.newInstance();
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public int getExceptionValue(int keycode, int modifiers) throws IOException {
        int Return2 = -1;
        KeyEvent ke = new KeyEvent(new TextField(), 401, System.currentTimeMillis(), modifiers, keycode, '\uffff');
        int cobFun = this.getRemoteVirtualKeyboard().mapKey(ke);
        if (VirtualKeyboard.isException(cobFun)) {
            Return2 = VirtualKeyboard.exception(cobFun);
        }
        return Return2;
    }

    @Override
    public int getTerminationValue(int keycode, int modifiers) throws IOException {
        int Return2 = -1;
        KeyEvent ke = new KeyEvent(new TextField(), 401, System.currentTimeMillis(), modifiers, keycode, '\uffff');
        int cobFun = this.getRemoteVirtualKeyboard().mapKey(ke);
        if (VirtualKeyboard.isTermination(cobFun)) {
            Return2 = VirtualKeyboard.termination(cobFun);
        }
        return Return2;
    }

    public HamburgerMenuAttrs getHamburgerMenuAttrs() {
        if (this.hamburgerMenuAttrs == null) {
            this.hamburgerMenuAttrs = new HamburgerMenuAttrs(this.getScreenRes());
        }
        return this.hamburgerMenuAttrs;
    }

    @Override
    public void addCreatedFont(Font f) {
        super.addCreatedFont(f);
        GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(f);
    }

    @Override
    public boolean enableWebClientCommunication(int statusValue) throws IOException {
        if (this.getWebClient() != null) {
            WebClientUtility.setCommunicationStatusValue(statusValue);
            return true;
        }
        return false;
    }

    @Override
    public boolean disableWebClientCommunication() throws IOException {
        if (this.getWebClient() != null) {
            WebClientUtility.setCommunicationStatusValue(0);
            return true;
        }
        return false;
    }

    @Override
    public Object[] getWebClientActionEvent(int timeout) throws IOException {
        WebClientEvent event;
        Object[] errCode = new String[]{"-1"};
        if (this.getWebClient() != null && (event = this.getWebClient().getActionEvent(timeout, (String[])errCode)) != null) {
            return new Object[]{event.getActionName(), event.getData(), event.getBinaryData()};
        }
        return errCode;
    }

    @Override
    public boolean sendWebClientActionEvent(String actionName, String data, byte[] binaryData) throws IOException {
        if (this.getWebClient() != null) {
            return WebClientUtility.sendActionEvent(actionName, data, binaryData);
        }
        return false;
    }

    @Override
    public void unexport() {
        if (this.getWebClient() != null) {
            this.getWebClient().dispose();
        }
        if (this.csProperty != null) {
            this.csProperty.removePropertyChangeListener(this);
        }
        super.unexport();
    }

    public boolean getM27901initdcalledineventqueue() {
        return this.m27901initdcalledineventqueue;
    }

    public void setChipsBoxMouseEnteredImage(Image me) {
        this.chipsboxmouseentered = me;
    }

    public Image getChipsBoxMouseEnteredImage() {
        return this.chipsboxmouseentered;
    }

    public void setChipsBoxMouseExitedImage(Image me) {
        this.chipsboxmouseexited = me;
    }

    public Image getChipsBoxMouseExitedImage() {
        return this.chipsboxmouseexited;
    }

    public void setTabCloseMouseEnteredImage(Image me) {
        this.tabclosemouseentered = me;
    }

    public Image getTabCloseMouseEnteredImage() {
        return this.tabclosemouseentered;
    }

    public void setTabCloseMouseExitedImage(Image me) {
        this.tabclosemouseexited = me;
    }

    public Image getTabCloseMouseExitedImage() {
        return this.tabclosemouseexited;
    }

    public boolean getM31715callsetstatecheckbox() {
        return this.m31715callsetstatecheckbox;
    }

    static {
        ToolTipManager.sharedInstance().setInitialDelay(750);
        ToolTipManager.sharedInstance().setDismissDelay(4000);
        specialKeys.put("ZB", new SpecialKey("ZB", 8));
        specialKeys.put("^A", new SpecialKey("^A", 65, 'A', 128));
        specialKeys.put("^B", new SpecialKey("^B", 66, 'B', 128));
        specialKeys.put("^C", new SpecialKey("^C", 67, 'C', 128));
        specialKeys.put("^D", new SpecialKey("^D", 68, 'D', 128));
        specialKeys.put("^E", new SpecialKey("^E", 69, 'E', 128));
        specialKeys.put("^F", new SpecialKey("^F", 70, 'F', 128));
        specialKeys.put("^G", new SpecialKey("^G", 71, 'G', 128));
        specialKeys.put("^H", new SpecialKey("^H", 72, 'H', 128));
        specialKeys.put("^I", new SpecialKey("^I", 9));
        specialKeys.put("^J", new SpecialKey("^J", 74, 'J', 128));
        specialKeys.put("^K", new SpecialKey("^K", 75, 'K', 128));
        specialKeys.put("^L", new SpecialKey("^L", 76, 'L', 128));
        specialKeys.put("^M", new SpecialKey("^M", 10));
        specialKeys.put("^N", new SpecialKey("^N", 78, 'N', 128));
        specialKeys.put("^O", new SpecialKey("^O", 79, 'O', 128));
        specialKeys.put("^P", new SpecialKey("^P", 80, 'P', 128));
        specialKeys.put("^Q", new SpecialKey("^Q", 81, 'Q', 128));
        specialKeys.put("^R", new SpecialKey("^R", 82, 'R', 128));
        specialKeys.put("^S", new SpecialKey("^S", 83, 'S', 128));
        specialKeys.put("^T", new SpecialKey("^T", 84, 'T', 128));
        specialKeys.put("^U", new SpecialKey("^U", 85, 'U', 128));
        specialKeys.put("^V", new SpecialKey("^V", 86, 'V', 128));
        specialKeys.put("^W", new SpecialKey("^W", 87, 'W', 128));
        specialKeys.put("^X", new SpecialKey("^X", 88, 'X', 128));
        specialKeys.put("^Y", new SpecialKey("^Y", 89, 'Y', 128));
        specialKeys.put("^Z", new SpecialKey("^Z", 90, 'Z', 128));
        specialKeys.put("^[", new SpecialKey("^[", 27));
        specialKeys.put("^\\", new SpecialKey("^\\", 92, 128));
        specialKeys.put("^]", new SpecialKey("^]", 93, 128));
        specialKeys.put("^^", new SpecialKey("^^", 514, 128));
        specialKeys.put("^_", new SpecialKey("^_", 523, 128));
        specialKeys.put("@A", new SpecialKey("@A", 65, 'A', 512));
        specialKeys.put("@B", new SpecialKey("@B", 66, 'B', 512));
        specialKeys.put("@C", new SpecialKey("@C", 67, 'C', 512));
        specialKeys.put("@D", new SpecialKey("@D", 68, 'D', 512));
        specialKeys.put("@E", new SpecialKey("@E", 69, 'E', 512));
        specialKeys.put("@F", new SpecialKey("@F", 70, 'F', 512));
        specialKeys.put("@G", new SpecialKey("@G", 71, 'G', 512));
        specialKeys.put("@H", new SpecialKey("@H", 72, 'H', 512));
        specialKeys.put("@I", new SpecialKey("@I", 73, 'I', 512));
        specialKeys.put("@J", new SpecialKey("@J", 74, 'J', 512));
        specialKeys.put("@K", new SpecialKey("@K", 75, 'K', 512));
        specialKeys.put("@L", new SpecialKey("@L", 76, 'L', 512));
        specialKeys.put("@M", new SpecialKey("@M", 77, 'M', 512));
        specialKeys.put("@N", new SpecialKey("@N", 78, 'N', 512));
        specialKeys.put("@O", new SpecialKey("@O", 79, 'O', 512));
        specialKeys.put("@P", new SpecialKey("@P", 80, 'P', 512));
        specialKeys.put("@Q", new SpecialKey("@Q", 81, 'Q', 512));
        specialKeys.put("@R", new SpecialKey("@R", 82, 'R', 512));
        specialKeys.put("@S", new SpecialKey("@S", 83, 'S', 512));
        specialKeys.put("@T", new SpecialKey("@T", 84, 'T', 512));
        specialKeys.put("@U", new SpecialKey("@U", 85, 'U', 512));
        specialKeys.put("@V", new SpecialKey("@V", 86, 'V', 512));
        specialKeys.put("@W", new SpecialKey("@W", 87, 'W', 512));
        specialKeys.put("@X", new SpecialKey("@X", 88, 'X', 512));
        specialKeys.put("@Y", new SpecialKey("@Y", 89, 'Y', 512));
        specialKeys.put("@Z", new SpecialKey("@Z", 90, 'Z', 512));
        specialKeys.put("@0", new SpecialKey("@0", 48, '0', 512));
        specialKeys.put("@1", new SpecialKey("@1", 49, '1', 512));
        specialKeys.put("@2", new SpecialKey("@2", 50, '2', 512));
        specialKeys.put("@3", new SpecialKey("@3", 51, '3', 512));
        specialKeys.put("@4", new SpecialKey("@4", 52, '4', 512));
        specialKeys.put("@5", new SpecialKey("@5", 53, '5', 512));
        specialKeys.put("@6", new SpecialKey("@6", 54, '6', 512));
        specialKeys.put("@7", new SpecialKey("@7", 55, '7', 512));
        specialKeys.put("@8", new SpecialKey("@8", 56, '8', 512));
        specialKeys.put("@9", new SpecialKey("@9", 57, '9', 512));
        specialKeys.put("127", new SpecialKey("127", 8, 128));
        specialKeys.put("k1", new SpecialKey("k1", 112));
        specialKeys.put("k2", new SpecialKey("k2", 113));
        specialKeys.put("k3", new SpecialKey("k3", 114));
        specialKeys.put("k4", new SpecialKey("k4", 115));
        specialKeys.put("k5", new SpecialKey("k5", 116));
        specialKeys.put("k6", new SpecialKey("k6", 117));
        specialKeys.put("k7", new SpecialKey("k7", 118));
        specialKeys.put("k8", new SpecialKey("k8", 119));
        specialKeys.put("k9", new SpecialKey("k9", 120));
        specialKeys.put("K0", new SpecialKey("K0", 121));
        specialKeys.put("K1", new SpecialKey("K1", 122));
        specialKeys.put("K2", new SpecialKey("K2", 123));
        specialKeys.put("K3", new SpecialKey("K3", 61440));
        specialKeys.put("K4", new SpecialKey("K4", 61441));
        specialKeys.put("K5", new SpecialKey("K5", 61442));
        specialKeys.put("K6", new SpecialKey("K6", 61443));
        specialKeys.put("K7", new SpecialKey("K7", 61444));
        specialKeys.put("K8", new SpecialKey("K8", 61445));
        specialKeys.put("K9", new SpecialKey("K9", 61446));
        specialKeys.put("K0", new SpecialKey("K0", 61447));
        specialKeys.put("kd", new SpecialKey("kd", 40));
        specialKeys.put("kh", new SpecialKey("kh", 36));
        specialKeys.put("kl", new SpecialKey("kl", 37));
        specialKeys.put("kr", new SpecialKey("kr", 39));
        specialKeys.put("ku", new SpecialKey("ku", 38));
        specialKeys.put("kA", new SpecialKey("kA", 155, 128));
        specialKeys.put("kB", new SpecialKey("kB", 9, 64));
        specialKeys.put("kE", new SpecialKey("kE", 35, 128));
        specialKeys.put("kL", new SpecialKey("kL", 127, 128));
        specialKeys.put("kN", new SpecialKey("kN", 34));
        specialKeys.put("kP", new SpecialKey("kP", 33));
        specialKeys.put("Kc", new SpecialKey("Kc", 3));
        specialKeys.put("Kd", new SpecialKey("Kd", 40, 128));
        specialKeys.put("Kl", new SpecialKey("Kl", 37, 128));
        specialKeys.put("Kr", new SpecialKey("Kr", 39, 128));
        specialKeys.put("Ku", new SpecialKey("Ku", 38, 128));
        specialKeys.put("Kx", new SpecialKey("Kx", 69, 'E', 512));
        specialKeys.put("KA", new SpecialKey("KA", 65, 'A', 512));
        specialKeys.put("KB", new SpecialKey("KB", 34, 128));
        specialKeys.put("KC", new SpecialKey("KC", 36, 128));
        specialKeys.put("KD", new SpecialKey("KD", 68, 'D', 512));
        specialKeys.put("KE", new SpecialKey("KE", 35));
        specialKeys.put("KF", new SpecialKey("KF", 70, 'F', 512));
        specialKeys.put("KI", new SpecialKey("KI", 155));
        specialKeys.put("KL", new SpecialKey("KL", 76, 'L', 512));
        specialKeys.put("KM", new SpecialKey("KM", 77, 'M', 512));
        specialKeys.put("KP", new SpecialKey("KP", 80, 'P', 512));
        specialKeys.put("KR", new SpecialKey("KR", 82, 'R', 512));
        specialKeys.put("KS", new SpecialKey("KS", 83, 'S', 512));
        specialKeys.put("KT", new SpecialKey("KT", 33, 128));
        specialKeys.put("KV", new SpecialKey("KV", 86, 'V', 512));
        specialKeys.put("KX", new SpecialKey("KX", 127));
        specialKeys.put("K?", new SpecialKey("K?", 72, 'H', 512));
        specialKeys.put("A1", new SpecialKey("A1", 97, 128));
        specialKeys.put("A2", new SpecialKey("A2", 98, 128));
        specialKeys.put("A3", new SpecialKey("A3", 99, 128));
        specialKeys.put("A4", new SpecialKey("A4", 100, 128));
        specialKeys.put("A5", new SpecialKey("A5", 101, 128));
        specialKeys.put("A6", new SpecialKey("A6", 102, 128));
        specialKeys.put("A7", new SpecialKey("A7", 103, 128));
        specialKeys.put("A8", new SpecialKey("A8", 104, 128));
        specialKeys.put("A9", new SpecialKey("A9", 105, 128));
        specialKeys.put("A0", new SpecialKey("A0", 96, 128));
        specialKeys.put("U1", new SpecialKey("U1", 122));
        specialKeys.put("U2", new SpecialKey("U2", 123));
        specialKeys.put("U3", new SpecialKey("U3", 122, 64));
        specialKeys.put("U4", new SpecialKey("U4", 123, 64));
        specialKeys.put("U5", new SpecialKey("U5", 122, 128));
        specialKeys.put("U6", new SpecialKey("U6", 123, 128));
        specialKeys.put("C1", new SpecialKey("C1", 112, 128));
        specialKeys.put("C2", new SpecialKey("C2", 113, 128));
        specialKeys.put("C3", new SpecialKey("C3", 114, 128));
        specialKeys.put("C4", new SpecialKey("C4", 115, 128));
        specialKeys.put("C5", new SpecialKey("C5", 116, 128));
        specialKeys.put("C6", new SpecialKey("C6", 117, 128));
        specialKeys.put("C7", new SpecialKey("C7", 118, 128));
        specialKeys.put("C8", new SpecialKey("C8", 119, 128));
        specialKeys.put("C9", new SpecialKey("C9", 120, 128));
        specialKeys.put("C0", new SpecialKey("C0", 121, 128));
        specialKeys.put("A-", new SpecialKey("A-", 45, 512));
        specialKeys.put("A=", new SpecialKey("A=", 61, 512));
        specialKeys.put("AB", new SpecialKey("AB", 66, 'B', 512));
        specialKeys.put("AC", new SpecialKey("AC", 67, 'C', 512));
        specialKeys.put("AG", new SpecialKey("AG", 71, 'G', 512));
        specialKeys.put("AJ", new SpecialKey("AJ", 74, 'J', 512));
        specialKeys.put("AN", new SpecialKey("AN", 78, 'N', 512));
        specialKeys.put("AO", new SpecialKey("AO", 79, 'O', 512));
        specialKeys.put("AQ", new SpecialKey("AQ", 81, 'Q', 512));
        specialKeys.put("AT", new SpecialKey("AT", 84, 'T', 512));
        specialKeys.put("AU", new SpecialKey("AU", 85, 'U', 512));
        specialKeys.put("AW", new SpecialKey("AW", 87, 'W', 512));
        specialKeys.put("AY", new SpecialKey("AY", 89, 'Y', 512));
        specialKeys.put("AZ", new SpecialKey("AZ", 90, 'Z', 512));
        specialKeys.put("a1", new SpecialKey("a1", 112, 512));
        specialKeys.put("a2", new SpecialKey("a2", 113, 512));
        specialKeys.put("a3", new SpecialKey("a3", 114, 512));
        specialKeys.put("a4", new SpecialKey("a4", 115, 512));
        specialKeys.put("a5", new SpecialKey("a5", 116, 512));
        specialKeys.put("a6", new SpecialKey("a6", 117, 512));
        specialKeys.put("a7", new SpecialKey("a7", 118, 512));
        specialKeys.put("a8", new SpecialKey("a8", 119, 512));
        specialKeys.put("a9", new SpecialKey("a9", 120, 512));
        specialKeys.put("a0", new SpecialKey("a0", 121, 512));
        specialKeys.put("U7", new SpecialKey("U7", 122, 512));
        specialKeys.put("U8", new SpecialKey("U8", 123, 512));
        specialKeys.put("S1", new SpecialKey("S1", 112, 192));
        specialKeys.put("S2", new SpecialKey("S2", 113, 192));
        specialKeys.put("S3", new SpecialKey("S3", 114, 192));
        specialKeys.put("S4", new SpecialKey("S4", 115, 192));
        specialKeys.put("S5", new SpecialKey("S5", 116, 192));
        specialKeys.put("S6", new SpecialKey("S6", 117, 192));
        specialKeys.put("S7", new SpecialKey("S7", 118, 192));
        specialKeys.put("S8", new SpecialKey("S8", 119, 192));
        specialKeys.put("S9", new SpecialKey("S9", 120, 192));
        specialKeys.put("S0", new SpecialKey("S0", 121, 192));
        specialKeys.put("U9", new SpecialKey("U9", 122, 192));
        specialKeys.put("U0", new SpecialKey("U0", 123, 192));
        for (String k : specialKeys.keySet()) {
            SpecialKey sk = specialKeys.get(k);
            specialKeyNames.put(sk.getKey(), sk.name);
        }
    }

    private class ParamVectorCover {
        private ParamVector pv = null;

        private ParamVectorCover() {
        }

        public ParamVector getParamVector() {
            return this.pv;
        }

        public void setParamVector(ParamVector pv) {
            this.pv = pv;
        }
    }

    private static class KeyBuf
    implements AWTEventListener {
        private StringBuilder buffer;
        private int maxBufferSize;

        private KeyBuf() {
        }

        @Override
        public synchronized void eventDispatched(AWTEvent event) {
            if (event.getID() == 401) {
                KeyEvent ke = (KeyEvent)event;
                if (this.buffer != null && (this.maxBufferSize == 0 || this.buffer.length() < this.maxBufferSize)) {
                    String key = new SpecialKey("", ke.getKeyCode(), ke.getModifiersEx()).getKey();
                    String str = (String)specialKeyNames.get(key);
                    if (str != null) {
                        this.buffer.append("{");
                        this.buffer.append(str);
                        this.buffer.append("}");
                    } else if (ke.getKeyChar() != '\uffff') {
                        this.buffer.append(ke.getKeyChar());
                    }
                }
            }
        }

        void sendKeyEvent(KeyEvent ke, RemoteDisplayWindow rdw) {
            if (!KeyboardBuffer.isEnabled() || rdw.isActiveAccept()) {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(ke);
            } else {
                KeyboardBuffer.addKeyEvent(ke);
            }
        }

        void sendKey(char keyChar, RemoteDisplayWindow rdw) {
            this.sendKey(keyChar, 0, 0, rdw);
        }

        void sendKey(char keyChar, int keyCode, int modifiers, RemoteDisplayWindow rdw) {
            Window window = (Window)rdw.getMainWindow().getWindow();
            this.sendKeyEvent(new KeyEvent(window, 401, System.currentTimeMillis(), modifiers, keyCode, keyChar, 1), rdw);
            this.sendKeyEvent(new KeyEvent(window, 400, System.currentTimeMillis() + 1L, modifiers, 0, keyChar), rdw);
            this.sendKeyEvent(new KeyEvent(window, 402, System.currentTimeMillis() + 2L, modifiers, keyCode, keyChar, 1), rdw);
        }

        void sendSpecialKey(char keyChar, int keyCode, int modifiers, RemoteDisplayWindow rdw) {
            switch (keyCode) {
                case 10: {
                    this.sendKey('\n', keyCode, modifiers, rdw);
                    break;
                }
                case 9: {
                    this.sendKey('\t', keyCode, modifiers, rdw);
                    break;
                }
                default: {
                    Window window = (Window)rdw.getMainWindow().getWindow();
                    this.sendKeyEvent(new KeyEvent(window, 401, System.currentTimeMillis(), modifiers, keyCode, keyChar, 1), rdw);
                    this.sendKeyEvent(new KeyEvent(window, 402, System.currentTimeMillis() + 1L, modifiers, keyCode, keyChar, 1), rdw);
                }
            }
        }

        synchronized void startRecording(int maxSize) {
            if (this.buffer != null) {
                this.stopRecording();
            }
            this.buffer = new StringBuilder();
            this.maxBufferSize = maxSize;
            Toolkit.getDefaultToolkit().addAWTEventListener(keybuf, 8L);
        }

        synchronized boolean isRecordingActive() {
            return this.buffer != null;
        }

        synchronized String stopRecording() {
            String Return2 = "";
            if (this.buffer != null) {
                Return2 = this.buffer.toString();
                this.buffer = null;
                this.maxBufferSize = 0;
                Toolkit.getDefaultToolkit().removeAWTEventListener(keybuf);
            }
            return Return2;
        }

        synchronized void sendKeys(String str, RemoteDisplayWindow rdw) {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                boolean sent = false;
                if (c == '{') {
                    if (i == str.length() - 1 || str.charAt(i + 1) == '{') {
                        this.sendKey(c, rdw);
                        ++i;
                        continue;
                    }
                    int idx = str.indexOf(125, i + 1);
                    if (idx > 0) {
                        SpecialKey sk;
                        String specStr = str.substring(i + 1, idx);
                        if (specStr.length() > 1 && specStr.startsWith("m")) {
                            try {
                                int exc = Integer.parseInt(specStr.substring(1));
                                RemoteRecordAccept rra = new RemoteRecordAccept(4, exc, 0, true, true);
                                rra.setWait(false);
                                rdw.getMainWindow().push(new CobolEventCouple(rdw, rra));
                                i = idx;
                                sent = true;
                            }
                            catch (NumberFormatException exc) {
                                // empty catch block
                            }
                        }
                        if (!sent && (sk = (SpecialKey)specialKeys.get(specStr)) != null) {
                            this.sendSpecialKey(sk.keyChar, sk.keyCode, sk.modifiers, rdw);
                            i = idx;
                            sent = true;
                        }
                    }
                }
                if (sent) continue;
                this.sendKey(c, rdw);
            }
        }
    }

    private static class SpecialKey {
        final String name;
        final int keyCode;
        final char keyChar;
        final int modifiers;

        SpecialKey(String name, int keyCode) {
            this(name, keyCode, '\uffff', 0);
        }

        SpecialKey(String name, int keyCode, int modifiers) {
            this(name, keyCode, '\uffff', modifiers);
        }

        SpecialKey(String name, int keyCode, char keyChar, int modifiers) {
            this.name = name;
            this.keyCode = keyCode;
            this.keyChar = keyChar;
            this.modifiers = modifiers;
        }

        String getKey() {
            return "" + this.keyCode + (this.modifiers > 0 ? "-" + this.modifiers : "");
        }
    }
}

