/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ActiveXContainer;
import com.iscobol.gui.EventListenerFactory;
import com.iscobol.gui.JFXContainer;
import com.iscobol.gui.JavaBeanInitException;
import com.iscobol.gui.JavaBeanUtilities;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.swing.CobolEvent;
import com.iscobol.gui.client.swing.CobolEventListener;
import com.iscobol.rts.Factory;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IscobolRuntimeException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class JavaBean
extends JPanel {
    private static final long serialVersionUID = 0L;
    private static final Class jfxNodeClass;
    private Vector cobolEventListeners = new Vector();
    private Object theBean;
    private Class beanType;
    private Component beanComp;
    private ActiveXContainer axContainer;
    private JFXContainer jfxContainer;
    private Hashtable eventIds = new Hashtable();
    private Hashtable beanEventListenersTable = new Hashtable();
    private LinkedList beanProperties = new LinkedList();
    private Hashtable bitmapProps = new Hashtable();
    private Method[] beanMethods;
    private int bitmapWidth = 16;
    private Image image;
    private static final Object NULL_OBJECT;
    private Font font;
    private Color background;
    private Color foreground;
    private boolean isDestroyed;
    private JScrollPane scrollPane;
    private boolean catchException;
    private boolean isremote;

    public JavaBean(String className, String initSign, Object[] initParams, boolean hscroll, boolean vscroll, boolean isremote, boolean catEx) {
        Constructor constr = null;
        this.catchException = catEx;
        try {
            if (className == null || className.length() == 0) {
                throw new IscobolRuntimeException(3, "Missing CLSID");
            }
            this.beanType = Class.forName(className);
            Vector<Class> v = new Vector<Class>();
            for (Class superCls = this.beanType.getSuperclass(); superCls != null; superCls = superCls.getSuperclass()) {
                v.add(0, superCls);
            }
            v.addElement(this.beanType);
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                this.loadBean((Class)e.nextElement());
            }
            this.beanMethods = this.beanType.getMethods();
            if (initSign != null) {
                Class[] parTypes = JavaBeanUtilities.signatureToTypes(initSign);
                constr = this.beanType.getConstructor(parTypes);
                if (initParams != null) {
                    for (int i = 0; i < initParams.length; ++i) {
                        initParams[i] = JavaBeanUtilities.checkType(parTypes[i], initParams[i]);
                    }
                }
                if (!this.isFX()) {
                    this.theBean = constr.newInstance(initParams);
                }
            } else {
                Constructor[] constrs = this.getConstructors(initParams);
                if (constrs.length == 0) {
                    throw new NoSuchMethodException();
                }
                if (constrs.length > 1) {
                    StringBuffer errMsg = new StringBuffer("Ambiguous constructor invokation:\n");
                    for (int i = 0; i < constrs.length; ++i) {
                        errMsg.append("   " + this.getConstructorSignature(constrs[i]) + "\n");
                    }
                    throw new NoSuchMethodException(errMsg.toString());
                }
                if (initParams != null) {
                    Class<?>[] parTypes = constrs[0].getParameterTypes();
                    for (int i = 0; i < initParams.length; ++i) {
                        initParams[i] = JavaBeanUtilities.checkType(parTypes[i], initParams[i]);
                    }
                }
                if (!this.isFX()) {
                    this.theBean = constrs[0].newInstance(initParams);
                }
            }
        }
        catch (Throwable ex) {
            if (!this.catchException) {
                throw new JavaBeanInitException(ex);
            }
            ex.printStackTrace();
            this.beanType = Object.class;
            this.beanMethods = new Method[0];
            this.theBean = new Object();
        }
        this.isremote = isremote;
        this.setLayout(new GridLayout(1, 0));
        if (this.theBean instanceof Component) {
            super.setFocusable(false);
            this.beanComp = (Component)this.theBean;
            if (vscroll || hscroll) {
                this.scrollPane = new JScrollPane(this.beanComp);
                this.scrollPane.setFocusable(false);
                this.scrollPane.getVerticalScrollBar().setFocusable(false);
                this.scrollPane.getHorizontalScrollBar().setFocusable(false);
                if (vscroll) {
                    this.scrollPane.setVerticalScrollBarPolicy(22);
                }
                if (hscroll) {
                    this.scrollPane.setHorizontalScrollBarPolicy(32);
                }
                this.add(this.scrollPane);
            } else {
                this.add(this.beanComp);
            }
            if (this.isActiveX()) {
                this.axContainer = (ActiveXContainer)((Object)this.beanComp);
                this.beanComp.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if ((e.getChangeFlags() & 1L) == 1L && JavaBean.this.beanComp.getParent() == null && !JavaBean.this.isDestroyed) {
                            JavaBean.this.axContainer.destroyActiveX();
                            JavaBean.this.isDestroyed = true;
                        }
                    }
                });
            }
        } else if (this.isFX()) {
            super.setOpaque(false);
            try {
                this.jfxContainer = (JFXContainer)Class.forName("com.iscobol.gui.client.fx.JFXContainerImpl").newInstance();
                if (constr != null) {
                    this.jfxContainer.setNode(constr, initParams);
                } else {
                    this.jfxContainer.setNode(this.beanType);
                }
                this.add((Component)((Object)this.jfxContainer));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public Object getBean() {
        return this.theBean;
    }

    public boolean isActiveX() {
        return this.beanComp instanceof ActiveXContainer;
    }

    private boolean isFX() {
        return jfxNodeClass != null && this.beanType != null && jfxNodeClass.isAssignableFrom(this.beanType);
    }

    private void loadBean(Class cls) throws IntrospectionException {
        BeanInfo bInfo = cls.getSuperclass() != null ? Introspector.getBeanInfo(cls, cls.getSuperclass()) : Introspector.getBeanInfo(cls);
        EventSetDescriptor[] events = bInfo.getEventSetDescriptors();
        for (int i = 0; i < events.length; ++i) {
            this.loadEventInfo(events[i]);
            this.beanEventListenersTable.put(events[i], NULL_OBJECT);
        }
        PropertyDescriptor[] props = bInfo.getPropertyDescriptors();
        if (props != null) {
            for (int i = 0; i < props.length; ++i) {
                this.beanProperties.add(props[i]);
            }
        }
    }

    private boolean isImageProperty(PropertyDescriptor pd) {
        Method wMeth = pd.getWriteMethod();
        if (wMeth != null) {
            Class<?>[] parTypes = wMeth.getParameterTypes();
            return parTypes != null && parTypes.length == 1 && (parTypes[0].isAssignableFrom(Icon.class) || parTypes[0].isAssignableFrom(Image.class));
        }
        return false;
    }

    private void loadEventInfo(EventSetDescriptor esd) {
        MethodDescriptor[] methods = esd.getListenerMethodDescriptors();
        if (methods != null && methods.length > 0) {
            for (int i = 0; i < methods.length; ++i) {
                String methName = methods[i].getName().toUpperCase();
                int id = Factory.getHashcode(methName);
                this.eventIds.put(methName, new Integer(id));
            }
        }
    }

    @Override
    public void setToolTipText(String tt) {
        if (this.beanComp != null && this.beanComp instanceof JComponent) {
            ((JComponent)this.beanComp).setToolTipText(tt);
        }
    }

    @Override
    public void setBackground(Color bg) {
        if (this.beanComp != null) {
            this.background = bg;
            this.beanComp.setBackground(bg);
        }
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    public void destroy() {
        if (this.axContainer != null && !this.isDestroyed) {
            this.axContainer.destroyActiveX();
            this.isDestroyed = true;
        }
    }

    @Override
    public void setForeground(Color fg) {
        if (this.beanComp != null) {
            this.foreground = fg;
            this.beanComp.setForeground(fg);
        }
    }

    @Override
    public Color getForeground() {
        return this.foreground;
    }

    @Override
    public void setEnabled(boolean e) {
        if (this.beanComp != null) {
            this.beanComp.setEnabled(e);
            if (this.scrollPane != null) {
                this.scrollPane.getVerticalScrollBar().setEnabled(e);
                this.scrollPane.getHorizontalScrollBar().setEnabled(e);
                this.scrollPane.setWheelScrollingEnabled(e);
            }
        } else {
            super.setEnabled(e);
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.beanComp != null) {
            return this.beanComp.isEnabled();
        }
        return super.isEnabled();
    }

    @Override
    public void setFont(Font f) {
        if (this.beanComp != null) {
            this.font = f;
            this.beanComp.setFont(f);
        }
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setVisible(boolean v) {
        boolean old = super.isVisible();
        super.setVisible(v);
        if (v && !old && this.isActiveX()) {
            for (Container cnt = this.getParent(); cnt != null; cnt = cnt.getParent()) {
                if (!(cnt instanceof RootPaneContainer)) continue;
                ((RootPaneContainer)((Object)cnt)).getRootPane().revalidate();
                break;
            }
        }
    }

    @Override
    public void addKeyListener(KeyListener l) {
        if (this.beanComp != null) {
            this.beanComp.addKeyListener(l);
        } else {
            super.addKeyListener(l);
        }
    }

    @Override
    public void removeKeyListener(KeyListener l) {
        if (this.beanComp != null) {
            this.beanComp.removeKeyListener(l);
        } else {
            super.removeKeyListener(l);
        }
    }

    @Override
    public void addFocusListener(FocusListener l) {
        if (this.beanComp != null) {
            this.beanComp.addFocusListener(l);
        } else {
            super.addFocusListener(l);
        }
    }

    @Override
    public void removeFocusListener(FocusListener l) {
        if (this.beanComp != null) {
            this.beanComp.removeFocusListener(l);
        } else {
            super.removeFocusListener(l);
        }
    }

    @Override
    public void addMouseListener(MouseListener l) {
        if (this.beanComp != null) {
            this.beanComp.addMouseListener(l);
        } else {
            super.addMouseListener(l);
        }
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        if (this.beanComp != null) {
            this.beanComp.removeMouseListener(l);
        } else {
            super.removeMouseListener(l);
        }
    }

    @Override
    public void setFocusable(boolean b) {
        if (this.beanComp != null) {
            this.beanComp.setFocusable(b);
        } else {
            super.setFocusable(b);
        }
    }

    @Override
    public boolean isFocusable() {
        if (this.beanComp != null) {
            return this.beanComp.isFocusable();
        }
        return super.isFocusable();
    }

    @Override
    public void requestFocus() {
        if (this.beanComp != null) {
            this.beanComp.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.beanComp != null) {
            return this.beanComp.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    public Object callMethod(String methodName, Object[] parameters) throws Throwable {
        try {
            Method m = JavaBeanUtilities.getMethod(this.beanType, false, this.beanMethods, methodName, null, parameters);
            if (this.axContainer != null) {
                this.axContainer.initActiveX();
            }
            if (this.isFX()) {
                return this.jfxContainer.callMethod(m, parameters);
            }
            return m.invoke(this.theBean, parameters);
        }
        catch (Throwable e) {
            if (this.catchException) {
                e.printStackTrace();
                return null;
            }
            throw e;
        }
    }

    public Object callMethod(String methodName, String signature, Object[] parameters) throws Throwable {
        try {
            Method m = JavaBeanUtilities.getMethod(this.beanType, false, this.beanMethods, methodName, signature, parameters);
            if (this.axContainer != null) {
                this.axContainer.initActiveX();
            }
            if (this.isFX()) {
                return this.jfxContainer.callMethod(m, parameters);
            }
            return m.invoke(this.theBean, parameters);
        }
        catch (Throwable e) {
            if (this.catchException) {
                e.printStackTrace();
                return null;
            }
            throw e;
        }
    }

    public int setProperty(String propName, Object value) throws Throwable {
        PropertyDescriptor pd = this.findPropertyDescriptor(propName);
        if (pd == null) {
            return 0;
        }
        if (this.isImageProperty(pd)) {
            return this.setImageProperty(pd, value);
        }
        return this.setProperty(pd, value);
    }

    private int setProperty(PropertyDescriptor pd, Object value) throws Throwable {
        if (this.theBean != null || this.jfxContainer != null) {
            try {
                Method wMeth = pd.getWriteMethod();
                if (wMeth != null) {
                    value = JavaBeanUtilities.checkType(wMeth.getParameterTypes()[0], value);
                    if (this.axContainer != null) {
                        this.axContainer.initActiveX();
                    }
                    Object[] params = new Object[]{value};
                    if (this.isFX()) {
                        this.jfxContainer.callMethod(wMeth, params);
                    } else {
                        wMeth.invoke(this.theBean, params);
                    }
                }
            }
            catch (Exception e) {
                if (this.catchException) {
                    e.printStackTrace();
                }
                throw e;
            }
        }
        return 0;
    }

    public Object getProperty(String propName) throws Throwable {
        if (this.theBean != null || this.jfxContainer != null) {
            PropertyDescriptor pd = this.findPropertyDescriptor(propName);
            if (pd == null) {
                return null;
            }
            if (this.isImageProperty(pd)) {
                return this.bitmapProps.get(pd.getName());
            }
            try {
                Method rMeth = pd.getReadMethod();
                if (rMeth != null) {
                    if (this.axContainer != null) {
                        this.axContainer.initActiveX();
                    }
                    Object[] params = new Object[]{};
                    if (this.isFX()) {
                        return this.jfxContainer.callMethod(rMeth, params);
                    }
                    return rMeth.invoke(this.theBean, params);
                }
            }
            catch (Exception e) {
                if (this.catchException) {
                    e.printStackTrace();
                }
                throw e;
            }
        }
        return null;
    }

    private int setImageProperty(PropertyDescriptor pd, Object propValue) throws Throwable {
        if (!(propValue instanceof INumericVar)) {
            return this.setProperty(pd, propValue);
        }
        if (this.image != null) {
            try {
                Class<?>[] parTypes;
                int strip = ((INumericVar)propValue).toint();
                Image imgStrip = ScreenUtility.getImage(this.bitmapWidth, -1, this.image, strip);
                Method wMeth = pd.getWriteMethod();
                if (wMeth != null && (parTypes = wMeth.getParameterTypes()).length == 1) {
                    Object arg = null;
                    if (parTypes[0].isAssignableFrom(Image.class)) {
                        arg = imgStrip;
                    } else if (parTypes[0].isAssignableFrom(ImageIcon.class)) {
                        arg = new ImageIcon(imgStrip);
                    } else {
                        return 0;
                    }
                    this.bitmapProps.put(pd.getName(), new Integer(strip));
                    if (this.axContainer != null) {
                        this.axContainer.initActiveX();
                    }
                    Object[] params = new Object[]{arg};
                    if (this.isFX()) {
                        this.jfxContainer.callMethod(wMeth, params);
                    } else {
                        wMeth.invoke(this.theBean, params);
                    }
                }
            }
            catch (Exception e) {
                if (this.catchException) {
                    e.printStackTrace();
                }
                throw e;
            }
        }
        return 0;
    }

    public void enableEvent(String eventName) {
        if (this.theBean != null) {
            EventSetDescriptor esd = this.findEventDescriptor(eventName);
            if (esd == null || this.beanEventListenersTable.get(esd) != NULL_OBJECT) {
                return;
            }
            try {
                Class[] parTypes = new Class[]{EventObject.class, String.class, Boolean.TYPE};
                Object proxyListener = EventListenerFactory.create(esd.getListenerType(), this, "fireEvent", parTypes);
                esd.getAddListenerMethod().invoke(this.theBean, proxyListener);
                this.beanEventListenersTable.put(esd, proxyListener);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void disableAllEvents() {
        if (this.theBean != null) {
            Iterator i = this.beanEventListenersTable.keySet().iterator();
            while (i.hasNext()) {
                try {
                    EventSetDescriptor esd = (EventSetDescriptor)i.next();
                    Object proxyListener = this.beanEventListenersTable.get(esd);
                    if (proxyListener == null || proxyListener == NULL_OBJECT) continue;
                    esd.getRemoveListenerMethod().invoke(this.theBean, proxyListener);
                    this.beanEventListenersTable.put(esd, NULL_OBJECT);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void disableEvent(String eventName) {
        if (this.theBean != null) {
            EventSetDescriptor esd = this.findEventDescriptor(eventName);
            if (esd == null || this.beanEventListenersTable.get(esd) == NULL_OBJECT) {
                return;
            }
            Object proxyListener = this.beanEventListenersTable.get(esd);
            if (proxyListener == null || proxyListener == NULL_OBJECT) {
                return;
            }
            try {
                esd.getRemoveListenerMethod().invoke(this.theBean, proxyListener);
                this.beanEventListenersTable.put(esd, NULL_OBJECT);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void fireEvent(EventObject evt, String eventName, boolean vetoable) throws Exception {
        Integer eId;
        block16: {
            if (evt.getSource() == this) {
                return;
            }
            if (evt instanceof PropertyChangeEvent) {
                PropertyChangeEvent pcevent = (PropertyChangeEvent)evt;
                if (pcevent.getNewValue() == this || pcevent.getOldValue() == this) {
                    return;
                }
                if (this.isremote) {
                    ObjectOutputStream oos = null;
                    oos = new ObjectOutputStream(new ByteArrayOutputStream());
                    oos.writeObject(pcevent);
                    try {
                        oos.close();
                    }
                    catch (IOException iOException) {}
                    break block16;
                    catch (IOException ex) {
                        try {
                            oos.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return;
                        catch (Throwable throwable) {
                            try {
                                oos.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }
            }
        }
        if ((eId = (Integer)this.eventIds.get(eventName.toUpperCase())) != null) {
            CobolEvent ce = new CobolEvent(this.theBean, 17011, eId, evt, vetoable);
            Enumeration e = this.cobolEventListeners.elements();
            while (e.hasMoreElements()) {
                ((CobolEventListener)e.nextElement()).cobolEvent(ce);
            }
        }
    }

    private EventSetDescriptor findEventDescriptor(String eventName) {
        Enumeration e = this.beanEventListenersTable.keys();
        while (e.hasMoreElements()) {
            EventSetDescriptor esd = (EventSetDescriptor)e.nextElement();
            if (!esd.getName().equalsIgnoreCase(eventName)) continue;
            return esd;
        }
        return null;
    }

    private PropertyDescriptor findPropertyDescriptor(String propName) {
        PropertyDescriptor pd;
        ListIterator li = this.beanProperties.listIterator();
        while (li.hasNext()) {
            pd = (PropertyDescriptor)li.next();
            if (!pd.getName().equals(propName)) continue;
            return pd;
        }
        li = this.beanProperties.listIterator();
        while (li.hasNext()) {
            pd = (PropertyDescriptor)li.next();
            if (!pd.getName().equalsIgnoreCase(propName)) continue;
            return pd;
        }
        return null;
    }

    public void addCobolEventListener(CobolEventListener l) {
        this.cobolEventListeners.addElement(l);
    }

    public void removeCobolEventListener(CobolEventListener l) {
        this.cobolEventListeners.removeElement(l);
    }

    public void setBitmapWidth(int bw) {
        this.bitmapWidth = bw;
    }

    public int getBitmapWidth() {
        return this.bitmapWidth;
    }

    public void setBitmap(Image im) {
        this.image = im;
    }

    public Image getBitmap() {
        return this.image;
    }

    private Constructor[] getConstructors(Object[] params) throws Exception {
        if (params == null) {
            params = new Object[]{};
        }
        Vector Return2 = new Vector();
        Constructor<?>[] constr = this.beanType.getConstructors();
        for (int i = 0; i < constr.length; ++i) {
            Class<?>[] parTypes = constr[i].getParameterTypes();
            if (parTypes.length != params.length) continue;
            boolean ok = true;
            for (int j = 0; j < parTypes.length; ++j) {
                if (JavaBeanUtilities.isAssignableFrom(parTypes[j], params[j])) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            Return2.addElement(constr[i]);
        }
        Constructor[] ret = new Constructor[Return2.size()];
        Return2.toArray(ret);
        return ret;
    }

    private String getConstructorSignature(Constructor c) throws Exception {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(c.getName());
        Return2.append("(");
        Class<?>[] params = c.getParameterTypes();
        for (int k = 0; k < params.length; ++k) {
            Class<?> parType;
            if (k > 0) {
                Return2.append(",");
            }
            if ((parType = params[k]).isArray()) {
                int i = 0;
                while (parType.isArray()) {
                    parType = parType.getComponentType();
                    ++i;
                }
                Return2.append(parType.getName());
                for (int j = 0; j < i; ++j) {
                    Return2.append("[]");
                }
                continue;
            }
            Return2.append(parType.getName());
        }
        Return2.append(")");
        return Return2.toString();
    }

    public boolean isEventDispatchThread() {
        if (this.axContainer != null) {
            return this.axContainer.isEventDispatchThread();
        }
        return SwingUtilities.isEventDispatchThread();
    }

    public boolean isCatchException() {
        return this.catchException;
    }

    public void setCatchException(boolean catchException) {
        this.catchException = catchException;
    }

    static {
        Class<?> c;
        try {
            Class.forName("javafx.embed.swing.JFXPanel").newInstance();
            c = Class.forName("javafx.scene.Node");
        }
        catch (Throwable t) {
            c = null;
        }
        jfxNodeClass = c;
        NULL_OBJECT = "NULL";
    }
}

