/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.lib;

import java.util.Stack;

public class ExpressionEvaluator {
    public static double evaluate(String expression) {
        Stack<Double> values = new Stack<Double>();
        Stack<Character> operators = new Stack<Character>();
        for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (c == ' ') continue;
            if (c >= '0' && c <= '9') {
                StringBuilder sb = new StringBuilder();
                while (i < expression.length() && expression.charAt(i) >= '0' && expression.charAt(i) <= '9') {
                    sb.append(expression.charAt(i));
                    ++i;
                }
                --i;
                values.push(Double.parseDouble(sb.toString()));
                continue;
            }
            if (c == '(') {
                operators.push(Character.valueOf(c));
                continue;
            }
            if (c == ')') {
                while (((Character)operators.peek()).charValue() != '(') {
                    values.push(ExpressionEvaluator.applyOperation(((Character)operators.pop()).charValue(), (Double)values.pop(), (Double)values.pop()));
                }
                operators.pop();
                continue;
            }
            if (c != '+' && c != '-' && c != '*' && c != '/') continue;
            while (!operators.empty() && ExpressionEvaluator.hasPrecedence(c, ((Character)operators.peek()).charValue())) {
                values.push(ExpressionEvaluator.applyOperation(((Character)operators.pop()).charValue(), (Double)values.pop(), (Double)values.pop()));
            }
            operators.push(Character.valueOf(c));
        }
        while (!operators.empty()) {
            values.push(ExpressionEvaluator.applyOperation(((Character)operators.pop()).charValue(), (Double)values.pop(), (Double)values.pop()));
        }
        return (Double)values.pop();
    }

    private static boolean hasPrecedence(char op1, char op2) {
        if (op2 == '(' || op2 == ')') {
            return false;
        }
        return op1 != '*' && op1 != '/' || op2 != '+' && op2 != '-';
    }

    private static double applyOperation(char op, double b, double a) {
        switch (op) {
            case '+': {
                return a + b;
            }
            case '-': {
                return a - b;
            }
            case '*': {
                return a * b;
            }
            case '/': {
                if (b == 0.0) {
                    throw new UnsupportedOperationException("Cannot divide by zero");
                }
                return a / b;
            }
        }
        return 0.0;
    }
}

