/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.javabeans;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StatusLine
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel rowColLabel;
    private JLabel percLabel;
    private int height = 20;

    public StatusLine() {
        this.setLayout(new BoxLayout(this, 2));
        this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.rowColLabel = new JLabel("               ");
        this.rowColLabel.setHorizontalAlignment(4);
        this.rowColLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.percLabel = new JLabel("               ");
        this.percLabel.setHorizontalAlignment(4);
        this.percLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add(this.percLabel);
        this.add(this.rowColLabel);
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.rowColLabel != null) {
            this.rowColLabel.setFont(f);
            this.percLabel.setFont(f);
            this.height = this.getFontMetrics(f).getHeight() + 2;
        }
    }

    public void setRowCol(int row, int col) {
        StringBuffer text = new StringBuffer();
        text.append(row);
        text.append(":");
        text.append(col);
        text.append(" ");
        int len = text.length();
        for (int i = 0; i < 15 - len; ++i) {
            text.insert(0, " ");
        }
        this.rowColLabel.setText(text.toString());
        this.doLayout();
    }

    public void setPercentage(int perc) {
        StringBuffer text = new StringBuffer();
        text.append(perc);
        text.append("%");
        text.append(" ");
        int len = text.length();
        for (int i = 0; i < 15 - len; ++i) {
            text.insert(0, " ");
        }
        this.percLabel.setText(text.toString());
        this.doLayout();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, this.height);
    }
}

