/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rpc.dualrpc.server;

import com.iscobol.rpc.dualrpc.common.IRpcWorkerFactory;
import com.iscobol.rpc.dualrpc.common.RpcWorkerFactory;
import com.iscobol.rpc.dualrpc.server.DualRpcServerApplicationFactory;
import com.iscobol.rpc.dualrpc.server.ServerNotRunningException;
import com.iscobol.rpc.dualrpc.server.ShutdownThread;
import com.iscobol.rpc.messageserver.common.IMessageSerializer;
import com.iscobol.rpc.messageserver.server.MessageServer;
import java.io.IOException;
import java.util.ArrayList;

public class DualRpcServer {
    private String host = null;
    private int port = 0;
    private boolean reuseAddress;
    private ArrayList listServerSideHandlerClassnames = new ArrayList();
    private MessageServer messageServer = null;
    private Object serverHandlerConfigurationObject = null;
    private DualRpcServerApplicationFactory applicationFactory = null;
    private int maxConnections = 512;
    private boolean keepAlive = true;
    private boolean ignoreMaxConnectionsLimit;
    private IMessageSerializer messageSerializer = null;
    private long messageSequence = 0L;
    private String messageIdSeed = "s" + System.identityHashCode(this) + "-" + System.currentTimeMillis() + "-";
    private IRpcWorkerFactory rpcWorkerFactory = new RpcWorkerFactory();

    public DualRpcServer(String host, int port, boolean reuseAddress, Object configurationObject) {
        this.host = host;
        this.port = port;
        this.reuseAddress = reuseAddress;
        this.serverHandlerConfigurationObject = configurationObject;
        this.applicationFactory = new DualRpcServerApplicationFactory(this);
    }

    public void listen() throws IOException {
        this.setMessageServer(new MessageServer(this.host, this.port, this.reuseAddress, this.applicationFactory));
        this.getMessageServer().setMaxConnections(this.getMaxConnections());
        this.getMessageServer().setKeepAlive(this.isKeepAlive());
        this.getMessageServer().setIgnoreMaxConnectionsLimit(this.isIgnoreMaxConnectionsLimit());
        if (this.messageSerializer != null) {
            this.getMessageServer().setMessageSerializer(this.messageSerializer);
        }
        this.getMessageServer().listen();
    }

    public void registerServerSideHandlerClassname(String handlerClassname) throws ClassNotFoundException {
        this.getListServerSideHandlerClassnames().add(handlerClassname);
    }

    public int currentConnectionCount() {
        return this.getMessageServer().currentConnectionCount();
    }

    protected ArrayList getListServerSideHandlerClassnames() {
        return this.listServerSideHandlerClassnames;
    }

    protected Object getServerHandlerConfigurationObject() {
        return this.serverHandlerConfigurationObject;
    }

    public synchronized void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public synchronized int getMaxConnections() {
        return this.maxConnections;
    }

    public boolean isIgnoreMaxConnectionsLimit() {
        return this.ignoreMaxConnectionsLimit;
    }

    public void setIgnoreMaxConnectionsLimit(boolean ignoreMaxConnectionsLimit) {
        this.ignoreMaxConnectionsLimit = ignoreMaxConnectionsLimit;
    }

    public synchronized void setSendAndReceiveMessages(boolean isSendAndReceiveMessages) throws ServerNotRunningException {
        if (this.getMessageServer() == null) {
            throw new ServerNotRunningException("Method can only be called after DualRpcServer is listening.");
        }
        this.getMessageServer().setSendAndReceiveMessages(isSendAndReceiveMessages);
    }

    public void shutdown(int quietTimeInSeconds) throws ServerNotRunningException {
        this.getMessageServer().setAcceptNewConnections(false);
        this.setSendAndReceiveMessages(false);
        ShutdownThread shutdownThread = new ShutdownThread(quietTimeInSeconds);
        shutdownThread.run();
    }

    public void setMessageSerializer(IMessageSerializer messageSerializer) {
        this.messageSerializer = messageSerializer;
    }

    protected synchronized String getNextMessageId() {
        ++this.messageSequence;
        return this.messageIdSeed + this.messageSequence;
    }

    public void setRpcWorkerFactory(IRpcWorkerFactory rpcWorkerFactory) {
        this.rpcWorkerFactory = rpcWorkerFactory;
    }

    protected IRpcWorkerFactory getRpcWorkerFactory() {
        return this.rpcWorkerFactory;
    }

    private void setMessageServer(MessageServer messageServer) {
        this.messageServer = messageServer;
    }

    public MessageServer getMessageServer() {
        return this.messageServer;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }
}

