/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler;

import com.veryant.cobol.compiler.BuiltIn;
import com.veryant.cobol.compiler.Magnitude;
import com.veryant.cobol.compiler.memory.IChunk;

public interface IOperand {
    public IChunk getChunk();

    public BuiltIn getBuiltIn();

    public Magnitude getMagnitude();

    public static boolean isNumeric(IOperand iOperand) {
        return iOperand != null && iOperand.getMagnitude() != null;
    }

    public static boolean isOtherThanNumeric(IOperand iOperand) {
        return !IOperand.isNumeric(iOperand);
    }

    public static boolean isInteger(IOperand iOperand) {
        return IOperand.isNumeric(iOperand) && iOperand.getMagnitude().isInteger();
    }

    public static boolean isOtherThanInteger(IOperand iOperand) {
        return !IOperand.isInteger(iOperand);
    }

    public static boolean isFixedPoint(IOperand iOperand) {
        return IOperand.isNumeric(iOperand) && iOperand.getMagnitude().isFixedPoint();
    }

    public static boolean isOtherThanFixedPoint(IOperand iOperand) {
        return !IOperand.isFixedPoint(iOperand);
    }

    public static boolean isFloatingPoint(IOperand iOperand) {
        return IOperand.isNumeric(iOperand) && iOperand.getMagnitude().isFloatingPoint();
    }

    public static boolean isOtherThanFloatingPoint(IOperand iOperand) {
        return !IOperand.isFloatingPoint(iOperand);
    }
}

